/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.templates.templateview;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import oracle.hcs.HCSArb;
import oracle.hcs.av.model.AVDimensionality;
import oracle.hcs.av.model.AVHierarchy;
import oracle.hcs.av.model.AnalyticView;
import oracle.hcs.db.IdentifierElement;
import oracle.hcs.hierarchy.model.Hierarchy;
import oracle.hcs.syntaxbuilder.HCSSyntaxType;
import oracle.hcs.templates.syntaxparser.ParseNode;
import oracle.hcs.templates.templateview.TemplateHyperParamCombo;

public class TemplateHyperParamAVHierarchy
extends TemplateHyperParamCombo
implements PropertyChangeListener {
    private static final String DEFAULT_VALUE = "dimension.hierarchy";
    private static final ParseNode pattern = new ParseNode("av_hierarchy", HCSSyntaxType.HIERARCHY.toString(), ParseNode.PatternType.NONE);
    private AnalyticView analyticView;

    public TemplateHyperParamAVHierarchy() {
        final ListCellRenderer listCellRenderer = this.hyperCombo.getRenderer();
        this.hyperCombo.setRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                return listCellRenderer.getListCellRendererComponent(jList, TemplateHyperParamAVHierarchy.this.uiValue(object), n, bl, bl2);
            }
        });
    }

    private String uiValue(Object object) {
        if (object != null && object instanceof AVHierarchy) {
            AVHierarchy aVHierarchy = (AVHierarchy)object;
            AVDimensionality aVDimensionality = (AVDimensionality)aVHierarchy.getParent();
            String string = "";
            String string2 = aVHierarchy.getHierarchyAlias();
            if (aVDimensionality != null) {
                string = aVDimensionality.getDimensionAlias();
                string2 = String.format("%s.%s", string, string2);
            }
            return string2;
        }
        return null;
    }

    @Override
    public int getPixelSize(int n) {
        if (this.getSelectedElement() != null) {
            return this.hyperCombo.getFontMetrics(this.hyperCombo.getFont()).stringWidth(this.uiValue(this.getSelectedElement()));
        }
        return 100;
    }

    @Override
    public String getErrorMessage() {
        return HCSArb.getString("EXPRESSION_EDITOR_ERROR_NO_HIERARCHY");
    }

    @Override
    public ParseNode getPattern() {
        return pattern;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    @Override
    public void init() {
        this.setAV(this.getTemplateContext().getAV());
        this.addHierarchies(this.analyticView);
    }

    void setAV(AnalyticView analyticView) {
        this.analyticView = analyticView;
    }

    private void addHierarchies(AnalyticView analyticView) {
        for (AVDimensionality aVDimensionality : analyticView.getDimensions()) {
            for (AVHierarchy aVHierarchy : aVDimensionality.getHierarchies()) {
                this.addElement(aVHierarchy);
            }
        }
        AVHierarchy aVHierarchy = (AVHierarchy)this.getHierarchy();
        this.firePropertyChangeEvent(new PropertyChangeEvent(this, "VALUE_CHANGED", null, aVHierarchy));
    }

    private Object getHierarchy() {
        return this.getSelectedElement();
    }

    @Override
    public Object getValue() {
        return this.getHierarchy();
    }

    @Override
    public String getExpression() {
        String string = "";
        if (this.getTemplateContext().isAV()) {
            AVHierarchy aVHierarchy = (AVHierarchy)this.getHierarchy();
            String string2 = aVHierarchy.getHierarchyAlias();
            AVDimensionality aVDimensionality = (AVDimensionality)aVHierarchy.getParent();
            String string3 = aVDimensionality.getDimensionAlias();
            string = this.getExprFromDimensionality(string3, string2);
        } else {
            Hierarchy hierarchy = (Hierarchy)this.getHierarchy();
            String string4 = hierarchy.getName();
            String string5 = hierarchy.getDimensionName();
            string = this.getExprFromDimensionality(string5, string4);
        }
        return string;
    }

    private String getExprFromDimensionality(String string, String string2) {
        return String.format("%s.%s", this.getObjectExternalName(string), this.getObjectExternalName(string2));
    }

    @Override
    public String getDefault() {
        return DEFAULT_VALUE;
    }

    @Override
    public boolean setValue(Object object) {
        ParseNode parseNode;
        String string;
        IdentifierElement identifierElement;
        if (object instanceof ParseNode && (identifierElement = new IdentifierElement(string = (parseNode = (ParseNode)object).getFullValue())).getCount() > 1) {
            AVHierarchy aVHierarchy;
            AVDimensionality aVDimensionality;
            String string2 = identifierElement.getFirst();
            String string3 = identifierElement.getSecond();
            if (this.analyticView != null && (aVDimensionality = this.analyticView.findDimensionalityForAlias(string2)) != null && (aVHierarchy = aVDimensionality.findHierarchyByAlias(string3)) != null) {
                this.setSelectedElement(aVHierarchy);
            }
        }
        return false;
    }
}

