/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.templates.templateview;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreePath;
import oracle.hcs.templates.templateview.TemplateNode;
import oracle.hcs.util.HyperLabel;
import oracle.hcs.util.HyperLabelActionListener;
import oracle.hcs.util.HyperLinkCombo;
import oracle.hcs.util.HyperLinkField;
import oracle.hcs.util.HyperParamColoringHelper;
import oracle.hcs.util.MouseEventForwarder;

public class TemplateNodeRenderer
implements HyperLabelActionListener,
MouseEventForwarder {
    private final JTree tree;
    private Map<Integer, Component> treeComponents;
    private Map<Integer, Boolean> rowEditingMap;
    boolean passedThroughEditor;
    private final String DOWN_KEY_PRESSED = "downkeypressed";
    private final String UP_KEY_PRESSED = "upkeypressed";
    private final String ENTER_KEY_PRESSED = "enterkeypressed";
    private KeyAdapter ka;
    private PropertyChangeListener propertyChangeListener;

    public TemplateNodeRenderer(JTree jTree) {
        this.tree = jTree;
        this.treeComponents = new HashMap<Integer, Component>();
        this.rowEditingMap = new HashMap<Integer, Boolean>();
    }

    public void setPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeListener = propertyChangeListener;
    }

    public void setupTreeRendering() {
        this.tree.setRowHeight(0);
        this.tree.setEditable(true);
        HyperTextCellRenderer hyperTextCellRenderer = new HyperTextCellRenderer();
        this.tree.setCellRenderer(hyperTextCellRenderer);
        this.tree.setCellEditor(new HyperTextCellEditor(this.tree, hyperTextCellRenderer, new HyperTextCellEditorImpl()));
        this.ka = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 40 && !keyEvent.isConsumed()) {
                    TemplateNodeRenderer.this.forwardDownKeyPress();
                    keyEvent.consume();
                }
            }
        };
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TemplateNodeRenderer.this.adjustTreeDisplay();
            }
        });
    }

    @Override
    public void notifyForwardMouseEvent() {
        if (!this.passedThroughEditor) {
            this.resetRowEditingMap();
        }
    }

    @Override
    public void forwardMouseEvent(MouseEvent mouseEvent) {
        MouseEvent mouseEvent2;
        int n = this.tree.getSelectionRows()[0];
        if (!this.rowEditingMap.get(n).booleanValue() && (mouseEvent2 = SwingUtilities.convertMouseEvent(mouseEvent.getComponent(), mouseEvent, this.tree)).isPopupTrigger()) {
            this.tree.dispatchEvent(mouseEvent2);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TemplateNodeRenderer.this.passedThroughEditor = false;
            }
        });
    }

    private void selectNextNodeDownwards() {
        if (this.tree.getSelectionRows().length > 0) {
            int n = this.tree.getSelectionRows()[0] + 1;
            this.selectNodeAtRow(n);
        }
    }

    private void resetRowEditingMap() {
        for (int i = 0; i < this.tree.getRowCount(); ++i) {
            this.rowEditingMap.put(i, false);
        }
    }

    private void setupDownKeyPressAndMouseForwarding(JPanel jPanel) {
        Stack<JPanel> stack = new Stack<JPanel>();
        stack.push(jPanel);
        while (!stack.isEmpty()) {
            JPanel jPanel2 = (JPanel)stack.pop();
            for (Component component : jPanel2.getComponents()) {
                HyperParamColoringHelper hyperParamColoringHelper;
                if (component instanceof HyperLabel) {
                    hyperParamColoringHelper = (HyperLabel)component;
                    ((HyperLabel)hyperParamColoringHelper).addActionListener(this);
                    continue;
                }
                if (component instanceof JPanel) {
                    stack.push((JPanel)component);
                    continue;
                }
                if (component instanceof JCheckBox || component instanceof HyperLinkField) {
                    component.addKeyListener(this.ka);
                    continue;
                }
                if (!(component instanceof HyperLinkCombo) || ((HyperLinkCombo)(hyperParamColoringHelper = (HyperLinkCombo)((Object)component))).mouseEventForwarderCount() != 0) continue;
                ((HyperLinkCombo)hyperParamColoringHelper).addMouseEventForwarder(this);
            }
        }
    }

    private void selectNodeAtRow(int n) {
        if (n >= 0 && n < this.tree.getRowCount()) {
            TreePath treePath = this.tree.getPathForRow(n);
            this.tree.clearSelection();
            this.startEditingOnTreePath(treePath);
        }
    }

    @Override
    public void forwardDownKeyPress() {
        this.selectNextNodeDownwards();
    }

    public void adjustTreeDisplay() {
        int n = this.tree.getRowCount();
        for (int i = n - 1; i > 0; --i) {
            TreePath treePath = this.tree.getPathForRow(i);
            this.startEditingOnTreePath(treePath);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TemplateNodeRenderer.this.resetRowEditingMap();
                TemplateNodeRenderer.this.passedThroughEditor = false;
            }
        });
    }

    private void startEditingOnTreePath(final TreePath treePath) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TemplateNodeRenderer.this.tree.setSelectionPath(treePath);
                TemplateNodeRenderer.this.tree.startEditingAtPath(treePath);
            }
        });
    }

    private class HyperTextCellEditorImpl
    extends AbstractCellEditor
    implements TreeCellEditor {
        @Override
        public Component getTreeCellEditorComponent(final JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, final int n) {
            JPanel jPanel;
            Object object2;
            if (TemplateNodeRenderer.this.propertyChangeListener != null && object instanceof TemplateNode) {
                object2 = (TemplateNode)object;
                object2.addPropertyChangeListener(TemplateNodeRenderer.this.propertyChangeListener);
            }
            if ((jPanel = (JPanel)(object2 = TemplateNodeRenderer.this.treeComponents.get(n))) != null) {
                AbstractAction abstractAction = new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        TemplateNodeRenderer.this.selectNextNodeDownwards();
                    }
                };
                AbstractAction abstractAction2 = new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (jTree.getSelectionRows().length > 0) {
                            int n = jTree.getSelectionRows()[0] - 1;
                            TemplateNodeRenderer.this.selectNodeAtRow(n);
                        }
                    }
                };
                AbstractAction abstractAction3 = new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        jTree.setSelectionRow(n);
                        KeyEvent keyEvent = new KeyEvent(jTree, 401, System.currentTimeMillis(), 0, 10, '\b');
                        jTree.dispatchEvent(keyEvent);
                    }
                };
                jPanel.setBorder(BorderFactory.createLineBorder(Color.blue));
                jPanel.getInputMap(0).put(KeyStroke.getKeyStroke(40, 0), "downkeypressed");
                jPanel.getInputMap(1).put(KeyStroke.getKeyStroke(38, 0), "upkeypressed");
                jPanel.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "enterkeypressed");
                jPanel.getActionMap().put("downkeypressed", abstractAction);
                jPanel.getActionMap().put("upkeypressed", abstractAction2);
                jPanel.getActionMap().put("enterkeypressed", abstractAction3);
                TemplateNodeRenderer.this.setupDownKeyPressAndMouseForwarding(jPanel);
                TemplateNodeRenderer.this.passedThroughEditor = true;
                TemplateNodeRenderer.this.rowEditingMap.put(n, true);
            }
            return object2;
        }

        @Override
        public Object getCellEditorValue() {
            return "";
        }
    }

    private class HyperTextCellEditor
    extends DefaultTreeCellEditor {
        public HyperTextCellEditor(JTree jTree, DefaultTreeCellRenderer defaultTreeCellRenderer, TreeCellEditor treeCellEditor) {
            super(jTree, defaultTreeCellRenderer, treeCellEditor);
        }

        @Override
        public boolean isCellEditable(EventObject eventObject) {
            Object object;
            if (eventObject instanceof MouseEvent) {
                Object object2;
                MouseEvent mouseEvent = (MouseEvent)eventObject;
                TreePath treePath = this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (treePath != null && (object2 = treePath.getLastPathComponent()) != null && object2 instanceof TemplateNode) {
                    TemplateNode templateNode = (TemplateNode)object2;
                    return templateNode.isEditable();
                }
            } else if (eventObject == null && this.tree.getSelectionPath() != null && (object = this.tree.getSelectionPath().getLastPathComponent()) != null && object instanceof TemplateNode) {
                TemplateNode templateNode = (TemplateNode)object;
                return templateNode.isEditable();
            }
            return false;
        }

        @Override
        protected void determineOffset(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n) {
            this.offset = 0;
        }
    }

    private class HyperTextCellRenderer
    extends DefaultTreeCellRenderer {
        public HyperTextCellRenderer() {
            this.setLeafIcon(null);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            TemplateNode templateNode;
            Component component;
            if (object instanceof TemplateNode && (component = (templateNode = (TemplateNode)object).getComponent()) != null) {
                if (n >= 0) {
                    JPanel jPanel = (JPanel)component;
                    jPanel.setBorder(BorderFactory.createEmptyBorder());
                    TemplateNodeRenderer.this.treeComponents.put(n, component);
                    TemplateNodeRenderer.this.rowEditingMap.put(n, false);
                }
                this.changeComponentColorScheme(jTree, component);
                return component;
            }
            return super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
        }

        private void changeComponentColorScheme(JTree jTree, Component component) {
            JPanel jPanel = (JPanel)component;
            jPanel.setBackground(jTree.getBackground());
            jPanel.setForeground(jTree.getForeground());
            Stack<JPanel> stack = new Stack<JPanel>();
            stack.push(jPanel);
            while (!stack.isEmpty()) {
                JPanel jPanel2 = (JPanel)stack.pop();
                for (Component component2 : jPanel2.getComponents()) {
                    if (component2 instanceof HyperParamColoringHelper) {
                        HyperParamColoringHelper hyperParamColoringHelper = (HyperParamColoringHelper)((Object)component2);
                        hyperParamColoringHelper.setBackgroundColor(jTree.getBackground());
                        continue;
                    }
                    component2.setBackground(jTree.getBackground());
                    if (!(component2 instanceof JPanel)) continue;
                    stack.push((JPanel)component2);
                }
            }
        }
    }
}

