/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.tree.model;

import oracle.hcs.tree.model.AbstractTreeTableModel;
import oracle.hcs.tree.model.ColumnData;
import oracle.hcs.tree.model.DefaultNode;
import oracle.hcs.tree.model.Node;
import oracle.hcs.tree.model.TreeTable;
import oracle.hcs.tree.model.TreeTableModel;

public class DefaultTreeTableModel
extends AbstractTreeTableModel {
    private TreeTable tree;

    public DefaultTreeTableModel(TreeTable treeTable) {
        this.tree = treeTable;
        if (treeTable.getRoots().size() == 1) {
            Node node = treeTable.getRoots().get(0);
            this.setRoot(node);
        } else {
            DefaultNode defaultNode = new DefaultNode(treeTable, null, "DUMMY_ROOT");
            for (Node node : treeTable.getRoots()) {
                defaultNode.addChild(node);
            }
            this.setRoot(defaultNode);
        }
    }

    @Override
    public Object getChild(Object object, int n) {
        return ((Node)object).getChild(n);
    }

    @Override
    public int getChildCount(Object object) {
        int n = ((Node)object).getChildren().size();
        return n;
    }

    @Override
    public Object getValueAt(Object object, int n) {
        Node node = (Node)object;
        ColumnData columnData = (ColumnData)node.getUserObject();
        Object object2 = columnData.getData(n);
        return object2;
    }

    @Override
    public int getColumnCount() {
        return this.tree.getColumnCount();
    }

    @Override
    public String getColumnName(int n) {
        return this.tree.getColumnName(n);
    }

    @Override
    public Class getColumnClass(int n) {
        if (n == 0) {
            return TreeTableModel.class;
        }
        return Object.class;
    }
}

