/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.tree.view;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeModel;
import oracle.hcs.tree.model.DefaultTreeTableModel;
import oracle.hcs.tree.model.Node;
import oracle.hcs.tree.model.TreeTable;
import oracle.hcs.tree.model.TreeTableModel;
import oracle.hcs.tree.view.AbstractCellEditor;
import oracle.hcs.tree.view.CustomTreeCellRenderer;
import oracle.hcs.tree.view.JTreeTableToolTipManager;
import oracle.hcs.tree.view.TreeTableModelAdapter;

public class JTreeTable
extends JTable {
    private TreeTableCellRenderer jTree;
    private TreeTableModel treeTableModel;
    private JTreeTableToolTipManager toolTipManager;

    public JTreeTable() {
        this.init();
    }

    public JTreeTable(TreeTableModel treeTableModel) {
        this.treeTableModel = treeTableModel;
        this.init();
        this.setModel(treeTableModel);
    }

    public JTreeTable(TreeTable treeTable) {
        this.init();
        this.setModel(treeTable);
    }

    private void init() {
        this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.setAutoResizeMode(0);
        this.setCellSelectionEnabled(true);
        this.jTree = new TreeTableCellRenderer(this.treeTableModel);
        this.jTree.setSelectionModel(new DefaultTreeSelectionModel(){
            {
                JTreeTable.this.setSelectionModel(this.listSelectionModel);
            }
        });
        this.jTree.setRowHeight(this.getRowHeight());
        this.jTree.setShowsRootHandles(true);
        ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("folder.png"));
        ImageIcon imageIcon2 = new ImageIcon(this.getClass().getResource("member.png"));
        this.jTree.setLeafIcon(imageIcon2);
        this.jTree.setFolderIcon(imageIcon);
        this.jTree.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                JTreeTable.this.repaint();
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                JTreeTable.this.repaint();
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
            }
        });
        this.setDefaultRenderer(TreeTableModel.class, this.jTree);
        this.setDefaultEditor(TreeTableModel.class, new TreeTableCellEditor());
        this.setShowGrid(true);
        this.setIntercellSpacing(new Dimension(0, 1));
    }

    public void setModel(TreeTableModel treeTableModel) {
        Node node;
        super.setModel(new TreeTableModelAdapter(treeTableModel, this.jTree));
        this.jTree.setModel(treeTableModel);
        Object object = treeTableModel.getRoot();
        if (object instanceof Node && (node = (Node)object).getUserObject().equals("DUMMY_ROOT")) {
            this.jTree.setRootVisible(false);
        }
        if (this.getParent() != null) {
            this.getParent().invalidate();
        }
        this.invalidate();
    }

    public void setModel(TreeTable treeTable) {
        this.treeTableModel = new DefaultTreeTableModel(treeTable);
        this.setModel(this.treeTableModel);
    }

    public void setLeafIcon(Icon icon) {
        this.jTree.setLeafIcon(icon);
    }

    public void setFolderIcon(Icon icon) {
        this.jTree.setLeafIcon(icon);
    }

    public void expandAll(boolean bl) {
        for (int i = 0; i < this.jTree.getRowCount(); ++i) {
            if (bl) {
                this.jTree.expandRow(i);
                continue;
            }
            this.jTree.collapseRow(i);
        }
    }

    public void setToolTipManager(JTreeTableToolTipManager jTreeTableToolTipManager) {
        this.toolTipManager = jTreeTableToolTipManager;
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        if (this.toolTipManager != null) {
            int n = this.rowAtPoint(mouseEvent.getPoint());
            int n2 = this.columnAtPoint(mouseEvent.getPoint());
            return this.toolTipManager.getCellToolTipValue(this, n2, n);
        }
        return null;
    }

    @Override
    public int getEditingRow() {
        return this.getColumnClass(this.editingColumn) == TreeTableModel.class ? -1 : this.editingRow;
    }

    public class TreeTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            return JTreeTable.this.jTree;
        }
    }

    public class TreeTableCellRenderer
    extends JTree
    implements TableCellRenderer {
        private CustomTreeCellRenderer tc;
        private int visibleRow;

        public TreeTableCellRenderer(TreeModel treeModel) {
            super(treeModel);
            this.tc = new CustomTreeCellRenderer();
            this.setCellRenderer(this.tc);
        }

        public void setModel(TreeTableModel treeTableModel) {
            super.setModel(treeTableModel);
            this.updateUI();
        }

        public void setLeafIcon(Icon icon) {
            this.tc.setLeafIcon(icon);
        }

        public void setFolderIcon(Icon icon) {
            this.tc.setFolderIcon(icon);
        }

        @Override
        public void setBounds(int n, int n2, int n3, int n4) {
            super.setBounds(n, 0, n3, JTreeTable.this.getHeight());
        }

        @Override
        public void paint(Graphics graphics) {
            graphics.translate(0, -this.visibleRow * this.getRowHeight());
            super.paint(graphics);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.visibleRow = n;
            return this;
        }
    }
}

