/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.util;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import oracle.bali.share.nls.StringUtils;
import oracle.hcs.HCSArb;
import oracle.hcs.util.PanelChanged;
import oracle.hcs.util.RestrictedTextField;
import oracle.ide.db.components.ComponentFactory;

public class DataTypeUI
implements ActionListener {
    private ComponentFactory helper;
    private JLabel dataTypeLabel;
    private DefaultComboBoxModel dataTypeModel;
    private JComboBox dataTypeComboBox;
    private JLabel dataTypeSizeLabel;
    private RestrictedTextField dataTypeSizeTextField;
    private JLabel dataTypeScaleLabel;
    private RestrictedTextField dataTypeScaleTextField;
    private PanelChanged propertyPanel;
    private static final String[] m_DataTypes = new String[]{"DATE", "DATETIME", "DECIMAL", "INTEGER", "NUMBER", "CHAR", "NCHAR", "VARCHAR2", "NVARCHAR2", "TIMESTAMP", "TIMESTAMP WITH TIME ZONE", "TIMESTAMP WITH LOCAL TIME ZONE", "BINARY_DOUBLE", "BINARY_FLOAT", "INTERVAL DAY TO SECOND", "INTERVAL YEAR TO MONTH"};

    public DataTypeUI(ComponentFactory componentFactory) {
        this(componentFactory, null);
    }

    public DataTypeUI(PanelChanged panelChanged) {
        this(null, panelChanged);
    }

    public DataTypeUI(ComponentFactory componentFactory, PanelChanged panelChanged) {
        this.helper = componentFactory;
        this.propertyPanel = panelChanged;
        String string = "MODELER.ATTRIBUTES.TYPE.ATTRIBUTE_DATA_TYPE.LABEL";
        this.dataTypeLabel = new JLabel();
        this.dataTypeModel = new DefaultComboBoxModel();
        this.dataTypeComboBox = new JComboBox(this.dataTypeModel);
        if (componentFactory != null) {
            componentFactory.registerComponent(this.dataTypeLabel, (Component)this.dataTypeComboBox, HCSArb.get(string), "DataType", "dataType");
        } else {
            this.dataTypeLabel.setText(StringUtils.stripMnemonic((String)HCSArb.get(string)));
            this.dataTypeLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)HCSArb.get(string)));
        }
        string = "MODELER.IMPL.DATA.SCALE";
        this.dataTypeSizeLabel = new JLabel();
        this.dataTypeSizeTextField = new RestrictedTextField(2);
        this.dataTypeSizeTextField.setFilterMode(2);
        this.dataTypeSizeTextField.setMaximumLength(4);
        if (componentFactory != null) {
            componentFactory.registerComponent(this.dataTypeSizeLabel, (Component)this.dataTypeSizeTextField, HCSArb.get(string), "DataTypeSize", "dataType");
        } else {
            this.dataTypeSizeLabel.setText(StringUtils.stripMnemonic((String)HCSArb.get(string)));
            this.dataTypeSizeLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)HCSArb.get(string)));
            this.dataTypeSizeLabel.setLabelFor(this.dataTypeSizeTextField);
        }
        string = "MODELER.IMPL.DATA.SCALE";
        this.dataTypeScaleLabel = new JLabel();
        this.dataTypeScaleTextField = new RestrictedTextField(2);
        this.dataTypeScaleTextField.setFilterMode(2);
        this.dataTypeScaleTextField.setMaximumLength(4);
        if (componentFactory != null) {
            componentFactory.registerComponent(this.dataTypeScaleLabel, (Component)this.dataTypeScaleLabel, HCSArb.get(string), "DataTypeScale", "dataType");
        } else {
            this.dataTypeScaleLabel.setText(StringUtils.stripMnemonic((String)HCSArb.get(string)));
            this.dataTypeScaleLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)HCSArb.get(string)));
            this.dataTypeScaleLabel.setLabelFor(this.dataTypeScaleLabel);
        }
        String[] stringArray = m_DataTypes;
        for (int i = 0; i < stringArray.length; ++i) {
            this.dataTypeModel.addElement(stringArray[i]);
        }
        this.dataTypeComboBox.addActionListener(this);
    }

    public void refreshDataTypeUI() {
        String string = (String)this.dataTypeModel.getSelectedItem();
        if (string != null) {
            this.dataTypeComboBox.removeActionListener(this);
            this.dataTypeModel.setSelectedItem(string);
            this.dataTypeComboBox.setSelectedItem(string);
            this.initializeDataTypeUIForRefresh(string);
            this.dataTypeComboBox.addActionListener(this);
        }
    }

    private void initializeDataTypeUIForRefresh(String string) {
        boolean bl = true;
        boolean bl2 = true;
        if (string.equals("VARCHAR2") || string.equals("NVARCHAR2") || string.equals("CHAR") || string.equals("NCHAR")) {
            bl2 = false;
        }
        if (string.equals("DATE") || string.equals("INTEGER") || string.equals("DECIMAL") || string.equals("BINARY_DOUBLE") || string.equals("BINARY_FLOAT") || string.equals("TIMESTAMP") || string.equals("TIMESTAMP WITH TIME ZONE") || string.equals("TIMESTAMP WITH LOCAL TIME ZONE") || string.equals("DATETIME") || string.equals("INTERVAL YEAR TO MONTH") || string.equals("INTERVAL DAY TO SECOND")) {
            bl2 = false;
            bl = false;
        }
        if (string.equals("FLOAT")) {
            bl2 = false;
        }
        this.dataTypeSizeLabel.setVisible(bl);
        this.dataTypeSizeTextField.setVisible(bl);
        this.dataTypeScaleLabel.setVisible(bl2);
        this.dataTypeScaleTextField.setVisible(bl2);
    }

    public boolean isVisible() {
        return this.dataTypeComboBox.isVisible();
    }

    public void fieldValueChanged() {
        if (this.propertyPanel != null) {
            this.propertyPanel.changed();
        }
    }

    public void setEnabled(boolean bl) {
        this.dataTypeLabel.setEnabled(bl);
        this.dataTypeComboBox.setEnabled(bl);
        this.dataTypeSizeLabel.setEnabled(bl);
        this.dataTypeSizeTextField.setEnabled(bl);
        this.dataTypeScaleLabel.setEnabled(bl);
        this.dataTypeScaleTextField.setEnabled(bl);
    }

    public void init(String string) {
        this.dataTypeComboBox.setSelectedItem(string);
    }

    public void setDataType(String string) {
        this.setDataTypeModel(string);
    }

    public void setDataType(String string, String string2, String string3) {
        this.setDataTypeModel(string);
        this.dataTypeSizeTextField.setText(string2);
        this.dataTypeScaleTextField.setText(string3);
        this.dataTypeSizeTextField.setEnabled(false);
        this.dataTypeScaleTextField.setEnabled(false);
    }

    public void setSQLDataType(String string) {
        String string2 = null;
        String string3 = null;
        String string4 = null;
        if (string == null) {
            return;
        }
        int n = string.indexOf("(");
        if (n > -1) {
            int n2 = string.indexOf(")");
            int n3 = string.indexOf(",");
            string2 = string.substring(0, n);
            if (n3 > -1) {
                string3 = string.substring(n + 1, n3);
                string4 = string.substring(n3 + 1, n2);
            } else {
                string3 = string.substring(n + 1, n2);
            }
        } else {
            string2 = string;
        }
        this.setDataType(string2);
        if (string3 != null) {
            this.setDataTypeSize(string3);
        } else {
            this.setDataTypeSize("");
        }
        if (string4 != null) {
            this.setDataTypeScale(string4);
        } else {
            this.setDataTypeScale("");
        }
    }

    public String getSQLDataType() {
        Object object = null;
        String string = null;
        String string2 = null;
        object = this.getDataType();
        string = this.getDataTypeSize();
        string2 = this.getDataTypeScale();
        if (string.length() > 0) {
            object = (String)object + "(" + string;
            if (string2.length() > 0) {
                object = (String)object + "," + string2;
            }
            object = (String)object + ")";
        }
        return object;
    }

    public String getDataType() {
        return (String)this.dataTypeModel.getSelectedItem();
    }

    public String getDataTypeSize() {
        return this.dataTypeSizeTextField.getText();
    }

    public void setDataTypeSize(String string) {
        this.dataTypeSizeTextField.setText(string);
    }

    public String getDataTypeScale() {
        return this.dataTypeScaleTextField.getText();
    }

    public void setDataTypeScale(String string) {
        this.dataTypeScaleTextField.setText(string);
    }

    public JLabel getDataTypeLabel() {
        return this.dataTypeLabel;
    }

    public JComboBox getDataTypeComboBox() {
        return this.dataTypeComboBox;
    }

    public JLabel getDataTypeSizeLabel() {
        return this.dataTypeSizeLabel;
    }

    public RestrictedTextField getDataTypeSizeTextField() {
        return this.dataTypeSizeTextField;
    }

    public JLabel getDataTypeScaleLabel() {
        return this.dataTypeScaleLabel;
    }

    public RestrictedTextField getDataTypeScaleTextField() {
        return this.dataTypeScaleTextField;
    }

    private void setDataTypeModel(String string) {
        String string2 = HCSArb.get("DATATYPE.NONE");
        for (int i = 0; i < this.dataTypeModel.getSize(); ++i) {
            if (!this.dataTypeModel.getElementAt(i).equals(string2)) continue;
            this.dataTypeModel.removeElementAt(i);
            break;
        }
        if (string == null) {
            this.dataTypeModel.addElement(string2);
            this.dataTypeModel.setSelectedItem(string2);
        } else {
            this.dataTypeModel.setSelectedItem(string);
        }
    }

    private void setPrecisionLabel(boolean bl) {
        String string = "";
        string = !bl ? HCSArb.get("MODELER.IMPL.DATA.SIZE") : HCSArb.get("MODELER.IMPL.DATA.PRECISION");
        this.dataTypeSizeLabel.setText(StringUtils.stripMnemonic((String)string));
        int n = StringUtils.getMnemonicIndex((String)string);
        this.dataTypeSizeLabel.setDisplayedMnemonicIndex(n);
        this.dataTypeSizeLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)string));
    }

    public void addDataType(String string) {
        int n = this.dataTypeModel.getIndexOf(string);
        if (n == -1) {
            this.dataTypeModel.addElement(string);
        }
    }

    public void removeDataTypel(String string) {
        for (int i = 0; i < this.dataTypeModel.getSize(); ++i) {
            if (!this.dataTypeModel.getElementAt(i).equals(string)) continue;
            this.dataTypeModel.removeElementAt(i);
            break;
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.propertyPanel != null) {
            this.propertyPanel.changed();
        }
        String string = (String)this.dataTypeModel.getSelectedItem();
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = false;
        this.dataTypeSizeTextField.setText("");
        this.dataTypeScaleTextField.setText("");
        if (string.equals("VARCHAR2") || string.equals("NVARCHAR2") || string.equals("CHAR") || string.equals("NCHAR")) {
            bl2 = false;
        }
        if (string.equals("DATE") || string.equals("INTEGER") || string.equals("DECIMAL") || string.equals("BINARY_DOUBLE") || string.equals("BINARY_FLOAT") || string.equals("TIMESTAMP") || string.equals("TIMESTAMP WITH TIME ZONE") || string.equals("TIMESTAMP WITH LOCAL TIME ZONE") || string.equals("DATETIME") || string.equals("INTERVAL YEAR TO MONTH") || string.equals("INTERVAL DAY TO SECOND")) {
            bl2 = false;
            bl = false;
        }
        if (string.equals("NUMBER")) {
            bl3 = true;
        }
        if (string.equals("FLOAT")) {
            bl3 = true;
            bl2 = false;
        }
        if (string.equals("NVARCHAR2") || string.equals("VARCHAR2")) {
            this.dataTypeSizeTextField.setText("256");
        }
        if (string.equals("NCHAR") || string.equals("CHAR")) {
            this.dataTypeSizeTextField.setText("1");
        }
        this.setPrecisionLabel(bl3);
        this.dataTypeSizeLabel.setVisible(bl);
        this.dataTypeSizeTextField.setVisible(bl);
        this.dataTypeScaleLabel.setVisible(bl2);
        this.dataTypeScaleTextField.setVisible(bl2);
    }
}

