/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.validation;

import java.awt.Component;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.hcs.HCSArb;
import oracle.hcs.db.DatabaseUtils;
import oracle.hcs.table.Queries;
import oracle.hcs.util.JavaXMLBind;
import oracle.ide.Ide;

public class HCSValidationQuery {
    private DBObject dbObject;
    private Logger Log = Logger.getLogger(HCSValidationQuery.class.getName());
    private static Queries queries;
    private static final int LOG_TABLE_COLUMN_COUNT = 8;
    private static final String XMLFILE = "hcsvalidationqueries.xml";
    protected static final String GET_PROC_CREATE_VALIDATE_LOG_TABLE = "get_proc_create_validate_log_table";
    protected static final String GET_LOG_TABLES_IN_SCHEMA = "get_log_tables_in_schema";
    protected static final String GET_TABLE_EXIST_IN_SCHEMA = "get_table_exist_in_schema";
    protected static final String GET_LOG_TABLE_VALID = "get_log_table_valid";
    protected static final String GET_MAX_LOG_NUMBER = "get_max_log_number";
    protected static final String GET_PROC_VALIDATE_HIERARCHY = "get_proc_validate_hierarchy";
    protected static final String GET_LOG_DETAILS = "get_log_details";
    protected static final String GET_PLSQL_SCRIPT = "get_plsql_hierarchy_validation_script";
    protected static final String CHECK_SUCCESS = "check_success";

    public HCSValidationQuery(DBObject dBObject) {
        this.dbObject = dBObject;
    }

    protected String getQuery(String string) {
        if (queries == null) {
            try {
                String string2 = "oracle.hcs.table";
                String string3 = JavaXMLBind.LoadDocument(this.getClass(), XMLFILE);
                JavaXMLBind.BindToJavaStr(string3, string2, this);
            }
            catch (Exception exception) {
                this.Log.log(Level.WARNING, exception.getLocalizedMessage(), exception);
            }
        }
        return queries.getSQL(string);
    }

    public void addQueries(Queries queries) {
        HCSValidationQuery.queries = queries;
    }

    public void createLogTable(String string) {
        Connection connection = this.dbObject.getConnection();
        try {
            String string2 = this.getQuery(GET_PROC_CREATE_VALIDATE_LOG_TABLE);
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string);
            DatabaseUtils.ExecuteStoredProc(connection, string2, arrayList);
        }
        catch (IOException | SQLException exception) {
            this.Log.log(Level.SEVERE, "Error creating validation log table in method, createLogTable", exception);
        }
    }

    protected List<String> getLogTablesInUserSchema() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Connection connection = this.dbObject.getConnection();
        List list = null;
        String string = this.getQuery(GET_LOG_TABLES_IN_SCHEMA);
        try {
            DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
            HashMap hashMap = new HashMap();
            list = dBUtil.executeReturnList(string, hashMap);
            SQLException sQLException = dBUtil.getLastException();
            if (sQLException != null) {
                throw sQLException;
            }
            for (Map map : list) {
                String string2 = (String)map.get("TABLE_NAME");
                if (string2.startsWith("AW$")) continue;
                arrayList.add(string2);
            }
        }
        catch (Exception exception) {
            this.Log.log(Level.SEVERE, "In method getLogTablesInUserSchema, SQL Exception occurred.", exception);
        }
        return arrayList;
    }

    public boolean logTableExist(String string, String string2) {
        boolean bl = false;
        Connection connection = this.dbObject.getConnection();
        String string3 = this.getQuery(GET_TABLE_EXIST_IN_SCHEMA);
        try {
            DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("OWNER", string.toUpperCase());
            hashMap.put("TABLE_NAME", string2.toUpperCase());
            List list = dBUtil.executeReturnList(string3, hashMap);
            SQLException sQLException = dBUtil.getLastException();
            if (sQLException != null) {
                throw sQLException;
            }
            if (!list.isEmpty()) {
                bl = true;
            }
        }
        catch (Exception exception) {
            this.Log.log(Level.SEVERE, "In method logTableExist, SQL Exception occurred.", exception);
        }
        return bl;
    }

    public boolean logTableValid(String string, String string2) {
        boolean bl = false;
        Connection connection = this.dbObject.getConnection();
        int n = 0;
        String string3 = this.getQuery(GET_LOG_TABLE_VALID);
        try {
            DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("OWNER", string.toUpperCase());
            hashMap.put("TABLE_NAME", string2.toUpperCase());
            String string4 = dBUtil.executeReturnOneCol(string3, hashMap);
            SQLException sQLException = dBUtil.getLastException();
            if (sQLException != null) {
                throw sQLException;
            }
            if (string4 != null) {
                n = Integer.valueOf(string4);
            }
            if (n == 8) {
                bl = true;
            } else {
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), HCSArb.format("HIERARCHY_VALIDATION_INVALID_LOG_TABLE_MSG", string2), HCSArb.getString("HIERARCHY_VALIDATION_INVALID_LOG_TABLE_TITLE"), 0);
            }
        }
        catch (Exception exception) {
            this.Log.log(Level.SEVERE, "In method logTableValid, SQL Exception occurred.", exception);
        }
        return bl;
    }

    public long getMaxLogNumberFromValidationTable(String string, String string2) {
        long l = 0L;
        Connection connection = this.dbObject.getConnection();
        String string3 = String.format(this.getQuery(GET_MAX_LOG_NUMBER), string, string2);
        try {
            DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
            String string4 = dBUtil.executeReturnOneCol(string3);
            SQLException sQLException = dBUtil.getLastException();
            if (sQLException != null) {
                throw sQLException;
            }
            if (string4 != null) {
                l = Integer.valueOf(string4).intValue();
            }
        }
        catch (Exception exception) {
            this.Log.log(Level.SEVERE, "In method getMaxLogNumberFromValidationTable, SQL Exception occurred.", exception);
        }
        return l;
    }

    public boolean isValidationSuccessful(String string, String string2, Long l) {
        boolean bl = false;
        Connection connection = this.dbObject.getConnection();
        String string3 = String.format(this.getQuery(CHECK_SUCCESS), string, this.dbObject.getObjectName(), string2, l);
        try {
            DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
            String string4 = dBUtil.executeReturnOneCol(string3);
            SQLException sQLException = dBUtil.getLastException();
            if (sQLException != null) {
                throw sQLException;
            }
            if (string4 != null && string4.equalsIgnoreCase("SUCCESS")) {
                bl = true;
            }
        }
        catch (Exception exception) {
            this.Log.log(Level.SEVERE, "In method isValidationSuccessful, SQL Exception occurred.", exception);
        }
        return bl;
    }
}

