/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.index;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import oracle.ide.cmd.ExitCommand;
import oracle.ide.cmd.ShutdownHook;
import oracle.ide.file.FileChangesExpiredException;
import oracle.ide.file.FileSet;
import oracle.ide.file.FileSetTable;
import oracle.ide.file.FileTable;
import oracle.ide.index.IndexingListener;
import oracle.ide.index.LockFailedException;
import oracle.ide.index.QueryCriteria;
import oracle.ide.index.QueryFailedException;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.JarIndex;
import oracle.ide.net.JarUtil;
import oracle.ide.performance.PerformanceLogger;
import oracle.ide.persistence.NameSpace;
import oracle.ide.persistence.Storage;
import oracle.ide.persistence.Storages;
import oracle.ide.util.IntHashMap;
import oracle.ideimpl.index.DataCollectorImpl;
import oracle.ideimpl.index.DataLocation;
import oracle.ideimpl.index.FileData;
import oracle.ideimpl.index.IndexIdTable;
import oracle.ideimpl.index.IndexInfo;
import oracle.ideimpl.index.IndexLogger;
import oracle.ideimpl.index.IndexProgressMonitor;
import oracle.ideimpl.index.IndexerStatistics;
import oracle.ideimpl.index.IndexingClient;
import oracle.ideimpl.index.IndexingContextImpl;
import oracle.ideimpl.index.ResultCollector;
import oracle.ideimpl.index.extension.IndexingInfo;
import oracle.javatools.assembly.AssemblyException;
import oracle.javatools.assembly.ObjectFactory;
import oracle.javatools.assembly.VariableLengthIntArrayFactory;
import oracle.javatools.util.ArraySortedSet;
import oracle.javatools.util.Maps;
import org.openide.util.RequestProcessor;

@ThreadSafe
public class IndexRoot
implements Runnable {
    private static final String STORAGE_PREFIX = "$index.Data$";
    private static final String INFO_RECORD_NAME = "$index.info$";
    private static final String ID_TABLE_RECORD_NAME = "$index.id.table$";
    private static final char[] ENCODING_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v'};
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private static final boolean VALIDATE = Boolean.getBoolean("ide.index.validate");
    private static final long VERSION_THRESHOLD;
    private static boolean shutdown;
    private static final ObjectFactory INT_ARRAY_FACTORY;
    private static final Comparator<Integer> REVERSE_COMPARATOR;
    private static final Map<FileSet, IndexRoot> INSTANCES;
    private static final int MEMORY_THRESHOLD = 0x200000;
    protected static final ExecutorService UPDATE_SCHEDULER;
    private final Workspace workspace;
    private final Project project;
    private final FileSet fileSet;
    @GuardedBy(value="lock")
    private String storageKey;
    private ReentrantLock lock = new ReentrantLock();
    private Condition updateFinished = this.lock.newCondition();
    @GuardedBy(value="lock")
    private long version = 0L;
    @GuardedBy(value="lock")
    private long lastCleanup = 0L;
    @GuardedBy(value="lock")
    private long cookie = -1L;
    @GuardedBy(value="lock")
    private Storage storage;
    @GuardedBy(value="lock")
    private NameSpace namespace;
    @GuardedBy(value="lock")
    private IndexIdTable fileTable;
    @GuardedBy(value="lock")
    private Future runningUpdate;
    @GuardedBy(value="lock")
    private List<IndexRootProgressMonitor> monitors = new ArrayList<IndexRootProgressMonitor>();
    @GuardedBy(value="lock")
    private int updateCount;
    @GuardedBy(value="lock")
    private int lockCount;
    @GuardedBy(value="INSTANCES")
    private int refCount;
    @GuardedBy(value="lock")
    private int[] changedFiles;
    @GuardedBy(value="lock")
    private boolean disposed;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IndexRoot getIndexRoot(Workspace workspace, Project project, FileSet fileSet) {
        Map<FileSet, IndexRoot> map = INSTANCES;
        synchronized (map) {
            IndexRoot instance = INSTANCES.get(fileSet);
            if (instance == null) {
                fileSet = fileSet.intern();
                instance = new IndexRoot(workspace, project, fileSet);
                INSTANCES.put(fileSet, instance);
            }
            instance.acquire();
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanup(Workspace workspace) {
        Map<FileSet, IndexRoot> map = INSTANCES;
        synchronized (map) {
            Iterator<IndexRoot> iterator = INSTANCES.values().iterator();
            while (iterator.hasNext()) {
                IndexRoot root = iterator.next();
                if (root == null || root.refCount != 0 || !workspace.equals((Object)root.workspace)) continue;
                iterator.remove();
                root.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanup(Project project) {
        Map<FileSet, IndexRoot> map = INSTANCES;
        synchronized (map) {
            Iterator<IndexRoot> iterator = INSTANCES.values().iterator();
            while (iterator.hasNext()) {
                IndexRoot root = iterator.next();
                if (root == null || root.refCount != 0 || !project.equals((Object)root.project)) continue;
                iterator.remove();
                root.dispose();
            }
        }
    }

    private IndexRoot(Workspace workspace, Project project, FileSet fileSet) {
        this.workspace = workspace;
        this.project = project;
        this.fileSet = fileSet;
    }

    public FileSet getFileSet() {
        return this.fileSet;
    }

    public URL getRootURL() {
        return this.fileSet.getRoot();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock() throws InterruptedException, LockFailedException {
        this.lock.lockInterruptibly();
        try {
            if (this.lockCount == 0) {
                boolean success = false;
                try {
                    this.storage = this.project == null ? Storages.getApplicationStorage((Workspace)this.workspace) : (this.workspace == null ? Storages.getProjectStorage((Project)this.project) : Storages.getProjectStorage((Workspace)this.workspace, (Project)this.project));
                    this.storage.open();
                    this.storageKey = IndexRoot.getStorageKey(this.storage, this.fileSet);
                    this.namespace = this.getNameSpace();
                    if (this.namespace == null) {
                        this.storage.close();
                        this.storage = null;
                        throw new LockFailedException("Unable to open index for " + this.fileSet);
                    }
                    this.validate();
                    IndexInfo info = this.loadIndexInfo();
                    byte[] tableData = this.namespace.getRecord(ID_TABLE_RECORD_NAME);
                    if (info != null && this.checkVersionThreshold(info) && tableData != null) {
                        this.version = info.version;
                        this.lastCleanup = info.lastCleanup;
                        this.cookie = info.cookie;
                    } else {
                        this.version = 0L;
                        this.lastCleanup = 0L;
                        this.cookie = -1L;
                    }
                    long start = System.nanoTime();
                    Storage fileTableStorage = this.workspace == null ? this.storage : Storages.getApplicationStorage((Workspace)this.workspace);
                    IndexIdTable oldFileTable = this.fileTable;
                    FileSetTable table = FileSetTable.getInstance((Storage)fileTableStorage, (FileSet)this.fileSet);
                    this.invokeIndexingListeners(this.workspace, this.project, (FileTable)table);
                    try {
                        this.fileTable = IndexIdTable.getInstance(table, tableData, (int)this.version, this.cookie);
                    }
                    catch (FileChangesExpiredException e) {
                        IndexLogger.getLogger().fine("File table expired for " + this.fileSet);
                        this.namespace.close();
                        this.storage.deleteNameSpace(this.storageKey);
                        this.namespace = this.getNameSpace();
                        this.version = 0L;
                        this.lastCleanup = 0L;
                        this.cookie = -1L;
                        this.fileTable = IndexIdTable.getInstance(table, null, (int)this.version, this.cookie);
                    }
                    if (oldFileTable != null) {
                        oldFileTable.release();
                    }
                    IndexerStatistics.addFileTableTime(System.nanoTime() - start);
                    this.fileTable.dump();
                    this.changedFiles = null;
                    success = true;
                }
                finally {
                    if (!success) {
                        if (this.namespace != null) {
                            this.namespace.close();
                            this.namespace = null;
                        }
                        if (this.storage != null) {
                            this.storage.close();
                            this.storage = null;
                        }
                    }
                }
            }
            ++this.lockCount;
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (RejectedExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new LockFailedException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void unlock() {
        this.lock.lock();
        try {
            if (--this.lockCount == 0) {
                this.namespace.close();
                this.namespace = null;
                this.storage.close();
                this.storage = null;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public IndexIdTable getFileTable() {
        this.lock.lock();
        try {
            IndexIdTable indexIdTable = this.fileTable;
            return indexIdTable;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void query(QueryCriteria criteria, ResultCollector results) throws InterruptedException, QueryFailedException {
        QueryCriteria copy = new QueryCriteria();
        copy.putAll(criteria);
        Set entries = copy.entrySet();
        Iterator iterator = entries.iterator();
        while (iterator.hasNext()) {
            if (shutdown || Thread.interrupted()) {
                throw new InterruptedException();
            }
            Map.Entry entry = iterator.next();
            iterator.remove();
            Object value = entry.getValue();
            results.startResultSet(copy.isEmpty());
            if (value instanceof String) {
                String[] values;
                String str = (String)value;
                for (String current : values = str.split("\\|")) {
                    this.lookup(entry.getKey(), current, results);
                }
            } else {
                this.lookup(entry.getKey(), entry.getValue(), results);
            }
            results.endResultSet();
        }
    }

    public int getChangedFileCount() throws InterruptedException {
        this.lock.lockInterruptibly();
        try {
            if (this.changedFiles == null) {
                this.changedFiles = this.fileTable.getChangedFiles();
            }
            int n = this.changedFiles.length;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquire() {
        Map<FileSet, IndexRoot> map = INSTANCES;
        synchronized (map) {
            ++this.refCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Map<FileSet, IndexRoot> map = INSTANCES;
        synchronized (map) {
            --this.refCount;
        }
    }

    protected void finalize() {
        this.dispose();
    }

    private void dispose() {
        this.lock.lock();
        try {
            if (!this.disposed) {
                if (this.fileTable != null) {
                    this.fileTable.release();
                }
                this.disposed = true;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(IndexProgressMonitor progress) throws InterruptedException {
        block17: {
            this.lock.lockInterruptibly();
            try {
                if (this.fileTable.getVersion() == this.version && this.fileTable.getCookie() == this.cookie) break block17;
                IndexRootProgressMonitor rootProgress = null;
                if (progress != null) {
                    rootProgress = new IndexRootProgressMonitor(progress);
                    this.monitors.add(rootProgress);
                }
                if (this.runningUpdate == null) {
                    try {
                        this.runningUpdate = UPDATE_SCHEDULER.submit(this);
                    }
                    catch (RejectedExecutionException e) {
                        if (rootProgress != null) {
                            this.monitors.remove(rootProgress);
                        }
                        throw new InterruptedException();
                    }
                }
                boolean cancelled = false;
                Future task = this.runningUpdate;
                ++this.updateCount;
                try {
                    while (task == this.runningUpdate) {
                        this.updateFinished.await();
                    }
                }
                catch (InterruptedException e) {
                    cancelled = true;
                    if (rootProgress != null) {
                        this.monitors.remove(rootProgress);
                    }
                    if (--this.updateCount == 0 && this.runningUpdate != null) {
                        this.runningUpdate.cancel(true);
                        this.runningUpdate = null;
                    }
                    throw e;
                }
                finally {
                    if (!cancelled) {
                        --this.updateCount;
                    }
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void run() {
        PerformanceLogger.get().startTiming("IndexRoot.run");
        int[] ids = null;
        try {
            this.lock();
            try {
                IndexIdTable localFileTable;
                this.lock.lockInterruptibly();
                try {
                    if (this.getChangedFileCount() == 0) {
                        return;
                    }
                    ids = new int[this.changedFiles.length];
                    System.arraycopy(this.changedFiles, 0, ids, 0, this.changedFiles.length);
                    localFileTable = this.fileTable;
                }
                finally {
                    this.lock.unlock();
                }
                Node.beginThreadNodeUsageCycle();
                try {
                    int current = 0;
                    IntHashMap data = new IntHashMap();
                    while (current < ids.length) {
                        if (shutdown) {
                            break;
                        }
                        current = this.updateImpl(localFileTable, ids, current, (IntHashMap<ArraySortedSet<FileData>>)data);
                        this.lock.lockInterruptibly();
                        try {
                            if (current == ids.length) {
                                long newVersion = this.fileTable.getVersion();
                                long newCookie = this.fileTable.getCookie();
                                this.saveIndex(newVersion, this.lastCleanup, newCookie, (IntHashMap<ArraySortedSet<FileData>>)data);
                                this.version = newVersion;
                                this.cookie = newCookie;
                                continue;
                            }
                            this.saveIndex(-1L, -1L, -1L, (IntHashMap<ArraySortedSet<FileData>>)data);
                        }
                        finally {
                            this.lock.unlock();
                        }
                    }
                }
                finally {
                    Node.endThreadNodeUsageCycle();
                }
            }
            finally {
                this.unlock();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Throwable t) {
            IndexLogger.getLogger().log(Level.SEVERE, "Exception while building index for " + this.fileSet, t);
        }
        finally {
            this.lock.lock();
            try {
                this.runningUpdate = null;
                this.monitors.clear();
                this.changedFiles = new int[0];
                this.updateFinished.signalAll();
            }
            finally {
                this.lock.unlock();
            }
            if (ids != null) {
                PerformanceLogger.get().stopTiming("IndexRoot.run", "Indexed " + ids.length + " files");
            } else {
                PerformanceLogger.get().stopTiming("IndexRoot.run", null);
            }
        }
    }

    private IndexInfo loadIndexInfo() {
        byte[] data;
        IndexInfo info = null;
        if (this.namespace != null && (data = this.namespace.getRecord(INFO_RECORD_NAME)) != null) {
            try {
                info = (IndexInfo)IndexInfo.INDEX_INFO_FACTORY.assemble(data);
            }
            catch (AssemblyException e) {
                this.namespace.close();
                this.storage.deleteNameSpace(this.storageKey);
                IndexLogger.getLogger().log(Level.FINE, "Invalid index for " + this.fileSet, e);
                this.namespace = this.getNameSpace();
            }
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveIndex(long version, long lastCleanup, long cookie, IntHashMap<ArraySortedSet<FileData>> dataMap) {
        if (this.namespace != null) {
            long start = System.nanoTime();
            try {
                if (version != -1L) {
                    IndexInfo info = new IndexInfo(version, lastCleanup, cookie);
                    byte[] data = IndexInfo.INDEX_INFO_FACTORY.disassemble((Object)info);
                    this.namespace.putRecord(INFO_RECORD_NAME, data);
                    this.namespace.putRecord(ID_TABLE_RECORD_NAME, this.fileTable.save());
                }
                Set hashSet = dataMap.keySet();
                int numHashes = hashSet.size();
                Integer[] hashesToProcess = hashSet.toArray(new Integer[numHashes]);
                Arrays.sort(hashesToProcess, REVERSE_COMPARATOR);
                for (int i = 0; i < numHashes; ++i) {
                    int hash = hashesToProcess[i];
                    String hashStr = IndexRoot.encode(hash);
                    byte[] data = this.namespace.getRecord(hashStr);
                    int[] oldData = EMPTY_INT_ARRAY;
                    if (data != null) {
                        oldData = (int[])INT_ARRAY_FACTORY.assemble(data);
                    }
                    int[] newData = this.mergeData(oldData, (ArraySortedSet<FileData>)((ArraySortedSet)dataMap.remove(hash)));
                    data = INT_ARRAY_FACTORY.disassemble((Object)newData);
                    this.namespace.putRecord(hashStr, data);
                }
                this.namespace.flush();
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.namespace.close();
                this.storage.deleteNameSpace(this.storageKey);
                IndexLogger.getLogger().log(Level.INFO, "Corrupted index deleted for " + this.fileSet);
                this.namespace = this.getNameSpace();
            }
            catch (AssemblyException e) {
                this.namespace.close();
                this.storage.deleteNameSpace(this.storageKey);
                IndexLogger.getLogger().log(Level.INFO, "Unable to save index for " + this.fileSet, e);
                this.namespace = this.getNameSpace();
            }
            finally {
                IndexerStatistics.addSaveTime(System.nanoTime() - start);
            }
        }
    }

    private static final String encode(int hash) {
        char[] c = new char[7];
        for (int i = 6; i >= 0; --i) {
            c[i] = ENCODING_CHARS[hash & 0x1F];
            hash >>>= 5;
        }
        return new String(c);
    }

    private int[] mergeData(int[] oldData, ArraySortedSet<FileData> newData) {
        int i = 0;
        int lastId = -1;
        int lastValidId = -1;
        int j = 0;
        while (j < oldData.length) {
            int delta = oldData[j++];
            int n = lastId = lastId == -1 ? delta : lastId + delta;
            if (this.fileTable.isValid(lastId)) {
                if (i == j - 1) {
                    lastValidId = lastId;
                    j += oldData[j] * 2 + 1;
                    i = j;
                    continue;
                }
                oldData[i++] = lastValidId == -1 ? lastId : lastId - lastValidId;
                lastValidId = lastId;
                int numLocations = oldData[j++];
                oldData[i++] = numLocations;
                for (int k = 0; k < numLocations; ++k) {
                    oldData[i++] = oldData[j++];
                    oldData[i++] = oldData[j++];
                }
                continue;
            }
            j += oldData[j] * 2 + 1;
        }
        int size = i + newData.size() * 2;
        for (FileData fileData : newData) {
            size += fileData.locations.size() * 2;
        }
        int[] merged = null;
        if (size == oldData.length) {
            merged = oldData;
        } else {
            merged = new int[size];
            if (i != 0) {
                System.arraycopy(oldData, 0, merged, 0, i);
            }
        }
        for (FileData fileData : newData) {
            ArraySortedSet<DataLocation> locations = fileData.locations;
            merged[i++] = lastValidId != -1 ? fileData.id - lastValidId : fileData.id;
            int sizeIndex = i++;
            int numLocations = locations.size();
            int lastOffset = -1;
            int lastLength = -1;
            for (DataLocation location : locations) {
                if (location.length == 0) {
                    --numLocations;
                    continue;
                }
                int offset = lastOffset != -1 ? location.offset - lastOffset : location.offset;
                merged[i++] = offset;
                int length = lastLength != -1 ? location.length - lastLength : location.length;
                merged[i++] = length;
                lastOffset = location.offset;
                lastLength = location.length;
            }
            merged[sizeIndex] = numLocations;
            lastValidId = fileData.id;
        }
        return merged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int updateImpl(IndexIdTable localFileTable, int[] ids, int start, IntHashMap<ArraySortedSet<FileData>> data) throws InterruptedException {
        IndexingContextImpl context = new IndexingContextImpl(this.workspace, this.project);
        context.put("fileTable", localFileTable.getFileTable());
        context.startIndexing();
        JarIndex jarIndex = null;
        if (JarUtil.isJarURL((URL)this.fileSet.getRoot())) {
            jarIndex = JarIndex.getInstance((URL)JarUtil.getJarFileURL((URL)this.fileSet.getRoot()));
            jarIndex.lockJarFile();
        }
        try {
            int i;
            DataCollectorImpl collector = new DataCollectorImpl(data);
            for (i = start; i < ids.length && collector.getCount() < 0x200000; ++i) {
                int id = ids[i];
                if (shutdown || Thread.interrupted()) {
                    throw new InterruptedException();
                }
                URL url = localFileTable.getFileURL(id);
                if (url == null) continue;
                collector.setId(id);
                context.put("fileId", new Integer(localFileTable.getFileTableId(id)));
                long timestamp = localFileTable.getTimestamp(id);
                context.index(url, timestamp, collector);
                this.lock.lock();
                try {
                    for (IndexRootProgressMonitor progress : this.monitors) {
                        progress.setCurrentValue(i);
                    }
                    continue;
                }
                finally {
                    this.lock.unlock();
                }
            }
            int n = i;
            return n;
        }
        finally {
            if (jarIndex != null) {
                jarIndex.unlockJarFile();
            }
            context.endIndexing();
        }
    }

    private static String getStorageKey(Storage storage, FileSet fileSet) {
        StringBuilder builder = new StringBuilder();
        builder.append(STORAGE_PREFIX);
        builder.append(storage.getRelativePath(fileSet.getRoot()));
        builder.append(fileSet.getFilter().getUniqueIdentifier());
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lookup(Object key, Object value, ResultCollector results) throws InterruptedException, QueryFailedException {
        block12: {
            if (shutdown) {
                return;
            }
            this.lock.lockInterruptibly();
            try {
                int hash;
                byte[] data;
                if (this.namespace == null || (data = this.namespace.getRecord(IndexRoot.encode(hash = "xml.all".equals(key) ? key.hashCode() : key.hashCode() ^ value.hashCode()))) == null) break block12;
                try {
                    int count;
                    int lastId = -1;
                    int[] ints = (int[])INT_ARRAY_FACTORY.assemble(data);
                    for (int i = 0; i < ints.length; i += count * 2 + 2) {
                        int id = ints[i];
                        if (lastId != -1) {
                            id += lastId;
                        }
                        count = ints[i + 1];
                        int lastOffset = -1;
                        int lastLength = -1;
                        for (int j = 0; j < count; ++j) {
                            int offset = ints[j * 2 + i + 2];
                            if (lastOffset != -1) {
                                offset += lastOffset;
                            }
                            int length = ints[j * 2 + i + 3];
                            if (lastLength != -1) {
                                length += lastLength;
                            }
                            results.add((String)key, id, null, offset, length);
                            lastOffset = offset;
                            lastLength = length;
                        }
                        if (count == 0) {
                            results.add((String)key, id, null, 0, 0);
                        }
                        lastId = id;
                    }
                }
                catch (AssemblyException ae) {
                    this.namespace.close();
                    this.storage.deleteNameSpace(this.storageKey);
                    this.namespace = this.getNameSpace();
                    throw new QueryFailedException(ae);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private NameSpace getNameSpace() {
        return this.storage.getNameSpace(this.storageKey, 1);
    }

    private void validate() {
        if (VALIDATE && this.namespace != null) {
            Iterator iterator = this.namespace.getKeyIterator();
            while (iterator.hasNext() && !shutdown) {
                String key = (String)iterator.next();
                this.namespace.getRecord(key);
            }
        }
    }

    private boolean checkVersionThreshold(IndexInfo info) {
        if (VERSION_THRESHOLD != 0L && info.version > VERSION_THRESHOLD) {
            this.namespace.close();
            this.storage.deleteNameSpace(this.storageKey);
            IndexLogger.getLogger().fine("Index older than threshold for " + this.fileSet);
            this.namespace = this.getNameSpace();
            return false;
        }
        return true;
    }

    private void invokeIndexingListeners(final Workspace workspace, final Project project, FileTable table) throws IOException, InterruptedException {
        Collection files;
        Collection<IndexingListener> listeners = IndexingInfo.getInstance().getIndexingListeners();
        if (!listeners.isEmpty() && !(files = table.getFiles()).isEmpty()) {
            for (IndexingListener listener : listeners) {
                if (shutdown) break;
                try {
                    final IndexingListener l = listener;
                    IndexingClient.run(new Runnable(){

                        @Override
                        public void run() {
                            l.indexUpdate(workspace, project, files);
                        }
                    });
                }
                catch (Exception e) {
                    IndexLogger.getLogger().severe("Exception occurred in indexing listener " + listener.getClass().getName() + " for " + this.fileSet);
                }
            }
        }
    }

    static {
        long threshold = 0L;
        String property = System.getProperty("ide.index.version.threshold");
        if (property != null) {
            try {
                threshold = Long.parseLong(property);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        VERSION_THRESHOLD = threshold;
        ExitCommand.addShutdownHook((ShutdownHook)new ShutdownHook(){

            public boolean canShutdown() {
                return true;
            }

            public void shutdown() {
                shutdown = true;
            }
        });
        INT_ARRAY_FACTORY = VariableLengthIntArrayFactory.VARIABLE_LENGTH_INT_ARRAY_FACTORY;
        REVERSE_COMPARATOR = new Comparator<Integer>(){

            @Override
            public int compare(Integer obj1, Integer obj2) {
                return obj2.compareTo(obj1);
            }
        };
        INSTANCES = new Maps.ManagedCacheMap(Maps.CacheMap.SOFT, IndexRoot.class.getSimpleName());
        UPDATE_SCHEDULER = new RequestProcessor("Index Update", 1, true);
    }

    private final class IndexRootProgressMonitor {
        private IndexProgressMonitor owner;
        private int start;

        public IndexRootProgressMonitor(IndexProgressMonitor owner) {
            this.owner = owner;
            this.start = owner.getCurrentValue();
        }

        public void setCurrentValue(int current) {
            this.owner.setCurrentValue(this.start + current);
        }
    }
}

