/*
 * Decompiled with CFR 0.152.
 */
package ice.ri.common.dialog.swing;

import ice.ri.common.dialog.SettingsDialogPanelGroup;
import ice.ri.common.dialog.swing.AbstractJSettingsDialog;
import ice.ri.common.dialog.swing.AbstractJSettingsDialogPanel;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class JTreeSettingsDialog
extends AbstractJSettingsDialog
implements TreeSelectionListener {
    private JPanel settingsPanel;
    private CardLayout cardLayout = new CardLayout();
    private DefaultMutableTreeNode rootNode;
    private JTree settingsTree;
    private JScrollPane treeSp;
    private DefaultTreeModel treeModel;
    private GridBagConstraints constraints;
    private JPanel buttonPanel;

    public JTreeSettingsDialog(JFrame parent, String title, int width, int height) {
        super(parent, title, width, height);
        this.settingsPanel = new JPanel(this.cardLayout);
        this.treeSp = new JScrollPane();
        this.rootNode = new DefaultMutableTreeNode("Settings", true);
        this.treeModel = new DefaultTreeModel(this.rootNode);
        this.settingsTree = new JTree(this.treeModel);
    }

    public void setGui() {
        this.settingsPanel.setBorder(new EmptyBorder(new Insets(0, 4, 0, 4)));
        this.getContentPane().add((Component)this.settingsPanel, "Center");
        this.treeSp.setPreferredSize(new Dimension(160, 320));
        this.treeSp.setBorder(new CompoundBorder(new EmptyBorder(new Insets(5, 5, 2, 5)), new EtchedBorder()));
        this.settingsTree.getSelectionModel().setSelectionMode(1);
        this.settingsTree.addTreeSelectionListener(this);
        DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
        renderer.setLeafIcon(new ImageIcon(""));
        renderer.setOpenIcon(new ImageIcon(""));
        renderer.setClosedIcon(new ImageIcon(""));
        this.settingsTree.setCellRenderer(renderer);
        this.treeSp.getViewport().add(this.settingsTree);
        this.getContentPane().add((Component)this.treeSp, "West");
        GridBagLayout layout = new GridBagLayout();
        this.constraints = new GridBagConstraints();
        this.buttonPanel = new JPanel(layout, true);
        this.constraints.insets = new Insets(5, 5, 5, 5);
        this.addGB(this.okButton, 1, 1);
        this.addGB(this.cancelButton, 2, 1);
        if (this.displayType == 1) {
            this.addGB(this.applyButton, 3, 1);
        }
        this.getContentPane().add((Component)this.buttonPanel, "South");
    }

    public void setTreePaneSize(int width, int height) {
        this.treeSp.setPreferredSize(new Dimension(width, height));
    }

    public void showTreeRoot(boolean value) {
        this.settingsTree.setShowsRootHandles(value);
    }

    private DefaultMutableTreeNode addNode(DefaultMutableTreeNode parent, Object child, boolean shouldBeVisible) {
        DefaultMutableTreeNode childNode = null;
        childNode = new DefaultMutableTreeNode(child);
        this.treeModel.insertNodeInto(childNode, parent, parent.getChildCount());
        if (shouldBeVisible) {
            this.settingsTree.scrollPathToVisible(new TreePath(childNode.getPath()));
        }
        return childNode;
    }

    public void valueChanged(TreeSelectionEvent evt) {
        TreePath path = evt.getPath();
        String selectedTerm = path.getLastPathComponent().toString();
        if (selectedTerm != null) {
            this.cardLayout.show(this.settingsPanel, selectedTerm);
        }
    }

    public void add(AbstractJSettingsDialogPanel panel) {
        super.add(panel);
        this.settingsPanel.add((Component)panel, panel.getName());
        this.addNode(this.rootNode, panel, true);
    }

    public void add(SettingsDialogPanelGroup group) {
        super.add(group);
        DefaultMutableTreeNode groupChildNode = null;
        groupChildNode = this.addNode(this.rootNode, group, true);
        Vector groupPanels = group.getPanels();
        Enumeration panels = groupPanels.elements();
        while (panels.hasMoreElements()) {
            AbstractJSettingsDialogPanel tmp = (AbstractJSettingsDialogPanel)panels.nextElement();
            this.settingsPanel.add((Component)tmp, tmp.getName());
            this.addNode(groupChildNode, tmp, true);
        }
    }

    private void addGB(Component component, int x, int y) {
        this.constraints.gridx = x;
        this.constraints.gridy = y;
        this.buttonPanel.add(component, this.constraints);
    }
}

