/*
 * Decompiled with CFR 0.152.
 */
package ice.ri.swing;

import ice.ri.swing.Resources;
import ice.ri.swing.Save;
import ice.ri.swing.WindowManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;

final class ProgressBarWindow
extends JFrame
implements WindowListener,
ActionListener {
    public static final int ONE_SECOND = 1000;
    private final WindowManager windowManager;
    private final Resources res;
    private ProgressBarWindow me;
    private JComponent readMarker;
    private Timer timer;
    private Save save;
    private int contentLength;

    public ProgressBarWindow(WindowManager windowManager, URL u, File file) {
        super(windowManager.getProperties().res.str("downloadwindow.title"));
        this.windowManager = windowManager;
        this.res = windowManager.getProperties().res;
        windowManager.register(this);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this);
        this.contentLength = -1;
        try {
            this.contentLength = u.openConnection().getContentLength();
        }
        catch (IOException ex) {
            this.res.displayError("save.read_error");
            windowManager.unregister(this);
            return;
        }
        if (this.contentLength < 0) {
            String s = this.res.str("statusbar.progress.read_count", "0");
            this.readMarker = new JLabel(s);
        } else {
            JProgressBar pb = new JProgressBar();
            pb.setMaximum(this.contentLength);
            pb.setValue(0);
            this.readMarker = pb;
        }
        JPanel panel = new JPanel();
        panel.setBorder(new EmptyBorder(10, 10, 10, 10));
        panel.setLayout(new BorderLayout());
        panel.add((Component)this.readMarker, "Center");
        this.setContentPane(panel);
        this.pack();
        this.setVisible(true);
        this.save = new Save(this.res, u, file, this.contentLength);
        this.timer = new Timer(1000, this);
        this.timer.start();
        this.me = this;
    }

    public void actionPerformed(ActionEvent evt) {
        int n = this.save.getCurrent();
        if (this.contentLength < 0) {
            JLabel l = (JLabel)this.readMarker;
            l.setText(this.res.str("statusbar.progress.read_count", String.valueOf(n >> 10)));
        } else {
            JProgressBar pb = (JProgressBar)this.readMarker;
            pb.setValue(n);
        }
        if (this.save.isDone()) {
            Toolkit.getDefaultToolkit().beep();
            this.timer.stop();
            this.windowManager.unregister(this.me);
            this.me.setVisible(false);
            this.me.dispose();
        }
    }

    public void windowActivated(WindowEvent ev) {
    }

    public void windowClosed(WindowEvent ev) {
    }

    public void windowClosing(WindowEvent ev) {
        boolean close = this.res.displayYesOrNo("stop.download");
        if (close) {
            if (this.save != null) {
                this.save.stop();
            }
            this.setVisible(false);
            this.dispose();
        }
    }

    public void windowDeactivated(WindowEvent ev) {
    }

    public void windowDeiconified(WindowEvent ev) {
    }

    public void windowIconified(WindowEvent ev) {
    }

    public void windowOpened(WindowEvent ev) {
    }
}

