/*
 * Decompiled with CFR 0.152.
 */
package ice.ri.swing;

import ice.ri.swing.Resources;
import ice.ri.swing.SwingWorker;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

final class Save
extends SwingWorker {
    private Resources res;
    private int current;
    private int contentLength;
    private URL u;
    private File file;
    private volatile boolean stop;
    private volatile InputStream urlInput;

    public Save(Resources res, URL u, File file, int contentLength) {
        this.res = res;
        this.u = u;
        this.file = file;
        this.contentLength = contentLength;
        this.current = 0;
        this.worker_start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object worker_construct() {
        byte[] buffer = new byte[4096];
        try {
            FileOutputStream fos = new FileOutputStream(this.file);
            try {
                InputStream is = this.u.openStream();
                try {
                    this.urlInput = is;
                    while (!this.stop) {
                        int read_count = is.read(buffer, 0, buffer.length);
                        if (read_count < 0) {
                            break;
                        }
                        this.current += read_count;
                        fos.write(buffer, 0, read_count);
                    }
                }
                finally {
                    is.close();
                    this.urlInput = null;
                }
            }
            finally {
                fos.close();
            }
        }
        catch (IOException ex) {
            this.contentLength = -2;
        }
        finally {
            this.contentLength = this.current;
        }
        return null;
    }

    public void worker_finished() {
        if (!this.stop && this.contentLength == -2) {
            this.res.displayError("save.read_error");
        }
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public int getCurrent() {
        return this.current;
    }

    public boolean isDone() {
        return this.contentLength >= 0 && this.current >= this.contentLength;
    }

    public void stop() {
        this.stop = true;
        InputStream is = this.urlInput;
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public boolean isError() {
        return this.contentLength < -1;
    }
}

