/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.dbTarget.db.changemgr.emo.cpapi;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.pool.OracleDataSource;
import oracle.sysman.dbTarget.db.changemgr.emo.cpapi.ChangePlan;
import oracle.sysman.dbTarget.db.changemgr.emo.cpapi.ChangePlanAccessException;
import oracle.sysman.dbTarget.db.changemgr.emo.cpapi.ChangePlanInfo;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.CMConnection;

public class ChangePlanAccess {
    public static final int CP_ACTION_ALLOWED = 1;
    public static final int CP_ACTION_NOT_ALLOWED = 2;
    public static final int CP_ACTION_NOT_APPLICABLE = 3;
    public static final int CP_CREATE_CHANGE_PLAN = 1;
    public static final int CP_REMOVE_CHANGE_PLAN = 2;
    public static final int CP_VIEW_CHANGE_PLAN = 3;
    public static final int CP_EDIT_CHANGE_PLAN = 4;
    public static final int CP_ADD_CHANGE_ITEM = 5;
    public static final int CP_VIEW_CHANGE_ITEM = 6;
    public static final int CP_REMOVE_CHANGE_ITEM = 7;
    public static final int CP_UPDATE_CHANGE_ITEM = 8;
    private static final int CP_CONNECTION_VALID = 9;
    private CMConnection m_cmConn = null;
    private String m_username = null;
    private boolean m_connected = false;
    private static final String s_planInfoQuery = "select change_plan_owner, change_plan_name, change_plan_description from sysman.mgmt$cm_change_plans";
    private static final String s_planIDQuery = "begin sysman.mgmt_cm_cp.get_change_plan( ?, ?, ?, ? ); end;";
    private static final String s_createPlanDML = "begin sysman.mgmt_cm_cp.create_change_plan( ?, ? ); end;";
    private static final String s_deletePlanDML = "begin sysman.mgmt_cm_cp.delete_change_plan( ?, ? ); end;";
    private static final String s_actionAllowedCall = "begin ? := sysman.mgmt_cm_cp.action_allowed( ?, ?, ? ); end;";
    private static final ChangePlanInfo s_dummyPlanInfo = new ChangePlanInfo("BOGUS_OWNER", "BOGUS_NAME");

    public void login(Connection connection) throws SQLException {
        OracleConnection conn = (OracleConnection)connection;
        this.m_cmConn = new CMConnection(conn);
        this.m_username = conn.getUserName();
        this.m_connected = true;
    }

    public void login(String username, String password, String connectString) throws SQLException, ChangePlanAccessException {
        OracleDataSource ods = new OracleDataSource();
        ods.setURL(connectString);
        ods.setUser(username);
        ods.setPassword(password);
        OracleConnection conn = (OracleConnection)ods.getConnection();
        this.login((Connection)conn);
    }

    public boolean isValidConnection() throws SQLException, ChangePlanAccessException {
        int allowed;
        try {
            allowed = this.userActionAllowed(9, s_dummyPlanInfo);
        }
        catch (SQLException se) {
            allowed = 2;
        }
        return allowed == 1;
    }

    public void logout() throws ChangePlanAccessException, SQLException {
        this.checkLogin();
        this.m_cmConn.close();
        this.m_cmConn = null;
        this.m_connected = false;
    }

    public boolean isConnected() {
        return this.m_connected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChangePlanInfo[] getChangePlans() throws ChangePlanAccessException, SQLException {
        this.checkLogin();
        ChangePlanInfo[] plans = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        Vector<ChangePlanInfo> pVec = null;
        try {
            stmt = this.m_cmConn.prepareStatement(s_planInfoQuery);
            rs = stmt.executeQuery();
            while (rs.next()) {
                String pOwner = rs.getString(1);
                String pName = rs.getString(2);
                String pDesc = rs.getString(3);
                ChangePlanInfo cpInfo = new ChangePlanInfo(pName, pOwner);
                cpInfo.setPlanDescription(pDesc);
                if (pVec == null) {
                    pVec = new Vector<ChangePlanInfo>();
                }
                pVec.add(cpInfo);
            }
        }
        catch (Throwable throwable) {
            CMConnection.close(stmt, rs);
            throw throwable;
        }
        CMConnection.close(stmt, rs);
        if (pVec != null) {
            plans = new ChangePlanInfo[pVec.size()];
            for (int i = 0; i < pVec.size(); ++i) {
                plans[i] = (ChangePlanInfo)pVec.elementAt(i);
            }
        }
        return plans;
    }

    public void createChangePlan(ChangePlanInfo planInfo) throws ChangePlanAccessException, SQLException {
        this.checkLogin();
        String planOwner = planInfo.getPlanOwner();
        String planName = planInfo.getPlanName();
        String planDesc = planInfo.getPlanDescription();
        PreparedStatement stmt = null;
        try {
            stmt = this.m_cmConn.prepareStatement(s_createPlanDML);
            stmt.setString(1, planName);
            if (planDesc != null) {
                stmt.setString(2, planDesc);
            } else {
                stmt.setNull(2, 12);
            }
            stmt.execute();
        }
        catch (SQLException se) {
            try {
                if (se.getErrorCode() == 20028) {
                    throw new ChangePlanAccessException(3, "Change Plan " + planOwner + "." + planName + " already exists.", se);
                }
                if (se.getErrorCode() == 20027) {
                    throw new ChangePlanAccessException(2, "Logged-in user does not have permission to create Change Plans", se);
                }
                throw se;
            }
            catch (Throwable throwable) {
                CMConnection.close(stmt);
                throw throwable;
            }
        }
        CMConnection.close(stmt);
    }

    public ChangePlan getOneChangePlan(String name, String owner) throws ChangePlanAccessException, SQLException {
        int planID;
        this.checkLogin();
        CallableStatement stmt = null;
        String planDesc = null;
        try {
            stmt = this.m_cmConn.prepareCall(s_planIDQuery);
            stmt.setString(1, owner);
            stmt.setString(2, name);
            stmt.registerOutParameter(3, 4);
            stmt.registerOutParameter(4, 12);
            stmt.executeQuery();
            planID = stmt.getInt(3);
            planDesc = stmt.getString(4);
        }
        catch (SQLException se) {
            try {
                if (se.getErrorCode() == 20030) {
                    throw new ChangePlanAccessException(4, "Change Plan " + owner + "." + name + " does not exist or cannot be accessed by the logged-in user.", se);
                }
                throw se;
            }
            catch (Throwable throwable) {
                CMConnection.close(stmt);
                throw throwable;
            }
        }
        CMConnection.close(stmt);
        ChangePlan plan = new ChangePlan(name, owner, planID, this);
        plan.setPlanDescription(planDesc);
        return plan;
    }

    public void removeChangePlan(String name, String owner) throws ChangePlanAccessException, SQLException {
        this.checkLogin();
        CallableStatement stmt = null;
        try {
            stmt = this.m_cmConn.prepareCall(s_deletePlanDML);
            stmt.setString(1, owner);
            stmt.setString(2, name);
            stmt.execute();
        }
        catch (SQLException se) {
            try {
                if (se.getErrorCode() == 20030) {
                    throw new ChangePlanAccessException(4, "Change Plan " + owner + "." + name + " does not exist or cannot be removed by the logged-in user.", se);
                }
                throw se;
            }
            catch (Throwable throwable) {
                CMConnection.close(stmt);
                throw throwable;
            }
        }
        CMConnection.close(stmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int userActionAllowed(int userAction, ChangePlanInfo planInfo) throws ChangePlanAccessException, SQLException {
        this.checkLogin();
        int isAllowed = 1;
        CallableStatement stmt = null;
        CMConnection cmConn = this.getConnection();
        try {
            stmt = cmConn.prepareCall(s_actionAllowedCall);
            stmt.registerOutParameter(1, 4);
            stmt.setInt(2, userAction);
            stmt.setString(3, planInfo.getPlanOwner());
            stmt.setString(4, planInfo.getPlanName());
            stmt.execute();
            isAllowed = stmt.getInt(1);
        }
        finally {
            CMConnection.close(stmt);
        }
        return isAllowed;
    }

    public static boolean isTypeSupported(String objType) {
        boolean isSupported = false;
        if (objType != null && (objType.equals("TABLE") || objType.equals("INDEX") || objType.equals("VIEW") || objType.equals("TRIGGER") || objType.equals("SYNONYM") || objType.equals("PACKAGE") || objType.equals("PACKAGE BODY") || objType.equals("PROCEDURE") || objType.equals("FUNCTION") || objType.equals("SEQUENCE") || objType.equals("DATABASE LINK") || objType.equals("MATERIALIZED VIEW") || objType.equals("MATERIALIZED VIEW LOG") || objType.equals("CLUSTER") || objType.equals("TABLESPACE") || objType.equals("ROLLBACK SEGMENT") || objType.equals("USER") || objType.equals("ROLE") || objType.equals("PROFILE") || objType.equals("TYPE") || objType.equals("TYPE BODY"))) {
            isSupported = true;
        }
        return isSupported;
    }

    void checkLogin() throws ChangePlanAccessException {
        if (this.m_cmConn == null) {
            throw new ChangePlanAccessException(1, "Not logged in.");
        }
    }

    CMConnection getConnection() {
        return this.m_cmConn;
    }

    public void setConnection(CMConnection cmConn) {
        this.m_cmConn = cmConn;
    }
}

