/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.dbTarget.db.changemgr.emo.cpapi;

public class ChangePlanAccessException
extends Exception {
    public static final int CP_NO_REASON = 0;
    public static final int CP_NOT_LOGGED_IN = 1;
    public static final int CP_NO_PERMISSION = 2;
    public static final int CP_PLAN_EXISTS = 3;
    public static final int CP_PLAN_NOT_EXIST = 4;
    public static final int CP_NO_OPEN_PLAN = 5;
    public static final int CP_ITEM_NOT_EXIST = 6;
    public static final int CP_ITEM_EXISTS = 7;
    public static final int CP_MISSING_ARG = 8;
    public static final int CP_INVALID_ARG = 9;
    public static final int CP_UNEXPECTED_XCPN = 10;
    static final int CP_ERR_PLAN_NOT_FOUND = 20026;
    static final int CP_ERR_NOT_ALLOWED = 20027;
    static final int CP_ERR_PLAN_EXISTS = 20028;
    static final int CP_ERR_CHANGE_ITEM_EXISTS = 20029;
    static final int CP_ERR_NOT_ACCESSIBLE = 20030;
    private int m_reason = 0;

    public ChangePlanAccessException(int reason) {
        this.m_reason = reason;
    }

    public ChangePlanAccessException(int reason, Throwable cause) {
        super(cause);
        this.m_reason = reason;
    }

    public ChangePlanAccessException(int reason, String message) {
        super(message);
        this.m_reason = reason;
    }

    public ChangePlanAccessException(int reason, String message, Throwable cause) {
        super(message, cause);
        this.m_reason = reason;
    }

    private ChangePlanAccessException() {
    }

    public int getReason() {
        return this.m_reason;
    }

    void setReason(int reason) {
        this.m_reason = reason;
    }

    @Override
    public String toString() {
        String reason = null;
        switch (this.m_reason) {
            case 0: {
                reason = "No reason given";
                break;
            }
            case 1: {
                reason = "Not logged in";
                break;
            }
            case 2: {
                reason = "No permission to perform operation";
                break;
            }
            case 3: {
                reason = "Change plan already exists";
                break;
            }
            case 4: {
                reason = "Change plan does not exist";
                break;
            }
            case 5: {
                reason = "No Change Plan has been opened";
                break;
            }
            case 6: {
                reason = "Change item does not exist";
                break;
            }
            case 7: {
                reason = "Change item already exists";
                break;
            }
            case 8: {
                reason = "Missing argument";
                break;
            }
            case 9: {
                reason = "Invalid argument";
                break;
            }
            case 10: {
                reason = "Unexpected exception occurred";
                if (this.getCause() == null) break;
                reason = reason + ": " + this.getCause().toString();
            }
        }
        if (reason != null) {
            return this.getMessage() + "\n" + reason;
        }
        return this.getMessage();
    }
}

