/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.pgql.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.text.Document;
import oracle.dbtools.logging.IStatusMessageConsumer;
import oracle.dbtools.pgql.PgqlResources;
import oracle.dbtools.pgql.commands.PgqlScriptRunnerPanel;
import oracle.dbtools.pgql.editor.PGQLEditorNode;
import oracle.dbtools.pgql.editor.insight.PgqlInsightPlugin;
import oracle.dbtools.pgql.utils.PgqlQueryExecuter;
import oracle.dbtools.pgql.utils.PgqlResultSetUtils;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskProgressUpdater;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.controls.grid.ResultSetTable;
import oracle.dbtools.raptor.editors.IDBEditor;
import oracle.dbtools.raptor.oviewer.base.AsynchronousViewerEditor;
import oracle.dbtools.raptor.oviewer.base.ViewerNode;
import oracle.dbtools.raptor.plsql.language.PLSQLLanguageSupport;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.util.Logger;
import oracle.dbtools.worksheet.TextView;
import oracle.dbtools.worksheet.WorksheetCallback;
import oracle.dbtools.worksheet.WorksheetContext;
import oracle.dbtools.worksheet.WorksheetResultPanel;
import oracle.dbtools.worksheet.editor.WorksheetTabbedPane;
import oracle.dbtools.worksheet.extension.WorksheetURLFileSystemHelper;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.EditorStatusBar;
import oracle.ide.ceditor.keymap.EditorFactory;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.controls.WaitCursor;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Node;
import oracle.ide.view.StatusProvider;
import oracle.javatools.db.DBException;
import oracle.javatools.db.Database;
import oracle.javatools.db.ora.OracleDatabaseImpl;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorOverview;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.BasicEditorPaneContainer;
import oracle.javatools.editor.gutter.LineGutterPlugin;
import oracle.javatools.editor.language.LanguageModule;
import oracle.javatools.editor.language.LanguageSupport;
import oracle.javatools.editor.plugins.BraceMatchingPlugin;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.editor.plugins.LineHighlightPlugin;
import oracle.javatools.icons.OracleIcons;
import oracle.pg.rdbms.pgql.PgqlResultSet;
import oracle.pg.rdbms.pgql.PgqlToSqlException;
import oracle.pgql.lang.PgqlException;
import oracle.pgql.lang.ir.StatementType;

public class PGQLEditor
extends AsynchronousViewerEditor
implements LayoutControl,
StatusProvider,
BasicEditorPaneContainer,
TextView,
IDBEditor,
TableColumnModelListener,
IRaptorTaskListener,
IStatusMessageConsumer {
    public static final String INFO_COMMENT = "/* Enter and run only one query. Replace the following with the query you wish to run. */";
    public String BASIC_QUERY = "SELECT e, v, n FROM MATCH (v)-[e]-(n) ON GRAPH1 LIMIT 100";
    private BasicEditorPane pgqlEditorPane = null;
    private EditorStatusBar statusBar = new EditorStatusBar();
    private BasicEditorOverview overview;
    private PgqlInsightPlugin insightPlugin = new PgqlInsightPlugin();
    private JComponent mainPanel;
    private WorksheetTabbedPane tabPanel;
    private ResultSetTable rsTable;
    private JScrollPane resultsPane;
    private DBObject dbObject = null;
    private Connection connection;
    private PgqlQueryExecuter pgqlQueryExecuter = null;
    ExecutorService executorService;

    public String getConnectionName() {
        return Connections.getInstance().getConnectionName(this.getConn());
    }

    public Database getDatabase() {
        Database database = null;
        try {
            database = Connections.getInstance().getDatabase(this.getConnectionName());
        }
        catch (DBException dBException) {
            Logger.severe(this.getClass(), (Throwable)dBException);
        }
        return database;
    }

    private Connection getConn() {
        if (this.getViewerNode() == null) {
            return null;
        }
        if (this.getViewerNode().getDBObject() == null) {
            return null;
        }
        return this.getViewerNode().getDBObject().getConnection();
    }

    public Connection getConnection() {
        return this.getConn();
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    WorksheetTabbedPane getWorksheetTabbedPane() {
        return this.tabPanel;
    }

    public void appendText(String string) {
    }

    public void replaceText(String string) {
    }

    public BasicEditorPane getFocusedEditorPane() {
        return this.pgqlEditorPane;
    }

    public JComponent[] getCustomCells() {
        if (this.statusBar != null) {
            return this.statusBar.getStatusBarCells();
        }
        return null;
    }

    public boolean isExpandable(JComponent jComponent) {
        return true;
    }

    protected JComponent createViewerUI() {
        Context context = this.getContext();
        this.dbObject = this.getViewerNode().getDBObject();
        if (!this.dbObject.getObjectName().equals("PG_FOLDER")) {
            if (this.dbObject.getObjectFolderType().equals("PG_OBJECT_FOLDER")) {
                this.BASIC_QUERY = "SELECT id(e), id(v), id(n) FROM MATCH (v)-[e]-(n) ON " + this.dbObject.getObjectName() + " LIMIT 100";
            } else if (this.dbObject.getObjectFolderType().equals("PG_VIEW_FOLDER")) {
                this.BASIC_QUERY = "SELECT e, v, n FROM MATCH (v)-[e]-(n) ON " + this.dbObject.getObjectName() + " LIMIT 100";
            }
        } else {
            this.BASIC_QUERY = "CREATE PROPERTY GRAPH MY_GRAPH";
        }
        Node node = context.getNode();
        if (node instanceof PGQLEditorNode) {
            PGQLEditorNode pGQLEditorNode = (PGQLEditorNode)node;
            Connection connection = pGQLEditorNode.getDBObject().getConnection();
            this.setConnection(connection);
            this.pgqlQueryExecuter = new PgqlQueryExecuter(this.connection);
        } else {
            ViewerNode viewerNode = (ViewerNode)node;
            Connection connection = viewerNode.getDBObject().getConnection();
            this.setConnection(connection);
            this.pgqlQueryExecuter = new PgqlQueryExecuter(this.connection);
        }
        this.initPGQLEditor();
        SwingUtilities.invokeLater(() -> this.initToolbar());
        this.initMainPanel();
        return this.mainPanel;
    }

    protected void updateContent(boolean bl) {
    }

    protected void cleanUp() {
        this.mainPanel = null;
    }

    public Object getPrintable() {
        return this.mainPanel;
    }

    public String getTabLabel() {
        return PgqlResources.getString("PGQLEditor.Title");
    }

    private BasicEditorPane getCodeArea() {
        return this.pgqlEditorPane;
    }

    private void setCodeArea(BasicEditorPane basicEditorPane) {
        this.pgqlEditorPane = basicEditorPane;
    }

    private void initPGQLEditor() {
        BasicEditorPane basicEditorPane = EditorFactory.createIdeEditorPane();
        this.setCodeArea(basicEditorPane);
        BasicDocument basicDocument = (BasicDocument)this.getCodeArea().getDocument();
        basicDocument.setLanguageSupport(LanguageModule.createSupportForFileType((String)"pgql"));
        PLSQLLanguageSupport pLSQLLanguageSupport = new PLSQLLanguageSupport();
        basicDocument.setLanguageSupport((LanguageSupport)pLSQLLanguageSupport);
        basicEditorPane.setDocument((Document)basicDocument);
        basicEditorPane.getDocument().putProperty("__EndOfLine__", "\n");
        basicEditorPane.installPlugin((EditorPlugin)new LineHighlightPlugin());
        LineGutterPlugin lineGutterPlugin = new LineGutterPlugin();
        basicEditorPane.installPlugin((EditorPlugin)lineGutterPlugin);
        basicEditorPane.installPlugin((EditorPlugin)new BraceMatchingPlugin());
        this.overview = new BasicEditorOverview(basicEditorPane);
        SwingUtilities.invokeLater(() -> basicEditorPane.installPlugin((EditorPlugin)this.statusBar));
        basicEditorPane.installPlugin((EditorPlugin)this.insightPlugin);
        basicEditorPane.setEditable(true);
        basicEditorPane.setText("/* Enter and run only one query. Replace the following with the query you wish to run. */\n" + this.BASIC_QUERY);
        basicEditorPane.setCaretPosition(0);
    }

    private void initMainPanel() {
        this.tabPanel = new WorksheetTabbedPane();
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new JScrollPane((Component)this.getCodeArea()), "Center");
        jPanel.add((Component)this.overview.getGUI(), "East");
        this.tabPanel.addTab(null, PgqlResources.getString("PGQL"), (Component)jPanel);
        this.rsTable = new ResultSetTable(PgqlResources.getString("PGQLEditor.QueryResult"));
        JSplitPane jSplitPane = new JSplitPane(0);
        jSplitPane.setTopComponent((Component)this.tabPanel);
        jSplitPane.setOneTouchExpandable(true);
        this.tabPanel.setPreferredSize(new Dimension(jSplitPane.getWidth(), jSplitPane.getHeight() / 2));
        jSplitPane.setResizeWeight(0.5);
        jSplitPane.setDividerLocation(0.5);
        this.resultsPane = new JScrollPane((Component)this.rsTable, 22, 30);
        jSplitPane.setBottomComponent(this.resultsPane);
        jSplitPane.setAutoscrolls(true);
        this.resultsPane.setPreferredSize(new Dimension(jSplitPane.getWidth(), jSplitPane.getHeight() / 2));
        this.mainPanel = jSplitPane;
        this.setContentModelLoaded(true);
    }

    protected void initToolbar() {
        Toolbar toolbar = (Toolbar)UIUtils.findFirstOfType((JComponent)((JComponent)this.getFixedTopMargin()), Toolbar.class);
        ToggleAction toggleAction = new ToggleAction(PgqlResources.getString("RUN_QUERY"), OracleIcons.getIcon((String)"run.png")){

            public void actionPerformed(ActionEvent actionEvent) {
                PGQLEditor.this.executorService = Executors.newSingleThreadExecutor();
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        String string = PGQLEditor.this.getCodeArea().getText().trim();
                        if (string.charAt(string.length() - 1) == ';') {
                            string = string.substring(0, string.length() - 1);
                        }
                        PGQLEditor.this.pgqlQueryExecuter.setQuery(string);
                        StatementType statementType = PGQLEditor.this.pgqlQueryExecuter.getQueryType();
                        ExecuteQueryTask executeQueryTask = new ExecuteQueryTask(PgqlResources.getString("PGQLEditor.QueryResult"), false, IRaptorTaskRunMode.MODAL);
                        executeQueryTask.setQuery(string).setQueryType(statementType);
                        RaptorTaskManager.getInstance().addTask(executeQueryTask, new ArrayList(), new ArrayList());
                    }
                };
                PGQLEditor.this.executorService.execute(runnable);
                PGQLEditor.this.executorService.shutdown();
            }
        };
        toggleAction.setName(toggleAction.getValue("Name").toString());
        toolbar.add(toggleAction);
        toolbar.addSeparator();
    }

    public void showResultSetOnTable(PgqlResultSet pgqlResultSet) {
        JSplitPane jSplitPane = (JSplitPane)this.mainPanel;
        jSplitPane.setBottomComponent(this.resultsPane);
        DefaultTableModel defaultTableModel = PgqlResultSetUtils.resultSetToTableModel(pgqlResultSet);
        this.rsTable = new ResultSetTable(PgqlResources.get("PGQLEditor.QueryResult"));
        this.rsTable.setModel((TableModel)defaultTableModel);
        this.rsTable.getColumnModel().addColumnModelListener(this);
        JViewport jViewport = new JViewport();
        JTable jTable = this.rsTable.getRowHeader();
        jViewport.setView((Component)this.rsTable);
        jViewport.setPreferredSize(jTable.getMaximumSize());
        this.resultsPane.setRowHeader(jViewport);
        this.resultsPane.setViewportView((Component)this.rsTable);
    }

    public void showQueryResultOnPanel(long l, StatementType statementType) {
        JSplitPane jSplitPane = (JSplitPane)this.mainPanel;
        String string = this.getConnQualifiedName();
        WorksheetContext worksheetContext = this.getWorksheetContext(null);
        PgqlScriptRunnerPanel pgqlScriptRunnerPanel = new PgqlScriptRunnerPanel(PgqlResources.getString("PGQLEditor.QueryResult"), worksheetContext);
        BasicEditorPane basicEditorPane = pgqlScriptRunnerPanel.getTextPane();
        jSplitPane.setBottomComponent((Component)((Object)pgqlScriptRunnerPanel));
        pgqlScriptRunnerPanel.setPinned(true);
        basicEditorPane.setEditable(true);
        if (statementType == StatementType.GRAPH_MODIFY) {
            basicEditorPane.setText(l + " " + PgqlResources.getString("PGQLEditor.ModifiedRows"));
        } else if (statementType == StatementType.CREATE_PROPERTY_GRAPH) {
            basicEditorPane.setText(PgqlResources.getString("PGQLEditor.GraphCreated"));
        } else if (statementType == StatementType.DROP_PROPERTY_GRAPH) {
            basicEditorPane.setText(PgqlResources.getString("PGQLEditor.GraphDropped"));
        }
        basicEditorPane.setEditable(false);
    }

    private String getConnQualifiedName() {
        OracleDatabaseImpl oracleDatabaseImpl = (OracleDatabaseImpl)this.getViewerNode().getDBObject().getDatabase();
        return oracleDatabaseImpl.getQualifiedName();
    }

    private WorksheetContext getWorksheetContext(BasicEditorPane basicEditorPane) {
        WorksheetContext worksheetContext = new WorksheetContext();
        worksheetContext.setConnectionName(this.getConnQualifiedName());
        worksheetContext.setEditor(basicEditorPane);
        worksheetContext.setStatementRunner(false);
        worksheetContext.setCallback((WorksheetCallback)new Callback());
        URL uRL = this.getContext().getNode().getURL();
        worksheetContext.setFileURL(uRL);
        worksheetContext.setIsTemporaryFile(WorksheetURLFileSystemHelper.isWorksheetURL((URL)uRL));
        if (worksheetContext.isTemporaryFile()) {
            this.getContext().getNode().getAttributes().unset(ElementAttributes.EDITOR_SAVEABLE_AS);
        }
        return worksheetContext;
    }

    public void messageChanged(RaptorTaskEvent raptorTaskEvent) {
    }

    public void progressChanged(RaptorTaskEvent raptorTaskEvent) {
    }

    public void stateChanged(RaptorTaskEvent raptorTaskEvent) {
    }

    @Override
    public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
    }

    @Override
    public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
    }

    @Override
    public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
    }

    @Override
    public void columnMarginChanged(ChangeEvent changeEvent) {
    }

    @Override
    public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
    }

    void addPanel(WorksheetResultPanel worksheetResultPanel) {
    }

    public void setStatusMessage(String string, Exception exception) {
    }

    private class ExecuteQueryTask<Object>
    extends RaptorTask<Object> {
        private String query;
        private StatementType queryType;

        public ExecuteQueryTask(String string, boolean bl, IRaptorTaskRunMode iRaptorTaskRunMode) {
            super(string, bl, iRaptorTaskRunMode);
            this.getDescriptor().addListener((IRaptorTaskListener)PGQLEditor.this);
        }

        public ExecuteQueryTask<Object> setQuery(String string) {
            this.query = string;
            return this;
        }

        public ExecuteQueryTask<Object> setQueryType(StatementType statementType) {
            this.queryType = statementType;
            return this;
        }

        protected Object doWork() {
            try {
                IRaptorTaskProgressUpdater iRaptorTaskProgressUpdater = this.getRaptorTaskProgressUpdater();
                if (iRaptorTaskProgressUpdater != null) {
                    iRaptorTaskProgressUpdater.checkCanProceed();
                    iRaptorTaskProgressUpdater.getDescriptor().setMessage(PgqlResources.get("EXECUTING") + this.query);
                }
                PGQLEditor.this.pgqlQueryExecuter.setQuery(this.query);
                long l = -1L;
                boolean bl = false;
                PgqlResultSet pgqlResultSet = null;
                switch (this.queryType) {
                    case SELECT: {
                        pgqlResultSet = PGQLEditor.this.pgqlQueryExecuter.executeSelectQuery();
                        if (pgqlResultSet == null) break;
                        PGQLEditor.this.showResultSetOnTable(pgqlResultSet);
                        break;
                    }
                    case GRAPH_MODIFY: {
                        bl = PGQLEditor.this.pgqlQueryExecuter.executeNonSelectQuery();
                        l = PGQLEditor.this.pgqlQueryExecuter.getModifyCount();
                        PGQLEditor.this.showQueryResultOnPanel(l, this.queryType);
                        break;
                    }
                    case CREATE_PROPERTY_GRAPH: 
                    case DROP_PROPERTY_GRAPH: {
                        bl = PGQLEditor.this.pgqlQueryExecuter.executeNonSelectQuery();
                        PGQLEditor.this.showQueryResultOnPanel(l, this.queryType);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(PgqlResources.getString("QUERYTYPE_NOT_AVAILABLE"));
                    }
                }
                if (iRaptorTaskProgressUpdater != null) {
                    iRaptorTaskProgressUpdater.checkCanProceed();
                }
            }
            catch (ExecutionException executionException) {
                PGQLEditor.this.pgqlQueryExecuter.cancelQuery();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)illegalArgumentException.toString(), (String)PgqlResources.getString("EXECUTION_ERROR"), null);
            }
            catch (PgqlToSqlException | PgqlException throwable) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)throwable.toString(), (String)PgqlResources.getString("EXECUTION_ERROR"), null);
            }
            return null;
        }
    }

    private class Callback
    implements WorksheetCallback {
        private WaitCursor m_cursor;

        private Callback() {
        }

        public void setEnabled(boolean bl) {
            if (bl && this.m_cursor != null) {
                this.m_cursor.hide();
                this.m_cursor = null;
            } else if (!bl && this.m_cursor == null) {
                this.m_cursor = new WaitCursor((Component)PGQLEditor.this.mainPanel);
                this.m_cursor.show();
            }
        }

        public void showResultPanel(final WorksheetResultPanel worksheetResultPanel) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    PGQLEditor.this.addPanel(worksheetResultPanel);
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeLater(runnable);
            }
        }

        public void setStatusMessage(String string, Exception exception) {
        }

        public void focusPanel(WorksheetResultPanel worksheetResultPanel) {
            final WorksheetTabbedPane worksheetTabbedPane = PGQLEditor.this.getWorksheetTabbedPane();
            final int n = worksheetTabbedPane.getPanelIndex((Component)worksheetResultPanel.getGUI());
            if (n != -1) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        worksheetTabbedPane.setSelectedIndex(n);
                    }
                };
                if (SwingUtilities.isEventDispatchThread()) {
                    runnable.run();
                } else {
                    SwingUtilities.invokeLater(runnable);
                }
            }
        }
    }
}

