/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.startup;

import java.io.File;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public final class HomeUtils {
    private static final ResourceBundle RESOURCES = ResourceBundle.getBundle("oracle.dbtools.raptor.startup.HomeSupportResources");
    static final String DEFAULT_NLS_DIR = "jlib";
    private static final String[] NONDEBUG_JDBC_LIBRARY = new String[]{"ojdbc8.jar"};
    private static final String[] DEBUG_JDBC_LIBRARY = new String[]{"ojdbc8_g.jar", "ojdbc8.jar"};
    static final String[] JDBC_LIBRARY = Boolean.getBoolean("oracle.dbtools.jdbc.logging") ? DEBUG_JDBC_LIBRARY : NONDEBUG_JDBC_LIBRARY;
    static final String DEFAULT_JDBC_DIR = "jdbc/lib";
    static final String XDB_LIBRARY = "xdb.jar";
    static final String DEFAULT_XDB_DIR = "rdbms/jlib";
    static final String JAVA_LIBRARY_PATH = "java.library.path";
    static final String MIN_VERSION_STRING = "19.3";
    static final int[] MIN_VERSION = new int[]{19, 3};
    static final String TEST_CONNECTION_URL = "jdbc:oracle:oci:@localhost";
    static final String TEST_CONNECTION_USER = "sqldev";
    static final String DEFAULT_BIN_DIR = "bin";
    static final String DEFAULT_LIB_DIR = "lib";
    static final String WINDOWS_PATH = "PATH";
    static final String LINUX_PATH = "LD_LIBRARY_PATH";
    static final String MAC_PATH = "DYLD_LIBRARY_PATH";

    static File getPath(File file, String string) {
        if (File.separatorChar == '/') {
            return new File(file, string);
        }
        return new File(file, string.replace('/', File.separatorChar));
    }

    static File getPath(File file, String[] stringArray) {
        for (String string : stringArray) {
            File file2 = new File(file, string);
            if (!file2.exists() || !file2.isFile()) continue;
            return file2;
        }
        return file;
    }

    static boolean checkVersion(String[] stringArray) throws NumberFormatException {
        if (stringArray == null) {
            throw new IllegalArgumentException();
        }
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            int n;
            int n2 = Integer.parseInt(stringArray[i]);
            if (n2 > (n = MIN_VERSION[i])) {
                bl = true;
                break;
            }
            if (n2 < n) {
                bl = false;
                break;
            }
            if (i != MIN_VERSION.length - 1) continue;
            bl = true;
            break;
        }
        return bl;
    }

    static String getPlatformLibraryDirectory() {
        boolean bl = false;
        String string = System.getProperty("os.name");
        if (string != null && string.toLowerCase().startsWith("windows")) {
            bl = true;
        }
        return bl ? DEFAULT_BIN_DIR : DEFAULT_LIB_DIR;
    }

    static String getResourceString(String string) {
        try {
            return RESOURCES.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return string;
        }
    }

    static String getOSPathVariable() {
        String string = System.getProperty("os.name");
        if (string != null) {
            if ((string = string.toLowerCase()).startsWith("windows")) {
                return WINDOWS_PATH;
            }
            if (string.startsWith("mac os x")) {
                return MAC_PATH;
            }
        }
        return LINUX_PATH;
    }
}

