/*
 * Decompiled with CFR 0.152.
 */
package liquibase.changelog;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import liquibase.ContextExpression;
import liquibase.LabelExpression;
import liquibase.Labels;
import liquibase.Scope;
import liquibase.change.AbstractChange;
import liquibase.change.Change;
import liquibase.change.ChangeFactory;
import liquibase.change.CheckSum;
import liquibase.change.DbmsTargetedChange;
import liquibase.change.core.EmptyChange;
import liquibase.change.core.RawSQLChange;
import liquibase.changelog.ChangeLogChild;
import liquibase.changelog.ChangeLogParameters;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.RollbackContainer;
import liquibase.changelog.visitor.ChangeExecListener;
import liquibase.configuration.LiquibaseConfiguration;
import liquibase.database.Database;
import liquibase.database.DatabaseList;
import liquibase.database.ObjectQuotingStrategy;
import liquibase.exception.DatabaseException;
import liquibase.exception.MigrationFailedException;
import liquibase.exception.PreconditionErrorException;
import liquibase.exception.PreconditionFailedException;
import liquibase.exception.RollbackFailedException;
import liquibase.exception.SetupException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.exception.ValidationErrors;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.executor.LoggingExecutor;
import liquibase.logging.Logger;
import liquibase.parser.core.ParsedNode;
import liquibase.parser.core.ParsedNodeException;
import liquibase.precondition.Conditional;
import liquibase.precondition.ErrorPrecondition;
import liquibase.precondition.FailedPrecondition;
import liquibase.precondition.core.PreconditionContainer;
import liquibase.resource.ResourceAccessor;
import liquibase.serializer.LiquibaseSerializable;
import liquibase.sql.visitor.SqlVisitor;
import liquibase.sql.visitor.SqlVisitorFactory;
import liquibase.statement.SqlStatement;
import liquibase.util.StreamUtil;
import liquibase.util.StringUtil;

public class ChangeSet
implements Conditional,
ChangeLogChild {
    protected CheckSum checkSum;
    private CheckSum storedCheckSum;
    protected String key;
    private ChangeLogParameters changeLogParameters;
    private List<Change> changes;
    private String id;
    private String author;
    private String filePath = "UNKNOWN CHANGE LOG";
    private String logicalFilePath;
    private String storedFilePath;
    private boolean alwaysRun;
    private boolean runOnChange;
    private ContextExpression contexts;
    private Labels labels;
    private boolean ignore;
    private Set<String> dbmsSet;
    private Boolean failOnError;
    private Set<CheckSum> validCheckSums = new HashSet<CheckSum>();
    private boolean runInTransaction;
    private ValidationFailOption onValidationFail = ValidationFailOption.HALT;
    private boolean validationFailed;
    private RollbackContainer rollback = new RollbackContainer();
    private String comments;
    private PreconditionContainer preconditions;
    private String runWith;
    private List<SqlVisitor> sqlVisitors = new ArrayList<SqlVisitor>();
    private ObjectQuotingStrategy objectQuotingStrategy;
    private DatabaseChangeLog changeLog;
    private String created;
    private String runOrder;
    private Map<String, Object> attributes = new HashMap<String, Object>();

    public boolean shouldAlwaysRun() {
        return this.alwaysRun;
    }

    public boolean shouldRunOnChange() {
        return this.runOnChange;
    }

    public ChangeSet(DatabaseChangeLog databaseChangeLog) {
        this.changes = new ArrayList<Change>();
        this.changeLog = databaseChangeLog;
    }

    public ChangeSet(String id, String author, boolean alwaysRun, boolean runOnChange, String filePath, String contextList, String dbmsList, DatabaseChangeLog databaseChangeLog) {
        this(id, author, alwaysRun, runOnChange, filePath, contextList, dbmsList, null, true, ObjectQuotingStrategy.LEGACY, databaseChangeLog);
    }

    public ChangeSet(String id, String author, boolean alwaysRun, boolean runOnChange, String filePath, String contextList, String dbmsList, boolean runInTransaction, DatabaseChangeLog databaseChangeLog) {
        this(id, author, alwaysRun, runOnChange, filePath, contextList, dbmsList, null, runInTransaction, ObjectQuotingStrategy.LEGACY, databaseChangeLog);
    }

    public ChangeSet(String id, String author, boolean alwaysRun, boolean runOnChange, String filePath, String contextList, String dbmsList, ObjectQuotingStrategy quotingStrategy, DatabaseChangeLog databaseChangeLog) {
        this(id, author, alwaysRun, runOnChange, filePath, contextList, dbmsList, null, true, quotingStrategy, databaseChangeLog);
    }

    public ChangeSet(String id, String author, boolean alwaysRun, boolean runOnChange, String filePath, String contextList, String dbmsList, boolean runInTransaction, ObjectQuotingStrategy quotingStrategy, DatabaseChangeLog databaseChangeLog) {
        this(id, author, alwaysRun, runOnChange, filePath, contextList, dbmsList, null, runInTransaction, quotingStrategy, databaseChangeLog);
    }

    public ChangeSet(String id, String author, boolean alwaysRun, boolean runOnChange, String filePath, String contextList, String dbmsList, String runWith, boolean runInTransaction, ObjectQuotingStrategy quotingStrategy, DatabaseChangeLog databaseChangeLog) {
        this(databaseChangeLog);
        this.id = id;
        this.author = author;
        this.filePath = filePath;
        this.alwaysRun = alwaysRun;
        this.runOnChange = runOnChange;
        this.runInTransaction = runInTransaction;
        this.objectQuotingStrategy = quotingStrategy;
        this.contexts = new ContextExpression(contextList);
        this.setDbms(dbmsList);
        this.runWith = runWith;
    }

    protected void setDbms(String dbmsList) {
        this.dbmsSet = DatabaseList.toDbmsSet(dbmsList);
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getLogicalFilePath() {
        return this.logicalFilePath;
    }

    public void setLogicalFilePath(String logicalFilePath) {
        this.logicalFilePath = logicalFilePath;
    }

    public String getStoredFilePath() {
        if (this.storedFilePath == null) {
            return this.getFilePath();
        }
        return this.storedFilePath;
    }

    public void setStoredFilePath(String storedFilePath) {
        this.storedFilePath = storedFilePath;
    }

    public String getRunWith() {
        return this.runWith;
    }

    public void clearCheckSum() {
        this.checkSum = null;
    }

    public CheckSum generateCheckSum() {
        if (this.checkSum == null) {
            StringBuilder stringToMD5 = new StringBuilder();
            for (Change change : this.getChanges()) {
                stringToMD5.append(change.generateCheckSum()).append(":");
            }
            for (SqlVisitor visitor : this.getSqlVisitors()) {
                stringToMD5.append(visitor.generateCheckSum()).append(";");
            }
            this.checkSum = CheckSum.compute(stringToMD5.toString());
        }
        return this.checkSum;
    }

    @Override
    public void load(ParsedNode node, ResourceAccessor resourceAccessor) throws ParsedNodeException {
        this.id = node.getChildValue((String)null, "id", String.class);
        this.author = node.getChildValue((String)null, "author", String.class);
        this.alwaysRun = node.getChildValue(null, "runAlways", node.getChildValue(null, "alwaysRun", false));
        this.runOnChange = node.getChildValue(null, "runOnChange", false);
        this.runWith = node.getChildValue((String)null, "runWith", String.class);
        this.contexts = new ContextExpression(node.getChildValue((String)null, "context", String.class));
        this.labels = new Labels(StringUtil.trimToNull(node.getChildValue((String)null, "labels", String.class)));
        this.setDbms(node.getChildValue((String)null, "dbms", String.class));
        this.runInTransaction = node.getChildValue(null, "runInTransaction", true);
        this.created = node.getChildValue((String)null, "created", String.class);
        this.runOrder = node.getChildValue((String)null, "runOrder", String.class);
        this.ignore = node.getChildValue(null, "ignore", false);
        this.comments = StringUtil.join(node.getChildren(null, "comment"), "\n", obj -> {
            if (((ParsedNode)obj).getValue() == null) {
                return "";
            }
            return ((ParsedNode)obj).getValue().toString();
        });
        this.comments = StringUtil.trimToNull(this.comments);
        String objectQuotingStrategyString = StringUtil.trimToNull(node.getChildValue((String)null, "objectQuotingStrategy", String.class));
        if (this.changeLog != null) {
            this.objectQuotingStrategy = this.changeLog.getObjectQuotingStrategy();
        }
        if (objectQuotingStrategyString != null) {
            this.objectQuotingStrategy = ObjectQuotingStrategy.valueOf(objectQuotingStrategyString);
        }
        if (this.objectQuotingStrategy == null) {
            this.objectQuotingStrategy = ObjectQuotingStrategy.LEGACY;
        }
        this.filePath = this.logicalFilePath = StringUtil.trimToNull(node.getChildValue((String)null, "logicalFilePath", String.class));
        if (this.filePath == null) {
            if (this.changeLog != null) {
                this.filePath = this.changeLog.getFilePath();
            }
        } else {
            this.filePath = this.filePath.replaceAll("\\\\", "/").replaceFirst("^/", "");
        }
        this.setFailOnError(node.getChildValue((String)null, "failOnError", Boolean.class));
        String onValidationFailString = node.getChildValue(null, "onValidationFail", "HALT");
        this.setOnValidationFail(ValidationFailOption.valueOf(onValidationFailString));
        for (ParsedNode child : node.getChildren()) {
            this.handleChildNode(child, resourceAccessor);
        }
    }

    protected void handleChildNode(ParsedNode child, ResourceAccessor resourceAccessor) throws ParsedNodeException {
        switch (child.getName()) {
            case "rollback": {
                this.handleRollbackNode(child, resourceAccessor);
                break;
            }
            case "validCheckSum": 
            case "validCheckSums": {
                if (child.getValue() == null) {
                    return;
                }
                if (child.getValue() instanceof Collection) {
                    for (Object checksum : (Collection)child.getValue()) {
                        this.addValidCheckSum((String)checksum);
                    }
                    break;
                }
                this.addValidCheckSum(child.getValue(String.class));
                break;
            }
            case "modifySql": {
                String dbmsString = StringUtil.trimToNull(child.getChildValue((String)null, "dbms", String.class));
                String contextString = StringUtil.trimToNull(child.getChildValue((String)null, "context", String.class));
                String labelsString = StringUtil.trimToNull(child.getChildValue((String)null, "labels", String.class));
                boolean applyToRollback = child.getChildValue(null, "applyToRollback", false);
                HashSet<String> dbms = new HashSet<String>();
                if (dbmsString != null) {
                    dbms.addAll(StringUtil.splitAndTrim(dbmsString, ","));
                }
                ContextExpression context = null;
                if (contextString != null) {
                    context = new ContextExpression(contextString);
                }
                Labels labels = null;
                if (labelsString != null) {
                    labels = new Labels(labelsString);
                }
                List<ParsedNode> potentialVisitors = child.getChildren();
                for (ParsedNode node : potentialVisitors) {
                    SqlVisitor sqlVisitor = SqlVisitorFactory.getInstance().create(node.getName());
                    if (sqlVisitor == null) continue;
                    sqlVisitor.setApplyToRollback(applyToRollback);
                    if (!dbms.isEmpty()) {
                        sqlVisitor.setApplicableDbms(dbms);
                    }
                    sqlVisitor.setContexts(context);
                    sqlVisitor.setLabels(labels);
                    sqlVisitor.load(node, resourceAccessor);
                    this.addSqlVisitor(sqlVisitor);
                }
                break;
            }
            case "preConditions": {
                this.preconditions = new PreconditionContainer();
                try {
                    this.preconditions.load(child, resourceAccessor);
                }
                catch (ParsedNodeException e) {
                    e.printStackTrace();
                }
                break;
            }
            case "changes": {
                for (ParsedNode changeNode : child.getChildren()) {
                    this.handleChildNode(changeNode, resourceAccessor);
                }
                break;
            }
            default: {
                Change change = this.toChange(child, resourceAccessor);
                if (change == null && child.getValue() instanceof String) {
                    this.setAttribute(child.getName(), child.getValue());
                    break;
                }
                this.addChange(change);
            }
        }
    }

    protected void handleRollbackNode(ParsedNode rollbackNode, ResourceAccessor resourceAccessor) throws ParsedNodeException {
        String changeSetId = rollbackNode.getChildValue((String)null, "changeSetId", String.class);
        if (changeSetId != null) {
            String changeSetAuthor = rollbackNode.getChildValue((String)null, "changeSetAuthor", String.class);
            String changeSetPath = rollbackNode.getChildValue(null, "changeSetPath", this.getFilePath());
            DatabaseChangeLog changeLog = this.getChangeLog();
            ChangeSet changeSet = changeLog.getChangeSet(changeSetPath, changeSetAuthor, changeSetId);
            while (changeSet == null && changeLog != null) {
                if ((changeLog = changeLog.getParentChangeLog()) == null) continue;
                changeSet = changeLog.getChangeSet(changeSetPath, changeSetAuthor, changeSetId);
            }
            if (changeSet == null) {
                throw new ParsedNodeException("Change set " + new ChangeSet(changeSetId, changeSetAuthor, false, false, changeSetPath, null, null, null).toString(false) + " does not exist");
            }
            for (Change change : changeSet.getChanges()) {
                this.rollback.getChanges().add(change);
            }
            return;
        }
        boolean foundValue = false;
        for (ParsedNode childNode : rollbackNode.getChildren()) {
            Change rollbackChange = this.toChange(childNode, resourceAccessor);
            if (rollbackChange == null) continue;
            this.addRollbackChange(rollbackChange);
            foundValue = true;
        }
        Object value = rollbackNode.getValue();
        if (value != null) {
            if (value instanceof String) {
                String finalValue = StringUtil.trimToNull((String)value);
                if (finalValue != null) {
                    String[] strings;
                    for (String string : strings = StringUtil.processMultiLineSQL(finalValue, true, true, ";")) {
                        this.addRollbackChange(new RawSQLChange(string));
                        foundValue = true;
                    }
                }
            } else {
                throw new ParsedNodeException("Unexpected object: " + value.getClass().getName() + " '" + value.toString() + "'");
            }
        }
        if (!foundValue) {
            this.addRollbackChange(new EmptyChange());
        }
    }

    protected Change toChange(ParsedNode value, ResourceAccessor resourceAccessor) throws ParsedNodeException {
        Change change = Scope.getCurrentScope().getSingleton(ChangeFactory.class).create(value.getName());
        if (change == null) {
            return null;
        }
        change.load(value, resourceAccessor);
        return change;
    }

    @Override
    public ParsedNode serialize() {
        throw new RuntimeException("TODO");
    }

    public ExecType execute(DatabaseChangeLog databaseChangeLog, Database database) throws MigrationFailedException {
        return this.execute(databaseChangeLog, null, database);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecType execute(DatabaseChangeLog databaseChangeLog, ChangeExecListener listener, Database database) throws MigrationFailedException {
        ExecType execType;
        block55: {
            Logger log = Scope.getCurrentScope().getLog(this.getClass());
            if (this.validationFailed) {
                return ExecType.MARK_RAN;
            }
            long startTime = new Date().getTime();
            execType = null;
            boolean skipChange = false;
            Executor originalExecutor = this.setupCustomExecutorIfNecessary(database);
            try {
                Executor executor;
                block54: {
                    StringBuilder message;
                    executor = Scope.getCurrentScope().getSingleton(ExecutorService.class).getExecutor("jdbc", database);
                    database.setObjectQuotingStrategy(this.objectQuotingStrategy);
                    if (database.supportsDDLInTransaction()) {
                        database.setAutoCommit(!this.runInTransaction);
                    }
                    executor.comment("Changeset " + this.toString(false));
                    if (StringUtil.trimToNull(this.getComments()) != null) {
                        String comments = this.getComments();
                        String[] lines = comments.split("\\n");
                        for (int i = 0; i < lines.length; ++i) {
                            if (i <= 0) continue;
                            lines[i] = database.getLineComment() + " " + lines[i];
                        }
                        executor.comment(StringUtil.join(Arrays.asList(lines), "\n"));
                    }
                    try {
                        if (this.preconditions != null) {
                            this.preconditions.check(database, databaseChangeLog, this, listener);
                        }
                    }
                    catch (PreconditionFailedException e) {
                        if (listener != null) {
                            listener.preconditionFailed(e, this.preconditions.getOnFail());
                        }
                        message = new StringBuilder();
                        message.append(StreamUtil.getLineSeparator());
                        for (FailedPrecondition failedPrecondition : e.getFailedPreconditions()) {
                            message.append("          ").append(failedPrecondition.toString());
                            message.append(StreamUtil.getLineSeparator());
                        }
                        if (this.preconditions.getOnFail().equals((Object)PreconditionContainer.FailOption.HALT)) {
                            throw new MigrationFailedException(this, message.toString(), e);
                        }
                        if (this.preconditions.getOnFail().equals((Object)PreconditionContainer.FailOption.CONTINUE)) {
                            skipChange = true;
                            execType = ExecType.SKIPPED;
                            Scope.getCurrentScope().getLog(this.getClass()).info("Continuing past: " + this.toString() + " despite precondition failure due to onFail='CONTINUE': " + message);
                            break block54;
                        }
                        if (this.preconditions.getOnFail().equals((Object)PreconditionContainer.FailOption.MARK_RAN)) {
                            execType = ExecType.MARK_RAN;
                            skipChange = true;
                            log.info("Marking ChangeSet: " + this.toString() + " ran despite precondition failure due to onFail='MARK_RAN': " + message);
                            break block54;
                        }
                        if (this.preconditions.getOnFail().equals((Object)PreconditionContainer.FailOption.WARN)) {
                            execType = null;
                            break block54;
                        }
                        throw new UnexpectedLiquibaseException("Unexpected precondition onFail attribute: " + (Object)((Object)this.preconditions.getOnFail()), e);
                    }
                    catch (PreconditionErrorException e) {
                        if (listener != null) {
                            listener.preconditionErrored(e, this.preconditions.getOnError());
                        }
                        message = new StringBuilder();
                        message.append(StreamUtil.getLineSeparator());
                        for (ErrorPrecondition errorPrecondition : e.getErrorPreconditions()) {
                            message.append("          ").append(errorPrecondition.toString());
                            message.append(StreamUtil.getLineSeparator());
                        }
                        if (this.preconditions.getOnError().equals((Object)PreconditionContainer.ErrorOption.HALT)) {
                            throw new MigrationFailedException(this, message.toString(), e);
                        }
                        if (this.preconditions.getOnError().equals((Object)PreconditionContainer.ErrorOption.CONTINUE)) {
                            skipChange = true;
                            execType = ExecType.SKIPPED;
                        } else if (this.preconditions.getOnError().equals((Object)PreconditionContainer.ErrorOption.MARK_RAN)) {
                            execType = ExecType.MARK_RAN;
                            skipChange = true;
                            log.info("Marking ChangeSet: " + this.toString() + " ran despite precondition error: " + message);
                        } else if (this.preconditions.getOnError().equals((Object)PreconditionContainer.ErrorOption.WARN)) {
                            execType = null;
                        } else {
                            throw new UnexpectedLiquibaseException("Unexpected precondition onError attribute: " + (Object)((Object)this.preconditions.getOnError()), e);
                        }
                        database.rollback();
                    }
                    finally {
                        database.rollback();
                    }
                }
                if (!skipChange) {
                    for (Change change : this.changes) {
                        try {
                            change.finishInitialization();
                        }
                        catch (SetupException se) {
                            throw new MigrationFailedException(this, (Throwable)se);
                        }
                    }
                    log.fine("Reading ChangeSet: " + this.toString());
                    for (Change change : this.getChanges()) {
                        if (!(change instanceof DbmsTargetedChange) || DatabaseList.definitionMatches(((DbmsTargetedChange)((Object)change)).getDbms(), database, true)) {
                            if (listener != null) {
                                listener.willRun(change, this, this.changeLog, database);
                            }
                            if (change.generateStatementsVolatile(database)) {
                                executor.comment("WARNING The following SQL may change each run and therefore is possibly incorrect and/or invalid:");
                            }
                            database.executeStatements(change, databaseChangeLog, this.sqlVisitors);
                            log.info(change.getConfirmationMessage());
                            if (listener == null) continue;
                            listener.ran(change, this, this.changeLog, database);
                            continue;
                        }
                        log.fine("Change " + change.getSerializedObjectName() + " not included for database " + database.getShortName());
                    }
                    if (this.runInTransaction) {
                        database.commit();
                    }
                    log.info("ChangeSet " + this.toString(false) + " ran successfully in " + (new Date().getTime() - startTime) + "ms");
                    if (execType == null) {
                        execType = ExecType.EXECUTED;
                    }
                } else {
                    log.fine("Skipping ChangeSet: " + this.toString());
                }
            }
            catch (Exception e) {
                try {
                    database.rollback();
                }
                catch (Exception e1) {
                    throw new MigrationFailedException(this, (Throwable)e);
                }
                if (this.getFailOnError() != null && !this.getFailOnError().booleanValue()) {
                    log.info("Change set " + this.toString(false) + " failed, but failOnError was false.  Error: " + e.getMessage());
                    log.fine("Failure Stacktrace", e);
                    execType = ExecType.FAILED;
                    break block55;
                }
                if (e instanceof MigrationFailedException) {
                    throw (MigrationFailedException)e;
                }
                throw new MigrationFailedException(this, (Throwable)e);
            }
            finally {
                Scope.getCurrentScope().getSingleton(ExecutorService.class).setExecutor("jdbc", database, originalExecutor);
                if (!this.runInTransaction && database.supportsDDLInTransaction()) {
                    try {
                        database.setAutoCommit(false);
                    }
                    catch (DatabaseException e) {
                        Scope.getCurrentScope().getLog(this.getClass()).warning("Could not resetInternalState autocommit", e);
                    }
                }
            }
        }
        return execType;
    }

    private Executor setupCustomExecutorIfNecessary(Database database) {
        Executor originalExecutor = Scope.getCurrentScope().getSingleton(ExecutorService.class).getExecutor("jdbc", database);
        if (this.getRunWith() == null || originalExecutor instanceof LoggingExecutor) {
            return originalExecutor;
        }
        String executorName = ChangeSet.lookupExecutor(this.getRunWith());
        Executor customExecutor = Scope.getCurrentScope().getSingleton(ExecutorService.class).getExecutor(executorName, database);
        Scope.getCurrentScope().getSingleton(ExecutorService.class).setExecutor("jdbc", database, customExecutor);
        List<Change> changes = this.getChanges();
        for (Change change : changes) {
            ResourceAccessor resourceAccessor;
            if (!(change instanceof AbstractChange) || (resourceAccessor = ((AbstractChange)change).getResourceAccessor()) == null) continue;
            customExecutor.setResourceAccessor(resourceAccessor);
            break;
        }
        return originalExecutor;
    }

    public static String lookupExecutor(String executorName) {
        if (StringUtil.isEmpty(executorName)) {
            return null;
        }
        String key = "liquibase." + executorName.toLowerCase() + ".executor";
        String replacementExecutorName = (String)Scope.getCurrentScope().getSingleton(LiquibaseConfiguration.class).getCurrentConfiguredValue(null, null, key).getValue();
        if (replacementExecutorName != null) {
            Scope.getCurrentScope().getLog(ChangeSet.class).info("Mapped '" + executorName + "' to executor '" + replacementExecutorName + "'");
            return replacementExecutorName;
        }
        if (executorName.equalsIgnoreCase("native")) {
            String message = "Unable to locate an executor for 'runWith=" + executorName + "'.  You must specify a valid executor name.";
            Scope.getCurrentScope().getLog(ChangeSet.class).warning(message);
            Scope.getCurrentScope().getUI().sendErrorMessage("WARNING: " + message);
        }
        return executorName;
    }

    public void rollback(Database database) throws RollbackFailedException {
        this.rollback(database, null);
    }

    public void rollback(Database database, ChangeExecListener listener) throws RollbackFailedException {
        Executor originalExecutor = this.setupCustomExecutorIfNecessary(database);
        try {
            Executor executor = Scope.getCurrentScope().getSingleton(ExecutorService.class).getExecutor("jdbc", database);
            executor.comment("Rolling Back ChangeSet: " + this.toString());
            database.setObjectQuotingStrategy(this.objectQuotingStrategy);
            if (database.supportsDDLInTransaction()) {
                database.setAutoCommit(!this.runInTransaction);
            }
            if (this.hasCustomRollbackChanges()) {
                LinkedList<SqlStatement> statements = new LinkedList<SqlStatement>();
                for (Change change : this.rollback.getChanges()) {
                    ValidationErrors errors;
                    if (change instanceof DbmsTargetedChange && !DatabaseList.definitionMatches(((DbmsTargetedChange)((Object)change)).getDbms(), database, true)) continue;
                    if (listener != null) {
                        listener.willRun(change, this, this.changeLog, database);
                    }
                    if ((errors = change.validate(database)).hasErrors()) {
                        throw new RollbackFailedException("Rollback statement failed validation: " + errors.toString());
                    }
                    SqlStatement[] changeStatements = change.generateStatements(database);
                    if (changeStatements != null) {
                        statements.addAll(Arrays.asList(changeStatements));
                    }
                    if (listener == null) continue;
                    listener.ran(change, this, this.changeLog, database);
                }
                if (!statements.isEmpty()) {
                    database.executeRollbackStatements(statements.toArray(new SqlStatement[0]), this.sqlVisitors);
                }
            } else {
                List<Change> changes = this.getChanges();
                for (int i = changes.size() - 1; i >= 0; --i) {
                    Change change = changes.get(i);
                    database.executeRollbackStatements(change, this.sqlVisitors);
                }
            }
            if (this.runInTransaction) {
                database.commit();
            }
            Scope.getCurrentScope().getLog(this.getClass()).fine("ChangeSet " + this.toString() + " has been successfully rolled back.");
        }
        catch (Exception e) {
            try {
                database.rollback();
            }
            catch (DatabaseException databaseException) {
                // empty catch block
            }
            throw new RollbackFailedException(e);
        }
        finally {
            Scope.getCurrentScope().getSingleton(ExecutorService.class).setExecutor("jdbc", database, originalExecutor);
            if (!this.runInTransaction && database.supportsDDLInTransaction()) {
                try {
                    database.setAutoCommit(false);
                }
                catch (DatabaseException e) {
                    Scope.getCurrentScope().getLog(this.getClass()).warning("Could not resetInternalState autocommit", e);
                }
            }
        }
    }

    public boolean hasCustomRollbackChanges() {
        return this.rollback != null && this.rollback.getChanges() != null && !this.rollback.getChanges().isEmpty();
    }

    public List<Change> getChanges() {
        return Collections.unmodifiableList(this.changes);
    }

    public void addChange(Change change) {
        if (change == null) {
            return;
        }
        this.changes.add(change);
        change.setChangeSet(this);
    }

    public String getId() {
        return this.id;
    }

    public String getAuthor() {
        return this.author;
    }

    public ContextExpression getContexts() {
        return this.contexts;
    }

    public Labels getLabels() {
        return this.labels;
    }

    public void setLabels(Labels labels) {
        this.labels = labels;
    }

    public Set<String> getDbmsSet() {
        return this.dbmsSet;
    }

    public boolean isIgnore() {
        return this.ignore;
    }

    public void setIgnore(boolean ignore) {
        this.ignore = ignore;
    }

    public boolean isInheritableIgnore() {
        DatabaseChangeLog changeLog = this.getChangeLog();
        return changeLog.isIncludeIgnore();
    }

    public Collection<ContextExpression> getInheritableContexts() {
        ArrayList<ContextExpression> expressions = new ArrayList<ContextExpression>();
        for (DatabaseChangeLog changeLog = this.getChangeLog(); changeLog != null; changeLog = changeLog.getParentChangeLog()) {
            ContextExpression includeExpression;
            ContextExpression expression = changeLog.getContexts();
            if (expression != null && !expression.isEmpty()) {
                expressions.add(expression);
            }
            if ((includeExpression = changeLog.getIncludeContexts()) == null || includeExpression.isEmpty()) continue;
            expressions.add(includeExpression);
        }
        return Collections.unmodifiableCollection(expressions);
    }

    public Collection<LabelExpression> getInheritableLabels() {
        ArrayList<LabelExpression> expressions = new ArrayList<LabelExpression>();
        for (DatabaseChangeLog changeLog = this.getChangeLog(); changeLog != null; changeLog = changeLog.getParentChangeLog()) {
            LabelExpression expression = changeLog.getIncludeLabels();
            if (expression == null || expression.isEmpty()) continue;
            expressions.add(expression);
        }
        return Collections.unmodifiableCollection(expressions);
    }

    public DatabaseChangeLog getChangeLog() {
        return this.changeLog;
    }

    public String toString(boolean includeMD5Sum) {
        return this.filePath + "::" + this.getId() + "::" + this.getAuthor() + (includeMD5Sum ? "::(Checksum: " + this.generateCheckSum() + ")" : "");
    }

    public String toString() {
        return this.toString(false);
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public boolean isAlwaysRun() {
        return this.alwaysRun;
    }

    public boolean isRunOnChange() {
        return this.runOnChange;
    }

    public boolean isRunInTransaction() {
        return this.runInTransaction;
    }

    public RollbackContainer getRollback() {
        return this.rollback;
    }

    public void addRollBackSQL(String sql) {
        if (StringUtil.trimToNull(sql) == null) {
            if (this.rollback.getChanges().isEmpty()) {
                this.rollback.getChanges().add(new EmptyChange());
            }
            return;
        }
        for (String statment : StringUtil.splitSQL(sql, null)) {
            this.rollback.getChanges().add(new RawSQLChange(statment.trim()));
        }
    }

    public void addRollbackChange(Change change) {
        if (change == null) {
            return;
        }
        this.rollback.getChanges().add(change);
        change.setChangeSet(this);
    }

    public boolean supportsRollback(Database database) {
        if (this.rollback != null && this.rollback.getChanges() != null && !this.rollback.getChanges().isEmpty()) {
            return true;
        }
        for (Change change : this.getChanges()) {
            if (change.supportsRollback(database)) continue;
            return false;
        }
        return true;
    }

    public String getDescription() {
        List<Change> changes = this.getChanges();
        if (changes.isEmpty()) {
            return "empty";
        }
        ArrayList<String> messages = new ArrayList<String>();
        for (Change change : changes) {
            messages.add(change.getDescription());
        }
        return StringUtil.limitSize(StringUtil.join(messages, "; "), 255);
    }

    public Boolean getFailOnError() {
        return this.failOnError;
    }

    public void setFailOnError(Boolean failOnError) {
        this.failOnError = failOnError;
    }

    public ValidationFailOption getOnValidationFail() {
        return this.onValidationFail;
    }

    public void setOnValidationFail(ValidationFailOption onValidationFail) {
        this.onValidationFail = onValidationFail;
    }

    public void setValidationFailed(boolean validationFailed) {
        this.validationFailed = validationFailed;
    }

    public void addValidCheckSum(String text) {
        this.validCheckSums.add(CheckSum.parse(text));
    }

    public Set<CheckSum> getValidCheckSums() {
        return Collections.unmodifiableSet(this.validCheckSums);
    }

    public boolean isCheckSumValid(CheckSum storedCheckSum) {
        for (CheckSum validCheckSum : this.validCheckSums) {
            if (!"1:any".equalsIgnoreCase(validCheckSum.toString()) && !"1:all".equalsIgnoreCase(validCheckSum.toString()) && !"1:*".equalsIgnoreCase(validCheckSum.toString())) continue;
            return true;
        }
        CheckSum currentMd5Sum = this.generateCheckSum();
        if (currentMd5Sum == null) {
            return true;
        }
        if (storedCheckSum == null) {
            return true;
        }
        if (currentMd5Sum.equals(storedCheckSum)) {
            return true;
        }
        for (CheckSum validCheckSum : this.validCheckSums) {
            if (!currentMd5Sum.equals(validCheckSum) && !storedCheckSum.equals(validCheckSum)) continue;
            return true;
        }
        return false;
    }

    @Override
    public PreconditionContainer getPreconditions() {
        return this.preconditions;
    }

    @Override
    public void setPreconditions(PreconditionContainer preconditionContainer) {
        this.preconditions = preconditionContainer;
    }

    public void addSqlVisitor(SqlVisitor sqlVisitor) {
        this.sqlVisitors.add(sqlVisitor);
    }

    public List<SqlVisitor> getSqlVisitors() {
        return this.sqlVisitors;
    }

    public ChangeLogParameters getChangeLogParameters() {
        return this.changeLogParameters;
    }

    public void setChangeLogParameters(ChangeLogParameters changeLogParameters) {
        this.changeLogParameters = changeLogParameters;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public ObjectQuotingStrategy getObjectQuotingStrategy() {
        return this.objectQuotingStrategy;
    }

    public String getCreated() {
        return this.created;
    }

    public void setCreated(String created) {
        this.created = created;
    }

    public String getRunOrder() {
        return this.runOrder;
    }

    public void setRunOrder(String runOrder) {
        if (runOrder != null && !"first".equals(runOrder = runOrder.toLowerCase()) && !"last".equals(runOrder)) {
            throw new UnexpectedLiquibaseException("runOrder must be 'first' or 'last'");
        }
        this.runOrder = runOrder;
    }

    @Override
    public String getSerializedObjectName() {
        return "changeSet";
    }

    @Override
    public Set<String> getSerializableFields() {
        return new LinkedHashSet<String>(Arrays.asList("id", "author", "runAlways", "runOnChange", "failOnError", "context", "labels", "dbms", "objectQuotingStrategy", "comment", "preconditions", "changes", "rollback", "labels", "logicalFilePath", "created"));
    }

    @Override
    public Object getSerializableFieldValue(String field) {
        if ("id".equals(field)) {
            return this.getId();
        }
        if ("author".equals(field)) {
            return this.getAuthor();
        }
        if ("runAlways".equals(field)) {
            if (this.isAlwaysRun()) {
                return true;
            }
            return null;
        }
        if ("runOnChange".equals(field)) {
            if (this.isRunOnChange()) {
                return true;
            }
            return null;
        }
        if ("failOnError".equals(field)) {
            return this.getFailOnError();
        }
        if ("context".equals(field)) {
            if (!this.getContexts().isEmpty()) {
                return this.getContexts().toString().replaceFirst("^\\(", "").replaceFirst("\\)$", "");
            }
            return null;
        }
        if ("labels".equals(field)) {
            if (this.getLabels() != null && !this.getLabels().isEmpty()) {
                return StringUtil.join(this.getLabels().getLabels(), ", ");
            }
            return null;
        }
        if ("dbms".equals(field)) {
            if (this.getDbmsSet() != null && !this.getDbmsSet().isEmpty()) {
                return StringUtil.join(this.getDbmsSet(), ",");
            }
            return null;
        }
        if ("comment".equals(field)) {
            return StringUtil.trimToNull(this.getComments());
        }
        if ("objectQuotingStrategy".equals(field)) {
            if (this.getObjectQuotingStrategy() == null) {
                return null;
            }
            return this.getObjectQuotingStrategy().toString();
        }
        if ("preconditions".equals(field)) {
            if (this.getPreconditions() != null && !this.getPreconditions().getNestedPreconditions().isEmpty()) {
                return this.getPreconditions();
            }
            return null;
        }
        if ("changes".equals(field)) {
            return this.getChanges();
        }
        if ("created".equals(field)) {
            return this.getCreated();
        }
        if ("logicalFilePath".equals(field)) {
            return this.getLogicalFilePath();
        }
        if ("rollback".equals(field)) {
            if (this.rollback != null && this.rollback.getChanges() != null && !this.rollback.getChanges().isEmpty()) {
                return this.rollback;
            }
            return null;
        }
        throw new UnexpectedLiquibaseException("Unexpected field request on changeSet: " + field);
    }

    @Override
    public LiquibaseSerializable.SerializationType getSerializableFieldType(String field) {
        if ("comment".equals(field) || "preconditions".equals(field) || "changes".equals(field) || "rollback".equals(field)) {
            return LiquibaseSerializable.SerializationType.NESTED_OBJECT;
        }
        return LiquibaseSerializable.SerializationType.NAMED_FIELD;
    }

    @Override
    public String getSerializedObjectNamespace() {
        return "http://www.liquibase.org/xml/ns/dbchangelog";
    }

    @Override
    public String getSerializableFieldNamespace(String field) {
        return this.getSerializedObjectNamespace();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ChangeSet)) {
            return false;
        }
        return this.toString(false).equals(((ChangeSet)obj).toString(false));
    }

    public int hashCode() {
        return this.toString(false).hashCode();
    }

    public Object getAttribute(String attribute) {
        return this.attributes.get(attribute);
    }

    public ChangeSet setAttribute(String attribute, Object value) {
        this.attributes.put(attribute, value);
        return this;
    }

    public CheckSum getStoredCheckSum() {
        return this.storedCheckSum;
    }

    public void setStoredCheckSum(CheckSum storedCheckSum) {
        this.storedCheckSum = storedCheckSum;
    }

    public static enum ValidationFailOption {
        HALT("HALT"),
        MARK_RAN("MARK_RAN");

        String key;

        private ValidationFailOption(String key) {
            this.key = key;
        }

        public String toString() {
            return this.key;
        }
    }

    public static enum ExecType {
        EXECUTED("EXECUTED", false, true),
        FAILED("FAILED", false, false),
        SKIPPED("SKIPPED", false, false),
        RERAN("RERAN", true, true),
        MARK_RAN("MARK_RAN", false, true);

        public final String value;
        public final boolean ranBefore;
        public final boolean ran;

        private ExecType(String value, boolean ranBefore, boolean ran) {
            this.value = value;
            this.ranBefore = ranBefore;
            this.ran = ran;
        }
    }

    public static enum RunStatus {
        NOT_RAN,
        ALREADY_RAN,
        RUN_AGAIN,
        MARK_RAN,
        INVALID_MD5SUM;

    }
}

