/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.com.opencsv;

import java.io.IOException;
import java.io.Reader;
import java.util.Locale;
import java.util.ResourceBundle;
import liquibase.repackaged.com.opencsv.CSVReaderBaseBuilder;
import liquibase.repackaged.com.opencsv.CSVReaderHeaderAware;
import liquibase.repackaged.com.opencsv.ICSVParser;
import liquibase.repackaged.com.opencsv.enums.CSVReaderNullFieldIndicator;
import liquibase.repackaged.com.opencsv.processor.RowProcessor;
import liquibase.repackaged.com.opencsv.validators.LineValidator;
import liquibase.repackaged.com.opencsv.validators.RowValidator;
import liquibase.repackaged.org.apache.commons.lang3.ObjectUtils;

public class CSVReaderHeaderAwareBuilder
extends CSVReaderBaseBuilder<CSVReaderHeaderAware> {
    public CSVReaderHeaderAwareBuilder(Reader reader) {
        super(reader);
    }

    public CSVReaderHeaderAwareBuilder withSkipLines(int skipLines) {
        this.skipLines = Math.max(skipLines, 0);
        return this;
    }

    public CSVReaderHeaderAwareBuilder withCSVParser(ICSVParser icsvParser) {
        this.icsvParser = icsvParser;
        return this;
    }

    public CSVReaderHeaderAwareBuilder withKeepCarriageReturn(boolean keepCR) {
        this.keepCR = keepCR;
        return this;
    }

    public CSVReaderHeaderAwareBuilder withVerifyReader(boolean verifyReader) {
        this.verifyReader = verifyReader;
        return this;
    }

    public CSVReaderHeaderAwareBuilder withFieldAsNull(CSVReaderNullFieldIndicator indicator) {
        this.nullFieldIndicator = indicator;
        return this;
    }

    public CSVReaderHeaderAwareBuilder withMultilineLimit(int multilineLimit) {
        this.multilineLimit = multilineLimit;
        return this;
    }

    public CSVReaderHeaderAwareBuilder withErrorLocale(Locale errorLocale) {
        this.errorLocale = ObjectUtils.defaultIfNull(errorLocale, Locale.getDefault());
        return this;
    }

    public CSVReaderHeaderAwareBuilder withLineValidator(LineValidator lineValidator) {
        this.lineValidatorAggregator.addValidator(lineValidator);
        return this;
    }

    public CSVReaderHeaderAwareBuilder withRowValidator(RowValidator rowValidator) {
        this.rowValidatorAggregator.addValidator(rowValidator);
        return this;
    }

    public CSVReaderHeaderAwareBuilder withRowProcessor(RowProcessor rowProcessor) {
        this.rowProcessor = rowProcessor;
        return this;
    }

    @Override
    public CSVReaderHeaderAware build() throws RuntimeException {
        ICSVParser parser = this.getOrCreateCsvParser();
        try {
            return new CSVReaderHeaderAware(this.reader, this.skipLines, parser, this.keepCR, this.verifyReader, this.multilineLimit, this.errorLocale, this.lineValidatorAggregator, this.rowValidatorAggregator, this.rowProcessor);
        }
        catch (IOException e) {
            throw new RuntimeException(ResourceBundle.getBundle("opencsv", this.errorLocale).getString("csvreaderheaderaware.impossible"), e);
        }
    }
}

