/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.com.opencsv;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import liquibase.repackaged.com.opencsv.AbstractCSVParser;
import liquibase.repackaged.com.opencsv.enums.CSVReaderNullFieldIndicator;
import liquibase.repackaged.org.apache.commons.lang3.ArrayUtils;
import liquibase.repackaged.org.apache.commons.lang3.StringUtils;

public class RFC4180Parser
extends AbstractCSVParser {
    private static final Pattern SPECIAL_REGEX_CHARS = Pattern.compile("[{}()\\[\\].+*?^$\\\\|]");
    private final String separatorAsString;
    private final String quoteCharString;

    public RFC4180Parser() {
        this('\"', ',', CSVReaderNullFieldIndicator.NEITHER);
    }

    RFC4180Parser(char quoteChar, char separator, CSVReaderNullFieldIndicator nullFieldIndicator) {
        super(separator, quoteChar, nullFieldIndicator);
        this.separatorAsString = SPECIAL_REGEX_CHARS.matcher(Character.toString(separator)).replaceAll("\\\\$0");
        this.quoteCharString = Character.toString(quoteChar);
    }

    @Override
    protected String convertToCsvValue(String value, boolean applyQuotesToAll) {
        String convertedString;
        String testValue = value == null && !this.nullFieldIndicator.equals((Object)CSVReaderNullFieldIndicator.NEITHER) ? "" : value;
        StringBuilder builder = new StringBuilder(testValue == null ? 16 : testValue.length() * 2);
        boolean containsQuoteChar = testValue != null && testValue.contains(Character.toString(this.getQuotechar()));
        boolean surroundWithQuotes = applyQuotesToAll || this.isSurroundWithQuotes(value, containsQuoteChar);
        String string = convertedString = !containsQuoteChar ? testValue : testValue.replaceAll(Character.toString(this.getQuotechar()), Character.toString(this.getQuotechar()) + Character.toString(this.getQuotechar()));
        if (surroundWithQuotes) {
            builder.append(this.getQuotechar());
        }
        builder.append(convertedString);
        if (surroundWithQuotes) {
            builder.append(this.getQuotechar());
        }
        return builder.toString();
    }

    @Override
    protected String[] parseLine(String nextLine, boolean multi) {
        String[] elements;
        if (!multi && this.pending != null) {
            this.pending = null;
        }
        if (nextLine == null) {
            if (this.pending != null) {
                String s = this.pending;
                this.pending = null;
                return new String[]{s};
            }
            return null;
        }
        String lineToProcess = multi && this.pending != null ? this.pending + nextLine : nextLine;
        this.pending = null;
        if (!StringUtils.contains((CharSequence)lineToProcess, this.quotechar)) {
            elements = this.handleEmptySeparators(this.tokenizeStringIntoArray(lineToProcess));
        } else {
            elements = this.handleEmptySeparators(this.splitWhileNotInQuotes(lineToProcess, multi));
            for (int i = 0; i < elements.length; ++i) {
                if (!StringUtils.contains((CharSequence)elements[i], this.quotechar)) continue;
                elements[i] = this.handleQuotes(elements[i]);
            }
        }
        return elements;
    }

    private String[] tokenizeStringIntoArray(String nextLine) {
        return nextLine.split(this.separatorAsString, -1);
    }

    private String[] handleEmptySeparators(String[] strings) {
        if (this.nullFieldIndicator == CSVReaderNullFieldIndicator.EMPTY_SEPARATORS || this.nullFieldIndicator == CSVReaderNullFieldIndicator.BOTH) {
            for (int i = 0; i < strings.length; ++i) {
                if (!strings[i].isEmpty()) continue;
                strings[i] = null;
            }
        }
        return strings;
    }

    private String[] splitWhileNotInQuotes(String nextLine, boolean multi) {
        int currentPosition = 0;
        ArrayList<String> elements = new ArrayList<String>();
        while (currentPosition < nextLine.length()) {
            int nextSeparator = nextLine.indexOf(this.separator, currentPosition);
            int nextQuote = nextLine.indexOf(this.quotechar, currentPosition);
            if (nextSeparator == -1) {
                elements.add(nextLine.substring(currentPosition));
                currentPosition = nextLine.length();
                continue;
            }
            if (nextQuote == -1 || nextQuote > nextSeparator || nextQuote != currentPosition) {
                elements.add(nextLine.substring(currentPosition, nextSeparator));
                currentPosition = nextSeparator + 1;
                continue;
            }
            int fieldEnd = this.findEndOfFieldFromPosition(nextLine, currentPosition);
            elements.add(fieldEnd >= nextLine.length() ? nextLine.substring(currentPosition) : nextLine.substring(currentPosition, fieldEnd));
            currentPosition = fieldEnd + 1;
        }
        if (multi && this.lastElementStartedWithQuoteButDidNotEndInOne(elements)) {
            this.pending = (String)elements.get(elements.size() - 1) + "\n";
            elements.remove(elements.size() - 1);
        } else if (nextLine.lastIndexOf(this.separator) == nextLine.length() - 1) {
            elements.add("");
        }
        return elements.toArray(ArrayUtils.EMPTY_STRING_ARRAY);
    }

    private boolean lastElementStartedWithQuoteButDidNotEndInOne(List<String> elements) {
        String lastElement = elements.get(elements.size() - 1);
        return this.startsButDoesNotEndWithQuote(lastElement) || this.hasOnlyOneQuote(lastElement) || this.hasOddQuotes(lastElement);
    }

    private boolean hasOddQuotes(String lastElement) {
        return StringUtils.countMatches((CharSequence)lastElement, this.quotechar) % 2 != 0;
    }

    private boolean hasOnlyOneQuote(String lastElement) {
        return StringUtils.countMatches((CharSequence)lastElement, this.quotechar) == 1;
    }

    private boolean startsButDoesNotEndWithQuote(String lastElement) {
        return lastElement.startsWith(Character.toString(this.quotechar)) && !lastElement.endsWith(Character.toString(this.quotechar));
    }

    private int findEndOfFieldFromPosition(String nextLine, int currentPosition) {
        int nextQuote = nextLine.indexOf(this.quotechar, currentPosition + 1);
        boolean inQuote = false;
        while (this.haveNotFoundLastQuote(nextLine, nextQuote)) {
            if (!inQuote && nextLine.charAt(nextQuote + 1) == this.separator) {
                return nextQuote + 1;
            }
            do {
                nextQuote = nextLine.indexOf(this.quotechar, nextQuote + 1);
                boolean bl = inQuote = !inQuote;
            } while (this.haveNotFoundLastQuote(nextLine, nextQuote) && nextLine.charAt(nextQuote + 1) == this.quotechar);
        }
        return nextLine.length();
    }

    private boolean haveNotFoundLastQuote(String nextLine, int nextQuote) {
        return nextQuote != -1 && nextQuote < nextLine.length() - 1;
    }

    private String handleQuotes(String element) {
        String ret = element;
        if (!this.hasOnlyOneQuote(ret) && ret.startsWith(this.quoteCharString)) {
            ret = StringUtils.removeStart(ret, this.quoteCharString);
            ret = StringUtils.removeEnd(ret, this.quoteCharString);
        }
        if ((ret = StringUtils.replace(ret, this.quoteCharString + this.quoteCharString, this.quoteCharString)).isEmpty() && (this.nullFieldIndicator == CSVReaderNullFieldIndicator.BOTH || this.nullFieldIndicator == CSVReaderNullFieldIndicator.EMPTY_QUOTES)) {
            ret = null;
        }
        return ret;
    }

    @Override
    public CSVReaderNullFieldIndicator nullFieldIndicator() {
        return this.nullFieldIndicator;
    }

    @Override
    public String getPendingText() {
        return StringUtils.defaultString(this.pending);
    }

    @Override
    public void setErrorLocale(Locale errorLocale) {
    }
}

