/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.com.opencsv.bean;

import java.util.Locale;
import java.util.ResourceBundle;
import liquibase.repackaged.com.opencsv.bean.AbstractCsvConverter;
import liquibase.repackaged.com.opencsv.exceptions.CsvDataTypeMismatchException;
import liquibase.repackaged.org.apache.commons.lang3.EnumUtils;
import liquibase.repackaged.org.apache.commons.lang3.StringUtils;

public class ConverterEnum
extends AbstractCsvConverter {
    public ConverterEnum(Class<?> type, String locale, String writeLocale, Locale errorLocale) {
        super(type, locale, writeLocale, errorLocale);
    }

    @Override
    public Object convertToRead(String value) throws CsvDataTypeMismatchException {
        Object o = null;
        if (StringUtils.isNotEmpty(value) && (o = EnumUtils.getEnumIgnoreCase(this.type, value)) == null) {
            throw new CsvDataTypeMismatchException(value, this.type, String.format(ResourceBundle.getBundle("opencsv").getString("illegal.enum.value"), value, this.type.getName()));
        }
        return o;
    }

    @Override
    public String convertToWrite(Object value) {
        String s = "";
        if (value != null) {
            Enum e = (Enum)value;
            s = e.name();
        }
        return s;
    }
}

