/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView;

import java.util.ArrayList;
import java.util.HashMap;
import oracle.javatools.annotations.Concealed;

@Concealed
public class BasePayloadHelper {
    protected HashMap<String, ArrayList<String>> m_updates = new HashMap();
    protected HashMap<String, ArrayList<String>> m_inserts = new HashMap();
    protected HashMap<String, ArrayList<String>> m_deletes = new HashMap();
    protected HashMap<String, StringBuffer> m_directions = new HashMap();
    protected HashMap<String, StringBuffer> m_values = new HashMap();
    protected boolean m_labelUpdate = false;
    protected int m_eventId = -1;
    public static final String ATTR_DATA_VALUES = "v";
    public static final String UPDATES_ONLY = "<updatesOnly/>";

    public void clear() {
        this.m_updates.clear();
        this.m_inserts.clear();
        this.m_deletes.clear();
        this.m_directions.clear();
        this.m_values.clear();
        this.m_labelUpdate = false;
        this.m_eventId = -1;
    }

    public boolean hasChanges() {
        return !this.m_updates.isEmpty() || !this.m_inserts.isEmpty() || !this.m_deletes.isEmpty() || !this.m_directions.isEmpty() || !this.m_values.isEmpty() || this.m_labelUpdate;
    }

    public boolean isUpdatesOnly() {
        return this.m_inserts.isEmpty() && this.m_deletes.isEmpty() && !this.m_updates.isEmpty() && !this.m_values.isEmpty();
    }

    public void setEventId(int eventId) {
        this.m_eventId = eventId;
    }

    public void addUpdate(String sid, String gid, boolean increase, String value) {
        this.addEntry(this.m_updates, sid, gid);
        StringBuffer dirs = this.m_directions.get(sid);
        if (dirs == null) {
            dirs = new StringBuffer();
            this.m_directions.put(sid, dirs);
        }
        dirs.append(increase ? (char)'u' : 'd');
        StringBuffer values = this.m_values.get(sid);
        if (values == null) {
            values = new StringBuffer();
            this.m_values.put(sid, values);
        }
        if (values.length() > 0) {
            values.append(',');
        }
        values.append(value);
    }

    public void addInsert(String sid, String gid) {
        this.addEntry(this.m_inserts, sid, gid);
    }

    public void addDelete(String sid, String gid) {
        this.addEntry(this.m_deletes, sid, gid);
    }

    public void addEntry(HashMap<String, ArrayList<String>> map, String sid, String gid) {
        ArrayList<String> gids = map.get(sid);
        if (gids == null) {
            gids = new ArrayList();
            map.put(sid, gids);
        }
        if (!gids.contains(gid)) {
            gids.add(gid);
        }
    }

    private static String getPayloadPart(String key, HashMap<String, ArrayList<String>> map) {
        if (!map.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append(key);
            sb.append("=\"");
            for (String sid : map.keySet()) {
                sb.append(sid);
                for (String gid : map.get(sid)) {
                    sb.append("~:");
                    sb.append(gid);
                }
                sb.append("~;");
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.deleteCharAt(sb.length() - 1);
            sb.append('\"');
            return sb.toString();
        }
        return null;
    }

    private static String getPayloadDirectionPart(String key, HashMap<String, StringBuffer> map) {
        if (!map.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append(key);
            sb.append("=\"");
            for (String sid : map.keySet()) {
                sb.append(sid);
                sb.append("~:");
                sb.append(map.get(sid).toString());
                sb.append("~;");
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.deleteCharAt(sb.length() - 1);
            sb.append('\"');
            return sb.toString();
        }
        return null;
    }

    private static String getPayloadValuePart(HashMap<String, StringBuffer> map) {
        if (!map.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append(ATTR_DATA_VALUES);
            sb.append("=\"");
            for (String sid : map.keySet()) {
                sb.append(map.get(sid).toString());
                sb.append(',');
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append('\"');
            return sb.toString();
        }
        return null;
    }

    public String getPayloadString(String updateType) {
        String values;
        String directions;
        String deletes;
        String inserts;
        StringBuffer sb = new StringBuffer();
        sb.append("<" + updateType + " id=\"");
        sb.append(this.m_eventId);
        sb.append('\"');
        String updates = BasePayloadHelper.getPayloadPart("u", this.m_updates);
        if (updates != null) {
            sb.append(' ');
            sb.append(updates);
        }
        if ((inserts = BasePayloadHelper.getPayloadPart("i", this.m_inserts)) != null) {
            sb.append(' ');
            sb.append(inserts);
        }
        if ((deletes = BasePayloadHelper.getPayloadPart("d", this.m_deletes)) != null) {
            sb.append(' ');
            sb.append(deletes);
        }
        if ((directions = BasePayloadHelper.getPayloadDirectionPart("ld", this.m_directions)) != null) {
            sb.append(' ');
            sb.append(directions);
        }
        if (this.isUpdatesOnly() && (values = BasePayloadHelper.getPayloadValuePart(this.m_values)) != null) {
            sb.append(' ');
            sb.append(values);
        }
        if (this.m_labelUpdate) {
            sb.append(' ');
            sb.append("lu=\"\"");
        }
        sb.append("/>");
        return sb.toString();
    }
}

