/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Shape;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Vector;
import oracle.dss.dataView.CustomHeaderAndFooterCallback;
import oracle.dss.dataView.Dataview;
import oracle.dss.dataView.TokenSubstitution;

public class HeaderAndFooterPainter {
    public static final int NONE = 0;
    public static final int DATE = 1;
    public static final int PAGE_NUMBER = 2;
    public static final int STRINGS = 4;
    private Dataview _view;
    private int _headerOrFooterID;
    private int _hAlignment;
    private int _contentType;
    private String[] _string;
    private String[] _callbackString;
    private int _pageNum;
    private int _maximumHeight;
    private TokenSubstitution m_tokenSubstitution = null;
    private int _margin = 18;
    private static final String m_constructor = "HeaderAndFooterPainter(Dataview view, int headerOrFooterID, Font font, Object[] content, int contentType)";
    private static final String m_method_setcontenttype = "setContentType(int contentType)";
    private static final String m_method_sethorizontalalignment = "setHorizontalAlignment(int hAlignment)";
    private static final String m_method_paint = "paint(Graphics g, int x, int y, int width, int height, CustomHeaderAndFooterCallback callback, int physPageNum)";
    private static final String m_method_calcmaximumheight = "calcMaximumHeight (Graphics g, CustomHeaderAndFooterCallback callback)";
    private String currentDate = null;
    private Font defaultFont = null;

    public HeaderAndFooterPainter(Dataview view, int headerOrFooterID, Font font, Object[] content, int contentType) {
        this.initialize(view, headerOrFooterID, font, content, contentType);
    }

    public HeaderAndFooterPainter(boolean header, Font font, String string, boolean showString, boolean showDate, boolean showPageNum) {
        int ID = header ? 2 : 32;
        String[] content = new String[]{string};
        int contentType = showString ? 4 : (showDate ? 1 : (showPageNum ? 2 : 0));
        this.initialize(null, ID, font, content, contentType);
    }

    private void initialize(Dataview view, int headerOrFooterID, Font font, Object[] content, int contentType) {
        this._view = view;
        this._headerOrFooterID = headerOrFooterID;
        switch (headerOrFooterID) {
            case 2: 
            case 32: {
                this._hAlignment = 0;
                break;
            }
            case 4: 
            case 64: {
                this._hAlignment = 4;
                break;
            }
            case 1: 
            case 16: {
                this._hAlignment = 2;
                break;
            }
            default: {
                this._hAlignment = 2;
                this._headerOrFooterID = 1;
                if (this._view == null) break;
                this._view.getErrorHandler().log("invalid headerOrFooterID", this.getClass().getName(), m_constructor);
            }
        }
        this._string = this.verifyObjArray(content) ? this.fastcopy(content) : this.convertObjToStringArray(content, m_constructor);
        this.defaultFont = font == null ? new Font("SansSerif", 0, 10) : font;
        this._contentType = contentType;
        switch (contentType) {
            case 1: {
                this.initDate();
            }
            case 0: 
            case 2: 
            case 4: {
                break;
            }
            default: {
                this._contentType = 0;
                if (this._view == null) break;
                this._view.getErrorHandler().log("invalid contentType", this.getClass().getName(), m_constructor);
            }
        }
    }

    public void setString(String str) {
        this._string = new String[1];
        this._string[0] = str;
    }

    public String getString() {
        if (this._string == null) {
            return null;
        }
        return this._string[0];
    }

    public void setShowString(boolean showString) {
        this._contentType = showString ? 4 : 0;
    }

    public boolean isShowString() {
        return (this._contentType & 4) > 0;
    }

    public void setShowDate(boolean showDate) {
        if (showDate) {
            this.initDate();
            this._contentType = 1;
        } else {
            this.currentDate = null;
            this._contentType = 0;
        }
    }

    public boolean isShowDate() {
        return (this._contentType & 1) > 0;
    }

    public void setShowPageNumber(boolean showPageNum) {
        this._contentType = showPageNum ? 2 : 0;
    }

    public boolean isShowPageNumber() {
        return (this._contentType & 2) > 0;
    }

    public void setStrings(String[] str) {
        this._string = str;
    }

    public String[] getStrings() {
        return this._string;
    }

    private String[] getParsedStrings(String[] keyStrings) {
        if (this.m_tokenSubstitution == null || keyStrings == null) {
            return keyStrings;
        }
        String[] parsedStrings = new String[keyStrings.length];
        for (int i = 0; i < keyStrings.length; ++i) {
            parsedStrings[i] = keyStrings[i] != null ? this.m_tokenSubstitution.getParsedString(keyStrings[i]) : null;
        }
        return parsedStrings;
    }

    public void setContentType(int contentType) {
        if (contentType != 1 && contentType != 2 && contentType != 4 && contentType != 0) {
            if (this._view != null) {
                this._view.getErrorHandler().log("invalid content type", this.getClass().getName(), m_method_setcontenttype);
            }
            return;
        }
        this._contentType = contentType;
        if (this._contentType == 1) {
            this.initDate();
        }
    }

    public int getContentType() {
        return this._contentType;
    }

    public void setHorizontalAlignment(int hAlignment) {
        if (hAlignment == 2 || hAlignment == 0 || hAlignment == 4) {
            this._hAlignment = hAlignment;
        } else if (this._view != null) {
            this._view.getErrorHandler().log("invalid horizontal alignment", this.getClass().getName(), m_method_sethorizontalalignment);
        }
    }

    public int getHorizontalAlignment() {
        return this._hAlignment;
    }

    public void setPageNumber(int pageNum) {
        this._pageNum = pageNum;
    }

    public int getPageNumber() {
        return this._pageNum;
    }

    public void setFont(Font font) {
        this.defaultFont = font;
    }

    public Font getFont() {
        return this.defaultFont;
    }

    private void initDate() {
        Locale loc = null;
        if (this._view != null) {
            loc = this._view.getLocale();
        }
        if (loc == null) {
            loc = Locale.getDefault();
        }
        Calendar cal = null;
        boolean bForceGregCal = loc.getLanguage().compareTo("th") == 0 && loc.getCountry().compareTo("TH") == 0;
        cal = bForceGregCal ? new GregorianCalendar(loc) : Calendar.getInstance(loc);
        DateFormat formatter = (DateFormat)DateFormat.getDateInstance(3, loc).clone();
        if (bForceGregCal) {
            formatter.setCalendar(cal);
        }
        formatter.setTimeZone(TimeZone.getDefault());
        this.currentDate = formatter.format(cal.getTime());
    }

    private String[] fastcopy(Object[] objarray) {
        if (objarray == null) {
            return null;
        }
        if (objarray instanceof String[]) {
            return (String[])objarray;
        }
        String[] result = new String[objarray.length];
        System.arraycopy(objarray, 0, result, 0, objarray.length);
        return result;
    }

    private String[] getText(int pageNum) {
        String[] strCurrent = null;
        if (this._contentType == 4) {
            strCurrent = this.getParsedStrings(this._string);
        } else {
            strCurrent = new String[1];
            if (this._contentType == 1) {
                strCurrent[0] = this.currentDate;
            } else if (this._contentType == 2) {
                strCurrent[0] = String.valueOf(pageNum);
            } else {
                strCurrent = null;
            }
        }
        return strCurrent;
    }

    private boolean verifyObjArray(Object[] content) {
        if (content instanceof String[] || content == null) {
            return true;
        }
        for (int index = 0; index < content.length; ++index) {
            if (content[index] instanceof String) continue;
            return false;
        }
        return true;
    }

    private String[] convertObjToStringArray(Object[] content, String methodName) {
        Vector<Object> element = new Vector<Object>();
        int stringElement = 0;
        for (int index = 0; index < content.length; ++index) {
            if (content[index] instanceof String) {
                element.addElement(content[index]);
                ++stringElement;
                continue;
            }
            if (this._view == null) continue;
            this._view.getErrorHandler().log("Object array contains non-string element", this.getClass().getName(), methodName);
        }
        if (stringElement > 0) {
            Object[] result = new String[stringElement];
            element.copyInto(result);
            return result;
        }
        return null;
    }

    protected int calcMaximumHeight(Graphics g, CustomHeaderAndFooterCallback callback, int physPageNumber, int[] hPos) {
        FontMetrics metrics = g.getFontMetrics(this.defaultFont);
        Object[] objarray = this.getText(physPageNumber);
        this._pageNum = physPageNumber;
        if (callback != null) {
            if (!this.verifyObjArray(objarray = callback.getDynamicContent(this._headerOrFooterID, objarray, physPageNumber, hPos))) {
                objarray = this.convertObjToStringArray(objarray, m_method_calcmaximumheight);
            }
            this._callbackString = this.fastcopy(objarray);
        } else {
            this._callbackString = null;
        }
        this._maximumHeight = objarray == null ? 0 : metrics.getHeight() * objarray.length - metrics.getLeading() * 2 + this._margin;
        return this._maximumHeight;
    }

    public int getMaximumHeight() {
        return this._maximumHeight;
    }

    public int getMinimumHeight(Graphics g) {
        if (this._contentType == 0) {
            return 0;
        }
        FontMetrics metrics = g.getFontMetrics(this.defaultFont);
        int height = metrics.getHeight() - metrics.getLeading() + this._margin;
        return height;
    }

    protected void setMargin(int margin) {
        this._margin = margin;
    }

    protected int getMargin() {
        return this._margin;
    }

    public void paint(Graphics g, int x, int y, int width, int height) {
        this.paint(g, x, y, width, height, null, this._pageNum, null);
    }

    public void paint(Graphics g, int x, int y, int width, int height, CustomHeaderAndFooterCallback callback, int physPageNum, int[] hPos) {
        FontMetrics metrics = g.getFontMetrics(this.defaultFont);
        Font old_font = g.getFont();
        Color old_color = g.getColor();
        g.setFont(this.defaultFont);
        g.setColor(Color.black);
        Shape saveBound = g.getClip();
        g.setClip(0, y, width, height);
        y += metrics.getAscent();
        int fontheight = metrics.getHeight();
        y = this._headerOrFooterID == 1 || this._headerOrFooterID == 2 || this._headerOrFooterID == 4 ? (y += this._margin - 2 * metrics.getLeading()) : (y += 2 * metrics.getLeading());
        Object[] strShowText = this.getText(physPageNum);
        if (callback != null) {
            if (this._callbackString == null) {
                Object[] objarray = callback.getDynamicContent(this._headerOrFooterID, strShowText, physPageNum, hPos);
                strShowText = this.verifyObjArray(objarray) ? this.fastcopy(objarray) : this.convertObjToStringArray(objarray, m_method_paint);
            } else {
                strShowText = this._callbackString;
                this._callbackString = null;
            }
        }
        width /= 3;
        if (strShowText != null) {
            int newx = x;
            int newy = y;
            for (int index = 0; index < strShowText.length; ++index) {
                if (strShowText[index] == null) {
                    newy += fontheight;
                    continue;
                }
                if (this._hAlignment != 2) {
                    int offset = 0;
                    int textWidth = metrics.stringWidth((String)strShowText[index]);
                    if (this._hAlignment == 0) {
                        offset = (width - textWidth) / 2;
                    } else if (this._hAlignment == 4) {
                        offset = width - textWidth;
                    }
                    newx = x + offset;
                }
                g.drawString((String)strShowText[index], newx, newy);
                newy += fontheight;
            }
        }
        g.setClip(saveBound);
        g.setFont(old_font);
        g.setColor(old_color);
    }

    public void setTokenSubstitution(TokenSubstitution token) {
        this.m_tokenSubstitution = token;
    }

    public TokenSubstitution getTokenSubstitution() {
        return this.m_tokenSubstitution;
    }
}

