/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.PrintJob;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.util.Locale;
import java.util.Vector;
import netscape.security.PrivilegeManager;
import oracle.bali.ewt.util.WindowUtils;
import oracle.dss.dataView.BaseTitle;
import oracle.dss.dataView.ComponentHandle;
import oracle.dss.dataView.CustomHeaderAndFooterCallback;
import oracle.dss.dataView.DataSubsetRecord;
import oracle.dss.dataView.Dataview;
import oracle.dss.dataView.Footnote;
import oracle.dss.dataView.HeaderAndFooterPainter;
import oracle.dss.dataView.PaginationRecord;
import oracle.dss.dataView.Subtitle;
import oracle.dss.dataView.Title;
import oracle.dss.dataView.TokenSubstitution;
import oracle.dss.dataView.TokenSubstitutionExtendedAdapter;
import oracle.dss.dataView.UIViewPrinter;
import oracle.dss.util.DataAccess;
import oracle.dss.util.DataDirectorException;
import oracle.dss.util.DataException;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.FormattedText;
import oracle.dss.util.LayerOutOfRangeException;
import oracle.dss.util.SliceOutOfRangeException;

public abstract class ViewPrinter
implements Printable,
UIViewPrinter {
    public static final int CURRENT_LOGICAL_PAGE = 0;
    public static final int ALL_LOGICAL_PAGES = 1;
    public static final int SELECTED_LOGICAL_PAGES = 2;
    public static final int ORIGINAL_SIZE = 0;
    public static final int SCALE_TO_ZOOM_FACTOR = 1;
    public static final int SCALE_TO_FIT_PAGES = 2;
    public static final int SCALE_TO_FIT_FULL_PAGE = 3;
    public static final int SCALE_TO_FIT_PAGE = 4;
    public static final int TEXT_COMPONENTS_ALL = -1;
    public static final int TEXT_COMPONENTS_NONE = 0;
    public static final int BELOW_HEADER = 1;
    public static final int ABOVE_FOOTER = 2;
    public static final int GRIDVIEW_COLUMN_HEADER = 1;
    public static final int GRIDVIEW_ROW_HEADER = 2;
    public static final int PAGE_HEADER = 4;
    public static final int TITLE = 8;
    public static final int SUBTITLE = 16;
    public static final int FOOTNOTE = 32;
    public static final int TOP_FORMATTED_TEXT_AREA = 64;
    public static final int BOTTOM_FORMATTED_TEXT_AREA = 128;
    public static final int HEADER_LEFT = 1;
    public static final int HEADER_CENTER = 2;
    public static final int HEADER_RIGHT = 4;
    public static final int FOOTER_LEFT = 16;
    public static final int FOOTER_CENTER = 32;
    public static final int FOOTER_RIGHT = 64;
    public static final int HEADERS_AND_FOOTERS_ALL = 255;
    public static final int HEADERS_AND_FOOTERS_NONE = 0;
    public static final int IGNORE_HEADERS_AND_FOOTERS = 1;
    public static final int ADJUST_FOR_HEADERS_AND_FOOTERS = 2;
    public static final int OCCLUDE_HEADERS_AND_FOOTERS = 3;
    public static final int MIN_PRINT_ZOOM_FACTOR = 10;
    public static final int UNIT_PIXELS = 0;
    public static final int UNIT_INCHES = 1;
    public static final int UNIT_CM = 2;
    protected int paperWidth = 612;
    protected int paperHeight = 792;
    protected int leftMargin = 72;
    protected int rightMargin = 72;
    protected int topMargin = 72;
    protected int bottomMargin = 72;
    protected int units = 0;
    protected int printZoomFactor = 100;
    protected int fitToNumPagesTall;
    protected int fitToNumPagesWide;
    protected int m_gridViewPrintScaleType = 0;
    protected int m_graphPrintScaleType = 4;
    protected int rangeType = 0;
    protected int headerHeight = 0;
    protected int footerHeight = 0;
    protected int[] logicalPage = null;
    protected int printableWidth;
    protected int printableHeight;
    protected HPosWrapper currLogPage = new HPosWrapper();
    protected HPosWrapper viewLogPage = new HPosWrapper();
    protected Vector m_selectedHPos = null;
    protected int viewLogPageNum = 0;
    protected int m_seqPageNumber = 0;
    protected boolean printByColumns = true;
    protected boolean currentLogicalPage = false;
    protected boolean resize = false;
    protected boolean m_gridlinesVisible = true;
    protected int m_repeatComponents = 63;
    protected PaginationRecord record = null;
    protected DataSubsetRecord subSetRecord = null;
    protected HeaderAndFooterPainter LeftHeader = null;
    protected HeaderAndFooterPainter CenterHeader = null;
    protected HeaderAndFooterPainter RightHeader = null;
    protected HeaderAndFooterPainter LeftFooter = null;
    protected HeaderAndFooterPainter CenterFooter = null;
    protected HeaderAndFooterPainter RightFooter = null;
    protected CustomHeaderAndFooterCallback _callback = null;
    protected int callbackMask = 0;
    protected int MarginAdjustment = 1;
    protected Rectangle pagingControlBounds = null;
    protected TokenSubstitution m_tokenSubstitution = null;
    protected FormattedText m_topFormattedText = null;
    protected FormattedText m_bottomFormattedText = null;
    protected Title title;
    protected Subtitle subtitle;
    protected Footnote footnote;
    protected Dataview dataView = null;
    protected Dimension oldTitleSize;
    protected Dimension oldSubtitleSize;
    protected Dimension oldFootnoteSize;
    protected Dimension oldTopFTASize;
    protected Dimension oldBottomFTASize;
    protected int titleHeight;
    protected int subtitleHeight;
    protected int footnoteHeight;
    protected int topFTAHeight;
    protected int bottomFTAHeight;
    protected int totalAdornHeight = 0;
    protected int repeatAdornHeight = 0;
    private boolean m_bTitleFocus = false;
    private boolean m_bSubtitleFocus = false;
    private boolean m_bFootnoteFocus = false;
    protected int m_aboveFooterWidth = 0;
    protected int m_belowHeaderWidth = 0;
    protected boolean m_bPreviewMode = false;
    protected PageFormat m_pageFormat = null;
    protected Dimension viewDim;
    protected Dimension dimension;
    protected static final String dataUnavailableMsg = "data is unavailable to print";
    protected static final String m_insuffSpace = "Insufficient space to print the View";
    protected static final int PAGING_CONTROL_GAP = 5;
    protected int pIndex = -1;
    private int oldtopMargin = this.topMargin;
    private int oldbottomMargin = this.bottomMargin;
    private PrintJob pjob;

    public ViewPrinter(Dataview dv) {
        this.LeftHeader = new HeaderAndFooterPainter(dv, 1, null, null, 4);
        this.CenterHeader = new HeaderAndFooterPainter(dv, 2, null, null, 4);
        this.RightHeader = new HeaderAndFooterPainter(dv, 4, null, null, 4);
        this.LeftFooter = new HeaderAndFooterPainter(dv, 16, null, null, 4);
        this.CenterFooter = new HeaderAndFooterPainter(dv, 32, null, null, 4);
        this.RightFooter = new HeaderAndFooterPainter(dv, 64, null, null, 4);
        this.setDataview(dv);
        this.setTokenSubstitution(new TokenSubstitutionExtendedAdapter(this, 56));
    }

    public void setTopFormattedText(FormattedText fta) {
        this.m_topFormattedText = fta;
    }

    public void setBottomFormattedText(FormattedText fta) {
        this.m_bottomFormattedText = fta;
    }

    public boolean print(boolean endPrintJob) {
        if (this.dataView.isDataUnavailable()) {
            this.dataView.getErrorHandler().log(dataUnavailableMsg, this.getClass().getName(), "print");
            return false;
        }
        try {
            if (this.rangeType == 0) {
                this.print(true, endPrintJob);
            } else {
                this.print(false, endPrintJob);
            }
        }
        catch (Exception e) {
            this.dataView.getErrorHandler().error((Throwable)e, this.getClass().getName(), "print");
        }
        return true;
    }

    @Override
    public void setUnits(int iUnit) {
        this.units = iUnit;
    }

    @Override
    public int getUnits() {
        return this.units;
    }

    @Override
    public void setLeftMargin(int mrgn) {
        this.leftMargin = mrgn;
    }

    @Override
    public int getLeftMargin() {
        return this.leftMargin;
    }

    @Override
    public void setRightMargin(int mrgn) {
        this.rightMargin = mrgn;
    }

    @Override
    public int getRightMargin() {
        return this.rightMargin;
    }

    @Override
    public void setTopMargin(int mrgn) {
        this.oldtopMargin = this.topMargin = mrgn;
    }

    @Override
    public int getTopMargin() {
        return this.topMargin;
    }

    @Override
    public void setBottomMargin(int mrgn) {
        this.oldbottomMargin = this.bottomMargin = mrgn;
    }

    @Override
    public int getBottomMargin() {
        return this.bottomMargin;
    }

    @Override
    public void setHeaderMargin(int mrgn) {
        this.LeftHeader.setMargin(mrgn);
        this.CenterHeader.setMargin(mrgn);
        this.RightHeader.setMargin(mrgn);
    }

    @Override
    public int getHeaderMargin() {
        return this.LeftHeader.getMargin();
    }

    @Override
    public void setFooterMargin(int mrgn) {
        this.LeftFooter.setMargin(mrgn);
        this.CenterFooter.setMargin(mrgn);
        this.RightFooter.setMargin(mrgn);
    }

    @Override
    public int getFooterMargin() {
        return this.LeftFooter.getMargin();
    }

    @Override
    public void setPrintZoomFactor(int zoom) {
        if (zoom < 10) {
            this.dataView.getErrorHandler().log("Print zoom factor is less than 10%", this.getClass().getName(), "setPrintZoomFactor");
            return;
        }
        this.printZoomFactor = zoom;
    }

    @Override
    public int getPrintZoomFactor() {
        return this.printZoomFactor;
    }

    public void setPrintScaleType(int type) {
        if (this.getViewPrinterType() != 2) {
            this.m_gridViewPrintScaleType = type;
        } else {
            this.m_graphPrintScaleType = type;
        }
    }

    public int getPrintScaleType() {
        if (this.getViewPrinterType() != 2) {
            return this.m_gridViewPrintScaleType;
        }
        return this.m_graphPrintScaleType;
    }

    @Override
    public void setGraphPrintScaleType(int type) {
        this.m_graphPrintScaleType = type;
    }

    @Override
    public int getGraphPrintScaleType() {
        return this.m_graphPrintScaleType;
    }

    @Override
    public void setGridViewPrintScaleType(int type) {
        this.m_gridViewPrintScaleType = type;
    }

    @Override
    public int getGridViewPrintScaleType() {
        return this.m_gridViewPrintScaleType;
    }

    @Override
    public void setFitToNumPagesTall(int num) {
        this.fitToNumPagesTall = num;
    }

    @Override
    public int getFitToNumPagesTall() {
        return this.fitToNumPagesTall;
    }

    @Override
    public void setFitToNumPagesWide(int num) {
        this.fitToNumPagesWide = num;
    }

    @Override
    public int getFitToNumPagesWide() {
        return this.fitToNumPagesWide;
    }

    @Override
    public void setGridlinesVisible(boolean visible) {
        this.m_gridlinesVisible = visible;
    }

    @Override
    public boolean isGridlinesVisible() {
        return this.m_gridlinesVisible;
    }

    public boolean setLogicalPage(int[] hPos) {
        if (this.dataView.isDataUnavailable()) {
            this.dataView.getErrorHandler().log(dataUnavailableMsg, this.getClass().getName(), "setLogicalPage");
            return false;
        }
        this.logicalPage = hPos;
        int maxLayerSpecified = -1;
        if (hPos != null) {
            maxLayerSpecified = hPos.length - 1;
        }
        try {
            this.changePageEdgeCurrentHPos(this.logicalPage, maxLayerSpecified);
        }
        catch (DataException e) {
            this.dataView.getErrorHandler().error((Throwable)e, this.getClass().getName(), "setLogicalPage");
        }
        this.resize = true;
        return true;
    }

    public int[] getLogicalPage() {
        return this.logicalPage;
    }

    @Override
    public void setSelectedHPos(Vector printHPos) {
        this.m_selectedHPos = printHPos;
    }

    @Override
    public Vector getSelectedHPos() {
        return this.m_selectedHPos;
    }

    @Override
    public void setRangeType(int type) {
        this.rangeType = type;
    }

    @Override
    public int getRangeType() {
        return this.rangeType;
    }

    public HeaderAndFooterPainter getFooterPainter() {
        return this.CenterFooter;
    }

    public HeaderAndFooterPainter getHeaderPainter() {
        return this.CenterHeader;
    }

    @Override
    public HeaderAndFooterPainter getHeaderAndFooterPainter(int headerOrFooterID) {
        switch (headerOrFooterID) {
            case 1: {
                return this.LeftHeader;
            }
            case 2: {
                return this.CenterHeader;
            }
            case 4: {
                return this.RightHeader;
            }
            case 16: {
                return this.LeftFooter;
            }
            case 32: {
                return this.CenterFooter;
            }
            case 64: {
                return this.RightFooter;
            }
        }
        return null;
    }

    public void setCustomHeaderAndFooterCallback(CustomHeaderAndFooterCallback callback) {
        this._callback = callback;
    }

    public CustomHeaderAndFooterCallback getCustomHeaderAndFooterCallback() {
        return this._callback;
    }

    public void setHeadersAndFootersUsingCallback(int mask) {
        this.callbackMask = mask;
    }

    public int getHeadersAndFootersUsingCallback() {
        return this.callbackMask;
    }

    public void setMarginAdjustment(int adjustment) {
        switch (adjustment) {
            case 1: 
            case 2: 
            case 3: {
                this.MarginAdjustment = adjustment;
                return;
            }
        }
        this.dataView.getErrorHandler().log("invalid margin adjustment", this.getClass().getName().toString(), "setMarginAdjustment (int adjustment)");
    }

    public int getMarginAdjustment() {
        return this.MarginAdjustment;
    }

    public void setViewDimension(Dimension dim) {
        this.paperWidth = dim.width;
        this.paperHeight = dim.height;
        this.dimension = this.viewDim = dim;
    }

    @Override
    public Dimension getViewDimension() {
        return this.viewDim;
    }

    @Override
    public void setPrintByColumns(boolean byColumns) {
        this.printByColumns = byColumns;
    }

    @Override
    public boolean isPrintByColumns() {
        return this.printByColumns;
    }

    public PrintJob getPrintJob() {
        return this.pjob;
    }

    public Dataview getDataview() {
        return this.dataView;
    }

    public boolean showPrintJob() {
        Frame frm1 = WindowUtils.parentFrame((Component)this.dataView);
        PrivilegeManager.enablePrivilege("UniversalPrintJobAccess");
        this.pjob = Toolkit.getDefaultToolkit().getPrintJob(frm1, this.dataView.getIntlString("Print"), null);
        if (this.pjob != null) {
            this.dimension = this.pjob.getPageDimension();
            this.paperWidth = this.dimension.width;
            this.paperHeight = this.dimension.height;
            this.viewDim = this.dimension;
            return true;
        }
        return false;
    }

    public void setPrintJob(PrintJob job) {
        this.pjob = job;
        if (this.pjob != null) {
            this.dimension = this.pjob.getPageDimension();
            this.paperWidth = this.dimension.width;
            this.paperHeight = this.dimension.height;
            this.viewDim = this.dimension;
        }
    }

    @Override
    public boolean renderPage(Graphics g) {
        if (this.dataView.isDataUnavailable()) {
            this.dataView.getErrorHandler().log(dataUnavailableMsg, this.getClass().getName(), "renderPage");
            return false;
        }
        if (!this.checkDataSourceLogPage()) {
            this.resetCurrentLogicalPage();
        }
        this.calcMargins(g);
        this.printToGraphics(g, this.record);
        this.printHeaderAndFooter(g);
        return true;
    }

    @Override
    public abstract boolean isFirstPhysicalPage();

    @Override
    public abstract boolean isLastPhysicalPage();

    @Override
    public void setSequentialPageNumber(int pageNum) {
        this.m_seqPageNumber = pageNum;
    }

    @Override
    public int getSequentialPageNumber() {
        return this.m_seqPageNumber;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (pageIndex == 0) {
            if (this.pIndex != -1) {
                this.renderPage(graphics);
                return 0;
            }
            if (this.prepareFirstPage(graphics)) {
                this.renderPage(graphics);
                return 0;
            }
            boolean done = false;
            do {
                if (done) {
                    this.pIndex = 0;
                    return 1;
                }
                if (!this.hasNextPage()) return 1;
            } while (!this.prepareNextPage(graphics));
            this.renderPage(graphics);
            return 0;
        }
        if (!this.hasNextPage()) {
            if (this.pIndex != pageIndex) return 1;
            this.renderPage(graphics);
            return 1;
        }
        if (this.pIndex == pageIndex) {
            this.renderPage(graphics);
            return 0;
        }
        this.pIndex = pageIndex;
        boolean done = false;
        do {
            if (done) return 1;
            if (!this.hasNextPage()) return 1;
        } while (!this.prepareNextPage(graphics));
        this.renderPage(graphics);
        return 0;
    }

    protected void print(boolean currentLogPage, boolean endPrintJob) {
        if (this.pjob != null) {
            this.printPages(this.pjob, currentLogPage);
            if (endPrintJob) {
                this.pjob.end();
            }
        }
    }

    private CustomHeaderAndFooterCallback getCallback(int Id) {
        if ((this.callbackMask & Id) > 0) {
            return this._callback;
        }
        return null;
    }

    protected void printHeaderAndFooter(Graphics g) {
        int y;
        int footerstart;
        int footerallowHeight;
        int headerallowHeight;
        int Margin = this.getMarginAdjustment();
        if (this.headerHeight == -1 && this.footerHeight == -1) {
            this.calcHeaderAndFooterHeights(g);
            Margin = 1;
        }
        switch (this.getMarginAdjustment()) {
            case 1: {
                headerallowHeight = this.headerHeight;
                footerallowHeight = this.footerHeight;
                footerstart = this.paperHeight - this.footerHeight;
                break;
            }
            case 2: {
                headerallowHeight = this.headerHeight;
                footerallowHeight = this.footerHeight;
                footerstart = this.paperHeight - this.footerHeight;
                break;
            }
            case 3: {
                headerallowHeight = this.topMargin;
                footerallowHeight = this.bottomMargin - this.LeftFooter.getMargin();
                if (this.footerHeight < this.bottomMargin) {
                    footerstart = this.paperHeight - this.footerHeight;
                    break;
                }
                footerstart = this.paperHeight - this.bottomMargin;
                break;
            }
            default: {
                headerallowHeight = 0;
                footerallowHeight = 0;
                footerstart = 0;
            }
        }
        int HeaderAndFooterWidth = this.printableWidth;
        g.translate(this.leftMargin, 0);
        int[] hPos = this.viewLogPage.getHPos();
        this.LeftHeader.paint(g, 0, 0, HeaderAndFooterWidth, headerallowHeight, this.getCallback(1), this.m_seqPageNumber, hPos);
        this.CenterHeader.paint(g, HeaderAndFooterWidth / 3, 0, HeaderAndFooterWidth, headerallowHeight, this.getCallback(2), this.m_seqPageNumber, hPos);
        this.RightHeader.paint(g, HeaderAndFooterWidth * 2 / 3, 0, HeaderAndFooterWidth, headerallowHeight, this.getCallback(4), this.m_seqPageNumber, hPos);
        this.LeftFooter.paint(g, 0, footerstart, HeaderAndFooterWidth, footerallowHeight, this.getCallback(16), this.m_seqPageNumber, hPos);
        this.CenterFooter.paint(g, HeaderAndFooterWidth / 3, footerstart, HeaderAndFooterWidth, footerallowHeight, this.getCallback(32), this.m_seqPageNumber, hPos);
        this.RightFooter.paint(g, HeaderAndFooterWidth * 2 / 3, footerstart, HeaderAndFooterWidth, footerallowHeight, this.getCallback(64), this.m_seqPageNumber, hPos);
        g.setClip(0, 0, this.paperWidth, this.paperHeight);
        if (this.m_belowHeaderWidth > 0) {
            y = this.headerHeight;
            if (y == 0) {
                y = this.LeftHeader.getMargin();
            } else if (y > headerallowHeight) {
                y = headerallowHeight;
            }
            if (this.m_belowHeaderWidth == 1) {
                g.drawLine(0, y, HeaderAndFooterWidth, y);
            } else {
                g.fillRect(0, y, HeaderAndFooterWidth, this.m_belowHeaderWidth);
            }
        }
        if (this.m_aboveFooterWidth > 0) {
            y = 0;
            y = this.footerHeight == 0 ? this.paperHeight - this.LeftFooter.getMargin() : footerstart;
            if (this.m_aboveFooterWidth == 1) {
                g.drawLine(0, y, HeaderAndFooterWidth, y);
            } else {
                g.fillRect(0, y -= this.m_aboveFooterWidth, HeaderAndFooterWidth, this.m_aboveFooterWidth);
            }
        }
        g.translate(-this.leftMargin, 0);
        if (Margin == 2) {
            this.topMargin = this.oldtopMargin;
            this.bottomMargin = this.oldbottomMargin;
        }
    }

    protected void calcAdornmentsDimension(int printableWidth) {
        this.saveAdornmentsSize();
        this.totalAdornHeight = 0;
        this.repeatAdornHeight = 0;
        if (this.m_topFormattedText != null) {
            this.totalAdornHeight = this.topFTAHeight = this.m_topFormattedText.getRequiredHeight(printableWidth);
            if (this.isRepeatComponent(64)) {
                this.repeatAdornHeight = this.topFTAHeight;
            }
        }
        if (this.title.isVisible()) {
            this.title.setSize(printableWidth, this.title.getPreferredSize().height);
            this.title.setSize(printableWidth, this.title.getPreferredSize().height);
            this.titleHeight = this.title.getSize().height;
            this.totalAdornHeight += this.titleHeight;
            if (this.isRepeatComponent(8)) {
                this.repeatAdornHeight += this.titleHeight;
            }
        }
        if (this.subtitle.isVisible()) {
            this.subtitle.setSize(printableWidth, this.subtitle.getPreferredSize().height);
            this.subtitle.setSize(printableWidth, this.subtitle.getPreferredSize().height);
            this.subtitleHeight = this.subtitle.getSize().height;
            this.totalAdornHeight += this.subtitleHeight;
            if (this.isRepeatComponent(16)) {
                this.repeatAdornHeight += this.subtitleHeight;
            }
        }
        if (this.footnote.isVisible()) {
            this.footnote.setSize(printableWidth, this.footnote.getPreferredSize().height);
            this.footnote.setSize(printableWidth, this.footnote.getPreferredSize().height);
            this.footnoteHeight = this.footnote.getSize().height;
            this.totalAdornHeight += this.footnoteHeight;
            this.repeatAdornHeight += this.footnoteHeight;
        }
        if (this.m_bottomFormattedText != null) {
            this.bottomFTAHeight = this.m_bottomFormattedText.getRequiredHeight(printableWidth);
            this.totalAdornHeight += this.bottomFTAHeight;
            this.repeatAdornHeight += this.bottomFTAHeight;
        }
        try {
            if (this.dataView.isPagingControlVisible() && this.dataView.getModel().getDataAccess().getLayerCount(2) > 0) {
                this.dataView.getPagingControl().getPagingComponent().validate();
                this.pagingControlBounds = this.dataView.getPagingControl().getPagingComponent().getPageBounds(null, null, 0, 0, printableWidth, this.printableHeight);
                this.pagingControlBounds.height += 5;
                this.totalAdornHeight += this.pagingControlBounds.height;
                if (this.isRepeatComponent(4)) {
                    this.repeatAdornHeight += this.pagingControlBounds.height;
                }
            }
        }
        catch (EdgeOutOfRangeException edgeOutOfRangeException) {
            // empty catch block
        }
        this.resetAdornmentsSize();
    }

    protected void saveAdornmentsSize() {
        if (this.title.isVisible()) {
            this.oldTitleSize = this.title.getSize();
        }
        if (this.subtitle.isVisible()) {
            this.oldSubtitleSize = this.subtitle.getSize();
        }
        if (this.footnote.isVisible()) {
            this.oldFootnoteSize = this.footnote.getSize();
        }
    }

    protected void resetAdornmentsSize() {
        if (this.title.isVisible()) {
            this.title.setSize(this.oldTitleSize);
        }
        if (this.subtitle.isVisible()) {
            this.subtitle.setSize(this.oldSubtitleSize);
        }
        if (this.footnote.isVisible()) {
            this.footnote.setSize(this.oldFootnoteSize);
        }
    }

    protected void saveTitlesFocus() {
        if (((BaseTitle)this.dataView.getDataviewTitle()).isSelected()) {
            this.m_bTitleFocus = true;
            ((BaseTitle)this.dataView.getDataviewTitle()).setSelected(false);
        } else {
            this.m_bTitleFocus = false;
        }
        if (((BaseTitle)this.dataView.getDataviewSubtitle()).isSelected()) {
            this.m_bSubtitleFocus = true;
            ((BaseTitle)this.dataView.getDataviewSubtitle()).setSelected(false);
        } else {
            this.m_bSubtitleFocus = false;
        }
        if (((BaseTitle)this.dataView.getDataviewFootnote()).isSelected()) {
            this.m_bFootnoteFocus = true;
            ((BaseTitle)this.dataView.getDataviewFootnote()).setSelected(false);
        } else {
            this.m_bFootnoteFocus = false;
        }
    }

    protected void restoreTitlesFocus() {
        ComponentHandle handle = this.dataView.getSelectedObject();
        boolean bTitleHandle = false;
        boolean bSubtitleHandle = false;
        boolean bFootnoteHandle = false;
        if (handle != null) {
            bTitleHandle = handle.getID() == 0;
            bSubtitleHandle = handle.getID() == 1;
            boolean bl = bFootnoteHandle = handle.getID() == 2;
        }
        if (this.m_bTitleFocus && bTitleHandle) {
            ((BaseTitle)this.dataView.getDataviewTitle()).setSelected(true);
        }
        if (this.m_bSubtitleFocus && bSubtitleHandle) {
            ((BaseTitle)this.dataView.getDataviewSubtitle()).setSelected(true);
        }
        if (this.m_bFootnoteFocus && bFootnoteHandle) {
            ((BaseTitle)this.dataView.getDataviewFootnote()).setSelected(true);
        }
    }

    protected void setDataview(Dataview dv) {
        this.dataView = dv;
    }

    protected void calcMargins(Graphics g) {
        if (g == null) {
            this.headerHeight = -1;
            this.footerHeight = -1;
            return;
        }
        this.calcHeaderAndFooterHeights(g);
        if (this.getMarginAdjustment() == 2) {
            this.adjustMargins();
        }
    }

    protected void adjustMargins() {
        this.oldtopMargin = this.topMargin;
        this.oldbottomMargin = this.bottomMargin;
        if (this.headerHeight > this.topMargin) {
            this.topMargin = this.headerHeight;
        }
        if (this.footerHeight > this.bottomMargin) {
            this.bottomMargin = this.footerHeight;
        }
    }

    public void calcHeaderAndFooterHeights(Graphics g) {
        int[] hPos = this.viewLogPage.getHPos();
        this.footerHeight = this.LeftFooter.calcMaximumHeight(g, this.getCallback(16), this.m_seqPageNumber, hPos);
        this.footerHeight = Math.max(this.footerHeight, this.CenterFooter.calcMaximumHeight(g, this.getCallback(32), this.m_seqPageNumber, hPos));
        this.footerHeight = Math.max(this.footerHeight, this.RightFooter.calcMaximumHeight(g, this.getCallback(64), this.m_seqPageNumber, hPos));
        this.headerHeight = this.LeftHeader.calcMaximumHeight(g, this.getCallback(1), this.m_seqPageNumber, hPos);
        this.headerHeight = Math.max(this.headerHeight, this.CenterHeader.calcMaximumHeight(g, this.getCallback(2), this.m_seqPageNumber, hPos));
        this.headerHeight = Math.max(this.headerHeight, this.RightHeader.calcMaximumHeight(g, this.getCallback(4), this.m_seqPageNumber, hPos));
    }

    protected boolean checkForNoData() {
        DataAccess access = this.dataView.getModel().getDataAccess();
        try {
            if (access.getEdgeExtent(1) != 0 && access.getEdgeExtent(0) != 0) {
                return false;
            }
        }
        catch (Exception e) {
            this.dataView.getErrorHandler().error((Throwable)e, this.getClass().getName(), "checkForNoData");
        }
        return true;
    }

    public abstract boolean startPrint();

    @Override
    public abstract boolean startPrint(boolean var1);

    @Override
    public abstract void endPrint();

    public void setRepeatHeaders(boolean repeat) {
        this.m_repeatComponents = repeat ? 255 : 0;
    }

    public boolean isRepeatHeaders() {
        return this.m_repeatComponents == 255;
    }

    @Override
    public void setRepeatComponent(int component, boolean repeat) {
        if (repeat) {
            this.m_repeatComponents |= component;
        } else {
            int compliment = ~component;
            this.m_repeatComponents &= compliment;
        }
    }

    @Override
    public boolean isRepeatComponent(int component) {
        return (this.m_repeatComponents & component) != 0;
    }

    protected abstract void printPages(PrintJob var1, boolean var2);

    protected abstract void printToGraphics(Graphics var1, PaginationRecord var2);

    public abstract boolean goToFirstPage();

    public abstract boolean goToNextPage();

    public abstract boolean goToPrevPage();

    @Override
    public abstract boolean prepareFirstPage(Graphics var1);

    @Override
    public abstract boolean prepareNextPage(Graphics var1);

    @Override
    public abstract void setScaleFontSize(int var1);

    @Override
    public abstract int getScaleFontSize();

    @Override
    public abstract boolean preparePrevPage(Graphics var1);

    @Override
    public abstract boolean hasNextPage();

    @Override
    public abstract boolean hasPrevPage();

    @Override
    public void setTokenSubstitution(TokenSubstitution token) {
        this.m_tokenSubstitution = token;
        this.LeftHeader.setTokenSubstitution(token);
        this.CenterHeader.setTokenSubstitution(token);
        this.RightHeader.setTokenSubstitution(token);
        this.LeftFooter.setTokenSubstitution(token);
        this.CenterFooter.setTokenSubstitution(token);
        this.RightFooter.setTokenSubstitution(token);
    }

    @Override
    public void setPageFormat(PageFormat pf) {
        this.m_pageFormat = pf;
        int paperWidth = (int)this.m_pageFormat.getWidth();
        int paperHeight = (int)this.m_pageFormat.getHeight();
        this.setViewDimension(new Dimension(paperWidth, paperHeight));
    }

    @Override
    public PageFormat getPageFormat() {
        return this.m_pageFormat;
    }

    @Override
    public TokenSubstitution getTokenSubstitution() {
        return this.m_tokenSubstitution;
    }

    @Override
    public Locale getLocale() {
        return this.dataView.getLocale();
    }

    @Override
    public boolean isDataviewTitleVisible() {
        return this.dataView.getDataviewTitle().isVisible();
    }

    @Override
    public boolean isDataviewSubtitleVisible() {
        return this.dataView.getDataviewSubtitle().isVisible();
    }

    @Override
    public boolean isDataviewFootnoteVisible() {
        return this.dataView.getDataviewFootnote().isVisible();
    }

    @Override
    public void setLineWidth(int position, int width) {
        if (position == 2) {
            this.m_aboveFooterWidth = width;
        } else if (position == 1) {
            this.m_belowHeaderWidth = width;
        }
    }

    @Override
    public int getLineWidth(int position) {
        if (position == 2) {
            return this.m_aboveFooterWidth;
        }
        if (position == 1) {
            return this.m_belowHeaderWidth;
        }
        return 0;
    }

    @Override
    public boolean renderFirstPage(Graphics g) {
        return false;
    }

    @Override
    public boolean renderLastPage(Graphics g) {
        return false;
    }

    @Override
    public boolean goToFirstPage(Graphics g) {
        return false;
    }

    @Override
    public boolean goToLastPage(Graphics g) {
        return false;
    }

    @Override
    public Cursor getWaitCursor() {
        return this.dataView.getController().getCursorType(2);
    }

    @Override
    public Cursor getDefaultCursor() {
        return this.dataView.getController().getCursorType(0);
    }

    protected boolean checkDataSourceLogPage() {
        boolean result = true;
        try {
            HPosWrapper currHPW = new HPosWrapper(this.dataView.getModel().getDataAccess().getEdgeCurrentHPos(2));
            if (!this.viewLogPage.equals(currHPW)) {
                result = false;
                int[] logPg = this.viewLogPage.getHPos();
                int maxLayerSpecified = -1;
                if (logPg != null) {
                    maxLayerSpecified = logPg.length - 1;
                }
                this.changePageEdgeCurrentHPos(logPg, maxLayerSpecified);
            }
        }
        catch (DataException e) {
            this.dataView.getErrorHandler().error((Throwable)e, this.getClass().getName(), "checkDataSourceLogPage");
        }
        return result;
    }

    protected int fetchRowBlock(int firstRow, int lastRow) {
        try {
            int[] startSlice = new int[2];
            int[] endSlice = new int[2];
            startSlice[0] = 0;
            endSlice[0] = this.dataView.getModel().getDataAccess().getEdgeExtent(0) - 1;
            startSlice[1] = firstRow;
            endSlice[1] = lastRow;
            if (this.dataView.getModel().getDataAccess() instanceof DataAccess && !this.dataView.getModel().getDataAccess().isFetched(startSlice, endSlice, 1)) {
                if (!this.dataView.getModel().getDataAccess().forceFetch(startSlice, endSlice, 1)) {
                    this.dataView.getErrorHandler().log("could not fetch rows", this.getClass().getName(), "fetchRowBlock");
                } else {
                    for (int i = startSlice[1]; i <= endSlice[1]; ++i) {
                        if (this.dataView.getWaitDataForRow(i) == null) continue;
                        this.dataView.setWaitDataForRow(i, null);
                    }
                }
            }
        }
        catch (DataException de) {
            this.dataView.getErrorHandler().error((Throwable)de, this.getClass().getName(), "fetchRowBlock");
            return -1;
        }
        return lastRow;
    }

    protected abstract void resetCurrentLogicalPage();

    protected boolean changePageEdgeCurrentHPos(int[] hPos, int maxLayerSpecified) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException, DataDirectorException {
        boolean bSuccess = this.dataView.getModel().getDataDirector().changeEdgeCurrentHPos(2, hPos, maxLayerSpecified);
        return bSuccess;
    }

    public HPosWrapper getLogicalPageInUse() {
        return this.viewLogPage;
    }

    public class HPosWrapper {
        private int[] m_hPos = null;

        public HPosWrapper() {
        }

        public HPosWrapper(int[] hPos) {
            this.m_hPos = hPos;
        }

        public void setHPos(int[] hPos) {
            this.m_hPos = hPos;
        }

        public int[] getHPos() {
            return this.m_hPos;
        }

        public boolean equals(int[] hPos) {
            if (this.m_hPos == null && hPos != null) {
                return false;
            }
            if (this.m_hPos != null && hPos == null) {
                return false;
            }
            if (this.m_hPos == null && hPos == null) {
                return true;
            }
            if (this.m_hPos.length != hPos.length) {
                return false;
            }
            for (int i = 0; i < this.m_hPos.length; ++i) {
                if (this.m_hPos[i] == hPos[i]) continue;
                return false;
            }
            return true;
        }

        public boolean equals(HPosWrapper hPos) {
            return this.equals(hPos.getHPos());
        }
    }
}

