/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import java.awt.Color;
import oracle.dss.dataView.BaseComponentXML;
import oracle.dss.graph.BaseGraphComponent;
import oracle.dss.graph.CommonGraph;
import oracle.dss.graph.PFJ;
import oracle.dss.graph.SFX;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.util.xml.ContainerNode;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;
import oracle.javatools.annotations.Concealed;

@Deprecated
public class ExceptionalRiser
extends BaseComponentXML {
    @Concealed
    protected CommonGraph m_commonGraph;
    @Concealed
    protected PFJ m_pfj;
    @Concealed
    protected IdentObj m_identObj;
    @Concealed
    protected SFX m_sfx;
    @Concealed
    protected static final String a_series = "series";
    @Concealed
    protected static final String a_group = "group";

    public ExceptionalRiser(CommonGraph graph, int series, int group) {
        this.m_commonGraph = graph;
        this.m_pfj = graph.getPFJ();
        this.m_pfj.setExceptionalRiser(series, group);
        this.m_identObj = this.m_pfj.getExceptionalRiser(series, group);
    }

    public SFX getSFX() {
        if (this.m_sfx == null) {
            this.m_sfx = new SFX(this.m_commonGraph, this.m_identObj);
        }
        return this.m_sfx;
    }

    public Color getFillColor() {
        return this.m_pfj.getFillColor(this.m_identObj);
    }

    public void setFillColor(Color newColor) {
        if (newColor == null) {
            this.m_commonGraph.getErrorHandler().log("invalid Color value", this.getClass().toString(), "setFillColor( Color newColor)");
            return;
        }
        this.m_pfj.setFillColor(this.m_identObj, newColor);
    }

    public Color getBorderColor() {
        return this.m_pfj.getBorderColor(this.m_identObj);
    }

    public void setBorderColor(Color newColor) {
        if (newColor == null) {
            this.m_commonGraph.getErrorHandler().log("invalid Color value", this.getClass().toString(), "setBorderColor( Color newColor)");
            return;
        }
        this.m_pfj.setBorderColor(this.m_identObj, newColor);
    }

    @Override
    @Concealed
    protected String getComponentName() {
        return "ExceptionalRiser";
    }

    @Concealed
    protected ObjectNode getXML(boolean allProperties, boolean allOverriddenProperties) {
        Color val;
        ObjectNode node = new ObjectNode(this.getComponentName());
        boolean nodeExists = false;
        node.addProperty(a_series, this.m_identObj.getSeriesID());
        node.addProperty(a_group, this.m_identObj.getGroupID());
        ContainerNode sfxNode = this.getSFX().getXML(allProperties, allOverriddenProperties);
        if (sfxNode != null) {
            node.addContainer(sfxNode);
            nodeExists = true;
        }
        if ((val = this.getBorderColor()) != null) {
            node.addProperty("borderColor", BaseGraphComponent.toHexString(val.getRGB()));
            nodeExists = true;
        }
        if ((val = this.getFillColor()) != null) {
            node.addProperty("fillColor", BaseGraphComponent.toHexString(val.getRGB()));
            nodeExists = true;
        }
        return nodeExists ? node : null;
    }

    @Concealed
    protected void setXML(ObjectNode node, boolean allProperties) {
        PropertyNode pNode;
        ContainerNode sfx = node.getContainer("SFX");
        if (sfx != null) {
            this.getSFX().setXML(sfx, allProperties);
        }
        if ((pNode = node.getProperty("borderColor")) != null) {
            this.setBorderColor(new Color(BaseGraphComponent.hexStringToInt(pNode.getValueAsString()), true));
        }
        if ((pNode = node.getProperty("fillColor")) != null) {
            this.setFillColor(new Color(BaseGraphComponent.hexStringToInt(pNode.getValueAsString()), true));
        }
    }
}

