/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import oracle.dss.graph.BaseMajorTick;
import oracle.dss.graph.CommonGraph;
import oracle.dss.graph.pfj.Attr;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;
import oracle.javatools.annotations.Concealed;

public class O1MajorTick
extends BaseMajorTick {
    @Concealed
    public O1MajorTick(CommonGraph graph) {
        super(graph);
        this.m_identObj = this.m_pfj.getO1MajorGrid();
    }

    @Override
    public boolean selectObject(int series, int group) {
        this.m_pfj.setSelection(this.m_identObj);
        return this.m_identObj.equals(this.m_pfj.getSelectionID());
    }

    @Override
    public int getTickStyle() {
        return this.m_pfj.getO1MajorGridStyle();
    }

    @Override
    public void setTickStyle(int style) {
        if (style < 0 || style > 6) {
            this.m_commonGraph.getErrorHandler().log("invalid style", "oracle.dss.graph.O1MajorTick", "setTickStyle(int style)");
        } else {
            this.m_pfj.setO1MajorGridStyle(style);
        }
    }

    public void setSkippedWithLabels(boolean skipped) {
        this.m_pfj.setIgnoreGridSkip(!skipped);
    }

    public boolean isSkippedWithLabels() {
        return !this.m_pfj.getIgnoreGridSkip();
    }

    @Override
    public boolean isVisible() {
        return this.getTickStyle() != 6;
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.setTickStyle(5);
        } else {
            this.setTickStyle(6);
        }
    }

    @Override
    @Concealed
    protected String getComponentName() {
        return "O1MajorTick";
    }

    @Override
    @Concealed
    public boolean getStyleXML(boolean allProperties, ObjectNode node) {
        boolean nodeExists = super.getStyleXML(allProperties, node);
        Object val = this.m_pfj.getObjProp(Attr.IgnoreGridSkip);
        if (val != null) {
            node.addProperty("skippedWithLabels", (Boolean)val == false);
            nodeExists = true;
        }
        return nodeExists;
    }

    @Override
    @Concealed
    public void setStyleXML(ObjectNode node) {
        super.setStyleXML(node);
        PropertyNode pNode = node.getProperty("skippedWithLabels");
        if (pNode != null) {
            this.setSkippedWithLabels(pNode.getValueAsBoolean());
        }
    }

    @Override
    @Concealed
    protected void resetStyle() {
        this.setSkippedWithLabels(true);
        super.resetStyle();
    }
}

