/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import java.awt.Color;
import oracle.dss.dataView.UIFillColor;
import oracle.dss.graph.BaseGraphComponent;
import oracle.dss.graph.CommonGraph;
import oracle.dss.graph.Series;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;
import oracle.javatools.annotations.Concealed;

public class ParetoMarker
extends BaseGraphComponent
implements UIFillColor {
    @Concealed
    public ParetoMarker(CommonGraph graph) {
        super(graph);
    }

    @Override
    public void setFillColor(Color color) {
        if (color == null) {
            this.m_commonGraph.getErrorHandler().log("invalid Color value", this.getClass().toString(), "setFillColor(Color color)");
            return;
        }
        this.m_pfj.setFillColor(this.m_pfj.getParetoLineMarker(), color);
    }

    @Override
    public Color getFillColor() {
        return this.m_pfj.getFillColor(this.m_pfj.getParetoLineMarker());
    }

    public void setMarkerShape(int shape) {
        if (shape < 0 || shape > 6) {
            this.m_commonGraph.getErrorHandler().log("invalid marker shape", this.getClass().getName(), "setMarkerShape (int shape)");
        } else {
            this.m_pfj.setMarkerShape(this.m_pfj.getParetoLineMarker(), shape);
        }
    }

    public int getMarkerShape() {
        return this.m_pfj.getMarkerShape(this.m_pfj.getParetoLineMarker());
    }

    @Override
    @Concealed
    protected String getComponentName() {
        return "ParetoMarker";
    }

    @Override
    @Concealed
    public void setStyleXML(ObjectNode node) {
        PropertyNode pNode = node.getProperty("fillColor");
        if (pNode != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("fillColor", new Color(ParetoMarker.hexStringToInt(pNode.getValueAsString()), true));
            } else {
                this.setFillColor(new Color(ParetoMarker.hexStringToInt(pNode.getValueAsString()), true));
            }
        }
        if ((pNode = node.getProperty("markerShape")) != null) {
            if (this.m_jsfHashMap != null) {
                this.m_commonGraph.getSeries();
                this.m_jsfHashMap.put("markerShape", new Integer(Series.convertMarkerShapeToInt(pNode.getValueAsString())));
            } else {
                this.m_commonGraph.getSeries();
                this.setMarkerShape(Series.convertMarkerShapeToInt(pNode.getValueAsString()));
            }
        }
    }

    @Override
    @Concealed
    public boolean getStyleXML(boolean allProperties, ObjectNode node) {
        boolean styleOverridden = false;
        Object val = this.getFillColor();
        if (val != null) {
            node.addProperty("fillColor", ParetoMarker.toHexString(((Color)val).getRGB()));
            styleOverridden = true;
        }
        if ((val = this.m_pfj.getMarkerShapeObj(this.m_pfj.getParetoLineMarker())) != null) {
            this.m_commonGraph.getSeries();
            node.addProperty("markerShape", Series.convertMarkerShapeToString((Integer)val));
            styleOverridden = true;
        }
        return styleOverridden;
    }

    @Concealed
    protected void resetStyle() {
        this.setMarkerShape(0);
    }
}

