/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import java.util.HashMap;
import oracle.dss.dataView.DataviewFontAttribute;
import oracle.dss.dataView.FontAttribute;
import oracle.dss.dataView.managers.Formattable;
import oracle.dss.dataView.managers.ViewFormat;
import oracle.dss.dataView.managers.ViewFormatCallback;
import oracle.dss.graph.BaseText;
import oracle.dss.graph.CommonGraph;
import oracle.dss.graph.Visible;
import oracle.dss.graph.pfj.Attr;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;
import oracle.javatools.annotations.Concealed;

public class SliceLabel
extends BaseText
implements Visible,
FontAttribute,
Formattable,
ViewFormatCallback,
DataviewFontAttribute {
    @Concealed
    protected ViewFormat m_viewFormat;
    private static final String m_method_setViewFormat = "setViewFormat(ViewFormat viewFormat)";

    @Concealed
    public SliceLabel(CommonGraph graph) {
        super(graph);
        this.m_identObj = this.m_pfj.getPieSliceLabel();
        this.m_viewFormat = new ViewFormat();
        this.m_viewFormat.setViewFormatCallback(this);
        this.m_viewFormat.setView(this.m_commonGraph);
    }

    @Concealed
    public void resetToDefault() {
        this.m_viewFormat = new ViewFormat();
        this.m_viewFormat.setViewFormatCallback(this);
        this.m_viewFormat.setView(this.m_commonGraph);
    }

    @Override
    public boolean selectObject(int series, int group) {
        if (series >= 0 && group >= 0) {
            IdentObj identObj = new IdentObj(this.m_identObj);
            if (this.m_commonGraph.getGraphType() != 100) {
                identObj.setSeriesID(series);
            }
            identObj.setGroupID(group);
            this.m_pfj.setSelection(identObj);
            if (identObj.equals(this.m_pfj.getSelectionID())) {
                return true;
            }
        }
        return false;
    }

    public int getTextType() {
        return this.m_pfj.getPieLabelDisplay();
    }

    public void setTextType(int i) {
        if (i < 0 || i > 4) {
            this.m_commonGraph.getErrorHandler().log("invalid text type", "oracle.dss.graph.SliceLabel", "setTextType(int i)");
        } else {
            this.m_pfj.setPieLabelDisplay(i);
        }
    }

    public int getTextRotation() {
        return this.m_pfj.getTextRotation(this.m_identObj);
    }

    public void setTextRotation(int rotate) {
        if (this.m_pfj.isFunnel()) {
            this.m_pfj.setTextRotation(this.m_identObj, rotate);
        } else if (rotate != 0 && rotate != 90 && rotate != 270) {
            this.m_commonGraph.getErrorHandler().log("invalid value for TextRotation", this.getClass().getName(), "setTextRotation(int rotate)");
        } else {
            this.m_pfj.setTextRotation(this.m_identObj, rotate);
        }
    }

    @Override
    public ViewFormat getViewFormat() {
        return this.m_viewFormat;
    }

    @Override
    public void setViewFormat(ViewFormat viewFormat) {
        if (viewFormat == null) {
            this.m_commonGraph.getErrorHandler().log("invalid ViewFormat", this.getClass().getName(), m_method_setViewFormat);
            return;
        }
        this.m_viewFormat = (ViewFormat)((Object)viewFormat.clone());
        this.m_viewFormat.setViewFormatCallback(this);
        this.m_viewFormat.setView(this.m_commonGraph);
        this.m_pfj.needRecalc();
    }

    @Concealed
    public void formatChanged(int attributeId, String attributeName, Object oldValue, Object newValue) {
        this.m_pfj.needRecalc();
    }

    @Override
    public boolean isVisible() {
        return this.m_pfj.getDisplay(this.m_identObj);
    }

    @Override
    public void setVisible(boolean yesNo) {
        this.m_pfj.setDisplay(this.m_identObj, yesNo);
    }

    @Override
    @Concealed
    protected String getComponentName() {
        return "SliceLabel";
    }

    @Concealed
    protected void setObjectId(IdentObj id) {
        this.m_identObj = id;
    }

    @Override
    @Concealed
    public boolean getNonstyleXML(boolean allProperties, ObjectNode node) {
        boolean nodeExists = super.getNonstyleXML(allProperties, node);
        ObjectNode viewFormatXMl = this.getViewFormat().getXML(allProperties);
        if (viewFormatXMl != null) {
            node.addProperty(viewFormatXMl);
            nodeExists = true;
        }
        return nodeExists;
    }

    @Override
    @Concealed
    public boolean getStyleXML(boolean allProperties, ObjectNode node) {
        int tmp;
        boolean nodeExists = super.getStyleXML(allProperties, node);
        Object val = null;
        val = this.m_commonGraph.getGraphType() == 100 ? this.m_pfj.getObjProp(Attr.FunnelLabelDisplay) : this.m_pfj.getObjProp(Attr.PieLabelDisplay);
        if (val != null) {
            tmp = (Integer)val;
            if (tmp == 0) {
                node.addProperty("textType", "LD_VALUE");
            } else if (tmp == 1) {
                node.addProperty("textType", "LD_PERCENT");
            } else if (tmp == 2) {
                node.addProperty("textType", "LD_TEXT");
            } else if (tmp == 3) {
                node.addProperty("textType", "LD_TEXT_PERCENT");
            } else if (tmp == 4) {
                node.addProperty("textType", "LD_TEXT_VALUE");
            }
            nodeExists = true;
        }
        if ((val = this.m_pfj.getDisplayObj(this.m_identObj)) != null) {
            node.addProperty("visible", ((Boolean)val).booleanValue());
            nodeExists = true;
        }
        if ((val = this.m_pfj.getTextRotationObj(this.m_identObj)) != null) {
            tmp = (Integer)val;
            if (tmp == 0) {
                node.addProperty("textRotation", "TR_HORIZ");
            } else if (tmp == 90) {
                node.addProperty("textRotation", "TR_HORIZ_ROTATE_90");
            } else if (tmp == 270) {
                node.addProperty("textRotation", "TR_HORIZ_ROTATE_270");
            } else if (this.m_pfj.isFunnel()) {
                node.addProperty("textRotation", tmp);
            }
            nodeExists = true;
        }
        return nodeExists;
    }

    @Override
    @Concealed
    public void setNonstyleXML(ObjectNode node, String version, int reset) {
        super.setNonstyleXML(node);
        ObjectNode viewFormat = node.getPropertyValueAsObjectNode("ViewFormat", true);
        if (viewFormat != null) {
            if (this.m_jsfHashMap != null) {
                HashMap map = new HashMap();
                this.m_jsfHashMap.put("ViewFormat", map);
                this.getViewFormat().setXML(viewFormat, version, reset, map);
            } else {
                this.getViewFormat().setXML(viewFormat, version, reset);
            }
        }
    }

    @Override
    @Concealed
    public void setStyleXML(ObjectNode node) {
        super.setStyleXML(node);
        PropertyNode pNode = node.getProperty("textType");
        if (pNode != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("textType", new Integer(SliceLabel.convertTextTypeToInt(pNode.getValueAsString())));
            } else {
                this.setTextType(SliceLabel.convertTextTypeToInt(pNode.getValueAsString()));
            }
        }
        if ((pNode = node.getProperty("textRotation")) != null) {
            String tmp = pNode.getValueAsString();
            if (tmp.equals("TR_HORIZ")) {
                this.setTextRotation(0);
            } else if (tmp.equals("TR_HORIZ_ROTATE_90")) {
                this.setTextRotation(90);
            } else if (tmp.equals("TR_HORIZ_ROTATE_270")) {
                this.setTextRotation(270);
            } else if (this.m_pfj.isFunnel()) {
                try {
                    int angle = Integer.parseInt(tmp);
                    this.setTextRotation(angle);
                }
                catch (NumberFormatException ne) {
                    this.m_commonGraph.getErrorHandler().log("invalid value for TextRotation", this.getClass().getName(), "setTextRotation(int rotate)");
                }
            }
        }
        if ((pNode = node.getProperty("visible")) != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("rendered", new Boolean(pNode.getValueAsBoolean()));
            } else {
                this.setVisible(pNode.getValueAsBoolean());
            }
        }
        if ((pNode = node.getProperty("rendered")) != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("rendered", new Boolean(pNode.getValueAsBoolean()));
            } else {
                this.setVisible(pNode.getValueAsBoolean());
            }
        }
    }

    @Concealed
    public static int convertTextTypeToInt(String string) {
        if (string.equals("LD_VALUE")) {
            return 0;
        }
        if (string.equals("LD_PERCENT")) {
            return 1;
        }
        if (string.equals("LD_TEXT")) {
            return 2;
        }
        if (string.equals("LD_TEXT_PERCENT")) {
            return 3;
        }
        if (string.equals("LD_TEXT_VALUE")) {
            return 4;
        }
        return -1;
    }

    @Override
    @Concealed
    protected void resetStyle() {
        this.setVisible(false);
        this.setTextRotation(0);
        this.setTextType(2);
        super.resetStyle();
    }
}

