/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import oracle.dss.graph.BaseDataAxis;
import oracle.dss.graph.CommonGraph;
import oracle.dss.graph.GraphConstants;
import oracle.javatools.annotations.Concealed;

public class Y1Axis
extends BaseDataAxis {
    @Concealed
    public Y1Axis(CommonGraph graph) {
        super(graph);
        this.m_identObj = this.m_pfj.getY1Axis();
        this.m_identObj2 = this.m_pfj.getY1AxisLine();
        this.m_labelIdentObj = this.m_pfj.getY1Label();
        this.m_majorGridIdentObj = this.m_pfj.getY1MajorGrid();
        this.m_minorGridIdentObj = this.m_pfj.getY1MinorGrid();
        this.m_id = 46;
    }

    @Override
    public boolean isAxisAutoScaledFromZero() {
        return this.m_pfj.getY1MustIncludeZero();
    }

    @Override
    public void setAxisAutoScaledFromZero(boolean yesNo) {
        this.m_pfj.setY1MustIncludeZero(yesNo);
    }

    @Override
    public boolean isAxisMaxAutoScaled() {
        return this.m_pfj.getY1ScaleMaxAuto();
    }

    @Override
    public void setAxisMaxAutoScaled(boolean yesNo) {
        this.m_pfj.setY1ScaleMaxAuto(yesNo);
    }

    @Override
    public boolean isAxisMinAutoScaled() {
        return this.m_pfj.getY1ScaleMinAuto();
    }

    @Override
    public void setAxisMinAutoScaled(boolean yesNo) {
        this.m_pfj.setY1ScaleMinAuto(yesNo);
    }

    @Override
    public double getAxisMaxAutoValue() {
        if (!this.m_pfj.isCalculated()) {
            this.m_commonGraph.calculatePlacement();
        }
        return this.m_pfj.getY1ScaleMaxAutoValue();
    }

    @Override
    public double getAxisMaxValue() {
        if (this.m_commonGraph.getGraphType() != 96) {
            return this.m_pfj.getY1ScaleMax();
        }
        return this.getAxisMaxAutoValue();
    }

    @Override
    public void setAxisMaxValue(double value) {
        this.m_pfj.setY1ScaleMax(value);
        if (this.m_commonGraph.getGraphType() == 96) {
            this.m_commonGraph.getErrorHandler().log("Current graph type doesn't support set Y1 axis maximum value", this.getClass().getName(), "setAxisMaxValue (double value)");
        }
    }

    @Override
    public double getAxisMinAutoValue() {
        if (!this.m_pfj.isCalculated()) {
            this.m_commonGraph.calculatePlacement();
        }
        return this.m_pfj.getY1ScaleMinAutoValue();
    }

    @Override
    public double getAxisMinValue() {
        if (this.m_commonGraph.getGraphType() != 96) {
            return this.m_pfj.getY1ScaleMin();
        }
        return this.getAxisMinAutoValue();
    }

    @Override
    public void setAxisMinValue(double value) {
        this.m_pfj.setY1ScaleMin(value);
        if (this.m_commonGraph.getGraphType() == 96) {
            this.m_commonGraph.getErrorHandler().log("Current graph type doesn't support set Y1 axis minimum value", this.getClass().getName(), "setAxisMinValue (double value)");
        }
    }

    @Override
    public double getAxisZoomMaxValue() {
        if (this.m_commonGraph.getGraphType() != 96) {
            Double val = this.m_pfj.getY1ScaleZoomMax();
            if (val != null) {
                return val;
            }
            return 0.0;
        }
        return this.getAxisMaxAutoValue();
    }

    @Override
    public void setAxisZoomMaxValue(double value) {
        this.m_pfj.setY1ScaleZoomMax(value);
        if (this.m_commonGraph.getGraphType() == 96) {
            this.m_commonGraph.getErrorHandler().log("Current graph type doesn't support set Y1 axis max zoom value", this.getClass().getName(), "setAxisZoomMaxValue (double value)");
        }
    }

    @Override
    public double getAxisZoomMinValue() {
        if (this.m_commonGraph.getGraphType() != 96) {
            Double val = this.m_pfj.getY1ScaleZoomMin();
            if (val != null) {
                return val;
            }
            return 0.0;
        }
        return this.getAxisMinAutoValue();
    }

    @Override
    public void setAxisZoomMinValue(double value) {
        this.m_pfj.setY1ScaleZoomMin(value);
        if (this.m_commonGraph.getGraphType() == 96) {
            this.m_commonGraph.getErrorHandler().log("Current graph type doesn't support set Y1 axis min zoom value", this.getClass().getName(), "setAxisZoomMinValue (double value)");
        }
    }

    @Override
    public double getMajorTickStep() {
        if (this.isMajorTickStepAutomatic() && !this.m_pfj.isCalculated()) {
            this.m_commonGraph.calculatePlacement();
        }
        return this.m_pfj.getY1MajorGridStep();
    }

    @Override
    public double getMinorTickStep() {
        if (this.getMinorTickStepType() != GraphConstants.MinorGridStepType.AUTO && !this.m_pfj.isCalculated()) {
            this.m_commonGraph.calculatePlacement();
        }
        return this.m_pfj.getY1MinorGridStep();
    }

    @Override
    @Concealed
    public double getAutoMajorTickStep() {
        if (!this.m_pfj.isCalculated()) {
            this.m_commonGraph.calculatePlacement();
        }
        return this.m_pfj.getY1MajorGridStepAutoValue();
    }

    @Override
    public void setMajorTickStep(double value) {
        if (value < 0.0) {
            this.m_commonGraph.getErrorHandler().log("invalid major tick step", this.getClass().getName(), "setMajorTickStep (double value)");
        } else {
            this.m_pfj.setY1MajorGridStep(value);
        }
    }

    @Override
    public void setMinorTickStep(double value) {
        if (value < 0.0) {
            this.m_commonGraph.getErrorHandler().log("invalid mijor tick step", this.getClass().getName(), "setMinorTickStep (double value)");
        } else {
            this.m_pfj.setY1MinorGridStep(value);
        }
    }

    @Override
    public boolean isMajorTickStepAutomatic() {
        return this.m_pfj.getY1MajorGridStepAuto();
    }

    @Override
    public void setMajorTickStepAutomatic(boolean yesNo) {
        this.m_pfj.setY1MajorGridStepAuto(yesNo);
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.m_pfj.setY1LabelDisplay(visible);
        this.m_pfj.setY1MajorGridDisplay(visible);
        this.m_pfj.setY1MinorGridDisplay(visible);
    }

    @Override
    @Concealed
    protected String getComponentName() {
        return "Y1Axis";
    }
}

