/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Vector;
import oracle.dss.graph.GraphConstants;
import oracle.dss.graph.pfj.DataFormat;
import oracle.dss.graph.pfj.GroupsEnumerator;
import oracle.dss.graph.pfj.JChart_2D_Standard;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.PfjAssert;
import oracle.dss.graph.pfj.SeriesEnumerator;
import oracle.dss.graph.pfj.draw.BlackBoxObj;
import oracle.dss.graph.pfj.draw.DetLabel;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.graph.pfj.draw.TextStyleObj;

public abstract class JChart_2D_BoxBase
extends JChart_2D_Standard {
    private static final long serialVersionUID = 1L;
    protected DataFormat m_df;
    GroupsEnumerator m_gEnumReadOnly;

    @Override
    protected void calcDataAbsolute() {
        this.m_DataLabel = new String[this.m_nTotalSeries][this.m_nTotalGroups];
        this.m_dataOK = new boolean[this.m_nTotalSeries][this.m_nTotalGroups];
        this.m_gEnumReadOnly = new GroupsEnumerator(this.m_Perspective, this.m_Access, true);
        this.m_Perspective.calcReferenceObjects(1);
        this.m_Perspective.calcAnnotations(GraphConstants.AnnotationLocation.BACK);
    }

    @Override
    protected void drawDataValues() {
        int g;
        int s;
        SeriesEnumerator sEnum = new SeriesEnumerator(this.m_Perspective, this.m_Access, true);
        GroupsEnumerator gEnum = new GroupsEnumerator(this.m_Perspective, this.m_Access, true);
        Graphics gx = this.m_Perspective.getGraphicsContext();
        IdentObj id = this.m_Perspective.getDataText();
        Vector<String> szLabels = new Vector<String>(this.m_nSeries * this.m_nGroups);
        Dimension labelDim = new Dimension(8000, 3000);
        boolean bDataValueFontSizeAbsolute = this.m_Perspective.getFontSizeAbsolute(id);
        TextStyleObj textStyle = new TextStyleObj(this.m_Perspective.m_fontCache, this.m_Perspective.getFontName(id), this.m_Perspective.getFontStyle(id), bDataValueFontSizeAbsolute, this.m_Perspective.getFontSize(id), this.m_Perspective.getFontSizeVC(id), this.m_Perspective.getTextRotation(id), this.m_Perspective.getTextJustHoriz(id), this.m_Perspective.getTextJustVert(id), false, false, this.m_Perspective.getTextWrap(id), this.m_Perspective.getLocale());
        while (sEnum.hasMoreElements() && (s = sEnum.nextSeries()) < this.m_nTotalSeries) {
            gEnum.reset();
            while (gEnum.hasMoreElements()) {
                g = gEnum.nextGroup();
                PfjAssert.pfjAssert(g >= 0 && g < this.m_nTotalGroups);
                this.m_DataLabel[s][g] = this.m_Perspective.getCustomDataText(this.m_DataLabel[s][g], new IdentObj(id.getObjectID(), s, g));
                szLabels.addElement(this.m_DataLabel[s][g]);
            }
        }
        int nFontSizeVC = bDataValueFontSizeAbsolute ? this.m_Perspective.m_VC.destToVirtHeight(this.m_Perspective.getFontSize(id)) : this.m_Perspective.getFontSizeVC(id);
        textStyle.formatAndAutofit(gx, this.m_Perspective, this.m_Perspective.getAutofit(new IdentObj(260)), this.m_Perspective.getTextAutofitMin(), this.m_Perspective.getTextAutofitMax(), nFontSizeVC, szLabels, labelDim, this.m_Perspective.m_VC);
        BlackBoxObj blackBox = new BlackBoxObj(this.m_Perspective, id);
        sEnum.reset();
        while (sEnum.hasMoreElements() && (s = sEnum.nextSeries()) < this.m_nTotalSeries) {
            gEnum.reset();
            while (gEnum.hasMoreElements()) {
                g = gEnum.nextGroup();
                PfjAssert.pfjAssert(g >= 0 && g < this.m_nTotalGroups);
                if (!this.m_dataOK[s][g] || this.m_DataLabel[s][g] == null) continue;
                Rectangle r = this.calcHiLoDataValuePosition(s, g, labelDim);
                IdentObj newID = new IdentObj(id.getObjectID(), s, g);
                String fullText = this.m_DataLabel[s][g];
                String newLabel = this.getTruncatedLabel(textStyle, labelDim.width, fullText);
                new DetLabel(this.m_Detectiv, newID, newLabel, fullText, r, textStyle, blackBox, false);
            }
        }
    }

    protected Rectangle calcHiLoDataValuePosition(int s, int g, Dimension labelDim) {
        Point center = this.getCoords(s, g);
        Point base = this.getBottomCoords(s, g);
        Rectangle r = new Rectangle(center.x - labelDim.width / 2, center.y - labelDim.height / 2, labelDim.width, labelDim.height);
        switch (this.m_Perspective.getDataTextPosition()) {
            case 0: {
                double nAngle = this.m_Perspective.getDataTextAngle(s, g);
                double nDist = this.m_Perspective.getDataTextRadius(s, g);
                r.x += (int)(Math.cos(nAngle * (Math.PI / 180)) * nDist * 40.0);
                r.y += (int)(Math.sin(nAngle * (Math.PI / 180)) * nDist * 40.0);
                break;
            }
            case 1: {
                if (this.isAxisAscending(s)) {
                    r.y += labelDim.height / 2;
                    break;
                }
                r.y -= labelDim.height / 2;
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                if (this.isAxisAscending(s)) {
                    r.y -= labelDim.height / 2;
                    break;
                }
                r.y += labelDim.height / 2;
                break;
            }
            case 4: {
                r.y = Math.min(center.y, base.y) + (Math.abs(center.y - base.y) - labelDim.height) / 2;
                break;
            }
            case 5: {
                r.y = base.y;
            }
        }
        Point offset = new Point(0, 0);
        if (this.m_Frame != null) {
            offset = this.m_Frame.getDepthOffset(1.0);
        }
        r.x -= offset.x;
        r.y -= offset.y;
        return r;
    }

    protected abstract Point getBottomCoords(int var1, int var2);

    @Override
    public void init(Perspective perspective) {
        super.init(perspective);
        this.m_df = this.m_Access.getDataFormat();
    }
}

