/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.awt.Point;
import java.awt.Rectangle;
import oracle.dss.graph.pfj.AssertionException;
import oracle.dss.graph.pfj.DataFormat;
import oracle.dss.graph.pfj.DataItem;
import oracle.dss.graph.pfj.DatumObj;
import oracle.dss.graph.pfj.GroupsEnumerator;
import oracle.dss.graph.pfj.JChart_2D_BoxBase;
import oracle.dss.graph.pfj.MarkerObj;
import oracle.dss.graph.pfj.MarkerTemplate;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.PfjAssert;
import oracle.dss.graph.pfj.RelativeAxisObj;
import oracle.dss.graph.pfj.draw.BlackBoxIF;
import oracle.dss.graph.pfj.draw.BlackBoxObj;
import oracle.dss.graph.pfj.draw.DetLine;
import oracle.dss.graph.pfj.draw.DetRect;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.graph.pfj.draw.SimpleBlackBoxObj;

public class JChart_2D_BoxPlot
extends JChart_2D_BoxBase {
    private static final long serialVersionUID = 1L;
    private boolean m_bIsFiveValue;
    private boolean m_bIsSevenValue;
    protected int m_nLineWidthMedian;
    protected int m_nLineWidth;
    protected int m_nTickLength;
    protected int m_nMarkerSize;

    @Override
    public void init(Perspective perspective) {
        super.init(perspective);
        this.m_bIsFiveValue = this.isFiveValueBoxPlot(this.m_df);
        this.m_bIsSevenValue = this.isSevenValueBoxPlot(this.m_df);
    }

    @Override
    protected void calcDataAbsolute() {
        super.calcDataAbsolute();
        this.drawBoxRisers();
        if (this.m_bIsSevenValue) {
            this.drawMarkers();
        }
        if (this.m_bDataTextDisplay) {
            this.drawDataValues();
        }
    }

    @Override
    protected Point getBottomCoords(int s, int g) {
        int nNumCoord;
        RelativeAxisObj yAxisObj = this.getAxisAssignment(s) == 1 ? this.m_Y2Axis : this.m_Y1Axis;
        int gRel = this.m_gEnumReadOnly.getRelativeGroup(g);
        PfjAssert.pfjAssert(gRel >= 0 && gRel < this.m_nGroups);
        int nOrdCoord = (int)this.m_O1Axis.getCenterCoord(gRel);
        try {
            double fMin = this.getMinValue(s, g);
            nNumCoord = (int)yAxisObj.getValueCoord(fMin);
        }
        catch (Exception e) {
            nNumCoord = 0;
        }
        Point center = this.m_bHorz ? new Point(nNumCoord, nOrdCoord) : new Point(nOrdCoord, nNumCoord);
        return center;
    }

    private void drawBoxRisers() {
        GroupsEnumerator gEnum = new GroupsEnumerator(this.m_Perspective, this.m_Access, true);
        double fMin = 0.0;
        double fMax = 0.0;
        double fQ1 = 0.0;
        double fMed = 0.0;
        double fQ3 = 0.0;
        int s = 0;
        IdentObj id = new IdentObj(-3, s);
        IdentObj idLine = new IdentObj(347, s);
        BlackBoxObj blackBoxLine = new BlackBoxObj(this.m_Perspective, idLine);
        gEnum.reset();
        while (gEnum.hasMoreElements()) {
            IdentObj newID;
            int y2;
            int x2;
            int y1;
            int x1;
            int g = gEnum.nextGroup();
            PfjAssert.pfjAssert(g >= 0 && g < this.m_nTotalGroups);
            int gRel = gEnum.getRelativeGroup(g);
            PfjAssert.pfjAssert(gRel >= 0 && gRel < this.m_nGroups);
            this.m_dataOK[s][g] = true;
            try {
                fMin = this.getMinValue(s, g);
                fQ1 = this.getQ1Value(s, g);
                fMed = this.getMedianValue(s, g);
                fQ3 = this.getQ3Value(s, g);
                fMax = this.getMaxValue(s, g);
            }
            catch (AssertionException e) {
                this.m_dataOK[s][g] = false;
                continue;
            }
            IdentObj idBar = new IdentObj(348, s, g);
            BlackBoxIF blackBox = this.assignSeriesColor(s, g);
            blackBox.setTransparentBorderColor(false);
            blackBox = blackBox.runRules(s, g);
            blackBoxLine.setBorderColor(this.m_Perspective.getBorderColor(id, true));
            if (blackBox.getFillColor() != null) {
                blackBox.setBorderColor(this.m_Perspective.getFillColor(id));
            }
            if (this.m_Perspective.getTransparentFillColor(id)) {
                blackBox.setTransparentBorderColor(true);
            }
            int nLineStyle = this.m_Perspective.getLineStyle(id);
            this.m_nLineWidth = 1;
            this.m_nLineWidthMedian = 3;
            int boxBottom = (int)this.m_Y1Axis.getValueCoord(fQ1);
            int boxTop = (int)this.m_Y1Axis.getValueCoord(fQ3);
            int boxLeft = (int)this.m_O1Axis.getLowCoord(0, gRel);
            int boxRight = (int)this.m_O1Axis.getHighCoord(0, gRel);
            int center = (int)this.m_O1Axis.getCenterCoord(gRel);
            Rectangle rVirt = new Rectangle(boxLeft, boxBottom, boxRight - boxLeft, boxTop - boxBottom);
            Rectangle rDest = this.m_Perspective.m_VC.virtToDest(rVirt);
            if (rDest.height < 2) {
                rDest.height = 2;
                rVirt = this.m_Perspective.m_VC.destToVirt(rDest);
            }
            if (!this.m_Y1Axis.isValueOffscale(fMax) || !this.m_Y1Axis.isValueOffscale(fQ3)) {
                x1 = center;
                y1 = boxTop;
                x2 = center;
                y2 = (int)this.m_Y1Axis.getValueCoord(fMax);
                newID = new IdentObj(idLine.getObjectID(), s, g);
                new DetLine(this.m_Detectiv, newID, x1, y1, x2, y2, (BlackBoxIF)blackBoxLine, this.m_rClip, this.m_nLineWidth);
            }
            if (!this.m_Y1Axis.isValueOffscale(fMin) || !this.m_Y1Axis.isValueOffscale(fQ1)) {
                x1 = center;
                y1 = boxBottom;
                x2 = center;
                y2 = (int)this.m_Y1Axis.getValueCoord(fMin);
                newID = new IdentObj(idLine.getObjectID(), s, g);
                new DetLine(this.m_Detectiv, newID, x1, y1, x2, y2, (BlackBoxIF)blackBoxLine, this.m_rClip, this.m_nLineWidth);
            }
            if (!this.m_Y1Axis.isValueOffscale(fQ1) || !this.m_Y1Axis.isValueOffscale(fQ3)) {
                if (this.m_autoGradient && (rDest.height <= 3 || rDest.width <= 3)) {
                    SimpleBlackBoxObj bb = new SimpleBlackBoxObj(this.m_Perspective, idBar, this.m_bWantRiserBorder);
                    new DetRect(this.m_Detectiv, idBar, rVirt, (BlackBoxIF)bb, this.m_rClip);
                } else {
                    new DetRect(this.m_Detectiv, idBar, rVirt, blackBox, this.m_rClip);
                }
            }
            if (!this.m_Y1Axis.isValueOffscale(fMed)) {
                x1 = boxLeft;
                y1 = (int)this.m_Y1Axis.getValueCoord(fMed);
                x2 = this.m_bWantRiserBorder ? boxRight + 1 : boxRight;
                y2 = y1;
                newID = new IdentObj(idLine.getObjectID(), s, g);
                new DetLine(this.m_Detectiv, newID, x1, y1, x2, y2, (BlackBoxIF)blackBoxLine, this.m_rClip, this.m_nLineWidthMedian, nLineStyle);
            }
            if (!this.m_Y1Axis.isValueOffscale(fMin)) {
                this.m_nTickLength = this.m_Perspective.getVC().destToVirtWidth(14);
                x1 = center - this.m_nTickLength / 2;
                y1 = (int)this.m_Y1Axis.getValueCoord(fMin);
                x2 = center + this.m_nTickLength / 2;
                y2 = y1;
                newID = new IdentObj(idLine.getObjectID(), s, g);
                new DetLine(this.m_Detectiv, newID, x1, y1, x2, y2, (BlackBoxIF)blackBoxLine, this.m_rClip, this.m_nLineWidth);
            }
            if (this.m_Y1Axis.isValueOffscale(fMax)) continue;
            x1 = center - this.m_nTickLength / 2;
            y1 = (int)this.m_Y1Axis.getValueCoord(fMax);
            x2 = center + this.m_nTickLength / 2;
            y2 = y1;
            newID = new IdentObj(idLine.getObjectID(), s, g);
            new DetLine(this.m_Detectiv, newID, x1, y1, x2, y2, (BlackBoxIF)blackBoxLine, this.m_rClip, this.m_nLineWidth);
        }
    }

    @Override
    protected void drawMarkers() {
        GroupsEnumerator gEnum = new GroupsEnumerator(this.m_Perspective, this.m_Access, true);
        double fTen = 0.0;
        double fNinety = 0.0;
        int s = 0;
        IdentObj id = new IdentObj(-3, s);
        gEnum.reset();
        while (gEnum.hasMoreElements()) {
            IdentObj newID;
            int g = gEnum.nextGroup();
            PfjAssert.pfjAssert(g >= 0 && g < this.m_nTotalGroups);
            int gRel = gEnum.getRelativeGroup(g);
            PfjAssert.pfjAssert(gRel >= 0 && gRel < this.m_nGroups);
            IdentObj markerID = new IdentObj(349, s, g);
            BlackBoxIF bBox = this.assignSeriesColor(new IdentObj(259, s), true);
            MarkerTemplate markerTemplate = this.getMarkerShape(id);
            this.m_dataOK[s][g] = true;
            try {
                fTen = this.getTenValue(s, g);
                fNinety = this.getNinetyValue(s, g);
            }
            catch (AssertionException e) {
                this.m_dataOK[s][g] = false;
                continue;
            }
            int bottom = (int)this.m_Y1Axis.getValueCoord(fTen);
            int top = (int)this.m_Y1Axis.getValueCoord(fNinety);
            int center = (int)this.m_O1Axis.getCenterCoord(gRel);
            this.m_nMarkerSize = 20;
            if (!this.m_Y1Axis.isValueOffscale(fTen)) {
                newID = new IdentObj(markerID.getObjectID(), s, g, 0, 0);
                MarkerObj.createMarker(this.m_Detectiv, newID, markerTemplate, new Point(center, bottom), this.m_nMarkerSize, this.m_nMarkerSize, bBox, null, true);
            }
            if (this.m_Y1Axis.isValueOffscale(fNinety)) continue;
            newID = new IdentObj(markerID.getObjectID(), s, g, 0, 1);
            MarkerObj.createMarker(this.m_Detectiv, newID, markerTemplate, new Point(center, top), this.m_nMarkerSize, this.m_nMarkerSize, bBox, null, true);
        }
    }

    @Override
    protected String processDataTextTemplate(String[] dataItems, String dataTextTemplate) {
        String ResultString = dataTextTemplate;
        return ResultString;
    }

    public double getMinValue(int s, int g) throws AssertionException {
        DataItem item = this.getMinItem();
        DatumObj dObj = this.getDataValue(s, g, item);
        if (dObj.m_bOK) {
            return dObj.m_fValue;
        }
        throw new AssertionException();
    }

    private DataItem getMinItem() {
        DataItem item;
        if (this.m_df == DataFormat.DF_FV) {
            item = DataItem.DI_FV_MIN;
        } else if (this.m_df == DataFormat.DF_SV) {
            item = DataItem.DI_SV_MIN;
        } else {
            throw new AssertionException("getMinItem used with wrong dataFormat: " + this.m_df.toString());
        }
        return item;
    }

    public double getMaxValue(int s, int g) throws AssertionException {
        DataItem item = this.getMaxItem();
        DatumObj dObj = this.getDataValue(s, g, item);
        if (dObj.m_bOK) {
            return dObj.m_fValue;
        }
        throw new AssertionException();
    }

    private DataItem getMaxItem() {
        DataItem item;
        if (this.m_df == DataFormat.DF_FV) {
            item = DataItem.DI_FV_MAX;
        } else if (this.m_df == DataFormat.DF_SV) {
            item = DataItem.DI_SV_MAX;
        } else {
            throw new AssertionException("getMaxItem used with wrong dataFormat: " + this.m_df.toString());
        }
        return item;
    }

    public double getMedianValue(int s, int g) throws AssertionException {
        DataItem item = this.getMedianItem();
        DatumObj dObj = this.getDataValue(s, g, item);
        if (dObj.m_bOK) {
            return dObj.m_fValue;
        }
        throw new AssertionException();
    }

    private DataItem getMedianItem() {
        DataItem item;
        if (this.m_df == DataFormat.DF_FV) {
            item = DataItem.DI_FV_MED;
        } else if (this.m_df == DataFormat.DF_SV) {
            item = DataItem.DI_SV_MED;
        } else {
            throw new AssertionException("getMedItem used with wrong dataFormat: " + this.m_df.toString());
        }
        return item;
    }

    public double getQ1Value(int s, int g) throws AssertionException {
        DataItem item = this.getQ1Item();
        DatumObj dObj = this.getDataValue(s, g, item);
        if (dObj.m_bOK) {
            return dObj.m_fValue;
        }
        throw new AssertionException();
    }

    private DataItem getQ1Item() {
        DataItem item;
        if (this.m_df == DataFormat.DF_FV) {
            item = DataItem.DI_FV_Q1;
        } else if (this.m_df == DataFormat.DF_SV) {
            item = DataItem.DI_SV_Q1;
        } else {
            throw new AssertionException("getQ1Item used with wrong dataFormat: " + this.m_df.toString());
        }
        return item;
    }

    public double getQ3Value(int s, int g) throws AssertionException {
        DataItem item = this.getQ3Item();
        DatumObj dObj = this.getDataValue(s, g, item);
        if (dObj.m_bOK) {
            return dObj.m_fValue;
        }
        throw new AssertionException();
    }

    private DataItem getQ3Item() {
        DataItem item;
        if (this.m_df == DataFormat.DF_FV) {
            item = DataItem.DI_FV_Q3;
        } else if (this.m_df == DataFormat.DF_SV) {
            item = DataItem.DI_SV_Q3;
        } else {
            throw new AssertionException("getQ3Item used with wrong dataFormat: " + this.m_df.toString());
        }
        return item;
    }

    public double getTenValue(int s, int g) throws AssertionException {
        DataItem item = this.getTenItem();
        DatumObj dObj = this.getDataValue(s, g, item);
        if (dObj.m_bOK) {
            return dObj.m_fValue;
        }
        throw new AssertionException();
    }

    private DataItem getTenItem() {
        if (this.m_df != DataFormat.DF_SV) {
            throw new AssertionException("getTenItem used with wrong dataFormat: " + this.m_df.toString());
        }
        DataItem item = DataItem.DI_SV_TEN;
        return item;
    }

    public double getNinetyValue(int s, int g) throws AssertionException {
        DataItem item = this.getNinetyItem();
        DatumObj dObj = this.getDataValue(s, g, item);
        if (dObj.m_bOK) {
            return dObj.m_fValue;
        }
        throw new AssertionException();
    }

    private DataItem getNinetyItem() {
        if (this.m_df != DataFormat.DF_SV) {
            throw new AssertionException("getNinetyItem used with wrong dataFormat: " + this.m_df.toString());
        }
        DataItem item = DataItem.DI_SV_NIN;
        return item;
    }

    public boolean isFiveValueBoxPlot(DataFormat theDataFormat) {
        return theDataFormat == DataFormat.DF_FV;
    }

    public boolean isSevenValueBoxPlot(DataFormat theDataFormat) {
        return theDataFormat == DataFormat.DF_SV;
    }

    @Override
    public boolean isSingleSeriesOnly() {
        return true;
    }

    @Override
    public boolean wantLegend() {
        return false;
    }

    @Override
    protected Point getCoords(int s, int g) {
        return null;
    }
}

