/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.Vector;

public class QSortPoly {
    static final int SORTTYPE_LEFTTORIGHT = 0;
    static final int SORTTYPE_RIGHTTOLEFT = 1;

    private QSortPoly() {
    }

    protected static void quickSortPoly(Vector vectorPoly, int nLeft, int nRight, int nSortType) {
        int i = nLeft;
        int j = nRight;
        int nMidIdx = (nLeft + nRight) / 2;
        Rectangle rectDataMid = ((Polygon)vectorPoly.elementAt(nMidIdx)).getBounds();
        do {
            Rectangle rectDataI = ((Polygon)vectorPoly.elementAt(i)).getBounds();
            while (QSortPoly.sortCondition(rectDataI, rectDataMid, nSortType)) {
                rectDataI = ((Polygon)vectorPoly.elementAt(++i)).getBounds();
            }
            Rectangle rectDataJ = ((Polygon)vectorPoly.elementAt(j)).getBounds();
            while (QSortPoly.sortCondition(rectDataMid, rectDataJ, nSortType)) {
                rectDataJ = ((Polygon)vectorPoly.elementAt(--j)).getBounds();
            }
            if (i > j) continue;
            QSortPoly.swapElements(vectorPoly, i, j);
            ++i;
            --j;
        } while (i <= j);
        if (nLeft < j) {
            QSortPoly.quickSortPoly(vectorPoly, nLeft, j - 1, nSortType);
        }
        if (i < nRight) {
            QSortPoly.quickSortPoly(vectorPoly, i + 1, nRight, nSortType);
        }
    }

    static boolean sortCondition(Rectangle rect1, Rectangle rect2, int nSortType) {
        boolean bContinue = false;
        switch (nSortType) {
            case 0: {
                if (rect1.x + rect1.width / 2 >= rect2.x + rect2.width / 2) break;
                bContinue = true;
                break;
            }
            case 1: {
                if (rect1.x + rect1.width / 2 <= rect2.x + rect2.width / 2) break;
                bContinue = true;
            }
        }
        return bContinue;
    }

    static void swapElements(Vector objList, int j, int i) {
        if (i != j) {
            Polygon poly = (Polygon)objList.elementAt(i);
            objList.setElementAt(objList.elementAt(j), i);
            objList.setElementAt(poly, j);
        }
    }
}

