/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.draw;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import oracle.dss.dataView.DataviewUtils;
import oracle.dss.graph.BaseText;
import oracle.dss.graph.CommonGraph;
import oracle.dss.graph.pfj.GraphExportXMLWriter;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.RangeSlider;
import oracle.dss.graph.pfj.VC;
import oracle.dss.graph.pfj.draw.DetObj;
import oracle.dss.graph.pfj.draw.Detectiv;
import oracle.dss.graph.pfj.draw.IdentObj;

public class DetMetadata
extends DetObj {
    private static final long serialVersionUID = 1L;
    String m_elementName;
    Map<String, String> m_metadataMap = new HashMap<String, String>();

    private DetMetadata(Detectiv detectiv) {
        super(detectiv, IdentObj.GLOBAL, null, false, false, false);
    }

    private DetMetadata(Detectiv detectiv, IdentObj id) {
        super(detectiv, id, null, false, false, false);
    }

    public static DetMetadata newPieMetadata(Detectiv detectiv, Rectangle2D bounds, double depth, double rotate) {
        DetMetadata md = new DetMetadata(detectiv);
        md.m_elementName = "pie";
        StringBuilder sb = DataviewUtils.getSharedStringBuilder();
        sb.append(bounds.getX()).append(',');
        sb.append(bounds.getY()).append(',');
        sb.append(bounds.getWidth()).append(',');
        sb.append(bounds.getHeight());
        md.m_metadataMap.put("p", sb.toString());
        md.m_metadataMap.put("depth", String.valueOf(depth));
        md.m_metadataMap.put("rotate", String.valueOf(rotate));
        CommonGraph graph = detectiv.getPerspective().getCommonGraph();
        Font labelFont = graph.getSliceLabel().getFont();
        Color labelColor = graph.getSliceLabel().getGraphFont().getGraphFontColor();
        boolean bUnderline = graph.getSliceLabel().getGraphFont().isUnderline();
        String font = GraphExportXMLWriter.getFontAttributes(labelFont, labelColor, bUnderline, graph.getErrorHandler());
        md.m_metadataMap.put("f", font);
        return md;
    }

    public static DetMetadata newScrollableLegendMetadata(Detectiv detectiv, Rectangle bounds, int legendHeight) {
        DetMetadata md = new DetMetadata(detectiv);
        md.m_elementName = "scrollableLegend";
        StringBuilder sb = DataviewUtils.getSharedStringBuilder();
        sb.append(bounds.getX()).append(',');
        sb.append(bounds.getY()).append(',');
        sb.append(bounds.getWidth()).append(',');
        sb.append(bounds.getHeight());
        md.m_metadataMap.put("p", sb.toString());
        md.m_metadataMap.put("h", String.valueOf(legendHeight));
        return md;
    }

    public static DetMetadata newRangeSliderMetadata(Detectiv detectiv, RangeSlider rs) {
        if (rs == null) {
            return null;
        }
        DetMetadata md = new DetMetadata(detectiv, new IdentObj(rs.getID()));
        md.m_elementName = "rs";
        return md;
    }

    public static DetMetadata newRangeSliderZoomButtonMetadata(Detectiv detectiv, Rectangle rect) {
        DetMetadata md = new DetMetadata(detectiv, new IdentObj(78));
        md.m_elementName = "rszb";
        Rectangle bounds = detectiv.getPerspective().getVC().virtToDest(rect);
        StringBuilder sb = DataviewUtils.getSharedStringBuilder();
        sb.append(bounds.getX()).append(',');
        sb.append(bounds.getY()).append(',');
        sb.append(bounds.getWidth()).append(',');
        sb.append(bounds.getHeight());
        md.m_metadataMap.put("p", sb.toString());
        CommonGraph graph = detectiv.getPerspective().getCommonGraph();
        boolean bX1Scrolling = graph.getScrollbarPresenceGroups() != 0 || graph.getScrollbarPresenceX1() != 0;
        boolean bY1Scrolling = graph.getScrollbarPresenceY1() != 0;
        boolean bY2Scrolling = graph.getScrollbarPresenceY2() != 0;
        int zoomableAxis = 0;
        if (bX1Scrolling) {
            ++zoomableAxis;
        }
        if (bY1Scrolling) {
            ++zoomableAxis;
        }
        if (bY2Scrolling) {
            ++zoomableAxis;
        }
        ArrayList<String> resources = new ArrayList<String>();
        if (zoomableAxis >= 1) {
            resources.add(graph.getIntlString("af_dvt_graph.RANGE_SLIDER_ZOOM"));
            resources.add(graph.getIntlString("af_dvt_graph.ACTUAL_SIZE"));
            resources.add(graph.getIntlString("af_dvt_graph.ZOOM_IN"));
            resources.add(graph.getIntlString("af_dvt_graph.ZOOM_OUT"));
        }
        if (zoomableAxis > 1) {
            boolean bVerticalGraph;
            boolean bDualY = graph.getPFJ().getJGraphType().isDualY();
            boolean bl = bVerticalGraph = !graph.getPFJ().getJGraphType().isOrientHorz();
            if (bVerticalGraph) {
                resources.add(graph.getIntlString("af_dvt_graph.HORIZONTAL_AXIS"));
                if (!bDualY) {
                    resources.add(graph.getIntlString("af_dvt_graph.VERTICAL_AXIS"));
                } else {
                    resources.add(graph.getIntlString("af_dvt_graph.VERTICAL_AXIS_1"));
                }
                resources.add(graph.getIntlString("af_dvt_graph.VERTICAL_AXIS_2"));
            } else {
                resources.add(graph.getIntlString("af_dvt_graph.VERTICAL_AXIS"));
                if (!bDualY) {
                    resources.add(graph.getIntlString("af_dvt_graph.HORIZONTAL_AXIS"));
                } else {
                    resources.add(graph.getIntlString("af_dvt_graph.HORIZONTAL_AXIS_1"));
                }
                resources.add(graph.getIntlString("af_dvt_graph.HORIZONTAL_AXIS_2"));
            }
        }
        StringBuilder resourceStr = new StringBuilder();
        for (String str : resources) {
            resourceStr.append(str).append(',');
        }
        if (resourceStr.length() > 0) {
            resourceStr.deleteCharAt(resourceStr.length() - 1);
        }
        md.m_metadataMap.put("resources", resourceStr.toString());
        md.m_metadataMap.put("flipped", Boolean.toString(graph.getPFJ().isAxisFlipped()));
        return md;
    }

    @Override
    public Rectangle getBounds() {
        return null;
    }

    @Override
    public void hilite(Graphics g, VC vc) {
    }

    @Override
    public boolean isPointInObj(int x, int y, VC vc) {
        return false;
    }

    @Override
    public boolean isPointInObj(Point pt, VC vc) {
        return false;
    }

    @Override
    public void paintIt(Graphics g, VC vc) {
    }

    @Override
    public void renderItToSVG(Map context) {
    }

    @Override
    public void setBounds(Rectangle rBounds) {
    }

    @Override
    public Polygon getShape(VC vc) {
        return null;
    }

    @Override
    public void renderItToXML(Map context) throws IOException, Exception {
        GraphExportXMLWriter writer = (GraphExportXMLWriter)context.get("xmlWriter");
        Perspective pfj = this.m_Detectiv.getPerspective();
        String dataScrollJs = null;
        String dataZoomJs = null;
        BaseText axisLabel = null;
        switch (super.getIdentID().getObjectID()) {
            case 75: {
                if (pfj.isX1AxisPresent()) {
                    this.m_metadataMap.put("id", "X1RS");
                    dataScrollJs = writer.getDataScrollSubmitJS("X1");
                    dataZoomJs = writer.getDataScrollbarZoomSubmitJS("X1");
                    axisLabel = pfj.getCommonGraph().getX1TickLabel();
                } else {
                    this.m_metadataMap.put("id", "O1RS");
                    dataScrollJs = writer.getDataScrollSubmitJS("O1");
                    dataZoomJs = writer.getDataScrollbarZoomSubmitJS("O1");
                    axisLabel = pfj.getCommonGraph().getO1TickLabel();
                }
                pfj.getHorzRangeSlider().writeMetaData(this.m_metadataMap);
                break;
            }
            case 76: {
                this.m_metadataMap.put("id", "Y1RS");
                dataScrollJs = writer.getDataScrollSubmitJS("Y1");
                dataZoomJs = writer.getDataScrollbarZoomSubmitJS("Y1");
                pfj.getY1RangeSlider().writeMetaData(this.m_metadataMap);
                axisLabel = pfj.getCommonGraph().getY1TickLabel();
                break;
            }
            case 77: {
                this.m_metadataMap.put("id", "Y2RS");
                dataScrollJs = writer.getDataScrollSubmitJS("Y2");
                dataZoomJs = writer.getDataScrollbarZoomSubmitJS("Y2");
                pfj.getY2RangeSlider().writeMetaData(this.m_metadataMap);
                axisLabel = pfj.getCommonGraph().getY2TickLabel();
                break;
            }
            case 78: {
                double ratio;
                String dataZoomInButtonJs = null;
                String dataZoomOutButtonJs = null;
                String actualJs = null;
                String actualAllJs = RangeSlider.getActualSizeJS(writer.getDataScrollbarZoomSubmitJS("ALL"));
                if (pfj.getHorzRangeSlider() != null) {
                    if (pfj.getJGraphType().getAxisDescriptor().hasX1() || pfj.isContinuousTimeAxis()) {
                        dataZoomInButtonJs = writer.getDataZoomInButtonSubmitJS("X1");
                        dataZoomOutButtonJs = writer.getDataZoomOutButtonSubmitJS("X1");
                        actualJs = RangeSlider.getActualSizeJS(writer.getDataScrollbarZoomSubmitJS("X1"));
                    } else {
                        dataZoomInButtonJs = writer.getDataZoomInButtonSubmitJS("O1");
                        dataZoomOutButtonJs = writer.getDataZoomOutButtonSubmitJS("O1");
                        actualJs = RangeSlider.getActualSizeJS(writer.getDataScrollbarZoomSubmitJS("O1"));
                    }
                    ratio = pfj.getHorzRangeSlider().getZoomRatio();
                    if (ratio < 16.0) {
                        this.m_metadataMap.put("x1in", dataZoomInButtonJs);
                    }
                    if (ratio > 1.0) {
                        this.m_metadataMap.put("x1out", dataZoomOutButtonJs);
                        this.m_metadataMap.put("x1actual", actualJs);
                        this.m_metadataMap.put("allactual", actualAllJs);
                    }
                }
                if (pfj.getY1RangeSlider() != null) {
                    dataZoomInButtonJs = writer.getDataZoomInButtonSubmitJS("Y1");
                    dataZoomOutButtonJs = writer.getDataZoomOutButtonSubmitJS("Y1");
                    actualJs = RangeSlider.getActualSizeJS(writer.getDataScrollbarZoomSubmitJS("Y1"));
                    ratio = pfj.getY1RangeSlider().getZoomRatio();
                    if (ratio < 16.0) {
                        this.m_metadataMap.put("y1in", dataZoomInButtonJs);
                    }
                    if (ratio > 1.0) {
                        this.m_metadataMap.put("y1out", dataZoomOutButtonJs);
                        this.m_metadataMap.put("y1actual", actualJs);
                        this.m_metadataMap.put("allactual", actualAllJs);
                    }
                }
                if (pfj.getY2RangeSlider() == null) break;
                dataZoomInButtonJs = writer.getDataZoomInButtonSubmitJS("Y2");
                dataZoomOutButtonJs = writer.getDataZoomOutButtonSubmitJS("Y2");
                actualJs = RangeSlider.getActualSizeJS(writer.getDataScrollbarZoomSubmitJS("Y2"));
                ratio = pfj.getY2RangeSlider().getZoomRatio();
                if (ratio < 16.0) {
                    this.m_metadataMap.put("y2in", dataZoomInButtonJs);
                }
                if (!(ratio > 1.0)) break;
                this.m_metadataMap.put("y2out", dataZoomOutButtonJs);
                this.m_metadataMap.put("y2actual", actualJs);
                this.m_metadataMap.put("allactual", actualAllJs);
                break;
            }
        }
        if (dataScrollJs != null) {
            this.m_metadataMap.put("scrollJS", dataScrollJs);
        }
        if (dataZoomJs != null) {
            this.m_metadataMap.put("zoomJS", dataZoomJs);
        }
        if (axisLabel != null) {
            Font labelFont = axisLabel.getFont();
            Color labelColor = axisLabel.getGraphFont().getGraphFontColor();
            String font = GraphExportXMLWriter.getFontAttributes(labelFont, labelColor, false, pfj.getErrorHandler());
            this.m_metadataMap.put("f", font);
        }
        writer.writeMetadataElement(this.m_elementName, this.m_metadataMap);
    }

    public static class EndHandle
    extends DetMetadata {
        private static final long serialVersionUID = 1L;

        public EndHandle(Detectiv detectiv, String handleId) {
            super(detectiv);
            this.m_metadataMap.put("id", handleId);
        }

        @Override
        public void renderItToXML(Map context) throws IOException, Exception {
            GraphExportXMLWriter writer = (GraphExportXMLWriter)context.get("xmlWriter");
            writer.endElement();
        }
    }

    public static class StartHandle
    extends DetMetadata {
        private static final long serialVersionUID = 1L;

        public StartHandle(Detectiv detectiv, String handleId) {
            super(detectiv);
            this.m_metadataMap.put("id", handleId);
        }

        @Override
        public void renderItToXML(Map context) throws IOException, Exception {
            GraphExportXMLWriter writer = (GraphExportXMLWriter)context.get("xmlWriter");
            writer.startHandleElement(this.m_metadataMap);
        }
    }
}

