/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.png;

import oracle.dss.graph.pfj.png.PNGChunk;
import oracle.dss.graph.pfj.png.PNGInfo;

class PNGTextChunk
extends PNGChunk {
    private static final String keyWord = "TDG_INFO";

    PNGTextChunk() {
    }

    @Override
    int getDataLength() {
        PNGInfo info = this.getPNGInfo();
        String text = info.getImageText();
        int len = keyWord.length() + 1;
        if (text != null) {
            len += text.length();
        }
        return len;
    }

    @Override
    String getChunkType() {
        return "tEXt";
    }

    @Override
    byte[] getData() {
        PNGInfo info = this.getPNGInfo();
        String text = info.getImageText();
        if (text == null) {
            text = "";
        }
        byte[] keyWord_ascii = this.toAsciiArray(keyWord);
        int keyWordLen = keyWord_ascii.length;
        byte[] text_ascii = this.toAsciiArray(text);
        int textLen = text_ascii.length;
        byte[] data = new byte[keyWordLen + textLen + 1];
        System.arraycopy(keyWord_ascii, 0, data, 0, keyWordLen);
        data[keyWordLen] = 0;
        System.arraycopy(text_ascii, 0, data, keyWordLen + 1, textLen);
        return data;
    }

    @Override
    boolean isCriticalChunk() {
        return false;
    }
}

