/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.dTree;

import java.awt.AWTEvent;
import java.awt.Adjustable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import oracle.bali.ewt.dTree.DTreeActivateListener;
import oracle.bali.ewt.dTree.DTreeDecoration;
import oracle.bali.ewt.dTree.DTreeEditListener;
import oracle.bali.ewt.dTree.DTreeEmptyDecoration;
import oracle.bali.ewt.dTree.DTreeEvent;
import oracle.bali.ewt.dTree.DTreeExpandedEnumeration;
import oracle.bali.ewt.dTree.DTreeExpansionListener;
import oracle.bali.ewt.dTree.DTreeItem;
import oracle.bali.ewt.dTree.DTreeItemEvent;
import oracle.bali.ewt.dTree.DTreeItemValidateEvent;
import oracle.bali.ewt.dTree.DTreeRange;
import oracle.bali.ewt.dTree.DTreeRootItem;
import oracle.bali.ewt.dTree.DTreeSelection;
import oracle.bali.ewt.dTree.DTreeSelectionManager;
import oracle.bali.ewt.dTree.DTreeSingleSelectionManager;
import oracle.bali.ewt.dTree.DTreeToolTipManager;
import oracle.bali.ewt.elaf.EWTTreeUI;
import oracle.bali.ewt.event.Cancelable;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.scrolling.ScrollableComponent;
import oracle.bali.ewt.text.MultiLineToolTip;
import oracle.bali.ewt.util.ImmInsets;
import oracle.bali.share.event.ListenerManager;

public class DTree
extends ScrollableComponent
implements Accessible {
    public static final String PROPERTY_SELECTION = "selection";
    public static final int DROP_STYLE_NONE = 0;
    public static final int DROP_STYLE_INTO = 1;
    public static final int DROP_STYLE_BEFORE = 2;
    public static final int DROP_STYLE_AFTER = 3;
    private DTreeItem _makeVisibleItem;
    private DTreeItem _makeChildrenVisibleItem;
    private MakeVisibleRunnable _makeVisibleRunnable;
    private MakeChildVisibleRunnable _makeChildVisibleRunnable;
    private DTreeRootItem _root;
    private DTreeItem _focused;
    private int _indentwd;
    private int _rowheight;
    private int _nositems;
    private int _noslevels;
    private int _layoutFrozenLevel;
    private DTreeSelectionManager _selManager = new DTreeSingleSelectionManager();
    private DTreeDecoration _decoration;
    private ListenerManager _activatelm;
    private ListenerManager _editlm;
    private ListenerManager _expandlm;
    private Adjustable _hAdjustable;
    private Adjustable _vAdjustable;
    private DTreeItem _mousePressItem;
    private DTreeItem _dropItem;
    private int _dropStyle;
    private boolean _editable;
    private DTreeItem _editItem;
    private Component _editor;
    private EditDismisser _editDismisser;
    private boolean _selectedAtPress;
    private ActionListener _keyboardListener;
    private DTreeToolTipManager _toolTipManager;
    private boolean _layoutValid;
    private Dimension _canvasSize;
    private SelectionListener _selListener;
    private Vector _selections;
    private static final int _DEFAULT_INDENTWIDTH = 18;
    private static final int _DEFAULT_ITEMS_ON_SCREEN = 20;
    private static final int _DEFAULT_LEVELS_ON_SCREEN = 5;
    private static final int _PREFERRED_WIDTH_ADJUSTMENT = 100;
    private static final int _MINIMUM_WIDTH_OF_EDITOR = 100;

    public static DTreeItem getCommonAncestor(DTreeItem item1, DTreeItem item2) {
        for (DTreeItem parent = item1; parent != null; parent = parent.getParent()) {
            if (!DTree.isItemDescendent(item2, parent)) continue;
            return parent;
        }
        return null;
    }

    public static boolean isItemBefore(DTreeItem beforeItem, DTreeItem afterItem) {
        DTreeItem root = DTree.getCommonAncestor(beforeItem, afterItem);
        if (root == beforeItem) {
            return true;
        }
        if (root == afterItem) {
            return false;
        }
        DTreeItem beforeparent = beforeItem;
        DTreeItem afterparent = afterItem;
        while (beforeparent.getParent() != root) {
            beforeparent = beforeparent.getParent();
        }
        while (afterparent.getParent() != root) {
            afterparent = afterparent.getParent();
        }
        return beforeparent.getIndex() < afterparent.getIndex();
    }

    public static boolean isItemDescendent(DTreeItem descendent, DTreeItem ancestor) {
        while (descendent != null) {
            if (descendent == ancestor) {
                return true;
            }
            descendent = descendent.getParent();
        }
        return false;
    }

    public static boolean isItemVisible(DTreeItem item) {
        DTreeItem parent = item.getParent();
        if (parent == null) {
            return item.getTree() != null;
        }
        return parent.isExpanded() && DTree.isItemVisible(parent);
    }

    public DTree() {
        this(null);
    }

    public DTree(DTreeRootItem root) {
        this._selManager.setTree(this);
        this._selListener = new SelectionListener();
        this._selManager.addPropertyChangeListener(this._selListener);
        this._selManager.addVetoableChangeListener(this._selListener);
        if (this._decoration == null) {
            this._decoration = DTreeEmptyDecoration.getInstance();
        }
        this._indentwd = 18;
        this._nositems = 20;
        this._noslevels = 5;
        this._canvasSize = new Dimension(0, 0);
        this.enableEvents(60L);
        this.updateUI();
        this._setRoot(root);
    }

    public final void addActivateListener(DTreeActivateListener listener) {
        if (this._activatelm == null) {
            this._activatelm = new ListenerManager();
        }
        this._activatelm.addListener((EventListener)listener);
    }

    public final void addEditListener(DTreeEditListener listener) {
        if (this._editlm == null) {
            this._editlm = new ListenerManager();
        }
        this._editlm.addListener((EventListener)listener);
    }

    public final void addExpansionListener(DTreeExpansionListener listener) {
        if (this._expandlm == null) {
            this._expandlm = new ListenerManager();
        }
        this._expandlm.addListener((EventListener)listener);
    }

    public void cancelEdit() {
        this._endEdit(false);
    }

    public boolean commitEdit() {
        return this._endEdit(true);
    }

    public void freezeLayouts() {
        ++this._layoutFrozenLevel;
    }

    public DTreeDecoration getDecoration() {
        return this._decoration;
    }

    public DTreeItem getDropHighlightItem() {
        return this._dropItem;
    }

    public int getDropHighlightStyle() {
        return this._dropStyle;
    }

    public Enumeration getExpandedEnumeration() {
        return new DTreeExpandedEnumeration(this);
    }

    public DTreeItem getFocusedItem() {
        this._focused = this._getFocusedItem(this._focused);
        return this._focused;
    }

    public int getIndentWidth() {
        return this._indentwd;
    }

    public DTreeItem getItemAt(int x, int y) {
        if (this._root == null) {
            return null;
        }
        return this._root.getItemAt(x, y);
    }

    public DTreeItem getDraggableItemAt(int x, int y) {
        DTreeItem target = this.getItemAt(x, y);
        if (target == null) {
            return null;
        }
        Point outerPos = this.convertCanvasToOuter(target.getX(), target.getY());
        Rectangle editBounds = target.getEditBounds();
        int leftbound = outerPos.x;
        int rightbound = outerPos.x + editBounds.x + editBounds.width;
        if (leftbound < x && x < rightbound) {
            return target;
        }
        return null;
    }

    public int getPreferredItemsOnScreen() {
        return this._nositems;
    }

    public int getPreferredLevelsOnScreen() {
        return this._noslevels;
    }

    public DTreeItem getPreviousVisibleItem(DTreeItem item) {
        DTreeItem prev = null;
        DTreeItem parent = item.getParent();
        int index = item.getIndex();
        if (index > 0) {
            prev = parent.getItem(index - 1);
        }
        if (prev == null) {
            prev = parent;
        } else if (prev.isExpanded()) {
            prev = this._getLastVisibleItem(prev);
        }
        if (prev == this.getRoot()) {
            prev = null;
        }
        return prev;
    }

    public final DTreeItem getNextVisibleItem(DTreeItem item) {
        if (item.isExpanded() && item.getItemCount() > 0) {
            return item.getItem(0);
        }
        for (DTreeItem parent = item.getParent(); parent != null; parent = parent.getParent()) {
            int index = item.getIndex();
            if (index < parent.getItemCount() - 1) {
                return parent.getItem(index + 1);
            }
            item = parent;
        }
        return null;
    }

    public DTreeRootItem getRoot() {
        return this._root;
    }

    public final DTreeSelection getSelection() {
        return this.getSelectionManager().getSelection();
    }

    public DTreeSelectionManager getSelectionManager() {
        return this._selManager;
    }

    public boolean isEditable() {
        return this._editable;
    }

    public boolean isEditing() {
        return this._editItem != null;
    }

    public void itemsAdded(DTreeItem parent, int startIndex, int count) {
        if (!DTree.isItemVisible(parent) || !parent.isExpanded()) {
            return;
        }
        if (this.getFont() == null) {
            this._invalidateTreeLayout();
            return;
        }
        DTreeSelectionManager selManager = this.getSelectionManager();
        selManager.itemsAdded(parent, startIndex, count);
        if (this._selections != null) {
            Enumeration enumer = this._selections.elements();
            while (enumer.hasMoreElements()) {
                DTreeSelection selection = (DTreeSelection)enumer.nextElement();
                selection.__itemsAdded(parent, startIndex, count);
            }
        }
        this._layoutValid = false;
        if (this._layoutFrozenLevel > 0) {
            return;
        }
        Dimension canvassize = this.layoutCanvas();
        this.setCanvasSize(canvassize.width, canvassize.height);
        Point canvasorg = this.getCanvasOrigin();
        Dimension innersize = this.getInnerSize();
        DTreeItem startItem = parent.getItem(startIndex);
        if (startItem == null) {
            return;
        }
        int starty = startItem.getY();
        if (starty < -canvasorg.y) {
            this.repaint();
        } else if (starty < -canvasorg.y + innersize.height) {
            this.repaint();
        }
        this._fireVisibleDataPropertyChange();
    }

    public void itemsInvalidated(DTreeItem parent, int startIndex, int count) {
        if (!this._isTreeLayoutValid()) {
            this.repaint();
        } else {
            DTreeItem topitem = parent.getItem(startIndex);
            DTreeItem bottomitem = parent.getItem(startIndex + count - 1);
            Dimension innersize = this.getInnerSize();
            Point toppos = this._convertCanvasToInner(0, topitem.getY());
            Point bottompos = this._convertCanvasToInner(0, bottomitem.getY());
            bottompos.y += bottomitem.getSize().height;
            if (toppos.y < innersize.height && bottompos.y > 0) {
                this.repaint();
            }
        }
        this._fireVisibleDataPropertyChange();
    }

    public void itemsRemoved(DTreeItem parent, int startIndex, int count) {
        if (DTree.isItemVisible(parent) && parent.isExpanded()) {
            this._invalidateTreeLayout();
        }
        DTreeSelectionManager selManager = this.getSelectionManager();
        selManager.itemsRemoved(parent, startIndex, count);
        if (this._selections != null) {
            Enumeration enumer = this._selections.elements();
            while (enumer.hasMoreElements()) {
                DTreeSelection selection = (DTreeSelection)enumer.nextElement();
                selection.__itemsRemoved(parent, startIndex, count);
            }
        }
        this._fireVisibleDataPropertyChange();
    }

    public void makeVisible(DTreeItem item) {
        this._makeVisible(item, true);
    }

    public void removeActivateListener(DTreeActivateListener listener) {
        if (this._activatelm != null) {
            this._activatelm.removeListener((EventListener)listener);
        }
    }

    public void removeEditListener(DTreeEditListener listener) {
        if (this._editlm != null) {
            this._editlm.removeListener((EventListener)listener);
        }
    }

    public void removeExpansionListener(DTreeExpansionListener listener) {
        if (this._expandlm != null) {
            this._expandlm.removeListener((EventListener)listener);
        }
    }

    public void setDecoration(DTreeDecoration decoration) {
        DTreeDecoration oldDecoration = this.getDecoration();
        if (oldDecoration != decoration) {
            if (decoration == null) {
                decoration = DTreeEmptyDecoration.getInstance();
            }
            this._decoration = decoration;
            this._invalidateTreeLayout();
        }
    }

    public void setDropHighlightItem(DTreeItem dropItem) {
        DTreeItem oldDropItem = this.getDropHighlightItem();
        if (oldDropItem != dropItem) {
            this._dropItem = dropItem;
            if (oldDropItem != null) {
                this._paintItemImmediate(oldDropItem);
            }
            if (this._dropItem != null) {
                this._paintItemImmediate(this._dropItem);
                this.makeVisible(this._dropItem);
            }
        }
    }

    public void setDropHighlightStyle(int dropStyle) {
        int oldDropStyle = this.getDropHighlightStyle();
        if (oldDropStyle != dropStyle) {
            this._dropStyle = dropStyle;
            DTreeItem dropItem = this.getDropHighlightItem();
            if (dropItem != null) {
                this._paintItemImmediate(dropItem);
            }
        }
    }

    public void setEditable(boolean editable) {
        if (this._editable != editable) {
            this._editable = editable;
            this._registerF2(editable);
        }
    }

    public void setFocusedItem(DTreeItem focusedItem) {
        DTreeItem oldFocused = this.getFocusedItem();
        if (oldFocused != (focusedItem = this._getFocusedItem(focusedItem))) {
            this._focused = focusedItem;
            this._paintItemImmediate(oldFocused);
            this._paintItemImmediate(this._focused);
            this.makeVisible(this._focused);
            AccessibleContext context = this.accessibleContext;
            if (context != null) {
                context.firePropertyChange("AccessibleActiveDescendant", oldFocused, focusedItem);
            }
        }
    }

    public void setIndentWidth(int indentWidth) {
        if (indentWidth != this._indentwd) {
            this._indentwd = indentWidth;
            this._invalidateTreeLayout();
        }
    }

    public void setPreferredItemsOnScreen(int itemsOnScreen) {
        if (itemsOnScreen != this._nositems) {
            this._nositems = itemsOnScreen;
            this.invalidate();
        }
    }

    public void setPreferredLevelsOnScreen(int levelsOnScreen) {
        if (levelsOnScreen != this._noslevels) {
            this._noslevels = levelsOnScreen;
            this.invalidate();
        }
    }

    public final void setSelection(DTreeSelection selection) throws PropertyVetoException {
        this.getSelectionManager().setSelection(selection);
    }

    public void setSelectionManager(DTreeSelectionManager selectionManager) {
        if (this._selManager != selectionManager) {
            this._selManager.setTree(null);
            this._selManager.removePropertyChangeListener(this._selListener);
            this._selManager.removeVetoableChangeListener(this._selListener);
            this._selManager = selectionManager == null ? new DTreeSingleSelectionManager() : selectionManager;
            this._selManager.setTree(this);
            this._selManager.addPropertyChangeListener(this._selListener);
            this._selManager.addVetoableChangeListener(this._selListener);
            this.repaintInterior();
        }
    }

    public void setRoot(DTreeRootItem root) {
        this._setRoot(root);
    }

    public boolean startEdit(DTreeItem item) {
        if (!this.isEditable()) {
            return false;
        }
        this.cancelEdit();
        Component editor = item.startEdit();
        if (editor == null) {
            return false;
        }
        DTreeItemValidateEvent evt = new DTreeItemValidateEvent(this, 2007, item);
        this.processEvent(evt);
        if (evt.isCancelled()) {
            return false;
        }
        this._makeHorizontalVisible(item);
        this._editor = editor;
        this._editItem = item;
        this._editDismisser = new EditDismisser();
        editor.addKeyListener(this._editDismisser);
        editor.addFocusListener(this._editDismisser);
        editor.setVisible(true);
        this.add(editor);
        editor.setBounds(this._getEditBounds(item));
        editor.requestFocus();
        return true;
    }

    public void setToolTipManager(DTreeToolTipManager manager) {
        DTreeToolTipManager oldManager = this._toolTipManager;
        this._toolTipManager = manager;
        ToolTipManager ttm = ToolTipManager.sharedInstance();
        if (this._toolTipManager == null) {
            if (oldManager != null) {
                ttm.unregisterComponent(this);
            }
        } else if (oldManager == null) {
            ttm.registerComponent(this);
            this.unregisterKeyboardAction(KeyStroke.getKeyStroke(27, 0, false));
        }
    }

    public DTreeToolTipManager getToolTipManager() {
        return this._toolTipManager;
    }

    @Override
    public JToolTip createToolTip() {
        return new MultiLineToolTip();
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        if (this._toolTipManager == null) {
            return super.getToolTipText(event);
        }
        DTreeItem item = this.getItemAt(event.getX(), event.getY());
        if (item == null) {
            return null;
        }
        return this._toolTipManager.getToolTipValue(this, item);
    }

    public void unfreezeLayouts() {
        --this._layoutFrozenLevel;
        if (this._layoutFrozenLevel == 0) {
            this._invalidateTreeLayout();
        }
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleDTree();
        }
        return this.accessibleContext;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.convertInnerToOuterSize(this.getIndentWidth(), this._rowheight);
    }

    @Override
    public Rectangle getPageBounds(PaintContext context, Dictionary printProperties, int pageXOrigin, int pageYOrigin, int pageWidth, int pageHeight) {
        DTreeItem item = this.getItemAt(0, pageXOrigin + pageHeight);
        if (item != null) {
            pageHeight = item.getY() - pageXOrigin;
        }
        return new Rectangle(pageWidth, pageHeight, pageWidth, pageHeight);
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        this._validateTreeLayout();
        int prefwidth = this.getIndentWidth() * this.getPreferredLevelsOnScreen();
        int prefheight = this._rowheight * this.getPreferredItemsOnScreen();
        return this.convertInnerToOuterSize(prefwidth += 100, prefheight);
    }

    @Override
    public EWTTreeUI getUI() {
        return (EWTTreeUI)this.ui;
    }

    @Override
    public String getUIClassID() {
        return "EWTTreeUI";
    }

    @Override
    public boolean isFocusTraversable() {
        return true;
    }

    @Override
    public boolean isHScrollable() {
        return true;
    }

    @Override
    public boolean isVScrollable() {
        return true;
    }

    @Override
    public void setCanvasOrigin(int x, int y) {
        this.commitEdit();
        super.setCanvasOrigin(x, y);
    }

    @Override
    public void updateUI() {
        this.setUI((EWTTreeUI)UIManager.getUI(this));
        this.cancelEdit();
        this.updateEditorUI();
    }

    protected void updateEditorUI() {
        Component editor;
        DTreeItem item = this.getRoot();
        if (item != null && (item = item.getItem(0)) != null && (editor = item.startEdit()) != null && editor instanceof JComponent) {
            ((JComponent)editor).updateUI();
            ((JComponent)editor).setBorder(UIManager.getBorder("Tree.editorBorder"));
        }
    }

    @Override
    protected Object getPaintData(Object key) {
        if (key.equals("Tree.expandedIcon") || key.equals("Tree.collapsedIcon")) {
            return UIManager.get(key);
        }
        return super.getPaintData(key);
    }

    protected int getRowCount() {
        return this._getVisibleItemCount();
    }

    @Override
    protected int getVMaximum() {
        int vmax;
        Dimension canvassize = this.getCanvasSize();
        if (this._rowheight == 0) {
            vmax = 0;
        } else {
            vmax = canvassize.height / this._rowheight;
            if (canvassize.height % this._rowheight != 0) {
                ++vmax;
            }
        }
        return vmax;
    }

    @Override
    protected int getVOffsetOfValue(int value) {
        return -value * this._rowheight;
    }

    @Override
    protected int getVValueOfOffset(int y) {
        int value = 0;
        if (this._rowheight != 0) {
            value = -y / this._rowheight;
            if (-y % this._rowheight != 0) {
                ++value;
            }
        }
        return value;
    }

    @Override
    protected Dimension layoutCanvas() {
        if (this._root == null) {
            return new Dimension(0, 0);
        }
        if (this._isTreeLayoutValid()) {
            return new Dimension(this._canvasSize.width, this._canvasSize.height);
        }
        DTreeDecoration decoration = this.getDecoration();
        ImmInsets insets = decoration.getDecorationInsets(this);
        this._root.layout(insets.left, insets.top);
        int canvasht = this._root.getSubTreeHeight() + insets.top + insets.bottom;
        int rowCount = this.getRowCount();
        this._rowheight = rowCount == 0 ? 0 : canvasht / rowCount;
        this._canvasSize = new Dimension(this._root.getSubTreeWidth() + insets.left + insets.right, canvasht);
        this._layoutValid = true;
        return new Dimension(this._canvasSize.width, this._canvasSize.height);
    }

    @Override
    protected void paintCanvasInterior(Graphics g) {
        Rectangle drawRect = g.getClipBounds();
        DTreeItem item = this.getItemAt(0, drawRect.y);
        if (item == null) {
            return;
        }
        DTreeSelectionManager selManager = this.getSelectionManager();
        DTreeItem focused = this.getFocusedItem();
        DTreeItem dropItem = this.getDropHighlightItem();
        int dropStyle = this.getDropHighlightStyle();
        DTreeDecoration decoration = this.getDecoration();
        Dimension canvassize = this.getCanvasSize();
        int maxwidth = canvassize.width;
        ImmInsets decorationInsets = decoration.getDecorationInsets(this);
        PaintContext context = this.getPaintContext();
        this._repairDecoration(context, g, item.getParent(), decoration);
        while (item != null) {
            int itemx = item.getX();
            int itemy = item.getY();
            if (itemy > drawRect.y + drawRect.height) break;
            Dimension itemSize = item.getSize();
            if (itemy + itemSize.height > drawRect.y) {
                g.translate(0, itemy);
                decoration.paintDecoration(context, g, item, itemx, itemSize.height);
                g.translate(itemx, 0);
                boolean selected = this._editItem != item && selManager.isSelected(item) || item == dropItem && dropStyle == 1;
                this.paintItem(g, item, selected, item == focused, itemSize.width, itemSize.height);
                g.translate(-itemx, -itemy);
            }
            if (itemx + itemSize.width + decorationInsets.right > maxwidth) {
                maxwidth = itemx + itemSize.width + decorationInsets.right;
            }
            item = this.getNextVisibleItem(item);
        }
        if (maxwidth > canvassize.width) {
            this.setCanvasSize(maxwidth, canvassize.height);
            this._invalidateTreeLayout();
        } else if (this._makeVisibleItem != null) {
            MakeVisibleRunnable runnable = this._getMakeVisibleRunnable();
            runnable.setToBeVisibleItem(this._makeVisibleItem);
            this._makeVisibleItem = null;
            SwingUtilities.invokeLater(runnable);
        } else if (this._makeChildrenVisibleItem != null) {
            MakeChildVisibleRunnable runnable = this._getMakeChildVisibleRunnable();
            runnable.setToBeVisibleItem(this._makeChildrenVisibleItem);
            this._makeChildrenVisibleItem = null;
            SwingUtilities.invokeLater(runnable);
        }
    }

    protected void paintItem(Graphics g, DTreeItem item, boolean isSelected, boolean isFocused, int itemWidth, int itemHeight) {
        item.paint(g, isSelected, this.hasFocus() && isFocused, itemWidth, itemHeight);
    }

    protected void processActivateEvent(DTreeItemEvent evt) {
        Enumeration listeners;
        if (this._activatelm == null || (listeners = this._activatelm.getListeners()) == null) {
            return;
        }
        if (evt.getID() == 2004) {
            while (listeners.hasMoreElements()) {
                DTreeActivateListener l = (DTreeActivateListener)listeners.nextElement();
                l.dTreeItemActivate(evt);
            }
        }
    }

    @Override
    protected void processEventImpl(AWTEvent evt) {
        if (evt instanceof DTreeEvent) {
            switch (evt.getID()) {
                case 2000: 
                case 2001: 
                case 2002: 
                case 2003: {
                    this.processExpansionEvent((DTreeItemEvent)evt);
                    break;
                }
                case 2004: {
                    this.processActivateEvent((DTreeItemEvent)evt);
                    break;
                }
                case 2007: 
                case 2008: 
                case 2009: {
                    this.processEditEvent((DTreeItemEvent)evt);
                    break;
                }
            }
        }
        super.processEventImpl(evt);
    }

    protected void processEditEvent(DTreeItemEvent evt) {
        Enumeration listeners;
        if (this._editlm == null || (listeners = this._editlm.getListeners()) == null) {
            return;
        }
        int evtid = evt.getID();
        while (listeners.hasMoreElements()) {
            DTreeEditListener l = (DTreeEditListener)listeners.nextElement();
            switch (evtid) {
                case 2007: {
                    l.dTreeItemEditing(evt);
                    break;
                }
                case 2008: {
                    l.dTreeItemEdited(evt);
                    break;
                }
                case 2009: {
                    l.dTreeItemEditCancelled(evt);
                }
            }
        }
    }

    protected void processExpansionEvent(DTreeItemEvent evt) {
        Enumeration listeners;
        int evtid = evt.getID();
        if (this._expandlm != null && (listeners = this._expandlm.getListeners()) != null) {
            while (listeners.hasMoreElements()) {
                DTreeExpansionListener l = (DTreeExpansionListener)listeners.nextElement();
                switch (evtid) {
                    case 2000: {
                        l.dTreeItemExpanding(evt);
                        break;
                    }
                    case 2001: {
                        l.dTreeItemExpanded(evt);
                        break;
                    }
                    case 2002: {
                        l.dTreeItemCollapsing(evt);
                        break;
                    }
                    case 2003: {
                        l.dTreeItemCollapsed(evt);
                    }
                }
            }
        }
        DTreeItem item = evt.getItem();
        switch (evtid) {
            case 2002: {
                if (((Cancelable)((Object)evt)).isCancelled()) break;
                DTreeSelectionManager selManager = this.getSelectionManager();
                selManager.itemCollapsing(evt);
                break;
            }
            case 2003: {
                this._invalidateTreeLayout();
                DTreeItem focused = this.getFocusedItem();
                if (!DTree.isItemDescendent(focused, item)) break;
                this.setFocusedItem(item);
                break;
            }
            case 2001: {
                this._invalidateTreeLayout();
                if (this._layoutFrozenLevel != 0) break;
                this.invalidate();
                this.repaint();
                this._makeChildrenVisible(item);
            }
        }
    }

    @Override
    protected void processFocusEvent(FocusEvent e) {
        AccessibleContext ac;
        super.processFocusEvent(e);
        int id = e.getID();
        if (id == 1004 || id == 1005) {
            this.repaint();
        }
        if ((ac = this.accessibleContext) != null && id == 1004) {
            ac.firePropertyChange("AccessibleActiveDescendant", null, this.getFocusedItem());
        }
    }

    @Override
    protected void processComponentKeyEvent(KeyEvent evt) {
        super.processComponentKeyEvent(evt);
        if (evt.isConsumed()) {
            return;
        }
        DTreeItem focused = this.getFocusedItem();
        boolean wasexpanded = false;
        if (focused != null) {
            wasexpanded = focused.isExpanded();
            focused.processKeyEvent(evt);
            if (evt.isConsumed()) {
                return;
            }
        }
        if (evt.getID() == 401 && !evt.isAltDown()) {
            this._handleKeyboardAction(evt, focused, wasexpanded);
        }
    }

    @Override
    protected void processMouseEvent(MouseEvent evt) {
        super.processMouseEvent(evt);
        if (evt.isConsumed() || !this.isEnabled()) {
            return;
        }
        int evtID = evt.getID();
        if (evtID == 501) {
            this.requestFocus();
            Point canvascoords = this.convertOuterToCanvas(evt.getX(), evt.getY());
            DTreeItem item = this.getItemAt(canvascoords.x, canvascoords.y);
            if (item != null) {
                this._mousePressItem = item;
                DTreeSelectionManager selManager = this.getSelectionManager();
                this._selectedAtPress = selManager.isSelected(item);
                ImmInsets insets = this.getBorderInsets();
                int itemx = item.getX();
                int itemy = item.getY();
                evt.translatePoint(-insets.left, -insets.top - itemy);
                DTreeDecoration decoration = this.getDecoration();
                decoration.processMouseEvent(evt, item);
                if (evt.isConsumed()) {
                    return;
                }
                Point canvasorg = this.getCanvasOrigin();
                evt.translatePoint(-canvasorg.x - itemx, -canvasorg.y);
                item.processMouseEvent(evt);
                evt.translatePoint(canvasorg.x + insets.left + itemx, canvasorg.y + insets.top + itemy);
                if (evt.isConsumed()) {
                    return;
                }
            }
            if (item == null || !this._selectedAtPress) {
                this._handleMouseSelection(evt, item, canvascoords);
            }
        } else if (evtID == 502) {
            if (this._mousePressItem != null) {
                if (this._mousePressItem.getTree() == this) {
                    this._dispatchItemMouseEvent(evt, this._mousePressItem);
                }
                this._mousePressItem = null;
            }
        } else if (evtID == 500) {
            Point canvascoords = this.convertOuterToCanvas(evt.getX(), evt.getY());
            DTreeItem item = this.getItemAt(canvascoords.x, canvascoords.y);
            if (item != null) {
                this._dispatchItemMouseEvent(evt, item);
                if (evt.isConsumed()) {
                    return;
                }
                if (this._selectedAtPress && evt.getClickCount() == 1) {
                    this._handleMouseSelection(evt, item, canvascoords);
                }
                this._handleMouseEdit(evt, item);
            }
        }
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent evt) {
        super.processMouseMotionEvent(evt);
        if (evt.isConsumed() || !this.isEnabled()) {
            return;
        }
        if (evt.getID() == 503) {
            Point canvascoords = this.convertOuterToCanvas(evt.getX(), evt.getY());
            DTreeItem item = this.getItemAt(canvascoords.x, canvascoords.y);
            if (item != null) {
                this._dispatchItemMouseEvent(evt, item);
            }
        } else if (evt.getID() == 506 && this._mousePressItem != null) {
            if (this._mousePressItem.getTree() != this) {
                this._mousePressItem = null;
            } else {
                this._dispatchItemMouseEvent(evt, this._mousePressItem);
            }
        }
    }

    @Override
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    protected void fireVetoableChange(String propertyName, Object oldValue, Object newValue) throws PropertyVetoException {
        super.fireVetoableChange(propertyName, oldValue, newValue);
    }

    void __fireAccessibleEvent(String type, Object oldValue, Object newValue) {
        AccessibleContext ac = this.accessibleContext;
        if (ac == null) {
            return;
        }
        if ("AccessibleChild".equals(type)) {
            if (oldValue instanceof Accessible) {
                oldValue = ((Accessible)oldValue).getAccessibleContext();
            }
            if (newValue instanceof Accessible) {
                newValue = ((Accessible)newValue).getAccessibleContext();
            }
        }
        ac.firePropertyChange(type, oldValue, newValue);
    }

    void __addSelection(DTreeSelection selection) {
        if (this._selections == null) {
            this._selections = new Vector(1, 1);
        }
        this._selections.addElement(selection);
    }

    void __removeSelection(DTreeSelection selection) {
        this._selections.removeElement(selection);
    }

    private Point _convertCanvasToInner(int x, int y) {
        Point canvasorg = this.getCanvasOrigin();
        canvasorg.x += x;
        canvasorg.y += y;
        return canvasorg;
    }

    private void _dispatchItemMouseEvent(MouseEvent evt, DTreeItem item) {
        ImmInsets insets = this.getBorderInsets();
        int itemx = item.getX();
        int itemy = item.getY();
        Point canvasorg = this.getCanvasOrigin();
        evt.translatePoint(-canvasorg.x - insets.left - itemx, -canvasorg.y - insets.top - itemy);
        item.processMouseEvent(evt);
        evt.translatePoint(canvasorg.x + insets.left + itemx, canvasorg.y + insets.top + itemy);
    }

    private boolean _endEdit(boolean doCommit) {
        if (!this.isEditing()) {
            return false;
        }
        this._editor.removeKeyListener(this._editDismisser);
        this._editor.removeFocusListener(this._editDismisser);
        this.remove(this._editor);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DTree.this.requestFocus();
            }
        });
        int evtID = 2009;
        if (doCommit && this._editItem.commitEdit(this._editor)) {
            evtID = 2008;
        }
        DTreeItem editItem = this._editItem;
        this._editItem = null;
        this._editor = null;
        this._editDismisser = null;
        this.processEvent(new DTreeItemEvent(this, evtID, editItem));
        return evtID == 2008;
    }

    private void _fireVisibleDataPropertyChange() {
        AccessibleDTree accessibleDTree = (AccessibleDTree)this.accessibleContext;
        if (accessibleDTree != null) {
            accessibleDTree.fireVisibleDataPropertyChange();
        }
    }

    private Rectangle _getEditBounds(DTreeItem item) {
        Point outerPos = this.convertCanvasToOuter(item.getX(), item.getY());
        Rectangle editBounds = item.getEditBounds();
        int width = editBounds.width;
        int canvasWidthLeft = this.getCanvasSize().width - item.getX();
        if (width >= canvasWidthLeft) {
            width -= editBounds.x;
        }
        int x = outerPos.x + editBounds.x;
        width = Math.max(width, 100);
        width = Math.min(width, canvasWidthLeft - editBounds.x);
        return new Rectangle(x, outerPos.y + editBounds.y, width, editBounds.height);
    }

    private Rectangle _getEditableBounds(DTreeItem item) {
        Point outerPos = this.convertCanvasToOuter(item.getX(), item.getY());
        Rectangle editBounds = item.getEditBounds();
        int width = editBounds.width;
        int x = outerPos.x + editBounds.x;
        return new Rectangle(x, outerPos.y + editBounds.y, width, editBounds.height);
    }

    private DTreeItem _getFirstVisibleItem() {
        int itemcount;
        DTreeRootItem root = this.getRoot();
        if (root != null && (itemcount = root.getItemCount()) > 0) {
            return root.getItem(0);
        }
        return null;
    }

    private DTreeItem _getFocusedItem(DTreeItem focusedItem) {
        if (focusedItem == null || focusedItem.getParent() == null || focusedItem.getTree() == null) {
            DTreeRootItem rootItem = this.getRoot();
            focusedItem = rootItem == null || rootItem.getItemCount() <= 0 ? null : rootItem.getItem(0);
        }
        return focusedItem;
    }

    private DTreeItem _getLastVisibleItem() {
        return this._getLastVisibleItem(null);
    }

    private DTreeItem _getLastVisibleItem(DTreeItem item) {
        DTreeItem last = item;
        if (last == null) {
            last = this.getRoot();
        }
        while (last != null && last.isExpanded()) {
            int itemcount = last.getItemCount();
            DTreeItem tmp = null;
            if (itemcount <= 0 || (tmp = last.getItem(itemcount - 1)) == null) break;
            last = tmp;
        }
        if (last == this.getRoot()) {
            return null;
        }
        return last;
    }

    private int _getRowsPerPage() {
        if (this._rowheight == 0) {
            return 0;
        }
        return this.getInnerSize().height / this._rowheight;
    }

    private int _getVisibleItemCount() {
        int itemcount = 0;
        Enumeration expandedItems = this.getExpandedEnumeration();
        while (expandedItems.hasMoreElements()) {
            DTreeItem item = (DTreeItem)expandedItems.nextElement();
            itemcount += item.getItemCount();
        }
        return itemcount;
    }

    private void _handleMouseEdit(MouseEvent evt, DTreeItem item) {
        if (evt.getID() == 500 && evt.getClickCount() == 1) {
            Rectangle editBounds = this._getEditableBounds(item);
            DTreeSelectionManager selManager = this.getSelectionManager();
            if (this._selectedAtPress && selManager.isSelected(item) && editBounds.contains(evt.getX(), evt.getY())) {
                this.startEdit(item);
            }
        }
    }

    private void _handleKeyboardAction(KeyEvent evt, DTreeItem item, boolean expanded) {
        if (item == null) {
            if (this.getRoot() == null) {
                return;
            }
            item = this.getRoot();
        }
        int keycode = evt.getKeyCode();
        DTreeItem newfocus = null;
        switch (keycode) {
            case 32: {
                newfocus = this._handleSpace(evt, item);
                break;
            }
            case 38: {
                newfocus = this.getPreviousVisibleItem(item);
                break;
            }
            case 40: {
                newfocus = this.getNextVisibleItem(item);
                break;
            }
            case 36: {
                newfocus = this._getFirstVisibleItem();
                break;
            }
            case 35: {
                newfocus = this._getLastVisibleItem();
                break;
            }
            case 33: {
                newfocus = this._handlePageUp(item);
                break;
            }
            case 34: {
                newfocus = this._handlePageDown(item);
                break;
            }
            case 37: {
                newfocus = this._handleLeft(item);
                break;
            }
            case 39: {
                newfocus = this._handleRight(item);
            }
        }
        if (newfocus != null) {
            if (!evt.isControlDown() || evt.isShiftDown() || keycode == 32) {
                this._updateSelection(evt, newfocus);
            }
            this.setFocusedItem(newfocus);
            evt.consume();
        }
    }

    private void _handleKeyboardEdit(DTreeItem item) {
        if (item != null && item != this.getRoot()) {
            this.startEdit(item);
        }
    }

    private DTreeItem _handleLeft(DTreeItem item) {
        DTreeItem newFocus = null;
        if (!(item == null || item.isExpandable() && item.isExpanded() || (newFocus = item.getParent()) != this.getRoot())) {
            newFocus = null;
        }
        return newFocus;
    }

    private void _handleMouseSelection(MouseEvent evt, DTreeItem item, Point canvaspos) {
        if (item != null) {
            if (item.getTree() == null) {
                item = null;
            } else {
                int itemx = item.getX();
                int itemwd = item.getSize().width;
                if (canvaspos.x < itemx || canvaspos.x >= itemx + itemwd) {
                    item = null;
                }
            }
        }
        if (item != null) {
            this._updateSelection(evt, item);
        }
    }

    private DTreeItem _handlePageDown(DTreeItem item) {
        DTreeItem newfocus = item;
        for (int numrows = this._getRowsPerPage() - 1; numrows > 0 && newfocus != null; --numrows) {
            newfocus = this.getNextVisibleItem(newfocus);
        }
        if (newfocus == null) {
            newfocus = this._getLastVisibleItem();
        }
        if (newfocus == this.getRoot()) {
            newfocus = null;
        }
        return newfocus;
    }

    private DTreeItem _handlePageUp(DTreeItem item) {
        DTreeItem newfocus = item;
        for (int numrows = this._getRowsPerPage() - 1; numrows > 0 && newfocus != null; --numrows) {
            newfocus = this.getPreviousVisibleItem(newfocus);
        }
        if (newfocus == null) {
            newfocus = this._getFirstVisibleItem();
        }
        if (newfocus == this.getRoot()) {
            newfocus = null;
        }
        return newfocus;
    }

    private DTreeItem _handleRight(DTreeItem item) {
        int itemcount;
        if (item != null && item.isExpandable() && item.isExpanded() && (itemcount = item.getItemCount()) > 0) {
            return item.getItem(0);
        }
        return null;
    }

    private DTreeItem _handleSpace(KeyEvent evt, DTreeItem item) {
        if (evt.isShiftDown() || evt.isControlDown()) {
            return item;
        }
        DTreeSelectionManager selManager = this.getSelectionManager();
        if (!selManager.isSelected(item) && item.getParent() != null) {
            try {
                selManager.toggleItem(item);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
        return null;
    }

    private void _makeChildrenVisible(DTreeItem item) {
        this._makeChildrenVisible(item, true);
    }

    private void _makeChildrenVisible(DTreeItem item, boolean storeVisibleItem) {
        DTreeItem last = this._getLastVisibleItem(item);
        if (last == null) {
            this.makeVisible(item);
            return;
        }
        this._validateTreeLayout();
        Point canvasorg = this.getCanvasOrigin();
        int newcanvasy = canvasorg.y;
        Rectangle innerrect = this.getInnerBounds();
        int itemy = item.getY();
        int lasty = last.getY();
        int lastht = last.getSize().height;
        Point innerpos = this._convertCanvasToInner(0, lasty);
        if (innerpos.y < 0) {
            newcanvasy = -lasty;
        } else if (innerpos.y + lastht > innerrect.height) {
            newcanvasy = innerrect.height - (lasty + lastht);
        }
        if (itemy < -newcanvasy) {
            newcanvasy = -itemy;
        }
        if (newcanvasy != canvasorg.y) {
            if (storeVisibleItem) {
                this._makeChildrenVisibleItem = item;
            }
            this.setCanvasOrigin(canvasorg.x, newcanvasy);
        }
    }

    private void _makeHorizontalVisible(DTreeItem item) {
        this.makeVisible(item);
        Point canvasorg = this.getCanvasOrigin();
        Rectangle innerrect = this.getInnerBounds();
        int itemx = item.getX();
        Point innerpos = this._convertCanvasToInner(itemx, 0);
        int itemwd = item.getSize().width;
        int newcanvasx = canvasorg.x;
        if (innerpos.x < 0) {
            newcanvasx = -itemx;
        } else if (innerpos.x + itemwd > innerrect.width && itemx + (newcanvasx = innerrect.width - (itemx + itemwd)) < 0) {
            newcanvasx = -itemx;
        }
        if (canvasorg.x != newcanvasx) {
            this.setCanvasOrigin(newcanvasx, canvasorg.y);
        }
    }

    private void _paintItemImmediate(DTreeItem item) {
        if (item == null || item.getTree() != this || !DTree.isItemVisible(item)) {
            return;
        }
        this._validateTreeLayout();
        int itemX = item.getX();
        int itemY = item.getY();
        Point outerpos = this.convertCanvasToOuter(itemX, itemY);
        Dimension itemSize = item.getSize();
        this.repaint(outerpos.x, outerpos.y, itemSize.width, itemSize.height);
    }

    private void _repairDecoration(PaintContext context, Graphics g, DTreeItem item, DTreeDecoration decoration) {
        DTreeRootItem root = this.getRoot();
        while (item != root) {
            int itemy = item.getY();
            g.translate(0, itemy);
            decoration.paintDecoration(context, g, item, item.getX(), item.getSize().height);
            g.translate(0, -itemy);
            item = item.getParent();
        }
    }

    private void _setRoot(DTreeRootItem root) {
        if (this._root != root) {
            try {
                this.setSelection(null);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            AccessibleContext ac = this.accessibleContext;
            if (this._root != null) {
                this._root.setTree(null);
                if (ac != null) {
                    ac.firePropertyChange("AccessibleChild", this._root.getAccessibleContext(), null);
                }
                this._root = null;
            }
            if (root != null) {
                this._root = root;
                this._root.setTree(this);
                this._root.setExpanded(true);
                if (ac != null) {
                    ac.firePropertyChange("AccessibleChild", null, this._root.getAccessibleContext());
                }
            }
            this._invalidateTreeLayout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _updateSelection(InputEvent evt, DTreeItem item) {
        DTreeSelectionManager selManager = this.getSelectionManager();
        this.freezeRepaints();
        try {
            if (evt.isShiftDown()) {
                selManager.extendSelection(item);
            } else if (evt.isControlDown()) {
                selManager.toggleItem(item);
            } else {
                selManager.selectItem(item);
            }
        }
        catch (PropertyVetoException propertyVetoException) {
        }
        finally {
            this.unfreezeRepaints();
        }
    }

    private void _invalidateTreeLayout() {
        this._layoutValid = false;
        this.invalidateCanvas();
    }

    private boolean _isTreeLayoutValid() {
        return this._layoutValid;
    }

    private void _validateTreeLayout() {
        if (!this._layoutValid) {
            Dimension canvassize = this.layoutCanvas();
            this.setCanvasSize(canvassize.width, canvassize.height);
            this._layoutValid = true;
        }
    }

    void __paintSelectionChanges(DTreeSelection oldSelection, DTreeSelection newSelection) {
        DTreeItem oldItem = this._getSingleSelectedItem(oldSelection);
        DTreeItem newItem = this._getSingleSelectedItem(newSelection);
        if (oldItem != null && newItem != null) {
            this._paintItemImmediate(oldItem);
            this._paintItemImmediate(newItem);
        } else {
            this.repaint();
        }
    }

    private DTreeItem _getSingleSelectedItem(DTreeSelection selection) {
        if (selection.getCount() != 1) {
            return null;
        }
        DTreeRange range = selection.getRange(0);
        if (range.getCount() != 1) {
            return null;
        }
        DTreeItem parent = range.getParent();
        return parent.getItem(range.getStartIndex());
    }

    private void _registerF2(boolean enabled) {
        KeyStroke s = KeyStroke.getKeyStroke(113, 0);
        if (enabled) {
            if (this._keyboardListener == null) {
                this._keyboardListener = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        DTreeItem item = DTree.this.getFocusedItem();
                        if (item != null) {
                            DTree.this._handleKeyboardEdit(item);
                        }
                    }
                };
            }
            this.registerKeyboardAction(this._keyboardListener, "", s, 0);
        } else if (this._keyboardListener != null) {
            this.unregisterKeyboardAction(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _makeVisible(DTreeItem item, boolean storeVisibleItem) {
        if (item == null) {
            return;
        }
        if (!DTree.isItemVisible(item)) {
            try {
                this.freezeLayouts();
                for (DTreeItem parent = item.getParent(); parent != null; parent = parent.getParent()) {
                    if (parent.isExpanded()) continue;
                    parent.setExpanded(true);
                }
            }
            finally {
                this.unfreezeLayouts();
            }
        }
        this._validateTreeLayout();
        Point canvasorg = this.getCanvasOrigin();
        Rectangle innerrect = this.getInnerBounds();
        int itemy = item.getY();
        Point innerpos = this._convertCanvasToInner(0, itemy);
        int itemht = item.getSize().height;
        int newcanvasy = canvasorg.y;
        if (innerpos.y < 0) {
            newcanvasy = -itemy;
        } else if (innerpos.y + itemht > innerrect.height) {
            newcanvasy = innerrect.height - (itemy + itemht);
        }
        if (canvasorg.y != newcanvasy) {
            if (storeVisibleItem) {
                this._makeVisibleItem = item;
            }
            this.setCanvasOrigin(canvasorg.x, newcanvasy);
        }
    }

    private MakeVisibleRunnable _getMakeVisibleRunnable() {
        if (this._makeVisibleRunnable == null) {
            this._makeVisibleRunnable = new MakeVisibleRunnable();
        }
        return this._makeVisibleRunnable;
    }

    private MakeChildVisibleRunnable _getMakeChildVisibleRunnable() {
        if (this._makeChildVisibleRunnable == null) {
            this._makeChildVisibleRunnable = new MakeChildVisibleRunnable();
        }
        return this._makeChildVisibleRunnable;
    }

    private class MakeChildVisibleRunnable
    implements Runnable {
        private DTreeItem _toBeVisibleItem;

        private MakeChildVisibleRunnable() {
        }

        @Override
        public void run() {
            DTree.this._makeChildrenVisible(this._toBeVisibleItem, false);
        }

        public void setToBeVisibleItem(DTreeItem item) {
            this._toBeVisibleItem = item;
        }
    }

    private class MakeVisibleRunnable
    implements Runnable {
        private DTreeItem _toBeVisibleItem;

        private MakeVisibleRunnable() {
        }

        @Override
        public void run() {
            DTree.this._makeVisible(this._toBeVisibleItem, false);
        }

        public void setToBeVisibleItem(DTreeItem item) {
            this._toBeVisibleItem = item;
        }
    }

    private class SelectionListener
    implements PropertyChangeListener,
    VetoableChangeListener {
        private SelectionListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName() == DTree.PROPERTY_SELECTION) {
                DTreeSelection oldSelection = (DTreeSelection)evt.getOldValue();
                DTreeSelection newSelection = (DTreeSelection)evt.getNewValue();
                DTree.this.__paintSelectionChanges(oldSelection, newSelection);
                DTree.this.firePropertyChange(DTree.PROPERTY_SELECTION, oldSelection, newSelection);
            }
        }

        @Override
        public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
            if (evt.getPropertyName() == DTree.PROPERTY_SELECTION) {
                DTree.this.fireVetoableChange(DTree.PROPERTY_SELECTION, evt.getOldValue(), evt.getNewValue());
            }
        }
    }

    private class EditDismisser
    extends KeyAdapter
    implements FocusListener {
        private EditDismisser() {
        }

        @Override
        public void keyReleased(KeyEvent evt) {
            int keyCode = evt.getKeyCode();
            if (keyCode == 10) {
                DTree.this.commitEdit();
                evt.consume();
            } else if (keyCode == 27) {
                DTree.this.cancelEdit();
                evt.consume();
            }
        }

        @Override
        public void focusLost(FocusEvent evt) {
            DTree.this.commitEdit();
        }

        @Override
        public void focusGained(FocusEvent evt) {
        }
    }

    protected class AccessibleDTree
    extends JComponent.AccessibleJComponent
    implements PropertyChangeListener,
    DTreeExpansionListener {
        public AccessibleDTree() {
            super(DTree.this);
            DTree.this.addPropertyChangeListener(this);
            DTree.this.addExpansionListener(this);
        }

        @Override
        public int getAccessibleChildrenCount() {
            return DTree.this.getRoot() == null ? 0 : 1;
        }

        @Override
        public Accessible getAccessibleChild(int index) {
            if (index == 0) {
                return DTree.this.getRoot();
            }
            return null;
        }

        @Override
        public Accessible getAccessibleAt(Point p) {
            Point canvasPos = DTree.this.convertOuterToCanvas(p.x, p.y);
            return DTree.this.getItemAt(canvasPos.x, canvasPos.y);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.TREE;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals(DTree.PROPERTY_SELECTION)) {
                DTreeSelection oldSelection = (DTreeSelection)evt.getOldValue();
                DTreeSelection newSelection = (DTreeSelection)evt.getNewValue();
                this.firePropertyChange("AccessibleSelection", DTree.this.getFocusedItem(), null);
            }
        }

        @Override
        public void dTreeItemExpanded(DTreeItemEvent evt) {
            DTreeItem item = evt.getItem();
            this.firePropertyChange("AccessibleState", AccessibleState.COLLAPSED, AccessibleState.EXPANDED);
            item.getAccessibleContext().firePropertyChange("AccessibleState", AccessibleState.COLLAPSED, AccessibleState.EXPANDED);
        }

        @Override
        public void dTreeItemCollapsed(DTreeItemEvent evt) {
            DTreeItem item = evt.getItem();
            this.firePropertyChange("AccessibleState", AccessibleState.EXPANDED, AccessibleState.COLLAPSED);
            item.getAccessibleContext().firePropertyChange("AccessibleState", AccessibleState.EXPANDED, AccessibleState.COLLAPSED);
        }

        @Override
        public void dTreeItemExpanding(DTreeItemEvent evt) {
        }

        @Override
        public void dTreeItemCollapsing(DTreeItemEvent evt) {
        }

        public void fireVisibleDataPropertyChange() {
            this.firePropertyChange("AccessibleVisibleData", null, null);
        }
    }
}

