/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.elaf.basic;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import oracle.bali.ewt.elaf.EWTSpinnerUI;
import oracle.bali.ewt.spinBox.SpinBox;
import oracle.bali.ewt.spinBox.SpinButton;
import oracle.bali.ewt.util.ImmInsets;

public abstract class BasicEWTSpinnerUI
extends EWTSpinnerUI {
    private static final int _GAP = 1;

    protected BasicEWTSpinnerUI() {
    }

    @Override
    public ImmInsets getSpinButtonInsets(JComponent component) {
        return ImmInsets.getEmptyInsets();
    }

    @Override
    public void installUI(JComponent component) {
        LookAndFeel.installColors(component, "EWTSpinner.background", "EWTSpinner.foreground");
        LookAndFeel.installBorder(component, "EWTSpinner.border");
        component.setOpaque(true);
    }

    @Override
    public void uninstallUI(JComponent component) {
        LookAndFeel.uninstallBorder(component);
    }

    @Override
    public Dimension getPreferredSize(JComponent component) {
        SpinBox box = (SpinBox)component;
        Dimension buddyPref = ((Component)((Object)box.getSpinBuddy())).getPreferredSize();
        Dimension spinPref = BasicEWTSpinnerUI.getSpinButton(box).getPreferredSize();
        ImmInsets i = box.getBorderInsets();
        ImmInsets spinInsets = this.getSpinButtonInsets(box);
        int xMargin = UIManager.getInt("EWTSpinner.innerXMargin");
        int verticalInsets = i.top + i.bottom;
        return new Dimension(spinPref.width + buddyPref.width + 1 + i.left + i.right + spinInsets.left + spinInsets.right + xMargin, Math.max(buddyPref.height + verticalInsets, spinPref.height + verticalInsets + spinInsets.top + spinInsets.bottom));
    }

    public static Component getSpinButton(Container component) {
        Component[] comps = component.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            Component found;
            if (comps[i] instanceof SpinButton) {
                return comps[i];
            }
            if (!(comps[i] instanceof Container) || (found = BasicEWTSpinnerUI.getSpinButton((Container)comps[i])) == null) continue;
            return found;
        }
        return null;
    }
}

