/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.elaf.oracle;

import java.awt.Graphics;
import java.awt.Image;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import oracle.bali.ewt.drawer.Drawer;
import oracle.bali.ewt.elaf.EWTDrawerUI;
import oracle.bali.ewt.elaf.basic.BasicUIUtils;
import oracle.bali.ewt.elaf.basic.DrawerBorderPainter;
import oracle.bali.ewt.elaf.basic.WhiteFilter;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.olaf.ColorScheme;
import oracle.bali.ewt.olaf.OracleButtonPainter;
import oracle.bali.ewt.olaf.OracleButtonUI;
import oracle.bali.ewt.olaf.PainterButton;
import oracle.bali.ewt.painter.AndOrStatePainterSwitcher;
import oracle.bali.ewt.painter.FilledRectPainter;
import oracle.bali.ewt.painter.FixedBorderPainter;
import oracle.bali.ewt.painter.FixedColorPainter;
import oracle.bali.ewt.painter.FixedImagePainter;
import oracle.bali.ewt.painter.InnerEdgeBorderPainterJoiner;
import oracle.bali.ewt.painter.JPaintContext;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.painter.PainterStacker;
import oracle.bali.ewt.plaf.BorderAdapter;

public class OracleEWTDrawerUI
extends OracleButtonUI
implements EWTDrawerUI {
    private static Border[] _sBorders = new Border[8];
    private static final OracleEWTDrawerUI _sInstance = new OracleEWTDrawerUI();
    private static Painter[] _sArrowPainters = new Painter[4];

    public static ComponentUI createUI(JComponent component) {
        return _sInstance;
    }

    @Override
    public void installUI(JComponent component) {
        super.installUI(component);
        Border oldBorder = component.getBorder();
        if (oldBorder == null || oldBorder instanceof UIResource) {
            component.setBorder(this.getBorder(component));
        }
    }

    @Override
    public Border getDrawerBorder(JComponent component) {
        int orientation = OracleEWTDrawerUI.getOrientation(component);
        return DrawerBorderPainter.getDrawerBorder(orientation);
    }

    @Override
    public Painter getPainter(JComponent component) {
        return this.getPainter(component, false);
    }

    @Override
    public JButton getPopUpArrowButton(JComponent component) {
        int orientation = (OracleEWTDrawerUI.getOrientation(component) + 1) % 4 + 1;
        PainterButton button = new PainterButton(OracleEWTDrawerUI.getArrowPainter(orientation));
        button.setFocusable(false);
        return button;
    }

    @Override
    public int getPopUpOverlap(JComponent component) {
        Painter painter = OracleEWTDrawerUI.getArrowPainter(4);
        PaintContext context = JPaintContext.getPaintContext(component);
        if (context == null) {
            return 1;
        }
        return painter.getPreferredSize((PaintContext)context).width + 1;
    }

    @Override
    public int getPerpendicularInsets(JComponent component) {
        return 1;
    }

    public static Painter getArrowPainter(int orientation) {
        Painter arrowPainter = _sArrowPainters[orientation - 1];
        if (arrowPainter == null) {
            Image image = BasicUIUtils.getArrow(orientation);
            image = ImageUtils.createFilteredImage(image, new WhiteFilter());
            OracleEWTDrawerUI._sArrowPainters[orientation - 1] = arrowPainter = new PainterStacker(new FixedColorPainter(FilledRectPainter.getPainter(), ColorScheme.NORMAL_INTENSITY), new FixedImagePainter(image, 0));
        }
        return arrowPainter;
    }

    @Override
    public void update(Graphics g, JComponent c) {
        this.fillBackground(g, c);
        this.paint(g, c);
    }

    @Override
    public Border getBorder(JComponent component) {
        Border border;
        int orientation = OracleEWTDrawerUI.getOrientation(component);
        boolean inToolbar = component.getParent() instanceof JToolBar;
        int index = orientation - 1;
        if (inToolbar) {
            index += 4;
        }
        if ((border = _sBorders[index]) == null) {
            int arrowLocation;
            Painter arrowPainter = OracleEWTDrawerUI.getArrowPainter(orientation);
            switch (orientation) {
                case 2: {
                    arrowLocation = 3;
                    break;
                }
                case 4: {
                    arrowLocation = 0;
                    break;
                }
                case 3: {
                    arrowLocation = 2;
                    break;
                }
                default: {
                    arrowLocation = 1;
                }
            }
            InnerEdgeBorderPainterJoiner borderPainter = new InnerEdgeBorderPainterJoiner(new FixedBorderPainter(0, 2, 0, 2), new OracleButtonPainter(null, true, false, inToolbar), new AndOrStatePainterSwitcher(new FixedBorderPainter(arrowPainter, -1, 0, 1, 0), arrowPainter, 2, 2, 0, 0), arrowLocation);
            border = OracleEWTDrawerUI._sBorders[index] = new BorderAdapter(borderPainter);
        }
        return border;
    }

    protected static int getOrientation(JComponent component) {
        return ((Drawer)component).getOrientation();
    }

    @Override
    protected String getPropertyPrefix() {
        return "EWTDrawer.";
    }

    protected OracleEWTDrawerUI() {
    }
}

