/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.elaf.oracle;

import java.awt.Color;
import java.awt.Graphics;
import javax.swing.UIDefaults;
import javax.swing.plaf.UIResource;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.painter.AbstractBorderPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.util.ImmInsets;

public class OracleHeaderItemPainter
extends AbstractBorderPainter
implements UIResource {
    private boolean _curvedFirstEdge;
    private boolean _curvedLastEdge;
    private boolean _horizontal;
    private static final ImmInsets _sInsets = new ImmInsets(1, 1, 1, 1);

    public OracleHeaderItemPainter(boolean horizontal, boolean curvedFirstEdge, boolean curvedLastEdge) {
        this._horizontal = horizontal;
        this._curvedFirstEdge = curvedFirstEdge;
        this._curvedLastEdge = curvedLastEdge;
    }

    @Override
    public int getRepaintFlags(PaintContext context) {
        return super.getRepaintFlags(context) | 2;
    }

    @Override
    protected boolean isBorderTransparent(PaintContext context) {
        return true;
    }

    @Override
    protected ImmInsets getOwnInsets(PaintContext context) {
        return _sInsets;
    }

    @Override
    protected void paintBorder(PaintContext context, Graphics g, int x, int y, int width, int height) {
        Color savedColor = g.getColor();
        Object data = context.getPaintData(Header.KEY_DRAW_RAISED);
        boolean raised = data instanceof Boolean ? (Boolean)data : true;
        int state = context.getPaintState();
        Color color = null;
        if ((state & 1) == 0 && (data = context.getPaintData("headerItemBorderColor")) instanceof Color) {
            color = (Color)data;
        }
        if (color == null) {
            color = context.getPaintUIDefaults().getColor("normalIntensity");
        }
        if (this._horizontal) {
            this._paintHorizontalBorder(context, g, x, y, width, height, raised, color);
        } else {
            this._paintVerticalBorder(context, g, x, y, width, height, raised, color);
        }
        if (savedColor != null) {
            g.setColor(savedColor);
        }
    }

    private void _paintVerticalBorder(PaintContext context, Graphics g, int x, int y, int width, int height, boolean raised, Color borderColor) {
        int state = context.getPaintState();
        UIDefaults defaults = context.getPaintUIDefaults();
        int bottom = y + height - 1;
        int right = x + width - 1;
        Color control = defaults.getColor("control");
        Color dark = defaults.getColor("darkIntensity");
        Color darkShadow = defaults.getColor("controlShadowDark");
        if (this._curvedFirstEdge) {
            g.setColor(darkShadow);
            g.drawLine(x, y, x, y + 1);
            g.drawLine(x + 1, y, x + 1, y);
        }
        if (raised && (state & 2) != 0) {
            int temp3;
            int temp2;
            int temp1;
            g.setColor(dark);
            if (this._curvedFirstEdge) {
                g.drawLine(x + 1, y + 1, x + 1, y + 1);
                temp1 = x + 2;
                temp2 = y + 2;
            } else {
                temp1 = x;
                temp2 = y;
            }
            if (this._curvedLastEdge) {
                g.drawLine(x + 1, bottom - 1, x + 1, bottom - 1);
                temp3 = bottom - 2;
            } else {
                temp3 = bottom;
            }
            g.drawLine(temp1, y, right, y);
            g.drawLine(x, temp2, x, temp3);
        } else {
            g.setColor(borderColor);
            if (context.getReadingDirection() == 1) {
                g.drawLine(right, y, right, bottom);
            } else {
                g.drawLine(x, y, x, bottom);
            }
            g.drawLine(x, bottom, right, bottom);
            if ((state & 4) == 0) {
                int temp3;
                int temp2;
                int temp1;
                if (raised) {
                    g.setColor(Color.white);
                }
                if (this._curvedFirstEdge) {
                    g.drawLine(x + 1, y + 1, x + 1, y + 1);
                    temp1 = x + 2;
                    temp2 = y + 2;
                } else {
                    temp1 = x;
                    temp2 = y;
                }
                if (this._curvedLastEdge) {
                    g.drawLine(x + 1, bottom - 1, x + 1, bottom - 1);
                    temp3 = bottom - 2;
                } else {
                    temp3 = bottom;
                }
                if (raised) {
                    g.drawLine(temp1, y, right, y);
                }
                g.drawLine(x, temp2, x, temp3);
                if (raised) {
                    g.setColor(control);
                } else {
                    g.setColor(borderColor);
                }
                g.drawLine(x, bottom, x, bottom);
                g.drawLine(right, y, right, y);
            } else if (this._curvedLastEdge) {
                g.setColor(darkShadow);
                g.drawLine(x, bottom - 1, x, bottom);
                g.drawLine(x + 1, bottom, x + 1, bottom);
            }
        }
    }

    private void _paintHorizontalBorder(PaintContext context, Graphics g, int x, int y, int width, int height, boolean raised, Color borderColor) {
        int state = context.getPaintState();
        UIDefaults defaults = context.getPaintUIDefaults();
        int bottom = y + height - 1;
        int right = x + width - 1;
        Color control = defaults.getColor("control");
        Color dark = defaults.getColor("darkIntensity");
        Color darkShadow = defaults.getColor("controlShadowDark");
        if (this._curvedFirstEdge) {
            g.setColor(darkShadow);
            g.drawLine(x, y, x, y + 1);
            g.drawLine(x + 1, y, x + 1, y);
        }
        if (raised && (state & 2) != 0) {
            int temp3;
            int temp2;
            int temp1;
            g.setColor(dark);
            if (this._curvedFirstEdge) {
                g.drawLine(x + 1, y + 1, x + 1, y + 1);
                temp1 = x + 2;
                temp2 = y + 2;
            } else {
                temp1 = x;
                temp2 = y;
            }
            if (this._curvedLastEdge) {
                g.drawLine(right - 1, y + 1, right - 1, y + 1);
                temp3 = right - 2;
            } else {
                temp3 = right;
            }
            g.drawLine(temp1, y, temp3, y);
            g.drawLine(x, temp2, x, bottom);
        } else {
            g.setColor(borderColor);
            g.drawLine(x, bottom, right, bottom);
            g.drawLine(right, y, right, bottom);
            if ((state & 4) == 0) {
                int temp3;
                int temp2;
                int temp1;
                if (raised) {
                    g.setColor(Color.white);
                }
                if (this._curvedFirstEdge) {
                    g.drawLine(x + 1, y + 1, x + 1, y + 1);
                    temp1 = x + 2;
                    temp2 = y + 2;
                } else {
                    temp1 = x;
                    temp2 = y;
                }
                if (this._curvedLastEdge) {
                    g.drawLine(right - 1, y + 1, right - 1, y + 1);
                    temp3 = right - 2;
                } else {
                    temp3 = right;
                }
                g.drawLine(temp1, y, temp3, y);
                if (raised) {
                    g.drawLine(x, temp2, x, bottom);
                }
                if (raised) {
                    g.setColor(control);
                } else {
                    g.setColor(borderColor);
                }
                g.drawLine(x, bottom, x, bottom);
                g.drawLine(right, y, right, y);
            } else if (this._curvedLastEdge) {
                g.setColor(darkShadow);
                g.drawLine(right - 1, y, right, y);
                g.drawLine(right, y + 1, right, y + 1);
            }
        }
    }
}

