/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.elaf.oracle;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.UIDefaults;
import oracle.bali.ewt.elaf.EWTPivotTableUI;
import oracle.bali.ewt.painter.AbstractPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.pivot.PivotTable;

class OraclePivotCornerPainter
extends AbstractPainter {
    public static final int UPPER_LEFT = 3;
    public static final int UPPER_RIGHT = 1;
    private static Painter _sUpperLeft;
    private static Painter _sUpperRight;
    private int _corner;

    private OraclePivotCornerPainter(int whichCorner) {
        this._corner = whichCorner;
    }

    public static Painter getPainter() {
        return OraclePivotCornerPainter.getPainter(3);
    }

    public static Painter getPainter(int whichCorner) {
        Painter painter = null;
        switch (whichCorner) {
            case 3: {
                if (_sUpperLeft == null) {
                    _sUpperLeft = new OraclePivotCornerPainter(3);
                }
                painter = _sUpperLeft;
                break;
            }
            case 1: {
                if (_sUpperRight == null) {
                    _sUpperRight = new OraclePivotCornerPainter(1);
                }
                painter = _sUpperRight;
            }
        }
        return painter;
    }

    @Override
    public Dimension getMinimumSize(PaintContext context) {
        return new Dimension(0, 0);
    }

    @Override
    public int getRepaintFlags(PaintContext context) {
        return 128;
    }

    @Override
    public void paint(PaintContext context, Graphics g, int x, int y, int width, int height) {
        Color savedColor = g.getColor();
        switch (this._corner) {
            case 3: {
                this._paintUpperLeft(context, g, x, y, width, height);
                break;
            }
            case 1: {
                this._paintUpperRight(context, g, x, y, width, height);
            }
        }
        if (savedColor != null) {
            g.setColor(savedColor);
        }
    }

    private void _paintUpperLeft(PaintContext context, Graphics g, int x, int y, int width, int height) {
        Object data;
        UIDefaults defaults = context.getPaintUIDefaults();
        int bottom = y + height - 1;
        int right = x + width - 1;
        Color cornerColor = null;
        int state = context.getPaintState();
        if ((state & 1) == 0 && (data = context.getPaintData(PivotTable.KEY_CORNER_BORDER_COLOR)) instanceof Color) {
            cornerColor = (Color)data;
        }
        if (cornerColor == null) {
            cornerColor = defaults.getColor("EWTPivot.darkShadow");
        }
        Object h = context.getPaintData(EWTPivotTableUI.HORIZONTAL_KEY);
        boolean horizontal = Boolean.TRUE.equals(h);
        Object v = context.getPaintData(EWTPivotTableUI.VERTICAL_KEY);
        boolean vertical = Boolean.TRUE.equals(v);
        g.setColor(context.getPaintBackground());
        g.fillRect(x, y, width, height);
        g.setColor(cornerColor);
        if (horizontal) {
            g.drawLine(x, bottom, right, bottom);
        }
        if (vertical) {
            g.drawLine(right, y, right, bottom);
        }
    }

    private void _paintUpperRight(PaintContext context, Graphics g, int x, int y, int width, int height) {
        UIDefaults defaults = context.getPaintUIDefaults();
        int bottom = y + height - 1;
        int right = x + width - 1;
        Color darkShadow = defaults.getColor("EWTPivot.darkShadow");
        Object h = context.getPaintData(EWTPivotTableUI.HORIZONTAL_KEY);
        boolean horizontal = Boolean.TRUE.equals(h);
        Object v = context.getPaintData(EWTPivotTableUI.VERTICAL_KEY);
        boolean vertical = Boolean.TRUE.equals(v);
        g.setColor(context.getPaintBackground());
        g.fillRect(x, y, width, height);
        g.setColor(darkShadow);
        if (vertical) {
            g.drawLine(x, y, x, bottom);
        }
        if (horizontal) {
            g.drawLine(x, bottom, right, bottom);
        }
    }
}

