/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.elaf.oracle2;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.PrintGraphics;
import java.awt.print.PrinterGraphics;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.painter.AbstractPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;

public class PivotHeaderGrippyPainterWithBorder
extends AbstractPainter {
    private static final int _GRIPPY_SIZE = 6;
    private static final int _GRIPPY_GAP = -2;
    private static final int _GRIPPY_STRIDE = 4;
    private static final int _MIN_GRIPPIES = 3;
    private static final int _MIN_PERP_GRIPPY_SIZE = 10;
    private static final int _MIN_ORIENT_GRIPPY_SIZE = 14;
    private static Painter _sPainter;

    public static Painter getPainter() {
        if (_sPainter == null) {
            _sPainter = new PivotHeaderGrippyPainterWithBorder();
        }
        return _sPainter;
    }

    @Override
    public Dimension getSize(PaintContext context, int width, int height) {
        if (width > 10) {
            width = 10;
        }
        if (height > 14) {
            height = 14;
        }
        return new Dimension(width, height);
    }

    @Override
    public Dimension getMinimumSize(PaintContext context) {
        return new Dimension(10, 14);
    }

    @Override
    public int getRepaintFlags(PaintContext context) {
        return 131;
    }

    @Override
    public void paint(PaintContext context, Graphics g, int x, int y, int width, int height) {
        boolean paint;
        boolean printing;
        Color savedColor = g.getColor();
        int state = context.getPaintState();
        boolean bl = printing = g instanceof PrintGraphics || g instanceof PrinterGraphics;
        if (!printing) {
            boolean raised;
            Object data;
            Color grippyColor = UIManager.getColor("EWTPivotPivotGrippy.background");
            g.setColor(grippyColor);
            g.fillRect(x - 1, y - 1, width + 1, height + 1);
            Color darkShadow = null;
            if ((state & 1) == 0 && (data = context.getPaintData("headerItemBorderColor")) instanceof Color) {
                darkShadow = (Color)data;
            }
            if (darkShadow == null) {
                darkShadow = UIManager.getColor("EWTPivot.darkShadow");
            }
            g.setColor(darkShadow);
            g.drawLine(x + width, y - 1, x + width, y + height);
            data = context.getPaintData(Header.KEY_DRAW_RAISED);
            boolean bl2 = raised = data instanceof Boolean ? (Boolean)data : true;
            if (raised) {
                g.setColor(Color.white);
                g.drawLine(x + width + 1, y, x + width + 1, y + height - 1);
            }
        }
        boolean enabled = (state & 1) == 0;
        boolean bl3 = paint = printing ? false : enabled;
        if (paint) {
            boolean isArmed;
            int numGrippies = 3;
            int grippySize = numGrippies * 6 + (numGrippies - 1) * -2;
            int grippyWidth = 6;
            int grippyHeight = grippySize;
            int yOffset = 4;
            int grippyX = x + (width - grippyWidth) / 2;
            int grippyY = y + (height - grippyHeight) / 2;
            int topRightCornerX = grippyX + grippyWidth - 2;
            int topRightCornerY = grippyY;
            int bottomLeftCornerX = grippyX;
            int bottomLeftCornerY = grippyY + grippyHeight - 2;
            int numTopRightCornerDots = 2;
            int numBottomLeftCornerDots = 2;
            UIDefaults defaults = context.getPaintUIDefaults();
            Color highlight = Color.white;
            Color dark = defaults.getColor("PivotTable.darkGrippy");
            boolean bl4 = isArmed = (state & 2) != 0;
            while (numGrippies > 0) {
                PivotHeaderGrippyPainterWithBorder.__drawGrippys(g, grippyX, grippyY, 6, highlight, dark, isArmed);
                --numGrippies;
                grippyY += yOffset;
            }
            PivotHeaderGrippyPainterWithBorder.__drawGrippys(g, topRightCornerX, topRightCornerY, numTopRightCornerDots, highlight, dark, isArmed);
            PivotHeaderGrippyPainterWithBorder.__drawGrippys(g, bottomLeftCornerX, bottomLeftCornerY, numBottomLeftCornerDots, highlight, dark, isArmed);
        }
        g.setColor(savedColor);
    }

    static void __drawGrippys(Graphics g, int x, int y, int length, Color highlight, Color dark, boolean isArmed) {
        int darkDots = 0;
        darkDots = length % 2 == 0 ? length / 2 : (length + 1) / 2;
        int whiteDots = length - darkDots;
        if (isArmed) {
            int i;
            g.setColor(highlight);
            int tempX = x;
            int tempY = y;
            for (i = 0; i < darkDots; ++i) {
                g.drawLine(tempX, tempY, tempX, tempY);
                tempX += 2;
                tempY += 2;
            }
            g.setColor(dark);
            ++x;
            ++y;
            for (i = 0; i < whiteDots; ++i) {
                g.drawLine(x, y, x, y);
                x += 2;
                y += 2;
            }
        } else {
            int i;
            g.setColor(dark);
            int tempX = x;
            int tempY = y;
            for (i = 0; i < darkDots; ++i) {
                g.drawLine(tempX, tempY, tempX, tempY);
                tempX += 2;
                tempY += 2;
            }
            g.setColor(highlight);
            ++x;
            ++y;
            for (i = 0; i < whiteDots; ++i) {
                g.drawLine(x, y, x, y);
                x += 2;
                y += 2;
            }
        }
    }

    private PivotHeaderGrippyPainterWithBorder() {
    }
}

