/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.graphics;

import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.util.Hashtable;

class TransparencyTester
implements ImageConsumer {
    private ImageProducer _producer;
    private static final int _COMPUTING_TRANSPARENCY = -1;
    private static final int _IS_NOT_TRANSPARENT = 0;
    private static final int _IS_TRANSPARENT = 1;
    private transient int _isTransparent = -1;

    public TransparencyTester(Image image) {
        this(image.getSource());
    }

    public TransparencyTester(ImageProducer producer) {
        this._producer = producer;
    }

    public synchronized boolean isTransparent() {
        if (this._isTransparent == -1) {
            this._producer.startProduction(this);
            while (this._isTransparent == -1) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    return true;
                }
            }
        }
        return this._isTransparent != 0;
    }

    @Override
    public void setDimensions(int width, int height) {
    }

    public void setProperties(Hashtable props) {
    }

    @Override
    public void setColorModel(ColorModel model) {
    }

    @Override
    public void setHints(int hintflags) {
    }

    @Override
    public void setPixels(int x, int y, int width, int height, ColorModel model, byte[] pixels, int offset, int scanSize) {
        if (this._isTransparent == -1) {
            int endY = y + height;
            int endX = x + width;
            while (y < endY) {
                int linePixelOffset = offset;
                for (int lineX = x; lineX < endX; ++lineX) {
                    int pixel = pixels[linePixelOffset];
                    if (pixel < 0) {
                        pixel += 256;
                    }
                    if (model.getAlpha(pixel) != 0) {
                        this._isTransparent = 1;
                    }
                    ++linePixelOffset;
                }
                offset += scanSize;
                ++y;
            }
        }
    }

    @Override
    public void setPixels(int x, int y, int width, int height, ColorModel model, int[] pixels, int offset, int scanSize) {
        if (this._isTransparent == -1) {
            int endY = y + height;
            int endX = x + width;
            do {
                int linePixelOffset = offset;
                int lineX = x;
                do {
                    if (model.getAlpha(pixels[linePixelOffset]) != 0) {
                        this._isTransparent = 1;
                        break;
                    }
                    ++linePixelOffset;
                } while (++lineX < endX);
                offset += scanSize;
            } while (this._isTransparent == -1 && ++y < endY);
        }
    }

    @Override
    public synchronized void imageComplete(int status) {
        if (status != 3) {
            this._isTransparent = 1;
        } else if (this._isTransparent != 0) {
            this._isTransparent = 1;
        }
        this._producer.removeConsumer(this);
        this.notifyAll();
    }
}

