/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.grid;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.grid.CellInputHandler;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.selection.Cell;

public class ComboBoxInputHandler
extends CellInputHandler {
    private static JComboBox _combobox;
    static boolean _dirty;
    private Object[] _items;
    private boolean _editable;

    public ComboBoxInputHandler() {
        this(null, false);
    }

    public ComboBoxInputHandler(boolean editable) {
        this(null, editable);
    }

    public ComboBoxInputHandler(Object[] items) {
        this(items, false);
    }

    public ComboBoxInputHandler(Object[] items, boolean editable) {
        this.setItems(items);
        this.setEditable(editable);
    }

    public void setItems(Object[] items) {
        if (this._items != null) {
            for (int i = 0; i < this._items.length; ++i) {
                this._items[i] = null;
            }
        }
        this._items = null;
        if (items != null) {
            this._items = new Object[items.length];
            System.arraycopy(items, 0, this._items, 0, items.length);
        }
    }

    public Object[] getItems() {
        if (this._items == null) {
            return null;
        }
        Object[] toReturn = new Object[this._items.length];
        System.arraycopy(this._items, 0, toReturn, 0, this._items.length);
        return toReturn;
    }

    public void setEditable(boolean editable) {
        this._editable = editable;
    }

    public boolean isEditable() {
        return this._editable;
    }

    @Override
    public void updateUI() {
        if (_combobox != null) {
            SwingUtilities.updateComponentTreeUI(_combobox);
        }
    }

    @Override
    public void mousePressed(MouseEvent e, Grid grid, int column, int row) {
        super.mousePressed(e, grid, column, row);
        Cell focusCell = grid.getFocusCell();
        if (focusCell != null && focusCell.column == column && focusCell.row == row && SwingUtilities.isLeftMouseButton(e)) {
            grid.startCellEdit(column, row);
        }
    }

    @Override
    public void focusGained(AWTEvent why, Grid grid, int column, int row) {
        if (why instanceof MouseEvent) {
            grid.startCellEdit(column, row);
        }
    }

    @Override
    public synchronized Component getEditControl(Grid grid, int column, int row) {
        if (_combobox == null) {
            _combobox = new CBIHJComboBox();
            _combobox.addItemListener(new Dirty());
        }
        _combobox.setEditable(this.isEditable());
        return _combobox;
    }

    @Override
    public boolean isDirty(Grid grid, int column, int row) {
        return _dirty;
    }

    @Override
    public void startEdit(Grid grid, int column, int row, Object data) {
        JComboBox combobox = (JComboBox)this.getEditControl(grid, column, row);
        if (combobox.getItemCount() > 0) {
            combobox.removeAllItems();
        }
        if (this._items != null) {
            for (int i = 0; i < this._items.length; ++i) {
                combobox.addItem(this._items[i]);
            }
        } else if (data != null) {
            combobox.addItem(data);
        }
        if (data != null) {
            combobox.setSelectedItem(data);
            _dirty = false;
        } else if (!this.isEditable()) {
            _dirty = true;
        } else {
            combobox.setSelectedItem(null);
            _dirty = false;
        }
    }

    @Override
    public synchronized Object commitEdit(Grid grid, int column, int row) {
        Object editorData;
        JComboBox combobox = (JComboBox)this.getEditControl(grid, column, row);
        Object data = combobox.getSelectedItem();
        if (combobox.isEditable() && data != (editorData = combobox.getEditor().getItem())) {
            combobox.getModel().setSelectedItem(editorData);
            return editorData;
        }
        return data;
    }

    @Override
    public Component[] getFocusableComponents(Grid grid, int focusColumn, int focusRow) {
        Component[] supe = super.getFocusableComponents(grid, focusColumn, focusRow);
        JComboBox jcb = (JComboBox)this.getEditControl(grid, focusColumn, focusRow);
        Component c = null;
        Vector<Component> v = new Vector<Component>(2);
        int count = jcb.getComponentCount();
        for (int i = 0; i < count; ++i) {
            c = jcb.getComponent(i);
            if (!(c instanceof JComponent) || !((JComponent)c).isRequestFocusEnabled()) continue;
            v.addElement(c);
        }
        if (v.size() == 0) {
            return supe;
        }
        Component[] result = new Component[supe.length + v.size()];
        System.arraycopy(supe, 0, result, 0, supe.length);
        for (int i = 0; i < v.size(); ++i) {
            result[supe.length + i] = (Component)v.elementAt(i);
        }
        return result;
    }

    private static class Dirty
    implements ItemListener {
        private Dirty() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            _dirty = true;
        }
    }

    public static class CBIHJComboBox
    extends JComboBox {
        @Override
        public void requestFocus() {
            int count = this.getComponentCount();
            for (int i = 0; i < count; ++i) {
                Component c = this.getComponent(i);
                if (!(c instanceof JComponent) || !((JComponent)c).isRequestFocusEnabled()) continue;
                c.requestFocus();
                return;
            }
            super.requestFocus();
        }
    }
}

