/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.grid;

import java.awt.Dimension;
import java.awt.Point;
import oracle.bali.ewt.graphics.Appearance;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.grid.GridToolTipManager;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.painter.BorderPainter;
import oracle.bali.ewt.painter.FormatPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.util.ImmInsets;

public class GridDataToolTipManager
implements GridToolTipManager {
    @Override
    public String getCellToolTipValue(Grid grid, int column, int row) {
        Object data = this.getCellToolTipData(grid, column, row);
        if (data == null) {
            return null;
        }
        if (!this.shouldDisplay(grid, data, column, row)) {
            return null;
        }
        if (data instanceof String) {
            return (String)data;
        }
        return null;
    }

    public Object getCellToolTipData(Grid grid, int column, int row) {
        Object data = null;
        TwoDModel ds = grid.getModel();
        if (ds != null) {
            data = ds.getData(column, row);
            Painter painter = grid.getColumnPainter(column);
            if (painter instanceof FormatPainter && data != null) {
                data = ((FormatPainter)painter).getFormat().format(data);
            }
        }
        return data;
    }

    protected boolean shouldDisplay(Grid grid, Object data, int column, int row) {
        BorderPainter borderPainter;
        int x = grid.getColumnPosition(column);
        int y = grid.getRowPosition(row);
        int width = grid.getColumnWidth(column);
        int height = grid.getRowHeight(row);
        Point origin = grid.getCanvasOrigin();
        Dimension size = grid.getInnerSize();
        Painter painter = grid.getColumnPainter(column);
        Appearance a = grid.getAppearanceManager().getCellPaintingAppearance(column, row);
        ImmInsets insets = a.getInsets();
        PaintContext context = grid.getCellPaintContext(column, row);
        Dimension prefSize = painter.getPreferredSize(context);
        if (insets != null) {
            prefSize.width += insets.left + insets.right;
        }
        if ((borderPainter = a.getBorderPainter()) != null && (insets = borderPainter.getInsets(context)) != null) {
            prefSize.width += insets.left + insets.right;
        }
        return prefSize.width > width || prefSize.height > height || -origin.x > x || -origin.y > y || -origin.x + size.width < x + width || -origin.y + size.height < y + height;
    }
}

