/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.header;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.PrintGraphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.print.PrinterGraphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.text.MessageFormat;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import oracle.bali.ewt.elaf.EWTHeaderUI;
import oracle.bali.ewt.geometry.GeneralGeometryManager;
import oracle.bali.ewt.geometry.GeometryEvent;
import oracle.bali.ewt.geometry.GeometryListener;
import oracle.bali.ewt.geometry.GeometryManager;
import oracle.bali.ewt.geometry.ReversedGeometryManager;
import oracle.bali.ewt.graphics.Appearance;
import oracle.bali.ewt.graphics.ColorUtils;
import oracle.bali.ewt.graphics.ImageSet;
import oracle.bali.ewt.header.AutoScroller;
import oracle.bali.ewt.header.GeneralHeaderSelectionManager;
import oracle.bali.ewt.header.HeaderEvent;
import oracle.bali.ewt.header.HeaderItemInputHandler;
import oracle.bali.ewt.header.HeaderKeyHandler;
import oracle.bali.ewt.header.HeaderMoveListener;
import oracle.bali.ewt.header.HeaderResizeListener;
import oracle.bali.ewt.header.HeaderSelectionManager;
import oracle.bali.ewt.header.HeaderToolTipManager;
import oracle.bali.ewt.header.HeaderValidateEvent;
import oracle.bali.ewt.header.Mover;
import oracle.bali.ewt.header.NullInputHandler;
import oracle.bali.ewt.header.SelectionAutoScroller;
import oracle.bali.ewt.header.StandardHeaderKeyHandler;
import oracle.bali.ewt.model.ArrayOneDModel;
import oracle.bali.ewt.model.EmptyOneDModel;
import oracle.bali.ewt.model.OneDModel;
import oracle.bali.ewt.model.OneDModelEvent;
import oracle.bali.ewt.model.OneDModelListener;
import oracle.bali.ewt.painter.BorderPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.PaintContextProxy;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.print.PrinterUtils;
import oracle.bali.ewt.scrolling.ScrollableComponent;
import oracle.bali.ewt.selection.OneDSelection;
import oracle.bali.ewt.text.MultiLineToolTip;
import oracle.bali.ewt.util.ImmInsets;
import oracle.bali.ewt.util.LocaleUtils;
import oracle.bali.share.collection.Range;
import oracle.bali.share.event.ListenerManager;
import oracle.bali.share.util.IntegerUtils;

public class Header
extends ScrollableComponent
implements Accessible {
    public static final Object KEY_APPEARANCE = "header.Appearance";
    public static final Object KEY_DRAW_RAISED = "header.drawRaised";
    public static final String KEY_HEADER_ITEM = "header.item";
    public static final String KEY_HEADER_ITEM_BORDER_COLOR = "headerItemBorderColor";
    public static final String PROPERTY_SELECTION = "selection";
    public static final String PROPERTY_SELECTION_MANAGER = "headerSelectionManager";
    public static final String PROPERTY_MODEL = "model";
    public static final String PROPERTY_GEOMETRY_MANAGER = "geometryManager";
    public static final String PROPERTY_FOCUS_ITEM = "focusItem";
    public static final Object DISPLAY_FOCUS_ITEM = "header.dispFocus";
    public static final Object DISPLAY_SELECTION_BORDER = "header.dispSelBorder";
    private static final String _IMAGE = "GRID_IMAGE";
    private static final String _UNKNOWN = "UNKNOWN";
    private static final String _RESOURCE = "oracle.bali.ewt.resource.AccessibilityBundle";
    private static final String _KEY_COLUMN = "SPREADTABLE.COLUMN";
    private static final String _KEY_ROW = "SPREADTABLE.ROW";
    private static final String _MOVE_LEFT = "move.left";
    private static final String _MOVE_RIGHT = "move.right";
    private static final String _RESIZE_LEFT = "resize.left";
    private static final String _RESIZE_RIGHT = "resize.right";
    private static final String _MOVE_UP = "move.up";
    private static final String _MOVE_DOWN = "move.down";
    private static final String _RESIZE_UP = "resize.up";
    private static final String _RESIZE_DOWN = "resize.down";
    private static final String _ROWHEADER = "HEADER.ROW";
    private static final String _COLHEADER = "HEADER.COLUMN";
    private static final char _NONE = '\u0000';
    private static final char _RESIZE = '\u0001';
    private static final char _MOVE = '\u0002';
    private static final char _CANCEL = '\u0003';
    private static final char _RESIZED = '\u0004';
    private static final int _TARGET = 5;
    private boolean _firstEdge;
    private boolean _lastEdge;
    private Painter _defaultPainter;
    private KeyboardActionListener _keyboardListener;
    private BorderPainter _borderPainter;
    private BorderPainter _firstBorderPainter;
    private BorderPainter _lastBorderPainter;
    private HeaderItemInputHandler _inputHandler;
    private ArrayOneDModel _itemGraphics;
    private ArrayOneDModel _painters;
    private ArrayOneDModel _notmovable;
    private OneDModel _ds;
    private DSListen _dsListener;
    private GeometryManager _gm;
    private Appearance _appearanceObject;
    private HeaderKeyHandler _keyHandler;
    private int _prefSize = -1;
    private int _mouseItem = -1;
    private int _moveItem = -1;
    private int _anchorItem = -1;
    private int _armedItem = -1;
    private int _focusItem = -1;
    private char _state = '\u0000';
    private int _orientation;
    private boolean _drawSelected;
    private boolean _drawRaised;
    private boolean _canMove;
    private boolean _canResize;
    private int _redrawInfo = -1;
    private int _outlinePosition = -1;
    private int _outlineOffset = -1;
    private HeaderSelectionManager _headerSelection;
    private boolean _scrollByItem;
    private boolean _alwaysDrawFocusItemHighlite;
    private ListenerManager _resizeListeners;
    private ListenerManager _moveListeners;
    private GeometryChangeListener _geometryChangeListener;
    private SelectionListener _selectionListener;
    private int _firstItem = -1;
    private boolean _ignoreSelectionRepaints = false;
    private HeaderToolTipManager _toolTipManager;
    private int _resizeOffset;
    private Color _headerItemBorderColor;
    private boolean _drawSelectionBorder;
    private boolean _selectionTransparent;
    private static final int _ALPHA = 60;
    private Color _extraBackground;

    public Header() {
        this(null);
    }

    public Header(OneDModel ds) {
        this(ds, 0);
    }

    public Header(OneDModel ds, int orientation) {
        if (ds == null) {
            ds = EmptyOneDModel.getOneDModel();
        }
        this._orientation = orientation;
        this._ds = ds;
        this._dsListener = new DSListen();
        this._ds.addModelListener(this._dsListener);
        this._canMove = true;
        this._canResize = true;
        this._drawSelected = true;
        this._drawRaised = true;
        this._scrollByItem = true;
        long mask = 60L;
        this.enableEvents(mask);
        this._registerKeyboardActions();
        this.updateUI();
    }

    public void dispose() {
        this._outlinePosition = -1;
        this._outlineOffset = -1;
        this._firstItem = -1;
        this._mouseItem = -1;
        this._moveItem = -1;
        this._anchorItem = -1;
        this._armedItem = -1;
        this._focusItem = -1;
        this.setToolTipManager(null);
        this._defaultPainter = null;
        this._borderPainter = null;
        this._firstBorderPainter = null;
        this._lastBorderPainter = null;
        this._inputHandler = null;
        this._appearanceObject = null;
        if (this._itemGraphics != null && this._itemGraphics.getItemCount() != 0) {
            this._itemGraphics.removeItems(0, this._itemGraphics.getItemCount());
        }
        this._itemGraphics = null;
        if (this._painters != null && this._painters.getItemCount() != 0) {
            this._painters.removeItems(0, this._painters.getItemCount());
        }
        this._painters = null;
        if (this._notmovable != null && this._notmovable.getItemCount() != 0) {
            this._notmovable.removeItems(0, this._notmovable.getItemCount());
        }
        this._notmovable = null;
        this._resizeListeners = null;
        this._moveListeners = null;
        this._keyHandler = null;
        this._gm.removeGeometryListener(this._geometryChangeListener);
        this._geometryChangeListener = null;
        this._gm = null;
        if (this._headerSelection != null) {
            this._headerSelection.removeVetoableChangeListener(this._selectionListener);
            this._headerSelection.removePropertyChangeListener(this._selectionListener);
        }
        this._headerSelection = null;
        this._selectionListener = null;
        this._ds.removeModelListener(this._dsListener);
        this._dsListener = null;
        this._ds = null;
        this._unregisterKeyboardActions();
        this.setUI(null);
    }

    @Override
    public String getUIClassID() {
        return "EWTHeaderUI";
    }

    public int getOrientation() {
        return this._orientation;
    }

    public BorderPainter getHeaderItemBorderPainter() {
        if (this._borderPainter == null) {
            EWTHeaderUI ui = this.getUI();
            this._borderPainter = ui.getHeaderItemBorderPainter(this);
        }
        return this._borderPainter;
    }

    public void setHeaderItemBorderPainter(BorderPainter painter) {
        if (this._borderPainter != painter) {
            this._borderPainter = painter;
            this.revalidate();
            this.repaint();
        }
    }

    public void setHeaderItemBorderColor(Color color) {
        if (color != this._headerItemBorderColor) {
            this._headerItemBorderColor = color;
            this.repaint();
        }
    }

    public Color getHeaderItemBorderColor() {
        return this._headerItemBorderColor;
    }

    public void setExtraCanvasBackground(Color color) {
        Color oldColor = this.getExtraCanvasBackground();
        this._extraBackground = color;
        if (oldColor != null ? !oldColor.equals(color) : color != null) {
            this.repaint();
        }
    }

    public Color getExtraCanvasBackground() {
        return this._extraBackground;
    }

    public BorderPainter getFirstItemBorderPainter() {
        if (this._firstBorderPainter == null) {
            EWTHeaderUI ui = this.getUI();
            this._firstBorderPainter = ui.getFirstItemBorderPainter(this);
        }
        return this._firstBorderPainter;
    }

    public void setFirstItemBorderPainter(BorderPainter painter) {
        if (this._firstBorderPainter != painter) {
            this._firstBorderPainter = painter;
            this.revalidate();
            this.repaint();
        }
    }

    public BorderPainter getLastItemBorderPainter() {
        if (this._lastBorderPainter == null) {
            EWTHeaderUI ui = this.getUI();
            this._lastBorderPainter = ui.getLastItemBorderPainter(this);
        }
        return this._lastBorderPainter;
    }

    public void setLastItemBorderPainter(BorderPainter painter) {
        if (this._lastBorderPainter != painter) {
            this._lastBorderPainter = painter;
            this.revalidate();
            this.repaint();
        }
    }

    public void setFirstEdge(boolean firstEdge) {
        if (firstEdge != this._firstEdge) {
            this._firstEdge = firstEdge;
            this.revalidate();
            this.repaint();
        }
    }

    public boolean isFirstEdge() {
        return this._firstEdge;
    }

    public void setLastEdge(boolean lastEdge) {
        if (this._lastEdge != lastEdge) {
            this._lastEdge = lastEdge;
            this.revalidate();
            this.repaint();
        }
    }

    public boolean isLastEdge() {
        return this._lastEdge;
    }

    public synchronized void addResizeListener(HeaderResizeListener listener) {
        if (this._resizeListeners == null) {
            this._resizeListeners = new ListenerManager();
        }
        this._resizeListeners.addListener((EventListener)listener);
    }

    public synchronized void removeResizeListener(HeaderResizeListener listener) {
        if (this._resizeListeners != null) {
            this._resizeListeners.removeListener((EventListener)listener);
        }
    }

    public synchronized void addMoveListener(HeaderMoveListener listener) {
        if (this._moveListeners == null) {
            this._moveListeners = new ListenerManager();
        }
        this._moveListeners.addListener((EventListener)listener);
    }

    public synchronized void removeMoveListener(HeaderMoveListener listener) {
        if (this._moveListeners != null) {
            this._moveListeners.removeListener((EventListener)listener);
        }
    }

    public void setToolTipManager(HeaderToolTipManager manager) {
        this._toolTipManager = manager;
        ToolTipManager ttm = ToolTipManager.sharedInstance();
        if (this._toolTipManager == null) {
            ttm.unregisterComponent(this);
        } else {
            ttm.registerComponent(this);
        }
    }

    public HeaderToolTipManager getToolTipManager() {
        return this._toolTipManager;
    }

    @Override
    public JToolTip createToolTip() {
        return new MultiLineToolTip();
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        if (this._toolTipManager == null) {
            return null;
        }
        int index = this.getItemAt(event.getX(), event.getY());
        if (index == -1) {
            return null;
        }
        return this._toolTipManager.getItemToolTipValue(this, index);
    }

    public int getItemCount() {
        return this._ds.getItemCount();
    }

    public boolean getDrawSelected() {
        return this._drawSelected;
    }

    public void setDrawSelected(boolean drawSelected) {
        if (this.getDrawSelected() != drawSelected) {
            this._drawSelected = drawSelected;
            this.repaintInterior();
        }
    }

    public boolean getDrawRaised() {
        return this._drawRaised;
    }

    public void setDrawRaised(boolean drawRaised) {
        if (drawRaised != this.getDrawRaised()) {
            this._drawRaised = drawRaised;
            this.repaintInterior();
        }
    }

    public void setHeaderSelectionManager(HeaderSelectionManager manager) {
        if (manager == null) {
            manager = GeneralHeaderSelectionManager.getNullHeaderSelectionManager();
        }
        if (manager != this._headerSelection) {
            SelectionListener listen = this._getSelectionListener();
            if (this._headerSelection != null) {
                this._headerSelection.removeVetoableChangeListener(listen);
                this._headerSelection.removePropertyChangeListener(listen);
            }
            HeaderSelectionManager oldManager = this._headerSelection;
            this._headerSelection = manager;
            this._headerSelection.addVetoableChangeListener(listen);
            this._headerSelection.addPropertyChangeListener(listen);
            this.repaintInterior();
            this.firePropertyChange(PROPERTY_SELECTION_MANAGER, oldManager, this._headerSelection);
        }
    }

    public HeaderSelectionManager getHeaderSelectionManager() {
        if (this._headerSelection == null) {
            this.setHeaderSelectionManager(new GeneralHeaderSelectionManager());
        }
        return this._headerSelection;
    }

    public int getOnScreenItemCount() {
        int max;
        int firstItem = this.getFirstItemOnScreen();
        int itemCount = this.getItemCount();
        if (itemCount == 0 || firstItem == -1) {
            return 0;
        }
        Point p = this.getCanvasOrigin();
        Dimension canvasSize = this.getCanvasSize();
        Dimension d = this.getInnerSize();
        int onScreenItemCount = 0;
        p.x = -p.x;
        p.y = -p.y;
        if (this._isHorizontal()) {
            max = p.x + d.width;
            if (max > canvasSize.width) {
                max = canvasSize.width;
            }
        } else {
            max = p.y + d.height;
            if (max > canvasSize.height) {
                max = canvasSize.height;
            }
        }
        GeometryManager gm = this._getGeometryManager();
        for (int i = gm.getItemVisibleIndex(firstItem); i < itemCount; ++i) {
            int temp = gm.visibleIndexToIndex(i);
            if (!gm.isItemVisible(temp)) continue;
            int pos = gm.getItemPosition(temp);
            if (pos >= max) break;
            ++onScreenItemCount;
        }
        return onScreenItemCount;
    }

    private int _getLastItemOnScreen() {
        Point p = this.getCanvasOrigin();
        Dimension d = this.getInnerSize();
        GeometryManager gm = this._getGeometryManager();
        if (this._isHorizontal()) {
            return gm.getItemAt(-p.x + d.width);
        }
        return gm.getItemAt(-p.y + d.height);
    }

    public void setFirstItemOnScreen(int index) {
        GeometryManager gm = this._getGeometryManager();
        if (index < 0 || index >= this.getItemCount() || !gm.isItemVisible(index)) {
            throw new IllegalArgumentException();
        }
        if (this._isHorizontal()) {
            if (this.getCanvasWidth() == 0) {
                this._firstItem = index;
                return;
            }
        } else if (this.getCanvasHeight() == 0) {
            this._firstItem = index;
            return;
        }
        this._firstItem = -1;
        Point origin = this.getCanvasOrigin();
        int offset = -gm.getItemPosition(index);
        if (this._isHorizontal()) {
            this.setCanvasOrigin(offset, origin.y);
        } else {
            this.setCanvasOrigin(origin.x, offset);
        }
    }

    public int getFirstItemOnScreen() {
        GeometryManager gm = this._getGeometryManager();
        if (this._firstItem != -1) {
            return this._firstItem;
        }
        Point p = this.getCanvasOrigin();
        if (this._isHorizontal()) {
            return gm.getItemAt(-p.x);
        }
        return gm.getItemAt(-p.y);
    }

    public boolean getCanResizeItems() {
        return this._canResize;
    }

    public void setCanResizeItems(boolean canResize) {
        this._canResize = canResize;
    }

    public boolean getCanMoveItems() {
        return this._canMove;
    }

    public void setCanMoveItems(boolean canMove) {
        this._canMove = canMove;
    }

    public boolean isItemMovable(int item) {
        if (!this.getCanMoveItems()) {
            return false;
        }
        if (this._notmovable == null) {
            return true;
        }
        Object data = this._notmovable.getData(item);
        return !Boolean.TRUE.equals(data);
    }

    public void setItemMovable(int item, boolean movable) {
        if (this._notmovable == null) {
            this._notmovable = new ArrayOneDModel(this.getItemCount());
        }
        Boolean data = movable ? Boolean.FALSE : Boolean.TRUE;
        this._notmovable.setData(item, data);
    }

    public void setHeaderKeyHandler(HeaderKeyHandler handler) {
        this._keyHandler = handler;
    }

    public HeaderKeyHandler getHeaderKeyHandler() {
        if (this._keyHandler == null) {
            this._keyHandler = StandardHeaderKeyHandler.getHeaderKeyHandler();
        }
        return this._keyHandler;
    }

    public int getFocusItem() {
        return this._focusItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setFocusItem(int item) {
        if (item != this._focusItem) {
            this.freezeRepaints();
            try {
                Integer oldValue = IntegerUtils.getInteger((int)this._focusItem);
                Integer newValue = IntegerUtils.getInteger((int)item);
                try {
                    this.fireVetoableChange(PROPERTY_FOCUS_ITEM, oldValue, newValue);
                }
                catch (PropertyVetoException pve) {
                    boolean bl = false;
                    this.unfreezeRepaints();
                    return bl;
                }
                int oldItem = this._focusItem;
                if (oldItem != -1) {
                    this.paintItem(oldItem);
                }
                this._focusItem = item;
                if (this._focusItem != -1) {
                    this.paintItem(this._focusItem);
                }
                if (this.getArmedItem() != -1) {
                    this.setArmedItem(-1);
                }
                OneDSelection sel = this.getSelection();
                if (this.getDrawSelectionBorder() && (sel.contains(oldItem) || sel.contains(this._focusItem))) {
                    this._paintSelections(sel, OneDSelection.getEmptySelection());
                }
                this.firePropertyChange(PROPERTY_FOCUS_ITEM, oldValue, newValue);
            }
            finally {
                this.unfreezeRepaints();
            }
        }
        return true;
    }

    @Override
    public void setCanvasSize(int width, int height) {
        int innerWidth;
        int oldCanvasWidth = this.getCanvasSize().width;
        super.setCanvasSize(width, height);
        if (this._isHorizontal() && this.getActualReadingDirection() == 2 && (innerWidth = this.getInnerSize().width) != 0) {
            int canvasWidth = this.getCanvasSize().width;
            Point oldOrigin = this.getCanvasOrigin();
            oldOrigin.x = oldCanvasWidth == 0 ? innerWidth - canvasWidth : (oldOrigin.x += oldCanvasWidth - canvasWidth);
            this.setCanvasOrigin(oldOrigin.x, oldOrigin.y);
        }
    }

    @Override
    public void setCanvasOrigin(int x, int y) {
        int canvasWidth = this.getCanvasSize().width;
        int canvasHeight = this.getCanvasSize().height;
        int innerWidth = this.getInnerSize().width;
        int innerHeight = this.getInnerSize().height;
        if (this._isHorizontal()) {
            if (canvasWidth != 0 && canvasWidth > innerWidth && x + canvasWidth < innerWidth) {
                x = -(canvasWidth - innerWidth);
            }
        } else if (canvasHeight != 0 && canvasHeight > innerHeight && y + canvasHeight < innerHeight) {
            y = -(canvasHeight - innerHeight);
        }
        super.setCanvasOrigin(x, y);
    }

    @Override
    public boolean isHScrollable() {
        return this._isHorizontal();
    }

    @Override
    public boolean isVScrollable() {
        return !this._isHorizontal();
    }

    public void setScrollByItem(boolean byItem) {
        if (byItem != this.getScrollByItem()) {
            this._scrollByItem = byItem;
            this.revalidate();
        }
    }

    public boolean getScrollByItem() {
        return this._scrollByItem;
    }

    public void setItemInputHandler(HeaderItemInputHandler handler) {
        this._inputHandler = handler;
    }

    public HeaderItemInputHandler getItemInputHandler() {
        if (this._inputHandler == null) {
            this._inputHandler = NullInputHandler.getHeaderItemInputHandler();
        }
        return this._inputHandler;
    }

    public void setDefaultPainter(Painter defaultPainter) {
        if (defaultPainter != this._defaultPainter) {
            this._defaultPainter = defaultPainter;
            this.repaintInterior();
        }
    }

    public Painter getDefaultPainter() {
        if (this._defaultPainter == null) {
            this._defaultPainter = (Painter)UIManager.get("Header.DefaultHeaderPainter");
        }
        return this._defaultPainter;
    }

    public Painter getPainter(int item) {
        Object data;
        if (this._painters != null && (data = this._painters.getData(item)) != null) {
            return (Painter)data;
        }
        return this.getDefaultPainter();
    }

    public void setPainter(int item, Painter painter) {
        if (this._painters == null) {
            this._painters = new ArrayOneDModel(this.getItemCount());
        }
        this._painters.setData(item, painter);
    }

    public void setAppearance(Appearance object) {
        this._appearanceObject = object.copy();
        this.repaintInterior();
    }

    public Appearance getAppearance() {
        return this._getAppearance().copy();
    }

    public Appearance getItemAppearance(int item) {
        return this._getItemAppearance(item).copy();
    }

    public void setItemAppearance(int item, Appearance appearance) {
        if (this._itemGraphics == null) {
            this._itemGraphics = new ArrayOneDModel(this.getItemCount());
        }
        this._itemGraphics.setData(item, appearance.copy());
    }

    public boolean isItemOnScreen(int item) {
        GeometryManager gm = this._getGeometryManager();
        if (!gm.isItemVisible(item)) {
            return false;
        }
        Point p = this.getCanvasOrigin();
        Dimension d = this.getInnerSize();
        int pos = gm.getItemPosition(item);
        int size = gm.getItemSize(item);
        p.x = -p.x;
        p.y = -p.y;
        if (this._isHorizontal()) {
            return pos + size >= p.x && pos < p.x + d.width;
        }
        return pos + size >= p.y && pos < p.y + d.height;
    }

    public final int getItemAt(int x, int y) {
        Point p = this.convertOuterToCanvas(x, y);
        int temp = this._isHorizontal() ? p.x : p.y;
        return this._getGeometryManager().getItemAt(temp);
    }

    public int getPreferredHeaderSize() {
        Font font;
        if (this._prefSize == -1 && (font = this.getFont()) != null) {
            FontMetrics fm = this.getFontMetrics(font);
            this._prefSize = this._isHorizontal() ? fm.getHeight() + 4 : fm.stringWidth("eeeee");
        }
        return this._prefSize;
    }

    public void setPreferredHeaderSize(int size) {
        if (this._prefSize != size) {
            this._prefSize = size;
            this.revalidate();
        }
    }

    private int _getDefaultItemSize() {
        FontMetrics fm;
        Font f = this.getFont();
        if (f != null && (fm = this.getFontMetrics(f)) != null) {
            return this._isHorizontal() ? fm.stringWidth("eeeee") : fm.getHeight() + 4;
        }
        return -1;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        GeometryManager gm = this._getGeometryManager();
        if (gm.getDefaultItemSize() != 0) {
            return;
        }
        int size = this._getDefaultItemSize();
        if (size != -1) {
            gm.setDefaultItemSize(size);
        }
    }

    @Override
    public void removeNotify() {
        AutoScroller.getAutoScroller().cancel(this);
        SelectionAutoScroller.getSelectionAutoScroller().cancel(this);
        super.removeNotify();
    }

    public void paintItem(int index) {
        if (index >= this.getItemCount()) {
            return;
        }
        GeometryManager gm = this._getGeometryManager();
        if (!gm.isItemVisible(index)) {
            return;
        }
        this.validate();
        int pos = gm.getItemPosition(index);
        int size = gm.getItemSize(index);
        Dimension d = this.getInnerSize();
        if (this._isHorizontal()) {
            this.paintImmediateCanvas(pos, 0, size, d.height);
        } else {
            this.paintImmediateCanvas(0, pos, d.width, size);
        }
    }

    @Override
    public boolean isFocusTraversable() {
        return true;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        Dimension dummy = this._calculateCanvasSize();
        int prefWidth = 0;
        int prefHeight = 0;
        GeometryManager gm = this._getGeometryManager();
        int items = gm.getVisibleItemCount();
        int size = gm.getTotalSize();
        int prefSize = size == 0 ? gm.getDefaultItemSize() : size;
        if (this._isHorizontal()) {
            prefWidth = prefSize;
            prefHeight = this.getPreferredHeaderSize();
        } else {
            prefWidth = this.getPreferredHeaderSize();
            prefHeight = prefSize;
        }
        return this.convertInnerToOuterSize(prefWidth, prefHeight);
    }

    @Override
    public Dimension getMinimumSize() {
        this.validate();
        int minWidth = 0;
        int minHeight = 0;
        GeometryManager gm = this._getGeometryManager();
        int items = gm.getVisibleItemCount();
        int size = gm.getTotalSize();
        int minSize = items == 0 ? gm.getDefaultItemSize() : size / items;
        Font font = this.getFont();
        if (font != null) {
            FontMetrics fm = this.getFontMetrics(font);
            if (this._isHorizontal()) {
                minHeight = fm.getHeight() + 4;
            } else {
                minWidth = fm.stringWidth("eeeee");
            }
        }
        if (this._isHorizontal()) {
            minWidth = minSize;
        } else {
            minHeight = minSize;
        }
        return this.convertInnerToOuterSize(minWidth, minHeight);
    }

    public OneDModel getModel() {
        return this._ds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setModel(OneDModel model) {
        OneDModel oldDS;
        if (model == null) {
            model = EmptyOneDModel.getOneDModel();
        }
        if (model != (oldDS = this.getModel())) {
            this.freezeRepaints();
            try {
                try {
                    this.deselectAll();
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
                if (oldDS != null) {
                    oldDS.removeModelListener(this._dsListener);
                }
                model.addModelListener(this._dsListener);
                this._ds = model;
                GeometryManager gm = this._getGeometryManager();
                gm.resetAll(this._ds.getItemCount());
                this._itemGraphics = null;
                this._painters = null;
                this._notmovable = null;
                this._mouseItem = -1;
                this._moveItem = -1;
                this._anchorItem = -1;
                this.setArmedItem(-1);
                this.setFocusItem(-1);
                this._firstItem = Math.min(this._firstItem, this.getItemCount() - 1);
                this.firePropertyChange(PROPERTY_MODEL, oldDS, this._ds);
            }
            finally {
                this.unfreezeRepaints();
            }
            this.invalidateCanvas();
        }
    }

    public void setSelection(OneDSelection selection) throws PropertyVetoException {
        this.getHeaderSelectionManager().setSelection(selection, -1);
    }

    public OneDSelection getSelection() {
        return this.getHeaderSelectionManager().getSelection();
    }

    public void selectAll() throws PropertyVetoException {
        int item1 = this.getNextVisibleItem(-1);
        int item2 = this.getPreviousVisibleItem(this.getItemCount());
        GeometryManager gm = this.getGeometryManager();
        OneDSelection sel = this._newModelRangeSelection(item1, item2);
        this.setSelection(sel);
    }

    public void deselectAll() throws PropertyVetoException {
        this.setSelection(OneDSelection.getEmptySelection());
    }

    public void setGeometryManager(GeometryManager geometryManager) {
        if (geometryManager == null) {
            throw new NullPointerException();
        }
        GeometryListener gml = this._getGeometryChangeListener();
        if (this._gm != null) {
            this._gm.removeGeometryListener(gml);
        }
        if (this._isHorizontal() && this.getActualReadingDirection() == 2) {
            geometryManager = new ReversedGeometryManager(geometryManager);
        }
        GeometryManager oldGM = this._gm;
        this._gm = geometryManager;
        this._gm.resetAll(this.getItemCount());
        this._gm.addGeometryListener(gml);
        this.firePropertyChange(PROPERTY_GEOMETRY_MANAGER, oldGM, this._gm);
    }

    public GeometryManager getGeometryManager() {
        GeometryManager gm = this._getGeometryManager();
        if (gm instanceof ReversedGeometryManager) {
            return ((ReversedGeometryManager)gm).getWrappedGeometryManager();
        }
        return gm;
    }

    public final void setDefaultItemSize(int size) {
        this._getGeometryManager().setDefaultItemSize(size);
    }

    public final int getDefaultItemSize() {
        return this._getGeometryManager().getDefaultItemSize();
    }

    public final void setItemSize(int modelIndex, int size) {
        this._getGeometryManager().setItemSize(modelIndex, size);
    }

    public final int getItemSize(int modelIndex) {
        return this._getGeometryManager().getItemSize(modelIndex);
    }

    public final boolean isItemResizable(int modelIndex) {
        return this._getGeometryManager().isItemResizable(modelIndex);
    }

    public final void setItemVisibleIndex(int modelIndex, int visibleIndex) {
        this._getGeometryManager().setItemVisibleIndex(modelIndex, visibleIndex);
    }

    public final int getItemVisibleIndex(int modelIndex) {
        return this._getGeometryManager().getItemVisibleIndex(modelIndex);
    }

    public final void setItemVisible(int modelIndex, boolean visible) {
        this._getGeometryManager().setItemVisible(modelIndex, visible);
    }

    public final boolean isItemVisible(int modelIndex) {
        return this._getGeometryManager().isItemVisible(modelIndex);
    }

    public final int getItemPosition(int modelIndex) {
        return this._getGeometryManager().getItemPosition(modelIndex);
    }

    private GeometryManager _getGeometryManager() {
        if (this._gm == null) {
            GeneralGeometryManager gm = new GeneralGeometryManager();
            int itemSize = this._getDefaultItemSize();
            if (itemSize != -1) {
                gm.setDefaultItemSize(itemSize);
            }
            this.setGeometryManager(gm);
        }
        return this._gm;
    }

    @Override
    public void updateUI() {
        if (this._appearanceObject instanceof UIResource) {
            this._appearanceObject = null;
        }
        this.setUI((EWTHeaderUI)UIManager.getUI(this));
    }

    public PaintContext getItemPaintContext(int item) {
        return new ItemPaintContext(this.getPaintContext(), item);
    }

    @Override
    public void printPage(PaintContext context, Dictionary printProperties, Graphics g) {
        boolean showFocus = PrinterUtils.getPrinterProperty(printProperties, DISPLAY_FOCUS_ITEM, true);
        boolean oldValue = this.getDrawSelectionBorder();
        this._setDrawSelectionBorder(PrinterUtils.getPrinterProperty(printProperties, DISPLAY_SELECTION_BORDER, false), false);
        if (context == null) {
            context = this.getPrintPaintContext(g);
        }
        this._paintHeader(g, context, showFocus);
        this._setDrawSelectionBorder(oldValue, false);
    }

    public void setArmedItem(int armedItem) {
        if (this._armedItem != armedItem) {
            if (this._armedItem != -1) {
                int temp = this._armedItem;
                this._armedItem = -1;
                this._repaintIfNeeded(temp);
            }
            this._armedItem = armedItem;
            if (this._armedItem != -1) {
                this._repaintIfNeeded(this._armedItem);
            }
        }
    }

    public int getArmedItem() {
        return this._armedItem;
    }

    public AccessibleHeader getAccessibleHeader() {
        return (AccessibleHeader)this.accessibleContext;
    }

    @Override
    protected Object getPaintData(Object key) {
        if (KEY_DRAW_RAISED.equals(key)) {
            return this.getDrawRaised() ? Boolean.TRUE : Boolean.FALSE;
        }
        if (KEY_HEADER_ITEM_BORDER_COLOR.equals(key)) {
            return this.getHeaderItemBorderColor();
        }
        return super.getPaintData(key);
    }

    protected Object getItemPaintData(int item, Object key) {
        return null;
    }

    protected int getItemPaintState(int baseState, int item) {
        return baseState;
    }

    @Override
    public EWTHeaderUI getUI() {
        return (EWTHeaderUI)this.ui;
    }

    @Override
    protected void processEventImpl(AWTEvent e) {
        if (e instanceof HeaderEvent) {
            switch (e.getID()) {
                case 2005: 
                case 2006: {
                    this.processResizeEvent((HeaderEvent)e);
                    break;
                }
                case 2007: 
                case 2008: {
                    this.processMoveEvent((HeaderEvent)e);
                }
            }
        } else {
            super.processEventImpl(e);
        }
    }

    protected void processResizeEvent(HeaderEvent e) {
        if (this._resizeListeners == null) {
            return;
        }
        Enumeration enumer = this._resizeListeners.getListeners();
        if (enumer == null) {
            return;
        }
        switch (e.getID()) {
            case 2005: {
                while (enumer.hasMoreElements()) {
                    ((HeaderResizeListener)enumer.nextElement()).itemResizing(e);
                }
                break;
            }
            case 2006: {
                while (enumer.hasMoreElements()) {
                    ((HeaderResizeListener)enumer.nextElement()).itemResized(e);
                }
                break;
            }
        }
    }

    protected void processMoveEvent(HeaderEvent e) {
        int id = e.getID();
        if (this._moveListeners == null) {
            return;
        }
        Enumeration enumer = this._moveListeners.getListeners();
        if (enumer == null) {
            return;
        }
        switch (e.getID()) {
            case 2007: {
                while (enumer.hasMoreElements()) {
                    ((HeaderMoveListener)enumer.nextElement()).itemMoving(e);
                }
                break;
            }
            case 2008: {
                while (enumer.hasMoreElements()) {
                    ((HeaderMoveListener)enumer.nextElement()).itemMoved(e);
                }
                break;
            }
        }
    }

    @Override
    protected void processComponentKeyEvent(KeyEvent e) {
        super.processComponentKeyEvent(e);
        if (e.isConsumed() || !this.isEnabled()) {
            return;
        }
        HeaderKeyHandler handler = this.getHeaderKeyHandler();
        handler.handleKeyEvent(this, e);
    }

    @Override
    protected void processFocusEvent(FocusEvent e) {
        super.processFocusEvent(e);
        int id = e.getID();
        if (id == 1004) {
            if (this.getFocusItem() != -1) {
                this._fireActiveEvent(-1, this.getFocusItem());
            } else {
                int item = this.getNextVisibleItem(-1);
                this.setFocusItem(item);
            }
        } else if (id == 1005) {
            this.setArmedItem(-1);
        }
        if (this.getFocusItem() != -1) {
            this.paintItem(this.getFocusItem());
        }
        if (this.getDrawSelectionBorder()) {
            this._paintSelections(this.getSelection(), OneDSelection.getEmptySelection());
        }
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        super.processMouseEvent(e);
        if (e.isConsumed()) {
            if (e.getID() == 502) {
                AutoScroller.getAutoScroller().cancel();
                SelectionAutoScroller.getSelectionAutoScroller().cancel();
                Mover.getMover().cancel(this);
                this._resetFeedback();
                this._state = '\u0000';
                this._resizeOffset = 0;
                this.resetCursor();
                this.setArmedItem(-1);
            }
            return;
        }
        if (!this.isEnabled() || this.getItemCount() == 0) {
            return;
        }
        switch (e.getID()) {
            case 501: {
                this._handleMousePressed(e);
                break;
            }
            case 502: {
                AutoScroller.getAutoScroller().cancel();
                SelectionAutoScroller.getSelectionAutoScroller().cancel();
                this._handleMouseReleased(e);
                break;
            }
            case 500: {
                this._handleMouseClicked(e);
                break;
            }
            case 504: {
                this._handleMouseEntered(e);
                break;
            }
            case 505: {
                this._handleMouseExited(e);
            }
        }
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent e) {
        super.processMouseMotionEvent(e);
        if (e.isConsumed() || !this.isEnabled() || this.getItemCount() == 0) {
            Mover.getMover().cancel(this);
            return;
        }
        switch (e.getID()) {
            case 506: {
                this._handleMouseDragged(e);
                break;
            }
            case 503: {
                this._handleMouseMoved(e);
            }
        }
    }

    @Override
    public void reshape(int x, int y, int width, int height) {
        int oldInnerWidth = this.getInnerSize().width;
        if (width < 0) {
            width = 0;
        }
        if (height < 0) {
            height = 0;
        }
        boolean changed = width != this.getWidth() || height != this.getHeight();
        super.reshape(x, y, width, height);
        if (!changed) {
            return;
        }
        Dimension d = this.getCanvasSize();
        this.setCanvasSize(d.width, d.height);
        this._checkForFirstItem(d);
        if (this._isHorizontal() && this.getActualReadingDirection() == 2) {
            int canvasWidth = d.width;
            int innerWidth = this.getInnerSize().width;
            Point canvasOrigin = this.getCanvasOrigin();
            int newOriginX = canvasOrigin.x;
            if (oldInnerWidth <= 0) {
                newOriginX = innerWidth - canvasWidth;
            } else if (oldInnerWidth != innerWidth && (newOriginX = canvasOrigin.x + innerWidth - oldInnerWidth) > 0) {
                if (canvasWidth > innerWidth) {
                    newOriginX = 0;
                } else if (newOriginX + canvasWidth > innerWidth) {
                    newOriginX = innerWidth - canvasWidth;
                }
            }
            this.setCanvasOrigin(newOriginX, canvasOrigin.y);
        }
        GeometryManager gm = this._getGeometryManager();
        if (this._isHorizontal()) {
            gm.setTotalSize(width);
        } else {
            gm.setTotalSize(height);
        }
    }

    @Override
    protected int getHMaximum() {
        if (this._isHorizontal()) {
            if (!this.getScrollByItem()) {
                return super.getHMaximum();
            }
            return this._getGeometryManager().getVisibleItemCount();
        }
        return 0;
    }

    @Override
    protected int getHValueOfOffset(int x) {
        if (this._isHorizontal()) {
            if (!this.getScrollByItem()) {
                return super.getHValueOfOffset(x);
            }
            GeometryManager gm = this._gm;
            int temp = gm.getItemAt(-x);
            int visIndex = gm.getItemVisibleIndex(temp);
            if (temp >= 0 && gm.getItemPosition(temp) < -x) {
                ++visIndex;
            }
            return visIndex;
        }
        return 0;
    }

    @Override
    protected int getHOffsetOfValue(int value) {
        if (this._isHorizontal()) {
            if (!this.getScrollByItem()) {
                return super.getHOffsetOfValue(value);
            }
            int temp = this._convertVisibleIndexToIndex(value);
            GeometryManager gm = this._getGeometryManager();
            temp = gm.visibleIndexToIndex(temp);
            int offset = gm.getItemPosition(temp);
            int canvasWidth = this.getCanvasSize().width;
            int innerWidth = this.getInnerSize().width;
            int minimumOffset = 0;
            if (canvasWidth > innerWidth && canvasWidth != 0 && innerWidth != 0) {
                minimumOffset = innerWidth - canvasWidth + 1;
            }
            if (-offset < minimumOffset) {
                offset = -minimumOffset;
            }
            return -offset;
        }
        return 0;
    }

    @Override
    protected int getVMaximum() {
        if (!this._isHorizontal()) {
            if (!this.getScrollByItem()) {
                return super.getVMaximum();
            }
            return this._getGeometryManager().getVisibleItemCount();
        }
        return 0;
    }

    @Override
    protected int getVValueOfOffset(int y) {
        if (!this._isHorizontal()) {
            if (!this.getScrollByItem()) {
                return super.getVValueOfOffset(y);
            }
            GeometryManager gm = this._getGeometryManager();
            int temp = gm.getItemAt(-y);
            return gm.getItemVisibleIndex(temp);
        }
        return 0;
    }

    @Override
    protected int getVOffsetOfValue(int value) {
        if (!this._isHorizontal()) {
            if (!this.getScrollByItem()) {
                return super.getVOffsetOfValue(value);
            }
            GeometryManager gm = this._getGeometryManager();
            int temp = this._convertVisibleIndexToIndex(value);
            temp = gm.visibleIndexToIndex(temp);
            int offset = gm.getItemPosition(temp);
            return -offset;
        }
        return 0;
    }

    @Override
    protected Dimension layoutCanvas() {
        Dimension d = this._calculateCanvasSize();
        if (this._state != '\u0004') {
            this._checkForFirstItem(d);
        }
        return d;
    }

    protected void paintExtraCanvas(Graphics g, PaintContext context, int x, int y, int width, int height) {
        g.setColor(this.getAppearance().getBackground());
        g.fillRect(x, y, width, height);
        g.setColor(Color.black);
        EWTHeaderUI ui = this.getUI();
        Painter frame = ui.getExtraCanvasPainter(this);
        frame.paint(context, g, x, y, width, height);
    }

    @Override
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    protected void fireVetoableChange(String propertyName, Object oldValue, Object newValue) throws PropertyVetoException {
        super.fireVetoableChange(propertyName, oldValue, newValue);
    }

    @Override
    protected void paintCanvasInterior(Graphics g) {
        this._paintHeader(g, this.getPaintContext(), true);
    }

    protected void setMoveCursor() {
        if (!this.getCanMoveItems() || this._state == '\u0001' || this._state == '\u0004') {
            return;
        }
        Cursor newCursor = Cursor.getPredefinedCursor(13);
        Cursor oldCursor = this.getCursor();
        if (oldCursor != newCursor) {
            this.setCursor(newCursor);
        }
    }

    protected void setResizeCursor() {
        if (this._state == '\u0002') {
            return;
        }
        Cursor newCursor = this._isHorizontal() ? Cursor.getPredefinedCursor(10) : Cursor.getPredefinedCursor(9);
        Cursor oldCursor = this.getCursor();
        if (oldCursor != newCursor) {
            this.setCursor(newCursor);
        }
    }

    protected void resetCursor() {
        if (this._state == '\u0001' || this._state == '\u0004' || this._state == '\u0002') {
            return;
        }
        Cursor newCursor = Cursor.getDefaultCursor();
        Cursor oldCursor = this.getCursor();
        if (oldCursor != newCursor) {
            this.setCursor(newCursor);
        }
    }

    protected void scrollItemIntoView(int item) {
        if (this._isItemCompletelyOnScreen(item)) {
            return;
        }
        GeometryManager gm = this._getGeometryManager();
        int newItem = -1;
        int visibleIndex = gm.getItemVisibleIndex(item);
        int firstItem = this.getFirstItemOnScreen();
        int lastItem = (firstItem = gm.getItemVisibleIndex(firstItem)) + this.getOnScreenItemCount() - 1;
        if (lastItem >= this.getItemCount()) {
            lastItem = this.getItemCount() - 1;
        }
        lastItem = gm.getItemVisibleIndex(lastItem);
        if (visibleIndex < firstItem) {
            newItem = item;
        } else if (visibleIndex >= lastItem) {
            int i;
            Dimension d = this.getInnerSize();
            int screenSize = this._isHorizontal() ? d.width : d.height;
            for (i = visibleIndex; i >= 0; --i) {
                int temp = gm.visibleIndexToIndex(i);
                if (!gm.isItemVisible(temp) || (screenSize -= gm.getItemSize(temp)) >= 0) continue;
                ++i;
                break;
            }
            if (i < 0) {
                i = 0;
            }
            newItem = i = gm.visibleIndexToIndex(i);
        }
        if (newItem == -1) {
            return;
        }
        this.setFirstItemOnScreen(newItem);
    }

    public int getPreviousVisibleItem(int index) {
        GeometryManager gm = this._getGeometryManager();
        int visibleIndex = index < this.getItemCount() ? gm.getItemVisibleIndex(index) : index;
        int i = visibleIndex - 1;
        if (i < 0) {
            return -1;
        }
        while (i >= 0) {
            int modelIndex = gm.visibleIndexToIndex(i);
            if (gm.isItemVisible(modelIndex)) {
                return modelIndex;
            }
            --i;
        }
        return -1;
    }

    public int getNextVisibleItem(int index) {
        GeometryManager gm = this._getGeometryManager();
        int visibleIndex = index >= 0 ? gm.getItemVisibleIndex(index) : index;
        int columns = this.getItemCount();
        for (int i = visibleIndex + 1; i < columns; ++i) {
            int modelIndex = gm.visibleIndexToIndex(i);
            if (!gm.isItemVisible(modelIndex)) continue;
            return modelIndex;
        }
        return -1;
    }

    public final void fireEvent(int id, int item) {
        HeaderEvent event = new HeaderEvent(this, id, item);
        this.processEvent(event);
    }

    public final boolean fireCancelableEvent(int id, int item) {
        HeaderValidateEvent event = new HeaderValidateEvent(this, id, item);
        this.processEvent(event);
        return event.isCancelled();
    }

    public void setAlwaysDrawFocusItemHighlite(boolean always) {
        if (this.isAlwaysDrawFocusItemHighlite() != always) {
            this._alwaysDrawFocusItemHighlite = always;
            if (this._focusItem != -1) {
                this.paintItem(this._focusItem);
            }
        }
    }

    public boolean isAlwaysDrawFocusItemHighlite() {
        return this._alwaysDrawFocusItemHighlite;
    }

    public void setDrawSelectionBorder(boolean draw) {
        this._setDrawSelectionBorder(draw, true);
    }

    public boolean getDrawSelectionBorder() {
        return this._drawSelectionBorder;
    }

    public void setSelectionTransparent(boolean transparent) {
        if (transparent != this._selectionTransparent) {
            this._selectionTransparent = transparent;
            this._paintSelections(this.getSelection(), OneDSelection.getEmptySelection());
        }
    }

    public boolean isSelectionTransparent() {
        return this._selectionTransparent;
    }

    void internalItemsAdded(OneDModelEvent e) {
        boolean repaint;
        OneDModelListener oddl;
        int start = e.getStartIndex();
        int number = e.getItemCount();
        HeaderSelectionManager sm = this.getHeaderSelectionManager();
        if (sm != null && (oddl = sm.getOneDModelListener()) != null) {
            this._ignoreSelectionRepaints = true;
            oddl.itemsAdded(e);
            this._ignoreSelectionRepaints = false;
        }
        if (this._gm != null && (oddl = this._gm.getOneDModelListener()) != null) {
            oddl.itemsAdded(new OneDModelEvent(this, 2001, start, number));
        }
        if (this._itemGraphics != null) {
            this._itemGraphics.addItems(start, number);
        }
        if (this._painters != null) {
            this._painters.addItems(start, number);
        }
        if (this._notmovable != null) {
            this._notmovable.addItems(start, number);
        }
        Dimension d = this.layoutCanvas();
        this.setCanvasSize(d.width, d.height);
        int temp = start;
        if (temp == this.getItemCount()) {
            --temp;
        }
        if (repaint = this.isItemOnScreen(temp)) {
            this.repaintInterior();
        }
    }

    void internalItemsRemoved(OneDModelEvent e) {
        OneDModelListener oddl;
        int start = e.getStartIndex();
        int number = e.getItemCount();
        int firstIndex = this.getFirstItemOnScreen();
        int lastIndex = firstIndex + this.getOnScreenItemCount();
        boolean repaint = false;
        if (start >= firstIndex && start <= lastIndex) {
            repaint = true;
        } else if (start < firstIndex && start + number > start) {
            repaint = true;
        }
        HeaderSelectionManager sm = this.getHeaderSelectionManager();
        if (sm != null && (oddl = sm.getOneDModelListener()) != null) {
            this._ignoreSelectionRepaints = true;
            oddl.itemsRemoved(e);
            this._ignoreSelectionRepaints = false;
        }
        if (this._gm != null && (oddl = this._gm.getOneDModelListener()) != null) {
            oddl.itemsRemoved(new OneDModelEvent(this, 2002, start, number));
        }
        this._anchorItem = -1;
        this._armedItem = -1;
        this._moveItem = -1;
        this._mouseItem = -1;
        if (this._itemGraphics != null) {
            this._itemGraphics.removeItems(start, number);
        }
        if (this._painters != null) {
            this._painters.removeItems(start, number);
        }
        if (this._notmovable != null) {
            this._notmovable.removeItems(start, number);
        }
        Dimension d = this.layoutCanvas();
        this.setCanvasSize(d.width, d.height);
        if (repaint) {
            this.repaintInterior();
        }
    }

    void internalInvalidateItems(OneDModelEvent e) {
        int height;
        int width;
        int y;
        int x;
        int startItem = e.getStartIndex();
        int endItem = startItem + e.getItemCount() - 1;
        Dimension d = this.getInnerSize();
        GeometryManager gm = this._getGeometryManager();
        if (this._isHorizontal()) {
            x = gm.getItemPosition(startItem);
            y = 0;
            width = gm.getItemPosition(endItem) + gm.getItemSize(endItem);
            height = d.height;
        } else {
            x = 0;
            y = gm.getItemPosition(startItem);
            width = d.width;
            height = gm.getItemPosition(endItem) + gm.getItemSize(endItem);
        }
        this.repaintCanvas(x, y, width, height);
    }

    int getAnchorItem() {
        return this._anchorItem;
    }

    void setAnchorItem(int item) {
        this._anchorItem = item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void growItemSelection(int item) {
        if (this._mouseItem == -1) {
            return;
        }
        try {
            this.freezeRepaints();
            HeaderSelectionManager sm = this.getHeaderSelectionManager();
            try {
                GeometryManager gm = this.getGeometryManager();
                OneDSelection sel = this._newModelRangeSelection(this._mouseItem, item);
                sm.setSelection(sel, item);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
        finally {
            this.unfreezeRepaints();
        }
    }

    void startMoving(int item, int point) {
        if (this.isItemMovable(item) && !this.fireCancelableEvent(2007, item)) {
            this._state = (char)2;
            this._outlineOffset = point - this._getGeometryManager().getItemPosition(item);
            this._outlinePosition = point;
            this.setMoveCursor();
            this.paintImmediateInterior();
        }
    }

    boolean _isHorizontal() {
        return this.getOrientation() == 0;
    }

    private void _setDrawSelectionBorder(boolean draw, boolean requestPaint) {
        if (draw != this._drawSelectionBorder) {
            this._drawSelectionBorder = draw;
            if (requestPaint) {
                this._paintSelections(this.getSelection(), OneDSelection.getEmptySelection());
            }
        }
    }

    private void _paintFocusItemOrSelectionBorder(PaintContext context, Graphics g, boolean paintFocusItem) {
        if (this.hasFocus() || this.isAlwaysDrawFocusItemHighlite()) {
            boolean selPaint = false;
            if (this.getDrawSelectionBorder()) {
                int focusItem = this.getFocusItem();
                OneDSelection sel = this.getSelection();
                if (focusItem == -1 || sel.contains(focusItem)) {
                    selPaint = this._paintSelectionBorder(context, g);
                }
            }
            if (!selPaint && paintFocusItem) {
                this.paintFocusItem(context, g);
            }
        }
    }

    private boolean _paintSelectionBorder(PaintContext context, Graphics g) {
        Rectangle selBounds = this._getSelectionBounds();
        if (selBounds == null) {
            return false;
        }
        this._paintBorderAroundItems(context, g, selBounds);
        return true;
    }

    private Rectangle _getSelectionBounds() {
        OneDSelection sel = this.getSelection();
        if (sel == null || sel.isEmpty()) {
            return null;
        }
        int min = -1;
        int max = -1;
        GeometryManager gm = this._getGeometryManager();
        Range[] ranges = sel.getRanges();
        if (ranges != null && ranges.length != 0) {
            ranges = gm.rangesToVisibleRanges(ranges);
            for (int i = 0; i < ranges.length; ++i) {
                min = min == -1 ? ranges[i].getLowerLimit() : Math.min(min, ranges[i].getLowerLimit());
                max = max == -1 ? ranges[i].getUpperLimit() : Math.max(max, ranges[i].getUpperLimit());
            }
            Range[] result = new Range[]{new Range(min, max)};
            if (!Range.rangesContain((Range[])ranges, (Range[])result)) {
                max = -1;
                min = -1;
            }
        }
        if (min == -1 || max == -1) {
            return null;
        }
        min = gm.visibleIndexToIndex(min);
        max = gm.visibleIndexToIndex(max);
        Rectangle item1 = this.getCellBoundsForItem(min);
        Rectangle item2 = this.getCellBoundsForItem(max);
        int width = item2.x - item1.x + item2.width;
        int height = item2.y - item1.y + item2.height;
        return new Rectangle(item1.x, item1.y, width, height);
    }

    private void _paintBorderAroundItems(PaintContext context, Graphics g, Rectangle drawRect) {
        EWTHeaderUI ui = this.getUI();
        BorderPainter painter = ui.getFocusItemPainter(this);
        if (painter != null) {
            painter.paint(context, g, drawRect.x, drawRect.y, drawRect.width, drawRect.height);
        }
    }

    private void _paintHeader(Graphics g, PaintContext context, boolean paintFocus) {
        this._paintExtraCanvasBackground(g);
        if (this.getItemCount() == 0) {
            Dimension d = this.getInnerSize();
            this.paintExtraCanvas(g, context, 0, 0, d.width, d.height);
            return;
        }
        if (this._isHorizontal()) {
            this._paintHorizontalHeader(g, context);
        } else {
            this._paintVerticalHeader(g, context);
        }
        this._paintFocusItemOrSelectionBorder(context, g, paintFocus);
        this._drawFeedback(g);
        this._drawOutline(g);
    }

    private void _paintExtraCanvasBackground(Graphics g) {
        Color extraBg = this.getExtraCanvasBackground();
        if (extraBg != null && this.getFill() == null) {
            Color old = g.getColor();
            g.setColor(extraBg);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor(old);
        }
    }

    private Dimension _calculateCanvasSize() {
        GeometryManager gm = this._getGeometryManager();
        Dimension d = new Dimension();
        if (this._isHorizontal()) {
            d.width = gm.getTotalSize();
            d.height = this.getPreferredHeaderSize();
        } else {
            d.width = this.getPreferredHeaderSize();
            d.height = gm.getTotalSize();
        }
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _handleMousePressed(MouseEvent e) {
        int diff;
        this.requestFocus();
        Point p = this.convertOuterToCanvas(e.getX(), e.getY());
        int temp = this._isHorizontal() ? p.x : p.y;
        GeometryManager gm = this._getGeometryManager();
        this._mouseItem = gm.getItemAt(temp);
        if (this._mouseItem == -1) {
            return;
        }
        boolean leftButton = SwingUtilities.isLeftMouseButton(e);
        int resizeItem = this.isResizing(this._mouseItem, temp);
        if (leftButton && resizeItem != -1) {
            this._mouseItem = resizeItem;
            if (!this.fireCancelableEvent(2005, this._mouseItem)) {
                this._state = '\u0001';
                gm.setResizing(true);
                this.setResizeCursor();
                this._resizeOffset = temp - (gm.getItemPosition(resizeItem) + gm.getItemSize(resizeItem));
            } else {
                this._state = (char)3;
                this.resetCursor();
            }
            return;
        }
        if (this._isHorizontal()) {
            diff = -gm.getItemPosition(this._mouseItem);
            e.translatePoint(diff, 0);
        } else {
            diff = -gm.getItemPosition(this._mouseItem);
            e.translatePoint(0, diff);
        }
        this.setFocusItem(this._mouseItem);
        this.getItemInputHandler().mousePressed(e, this, this._mouseItem);
        if (this._isHorizontal()) {
            e.translatePoint(-diff, 0);
        } else {
            e.translatePoint(0, -diff);
        }
        if (e.isConsumed() || !leftButton) {
            this.resetCursor();
            return;
        }
        this.setArmedItem(this._mouseItem);
        Mover.getMover().schedule(this, this._mouseItem, temp);
        try {
            this.freezeRepaints();
            HeaderSelectionManager sm = this.getHeaderSelectionManager();
            if (e.isShiftDown()) {
                if (this.getAnchorItem() == -1) {
                    this.setAnchorItem(this._mouseItem);
                }
                OneDSelection sel = this._newModelRangeSelection(this._mouseItem, this.getAnchorItem());
                if (e.isControlDown()) {
                    sm.addSelection(sel);
                } else {
                    sm.setSelection(sel, -1);
                }
            } else {
                OneDSelection sel = new OneDSelection(this._mouseItem);
                boolean setAnchor = true;
                if (e.isControlDown()) {
                    if (sm.getSelection().contains(this._mouseItem)) {
                        sm.removeSelection(sel);
                    } else {
                        sm.addSelection(sel);
                    }
                } else {
                    sm.setSelection(sel, -1);
                }
                this.setAnchorItem(this._mouseItem);
            }
        }
        catch (PropertyVetoException propertyVetoException) {
        }
        finally {
            this.unfreezeRepaints();
        }
    }

    private void _handleMouseReleased(MouseEvent e) {
        int temp;
        GeometryManager gm = this._getGeometryManager();
        Mover.getMover().cancel(this);
        this._resetFeedback();
        Point p = this.convertOuterToCanvas(e.getX(), e.getY());
        int n = temp = this._isHorizontal() ? p.x : p.y;
        if (this._state == '\u0001') {
            gm.setResizing(false);
            this.fireEvent(2006, this._mouseItem);
        } else if (this._state == '\u0004') {
            gm.setResizing(false);
            this._resizeItemByMouse(e);
            this.fireEvent(2006, this._mouseItem);
        } else if (this._state == '\u0002') {
            int item = gm.getItemAt(temp);
            item = item == -1 ? (temp < 0 ? 0 : this.getItemCount() - 1) : gm.getItemVisibleIndex(item);
            gm.setItemVisibleIndex(this._mouseItem, item);
            this.fireEvent(2008, this._mouseItem);
        }
        if (this._mouseItem != -1) {
            int diff;
            if (this._isHorizontal()) {
                diff = -gm.getItemPosition(this._mouseItem);
                e.translatePoint(diff, 0);
            } else {
                diff = -gm.getItemPosition(this._mouseItem);
                e.translatePoint(0, diff);
            }
            this.getItemInputHandler().mouseReleased(e, this, this._mouseItem);
            if (this._isHorizontal()) {
                e.translatePoint(-diff, 0);
            } else {
                e.translatePoint(0, -diff);
            }
            this.setArmedItem(-1);
            this._mouseItem = -1;
        }
        this._state = '\u0000';
        this._resizeOffset = 0;
        this.resetCursor();
    }

    private void _handleMouseClicked(MouseEvent e) {
        int temp;
        Point p = this.convertOuterToCanvas(e.getX(), e.getY());
        GeometryManager gm = this._getGeometryManager();
        int item = gm.getItemAt(temp = this._isHorizontal() ? p.x : p.y);
        if (item != -1) {
            int diff;
            int resizeItem;
            if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2 && (resizeItem = this.isResizing(item, temp)) != -1) {
                HeaderValidateEvent event = new HeaderValidateEvent(this, 2005, resizeItem, true);
                this.processEvent(event);
                if (!event.isCancelled()) {
                    this.processEvent(new HeaderEvent(this, 2006, resizeItem, true));
                    e.consume();
                    return;
                }
            }
            if (this._isHorizontal()) {
                diff = -gm.getItemPosition(item);
                e.translatePoint(diff, 0);
            } else {
                diff = -gm.getItemPosition(item);
                e.translatePoint(0, diff);
            }
            this.getItemInputHandler().mouseClicked(e, this, item);
            if (this._isHorizontal()) {
                e.translatePoint(-diff, 0);
            } else {
                e.translatePoint(0, -diff);
            }
        }
    }

    private void _handleMouseMoved(MouseEvent e) {
        Point p = this.convertOuterToCanvas(e.getX(), e.getY());
        GeometryManager gm = this._getGeometryManager();
        int temp = this._isHorizontal() ? p.x : p.y;
        int item = gm.getItemAt(temp);
        HeaderItemInputHandler handler = this.getItemInputHandler();
        if (item != this._moveItem) {
            MouseEvent newEvent;
            Point tempPoint;
            if (this._moveItem != -1) {
                tempPoint = this._isHorizontal() ? new Point(p.x - gm.getItemPosition(this._moveItem), p.y) : new Point(p.x, p.y - gm.getItemPosition(this._moveItem));
                newEvent = new MouseEvent(this, 505, e.getWhen(), e.getModifiers(), tempPoint.x, tempPoint.y, e.getClickCount(), e.isPopupTrigger());
                handler.mouseExited(newEvent, this, this._moveItem);
            }
            if (item != -1) {
                tempPoint = this._isHorizontal() ? new Point(p.x - gm.getItemPosition(item), p.y) : new Point(p.x, p.y - gm.getItemPosition(item));
                newEvent = new MouseEvent(this, 504, e.getWhen(), e.getModifiers(), tempPoint.x, tempPoint.y, e.getClickCount(), e.isPopupTrigger());
                handler.mouseEntered(newEvent, this, item);
            }
            this._moveItem = item;
        }
        if (this._moveItem != -1) {
            int diff;
            if (this._isHorizontal()) {
                diff = -gm.getItemPosition(this._moveItem);
                e.translatePoint(diff, 0);
            } else {
                diff = -gm.getItemPosition(this._moveItem);
                e.translatePoint(0, diff);
            }
            handler.mouseMoved(e, this, this._moveItem);
            if (this._isHorizontal()) {
                e.translatePoint(-diff, 0);
            } else {
                e.translatePoint(0, -diff);
            }
        }
        if (this.isResizing(this._moveItem, temp) != -1) {
            this.setResizeCursor();
        } else {
            this.resetCursor();
        }
    }

    private void _handleMouseDragged(MouseEvent e) {
        int diff;
        AutoScroller autoScroller;
        int point;
        if (this._mouseItem == -1) {
            return;
        }
        GeometryManager gm = this._getGeometryManager();
        Point p = this.convertOuterToCanvas(e.getX(), e.getY());
        int temp = this._isHorizontal() ? p.x : p.y;
        if (temp < (point = Mover.getMover().getPoint()) - 3 || temp > point + 3) {
            Mover.getMover().cancel(this);
        }
        int item = this.getItemAt(e.getX(), e.getY());
        boolean leftButton = SwingUtilities.isLeftMouseButton(e);
        if (this._state == '\u0001') {
            this._state = (char)4;
            this._resizeItemByMouse(e);
        } else if (this._state == '\u0004') {
            this._resizeItemByMouse(e);
        } else if (this._state == '\u0002') {
            int newRedraw;
            if (item != -1) {
                newRedraw = gm.getItemPosition(item);
                if (gm.getItemVisibleIndex(item) > gm.getItemVisibleIndex(this._mouseItem)) {
                    newRedraw += gm.getItemSize(item);
                }
            } else {
                int items = this.getPreviousVisibleItem(this.getItemCount());
                newRedraw = gm.getItemPosition(items) + gm.getItemSize(items) + 1;
            }
            if (this._redrawInfo != newRedraw) {
                this._redrawInfo = newRedraw;
            }
            this._outlinePosition = temp;
            this.paintImmediateInterior();
            autoScroller = AutoScroller.getAutoScroller();
            this._checkScroller(autoScroller, e);
        } else if (leftButton) {
            boolean armed = item == this._mouseItem & this.contains(e.getX(), e.getY());
            this.setArmedItem(armed ? this._mouseItem : -1);
        }
        if (this._isHorizontal()) {
            diff = -gm.getItemPosition(this._mouseItem);
            e.translatePoint(diff, 0);
        } else {
            diff = -gm.getItemPosition(this._mouseItem);
            e.translatePoint(0, diff);
        }
        this.getItemInputHandler().mouseDragged(e, this, this._mouseItem);
        if (this._isHorizontal()) {
            e.translatePoint(-diff, 0);
        } else {
            e.translatePoint(0, -diff);
        }
        if (this._state != '\u0000' || item == -1 || e.isConsumed() || e.isControlDown() || e.isShiftDown() || e.isMetaDown()) {
            return;
        }
        HeaderSelectionManager sm = this.getHeaderSelectionManager();
        try {
            sm.setSelection(this._newModelRangeSelection(this._mouseItem, item), item);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        if (!sm.getSelection().isEmpty()) {
            autoScroller = SelectionAutoScroller.getSelectionAutoScroller();
            this._checkScroller(autoScroller, e);
        }
    }

    private OneDSelection _newModelRangeSelection(int modelItem1, int modelItem2) {
        GeometryManager gm = this.getGeometryManager();
        int lo = gm.getItemVisibleIndex(modelItem1);
        int hi = gm.getItemVisibleIndex(modelItem2);
        if (hi < lo) {
            int tmp = hi;
            hi = lo;
            lo = tmp;
        }
        Range[] ranges = new Range[]{new Range(lo, hi)};
        return new OneDSelection(gm.visibleRangesToRanges(ranges));
    }

    private void _repaintIfNeeded(int item) {
        ItemPaintContext context;
        BorderPainter painter = this.getHeaderItemBorderPainter();
        if ((painter.getRepaintFlags(context = new ItemPaintContext(this.getPaintContext(), item)) & 2) != 0) {
            this.paintItem(item);
        }
    }

    private void _checkScroller(AutoScroller autoScroller, MouseEvent e) {
        int max;
        int pointToCheck;
        if (this._isHorizontal()) {
            pointToCheck = e.getX() + this.getCanvasOriginX();
            max = this.getInnerSize().width;
        } else {
            pointToCheck = e.getY() + this.getCanvasOriginY();
            max = this.getInnerSize().height;
        }
        int averageItemSize = this._getGeometryManager().getTotalSize() / this.getItemCount();
        if (pointToCheck < (averageItemSize /= 2)) {
            autoScroller.schedule(this, true);
        } else if (pointToCheck > max - averageItemSize) {
            autoScroller.schedule(this, false);
        } else {
            autoScroller.cancel();
        }
    }

    private void _resizeItemByMouse(MouseEvent e) {
        int item = this._mouseItem;
        GeometryManager gm = this._getGeometryManager();
        Point p = this.convertOuterToCanvas(e.getX(), e.getY());
        int temp = this._isHorizontal() ? p.x : p.y;
        Dimension d = this.getSize();
        int max = this._isHorizontal() ? d.width : d.height;
        int pos = gm.getItemPosition(item);
        int oldSize = gm.getItemSize(item);
        int size = Math.max(temp - pos - this._resizeOffset, 2);
        if (this.getScrollByItem() && size > max && oldSize <= max && gm.getVisibleItemCount() > 1) {
            size = max;
        }
        gm.setItemSize(item, size);
    }

    private void _handleMouseEntered(MouseEvent e) {
        GeometryManager gm = this._getGeometryManager();
        this._moveItem = this.getItemAt(e.getX(), e.getY());
        if (this._moveItem != -1) {
            int diff;
            if (this._isHorizontal()) {
                diff = -gm.getItemPosition(this._moveItem);
                e.translatePoint(diff, 0);
            } else {
                diff = -gm.getItemPosition(this._moveItem);
                e.translatePoint(0, diff);
            }
            this.getItemInputHandler().mouseEntered(e, this, this._moveItem);
            if (this._isHorizontal()) {
                e.translatePoint(-diff, 0);
            } else {
                e.translatePoint(0, -diff);
            }
        }
    }

    private void _handleMouseExited(MouseEvent e) {
        GeometryManager gm = this._getGeometryManager();
        this.resetCursor();
        if (this._moveItem != -1) {
            int diff;
            if (this._isHorizontal()) {
                diff = -gm.getItemPosition(this._moveItem);
                e.translatePoint(diff, 0);
            } else {
                diff = -gm.getItemPosition(this._moveItem);
                e.translatePoint(0, diff);
            }
            this.getItemInputHandler().mouseExited(e, this, this._moveItem);
            if (this._isHorizontal()) {
                e.translatePoint(diff, 0);
            } else {
                e.translatePoint(0, diff);
            }
        }
    }

    private int _convertVisibleIndexToIndex(int index) {
        GeometryManager gm = this._getGeometryManager();
        if (gm.getVisibleItemCount() == this.getItemCount()) {
            return index;
        }
        int i = 0;
        int visibleIndex = -1;
        while (visibleIndex < index) {
            int temp = gm.visibleIndexToIndex(i);
            if (gm.isItemVisible(temp)) {
                ++visibleIndex;
            }
            ++i;
        }
        return i - 1;
    }

    private void _drawOutline(Graphics g) {
        if (this._outlinePosition == -1) {
            return;
        }
        int mouseItem = this._mouseItem;
        if (mouseItem == -1) {
            return;
        }
        Dimension d = this.getInnerSize();
        int size = this._getGeometryManager().getItemSize(mouseItem);
        g.setColor(Color.black);
        if (this._isHorizontal()) {
            g.drawRect(this._outlinePosition - this._outlineOffset + 2, 2, size - 5, d.height - 5);
        } else {
            g.drawRect(2, this._outlinePosition - this._outlineOffset + 2, d.width - 5, size - 5);
        }
    }

    private void _resetFeedback() {
        if (this._redrawInfo != -1) {
            this.repaint();
        }
        this._redrawInfo = -1;
        this._outlineOffset = -1;
        this._outlinePosition = -1;
    }

    private void _drawFeedback(Graphics g) {
        if (this._redrawInfo == -1) {
            return;
        }
        Dimension d = this.getInnerSize();
        g.setColor(Color.black);
        if (this._isHorizontal()) {
            g.fillRect(this._redrawInfo, 0, 4, d.height);
        } else {
            g.fillRect(0, this._redrawInfo, d.width, 4);
        }
    }

    private void _paintVerticalHeader(Graphics g, PaintContext context) {
        int startItem;
        GeometryManager gm = this._getGeometryManager();
        Rectangle drawRect = g.getClipBounds();
        if (drawRect.y < 0) {
            drawRect.height += drawRect.y;
            drawRect.y = 0;
        }
        if ((startItem = gm.getItemAt(drawRect.y)) == -1) {
            this._finishVerticalHeader(g, context, this.getInnerSize());
            return;
        }
        startItem = gm.getItemVisibleIndex(startItem);
        int endItem = gm.getItemAt(drawRect.y + drawRect.height - 1);
        if (endItem == -1) {
            endItem = this.getPreviousVisibleItem(this.getItemCount());
        }
        endItem = gm.getItemVisibleIndex(endItem);
        Dimension d = this.getInnerSize();
        boolean print = g instanceof PrintGraphics || g instanceof PrinterGraphics;
        int canvasStart = print ? 0 : -this.getCanvasOrigin().y;
        Shape oldClip = g.getClip();
        int maxY = drawRect.y + drawRect.height;
        int width = this.getCanvasWidth();
        ItemPaintContext paintContext = new ItemPaintContext(context, 0);
        BorderPainter itemFrame = this.getHeaderItemBorderPainter();
        BorderPainter firstPainter = this.getFirstItemBorderPainter();
        BorderPainter lastPainter = this.getLastItemBorderPainter();
        ImmInsets insets = itemFrame.getInsets(context);
        int firstItemOnScreen = this.getFirstItemOnScreen();
        int lastItemOnScreen = this._getLastItemOnScreen();
        int itemCount = this.getItemCount();
        for (int i = startItem; i <= endItem; ++i) {
            int dsIndex = gm.visibleIndexToIndex(i);
            if (dsIndex < 0 || dsIndex >= itemCount || !gm.isItemVisible(dsIndex)) continue;
            BorderPainter framePainter = dsIndex == firstItemOnScreen ? firstPainter : (dsIndex == lastItemOnScreen ? lastPainter : itemFrame);
            int pos = gm.getItemPosition(dsIndex);
            int size = gm.getItemSize(dsIndex);
            g.setClip(oldClip);
            g.clipRect(0, pos, d.width, size);
            paintContext.setItem(dsIndex);
            Painter painter = this.getPainter(dsIndex);
            g.setColor(paintContext.getPaintBackground());
            g.fillRect(0, pos, d.width, size);
            framePainter.paint(paintContext, g, 0, pos, width, size);
            g.setColor(paintContext.getPaintForeground());
            g.setFont(paintContext.getPaintFont());
            ImmInsets itemInsets = paintContext.getAppearance().getInsets();
            painter.paint(paintContext, g, insets.left + itemInsets.left, pos + insets.top + itemInsets.top, width - insets.left - insets.right - (itemInsets.left + itemInsets.right), size - insets.top - insets.bottom - (itemInsets.top + itemInsets.bottom));
        }
        g.setClip(oldClip);
        this._finishVerticalHeader(g, context, d);
    }

    private void _finishVerticalHeader(Graphics g, PaintContext context, Dimension innerSize) {
        Shape oldClip = g.getClip();
        Dimension canvasSize = this.getCanvasSize();
        int height = canvasSize.height;
        if (height < innerSize.height) {
            g.setClip(oldClip);
            g.clipRect(0, height, innerSize.width, innerSize.height - height);
            this.paintExtraCanvas(g, context, 0, height, innerSize.width, innerSize.height - height);
        } else {
            Point p = this.getCanvasOrigin();
            int canvasOnScreen = canvasSize.height + p.y;
            int extra = innerSize.height - canvasOnScreen;
            if (extra > 0) {
                g.setClip(oldClip);
                g.clipRect(0, height, canvasSize.width, extra);
                this.paintExtraCanvas(g, context, 0, height, innerSize.width, extra);
            }
        }
        g.setClip(oldClip);
    }

    private void _paintHorizontalHeader(Graphics g, PaintContext context) {
        int startItem;
        GeometryManager gm = this._getGeometryManager();
        Rectangle drawRect = g.getClipBounds();
        if (drawRect.x < 0) {
            drawRect.width += drawRect.x;
            drawRect.x = 0;
        }
        if ((startItem = gm.getItemAt(drawRect.x)) == -1) {
            this._finishHorizontalHeader(g, context, this.getInnerSize());
            return;
        }
        startItem = gm.getItemVisibleIndex(startItem);
        int endItem = gm.getItemAt(drawRect.x + drawRect.width - 1);
        if (endItem == -1) {
            endItem = this.getPreviousVisibleItem(this.getItemCount());
        }
        endItem = gm.getItemVisibleIndex(endItem);
        boolean print = g instanceof PrintGraphics || g instanceof PrinterGraphics;
        int canvasStart = print ? 0 : -this.getCanvasOrigin().x;
        Dimension d = this.getInnerSize();
        Shape oldClip = g.getClip();
        int maxX = drawRect.x + drawRect.width;
        int height = this.getCanvasHeight();
        ItemPaintContext paintContext = new ItemPaintContext(context, 0);
        BorderPainter itemFrame = this.getHeaderItemBorderPainter();
        BorderPainter firstPainter = this.getFirstItemBorderPainter();
        BorderPainter lastPainter = this.getLastItemBorderPainter();
        ImmInsets insets = itemFrame.getInsets(context);
        int firstItemOnScreen = this.getFirstItemOnScreen();
        int lastItemOnScreen = this._getLastItemOnScreen();
        int itemCount = this.getItemCount();
        for (int i = startItem; i <= endItem; ++i) {
            int dsIndex = gm.visibleIndexToIndex(i);
            if (dsIndex < 0 || dsIndex >= itemCount || !gm.isItemVisible(dsIndex)) continue;
            BorderPainter framePainter = dsIndex == firstItemOnScreen ? firstPainter : (dsIndex == lastItemOnScreen ? lastPainter : itemFrame);
            int pos = gm.getItemPosition(dsIndex);
            int size = gm.getItemSize(dsIndex);
            g.setClip(oldClip);
            g.clipRect(pos, 0, size, d.height);
            paintContext.setItem(dsIndex);
            Painter painter = this.getPainter(dsIndex);
            g.setColor(paintContext.getPaintBackground());
            g.fillRect(pos, 0, size, d.height);
            framePainter.paint(paintContext, g, pos, 0, size, height);
            g.setColor(paintContext.getPaintForeground());
            g.setFont(paintContext.getPaintFont());
            ImmInsets itemInsets = paintContext.getAppearance().getInsets();
            painter.paint(paintContext, g, pos + insets.left + itemInsets.left, insets.top + itemInsets.top, size - (insets.left + insets.right) - (itemInsets.left + itemInsets.right), height - (insets.top + insets.bottom) - (itemInsets.top + itemInsets.bottom));
        }
        g.setClip(oldClip);
        this._finishHorizontalHeader(g, context, d);
    }

    private void _finishHorizontalHeader(Graphics g, PaintContext context, Dimension innerSize) {
        boolean l2r;
        Shape oldClip = g.getClip();
        Dimension canvasSize = this.getCanvasSize();
        int width = canvasSize.width;
        int height = innerSize.height;
        boolean bl = l2r = this.getActualReadingDirection() == 1;
        if (width < innerSize.width) {
            g.setClip(oldClip);
            int extraX = l2r ? width : width - innerSize.width;
            g.clipRect(extraX, 0, innerSize.width - width, height);
            this.paintExtraCanvas(g, context, extraX, 0, innerSize.width - width, height);
        } else {
            Point p = this.getCanvasOrigin();
            int canvasOnScreen = canvasSize.width + p.x;
            int extra = innerSize.width - canvasOnScreen;
            if (extra > 0) {
                int extraX = l2r ? width : 0;
                g.setClip(oldClip);
                g.clipRect(extraX, 0, extra, height);
                this.paintExtraCanvas(g, context, extraX, 0, extra, height);
            }
        }
        g.setClip(oldClip);
    }

    private Appearance _createAppearance() {
        return (Appearance)UIManager.get("Header.DefaultAppearance");
    }

    private Appearance _getAppearance() {
        if (this._appearanceObject == null) {
            this._appearanceObject = this._createAppearance();
        }
        return this._appearanceObject;
    }

    Appearance _getItemAppearance(int item) {
        Object data;
        if (this._itemGraphics != null && (data = this._itemGraphics.getData(item)) != null) {
            return (Appearance)data;
        }
        return this._getAppearance();
    }

    private int isResizing(int item, int point) {
        int temp = this.pointInResize(item, point);
        if (temp == -1) {
            return -1;
        }
        return this.getCanResizeItems() && this._getGeometryManager().isItemResizable(temp) ? temp : -1;
    }

    private int pointInResize(int item, int point) {
        boolean l2r;
        boolean leftSide;
        int size;
        if (item == -1) {
            return -1;
        }
        GeometryManager gm = this._getGeometryManager();
        int pos = gm.getItemPosition(item);
        boolean rightSide = point >= pos + (size = gm.getItemSize(item)) - 5;
        boolean bl = leftSide = point >= pos && point <= pos + 5;
        if (!rightSide && !leftSide) {
            return -1;
        }
        boolean bl2 = l2r = !this._isHorizontal() || this.getActualReadingDirection() == 1;
        if (rightSide) {
            if (l2r) {
                return item;
            }
            return this.getNextVisibleItem(item);
        }
        if (leftSide) {
            if (l2r) {
                return this.getPreviousVisibleItem(item);
            }
            return item;
        }
        return -1;
    }

    private boolean _isItemCompletelyOnScreen(int item) {
        Point p = this.getCanvasOrigin();
        Dimension d = this.getInnerSize();
        GeometryManager gm = this._getGeometryManager();
        int pos = gm.getItemPosition(item);
        int size = gm.getItemSize(item);
        p.x = -p.x;
        p.y = -p.y;
        if (this._isHorizontal()) {
            return pos >= p.x && (pos + size < p.x + d.width || size > d.width);
        }
        return pos >= p.y && (pos + size < p.y + d.height || size > d.height);
    }

    private void _checkForFirstItem(Dimension d) {
        int index;
        Dimension size = this.getInnerSize();
        GeometryManager gm = this._getGeometryManager();
        if (this._firstItem != -1) {
            if (this._isHorizontal() && d.width != 0 || !this._isHorizontal() && d.height != 0) {
                int offset = -gm.getItemPosition(this._firstItem);
                if (this._isHorizontal()) {
                    this.setCanvasOrigin(offset, this.getCanvasOriginY());
                } else {
                    this.setCanvasOrigin(this.getCanvasOriginX(), offset);
                }
                this._firstItem = -1;
            }
        } else if ((this._isHorizontal() && size.width >= d.width && d.width != 0 || !this._isHorizontal() && size.height >= d.height && d.height != 0) && (index = this.getNextVisibleItem(-1)) != -1) {
            int offset = -gm.getItemPosition(index);
            if (this._isHorizontal()) {
                this.setCanvasOrigin(offset, this.getCanvasOriginY());
            } else {
                this.setCanvasOrigin(this.getCanvasOriginX(), offset);
            }
        }
    }

    protected Rectangle getCellBoundsForItem(int item) {
        Rectangle r = new Rectangle();
        Dimension sz = this.getInnerSize();
        if (this._isHorizontal()) {
            r.x = this.getItemPosition(item);
            r.y = 0;
            r.width = this.getItemSize(item);
            r.height = sz.height;
        } else {
            r.x = 0;
            r.y = this.getItemPosition(item);
            r.width = sz.width;
            r.height = this.getItemSize(item);
        }
        return r;
    }

    private SelectionListener _getSelectionListener() {
        if (this._selectionListener == null) {
            this._selectionListener = new SelectionListener();
        }
        return this._selectionListener;
    }

    private GeometryListener _getGeometryChangeListener() {
        if (this._geometryChangeListener == null) {
            this._geometryChangeListener = new GeometryChangeListener();
        }
        return this._geometryChangeListener;
    }

    private void _paintSelections(OneDSelection oldSelection, OneDSelection newSelection) {
        OneDSelection sel = oldSelection.add(newSelection);
        Range[] ranges = sel.getRanges();
        this._paintRanges(ranges);
    }

    private void _paintRanges(Range[] ranges) {
        if (ranges == null) {
            return;
        }
        GeometryManager gm = this.getGeometryManager();
        ranges = gm.rangesToVisibleRanges(ranges);
        int n = ranges.length;
        for (int i = 0; i < n; ++i) {
            for (int j = ranges[i].getLowerLimit(); j <= ranges[i].getUpperLimit(); ++j) {
                this.paintItem(gm.visibleIndexToIndex(j));
            }
        }
    }

    private void _registerKeyboardActions() {
        this._keyboardListener = new KeyboardActionListener();
        if (this._isHorizontal()) {
            KeyStroke s = KeyStroke.getKeyStroke(37, 10);
            this.registerKeyboardAction(this._keyboardListener, _MOVE_LEFT, s, 0);
            s = KeyStroke.getKeyStroke(39, 10);
            this.registerKeyboardAction(this._keyboardListener, _MOVE_RIGHT, s, 0);
            s = KeyStroke.getKeyStroke(37, 8);
            this.registerKeyboardAction(this._keyboardListener, _RESIZE_LEFT, s, 0);
            s = KeyStroke.getKeyStroke(39, 8);
            this.registerKeyboardAction(this._keyboardListener, _RESIZE_RIGHT, s, 0);
        } else {
            KeyStroke s = KeyStroke.getKeyStroke(38, 10);
            this.registerKeyboardAction(this._keyboardListener, _MOVE_UP, s, 0);
            s = KeyStroke.getKeyStroke(40, 10);
            this.registerKeyboardAction(this._keyboardListener, _MOVE_DOWN, s, 0);
            s = KeyStroke.getKeyStroke(38, 8);
            this.registerKeyboardAction(this._keyboardListener, _RESIZE_UP, s, 0);
            s = KeyStroke.getKeyStroke(40, 8);
            this.registerKeyboardAction(this._keyboardListener, _RESIZE_DOWN, s, 0);
        }
    }

    private void _unregisterKeyboardActions() {
        if (this._isHorizontal()) {
            KeyStroke s = KeyStroke.getKeyStroke(37, 2);
            this.unregisterKeyboardAction(s);
            s = KeyStroke.getKeyStroke(39, 2);
            this.unregisterKeyboardAction(s);
            s = KeyStroke.getKeyStroke(37, 10);
            this.unregisterKeyboardAction(s);
            s = KeyStroke.getKeyStroke(39, 10);
            this.unregisterKeyboardAction(s);
        } else {
            KeyStroke s = KeyStroke.getKeyStroke(38, 2);
            this.unregisterKeyboardAction(s);
            s = KeyStroke.getKeyStroke(40, 2);
            this.unregisterKeyboardAction(s);
            s = KeyStroke.getKeyStroke(38, 10);
            this.unregisterKeyboardAction(s);
            s = KeyStroke.getKeyStroke(40, 10);
            this.unregisterKeyboardAction(s);
        }
    }

    @Override
    public final AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = this.createAccessibleHeader();
        }
        return this.accessibleContext;
    }

    protected AccessibleHeader createAccessibleHeader() {
        return new AccessibleHeader();
    }

    protected void paintFocusItem(PaintContext context, Graphics g) {
        if (this.getFocusItem() != -1 && (this.hasFocus() || this.isAlwaysDrawFocusItemHighlite())) {
            Rectangle drawRect = this.__getItemRect(context, this.getFocusItem());
            if (drawRect == null) {
                return;
            }
            this._paintBorderAroundItems(context, g, drawRect);
        }
    }

    Rectangle __getItemRect(PaintContext context, int index) {
        if (!this.isItemOnScreen(index)) {
            return null;
        }
        Rectangle rect = new Rectangle();
        if (this._isHorizontal()) {
            rect.x = this.getItemPosition(index);
            rect.y = 0;
            rect.width = this.getItemSize(index);
            rect.height = this.getCanvasHeight();
        } else {
            rect.x = 0;
            rect.y = this.getItemPosition(index);
            rect.width = this.getCanvasWidth();
            rect.height = this.getItemSize(index);
        }
        ++rect.x;
        ++rect.y;
        rect.width -= 2;
        rect.height -= 2;
        return rect;
    }

    void _fireActiveEvent(int oldIndex, int newIndex) {
        AccessibleContext ac = this.accessibleContext;
        if (ac != null) {
            ac.firePropertyChange("AccessibleActiveDescendant", ac.getAccessibleChild(oldIndex), ac.getAccessibleChild(newIndex));
        }
    }

    public class AccessibleHeader
    extends JComponent.AccessibleJComponent
    implements AccessibleSelection,
    PropertyChangeListener,
    GeometryListener,
    OneDModelListener {
        public AccessibleHeader() {
            super(Header.this);
            Header.this.addPropertyChangeListener(this);
            Header.this.getModel().addModelListener(this);
            Header.this.getGeometryManager().addGeometryListener(this);
        }

        @Override
        public String getAccessibleName() {
            String parentName;
            AccessibleContext context;
            Accessible parent;
            String name = super.getAccessibleName();
            if (name == null && (parent = this.getAccessibleParent()) != null && (context = parent.getAccessibleContext()) != null && context.getAccessibleRole() == AccessibleRole.TABLE && (parentName = context.getAccessibleName()) != null) {
                ResourceBundle b = ResourceBundle.getBundle(Header._RESOURCE, this.getLocale());
                String text = b.getString(Header.this.getOrientation() == 0 ? Header._COLHEADER : Header._ROWHEADER);
                MessageFormat form = new MessageFormat(text);
                Object[] args = new Object[]{parentName};
                return form.format(args);
            }
            return name;
        }

        public String getAccessibleName(int index) {
            Object data = Header.this.getModel().getData(index);
            String name = this.getAccessibleName(index, data);
            return this.getAccessibleNameForTable(index, data, name);
        }

        public String getAccessibleDescription(int index) {
            HeaderToolTipManager manager = Header.this.getToolTipManager();
            if (manager == null) {
                return null;
            }
            return manager.getItemToolTipValue(Header.this, index);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return Header.this._isHorizontal() ? AccessibleRole.COLUMN_HEADER : AccessibleRole.ROW_HEADER;
        }

        @Override
        public Accessible getAccessibleAt(Point p) {
            int index = Header.this.getItemAt(p.x, p.y);
            return this.getAccessibleChild(index);
        }

        @Override
        public int getAccessibleChildrenCount() {
            return Header.this.getModel() == null ? 0 : Header.this.getItemCount();
        }

        @Override
        public Accessible getAccessibleChild(int i) {
            if (i < 0 || i >= this.getAccessibleChildrenCount()) {
                return null;
            }
            return new AccessibleItem(i);
        }

        @Override
        public AccessibleSelection getAccessibleSelection() {
            return this;
        }

        @Override
        public int getAccessibleSelectionCount() {
            return Header.this.getSelection().getSelectedItemCount();
        }

        @Override
        public Accessible getAccessibleSelection(int i) {
            OneDSelection sel = Header.this.getSelection();
            int n = sel.getSelectedItemAtIndex(i);
            if (n != -1) {
                return this.getAccessibleChild(n);
            }
            return null;
        }

        @Override
        public boolean isAccessibleChildSelected(int i) {
            return Header.this.getSelection().contains(i);
        }

        @Override
        public void addAccessibleSelection(int i) {
            OneDSelection oldSel = Header.this.getSelection();
            try {
                Header.this.setSelection(oldSel.add(i));
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }

        @Override
        public void removeAccessibleSelection(int i) {
            OneDSelection oldSel = Header.this.getSelection();
            try {
                Header.this.setSelection(oldSel.subtract(i));
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }

        @Override
        public void clearAccessibleSelection() {
            try {
                Header.this.deselectAll();
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }

        @Override
        public void selectAllAccessibleSelection() {
            try {
                Header.this.selectAll();
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            Object oldValue = e.getOldValue();
            Object newValue = e.getNewValue();
            if (Header.PROPERTY_MODEL.equals(name)) {
                if (oldValue != null) {
                    ((OneDModel)oldValue).removeModelListener(this);
                }
                if (newValue != null) {
                    ((OneDModel)newValue).addModelListener(this);
                }
            } else if (Header.PROPERTY_GEOMETRY_MANAGER.equals(name)) {
                if (oldValue != null) {
                    ((GeometryManager)oldValue).removeGeometryListener(this);
                }
                if (newValue != null) {
                    ((GeometryManager)newValue).addGeometryListener(this);
                }
            } else if (Header.PROPERTY_SELECTION.equals(name)) {
                this.firePropertyChange("AccessibleSelection", Boolean.TRUE, Boolean.FALSE);
            } else if (Header.PROPERTY_FOCUS_ITEM.equals(name)) {
                int oldIndex = oldValue == null ? -1 : (Integer)oldValue;
                int newIndex = newValue == null ? -1 : (Integer)newValue;
                Header.this._fireActiveEvent(oldIndex, newIndex);
            }
        }

        @Override
        public void itemsAdded(OneDModelEvent e) {
            this.firePropertyChange("AccessibleVisibleData", null, null);
        }

        @Override
        public void itemsRemoved(OneDModelEvent e) {
            this.firePropertyChange("AccessibleVisibleData", null, null);
        }

        @Override
        public void invalidateItems(OneDModelEvent e) {
            this.firePropertyChange("AccessibleVisibleData", null, null);
        }

        @Override
        public void geometryChanged(GeometryEvent e) {
            this.firePropertyChange("AccessibleVisibleData", null, null);
        }

        protected String getAccessibleName(int index, Object data) {
            String name = null;
            name = data == null ? null : (data instanceof String ? (String)data : (data instanceof ImageIcon ? ((ImageIcon)data).getDescription() : (data instanceof Image || data instanceof ImageSet || data instanceof Icon ? this._getTranslatedString(Header._IMAGE) : this._getTranslatedString(Header._UNKNOWN))));
            return name;
        }

        protected String getAccessibleNameForTable(int index, Object data, String itemName) {
            Accessible parent = this.getAccessibleParent();
            if (parent == null) {
                return itemName;
            }
            AccessibleContext ac = parent.getAccessibleContext();
            if (ac.getAccessibleRole() != AccessibleRole.TABLE) {
                return itemName;
            }
            if (itemName == null) {
                itemName = IntegerUtils.getString((int)index);
            }
            String key = Header.this._isHorizontal() ? Header._KEY_COLUMN : Header._KEY_ROW;
            String text = this._getTranslatedString(key);
            MessageFormat form = new MessageFormat(text);
            Object[] args = new Object[]{itemName};
            itemName = form.format(args);
            return itemName;
        }

        private String _getTranslatedString(String key) {
            ResourceBundle b = ResourceBundle.getBundle(Header._RESOURCE, this.getLocale());
            return b.getString(key);
        }

        private class AccessibleItem
        extends AccessibleContext
        implements Accessible,
        AccessibleComponent {
            private int _position;

            public AccessibleItem(int position) {
                this._position = position;
                this.setAccessibleParent(Header.this);
            }

            @Override
            public AccessibleContext getAccessibleContext() {
                return this;
            }

            @Override
            public String getAccessibleName() {
                if (this.accessibleName != null && this.accessibleName != "") {
                    return this.accessibleName;
                }
                return AccessibleHeader.this.getAccessibleName(this._position);
            }

            @Override
            public String getAccessibleDescription() {
                if (this.accessibleDescription != null && this.accessibleDescription != "") {
                    return this.accessibleDescription;
                }
                return AccessibleHeader.this.getAccessibleDescription(this._position);
            }

            @Override
            public AccessibleStateSet getAccessibleStateSet() {
                AccessibleStateSet result = new AccessibleStateSet();
                if (this.isVisible()) {
                    result.add(AccessibleState.VISIBLE);
                    if (this.isShowing()) {
                        result.add(AccessibleState.SHOWING);
                    }
                }
                result.add(AccessibleState.FOCUSABLE);
                if (Header.this.getFocusItem() == this._position) {
                    result.add(AccessibleState.FOCUSED);
                }
                result.add(AccessibleState.TRANSIENT);
                if (Header.this.isEnabled()) {
                    result.add(AccessibleState.ENABLED);
                }
                if (Header.this.isItemResizable(this._position)) {
                    result.add(AccessibleState.RESIZABLE);
                }
                result.add(AccessibleState.SELECTABLE);
                if (Header.this.getSelection().contains(this._position)) {
                    result.add(AccessibleState.SELECTED);
                }
                return result;
            }

            @Override
            public Accessible getAccessibleAt(Point p) {
                return null;
            }

            @Override
            public int getAccessibleIndexInParent() {
                return this._position;
            }

            @Override
            public Accessible getAccessibleChild(int i) {
                return null;
            }

            @Override
            public Locale getLocale() {
                return Header.this.getLocale();
            }

            @Override
            public AccessibleComponent getAccessibleComponent() {
                return this;
            }

            @Override
            public Color getBackground() {
                Color b = Header.this._getItemAppearance(this._position).getBackground();
                if (b == null) {
                    return Header.this.getBackground();
                }
                return b;
            }

            @Override
            public void setBackground(Color c) {
                Appearance app = Header.this.getItemAppearance(this._position);
                app.setBackground(c);
                Header.this.setItemAppearance(this._position, app);
            }

            @Override
            public Font getFont() {
                Font f = Header.this._getItemAppearance(this._position).getFont();
                if (f == null) {
                    return Header.this.getFont();
                }
                return f;
            }

            @Override
            public void setFont(Font f) {
                Appearance app = Header.this.getItemAppearance(this._position);
                app.setFont(f);
                Header.this.setItemAppearance(this._position, app);
            }

            @Override
            public FontMetrics getFontMetrics(Font f) {
                return Header.this.getFontMetrics(f);
            }

            @Override
            public boolean isEnabled() {
                return true;
            }

            @Override
            public void setEnabled(boolean b) {
            }

            @Override
            public Color getForeground() {
                Color f = Header.this._getItemAppearance(this._position).getForeground();
                if (f == null) {
                    return Header.this.getForeground();
                }
                return f;
            }

            @Override
            public void setForeground(Color c) {
                Appearance app = Header.this.getItemAppearance(this._position);
                app.setForeground(c);
                Header.this.setItemAppearance(this._position, app);
            }

            @Override
            public Cursor getCursor() {
                return Header.this.getCursor();
            }

            @Override
            public void setCursor(Cursor c) {
            }

            @Override
            public boolean isVisible() {
                return Header.this.isItemVisible(this._position);
            }

            @Override
            public void setVisible(boolean b) {
                Header.this.setItemVisible(this._position, b);
            }

            @Override
            public boolean isShowing() {
                return this.isVisible();
            }

            @Override
            public boolean contains(Point p) {
                return this.getBounds().contains(p);
            }

            @Override
            public Point getLocationOnScreen() {
                Point parentLocation = Header.this.getLocationOnScreen();
                Point componentLocation = this.getLocation();
                componentLocation.translate(parentLocation.x, parentLocation.y);
                return componentLocation;
            }

            @Override
            public Point getLocation() {
                return this.getBounds().getLocation();
            }

            @Override
            public void setLocation(Point p) {
            }

            @Override
            public Rectangle getBounds() {
                return Header.this.getCellBoundsForItem(this._position);
            }

            @Override
            public void setBounds(Rectangle r) {
            }

            @Override
            public Dimension getSize() {
                return this.getBounds().getSize();
            }

            @Override
            public void setSize(Dimension d) {
            }

            @Override
            public int getAccessibleChildrenCount() {
                return 0;
            }

            @Override
            public AccessibleRole getAccessibleRole() {
                return AccessibleRole.LABEL;
            }

            @Override
            public boolean isFocusTraversable() {
                return false;
            }

            @Override
            public void requestFocus() {
            }

            @Override
            public void addFocusListener(FocusListener l) {
            }

            @Override
            public void removeFocusListener(FocusListener l) {
            }
        }
    }

    private class GeometryChangeListener
    implements GeometryListener {
        private GeometryChangeListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void geometryChanged(GeometryEvent e) {
            switch (e.getID()) {
                case 2005: {
                    GeometryManager gm = Header.this._getGeometryManager();
                    int item = e.getItem();
                    Header.this.freezeRepaints();
                    try {
                        Dimension d = Header.this.layoutCanvas();
                        Header.this.setCanvasSize(d.width, d.height);
                        if (!Header.this.isItemOnScreen(item)) break;
                        d = Header.this.getInnerSize();
                        Point p = Header.this.getCanvasOrigin();
                        int pos = gm.getItemPosition(item);
                        if (Header.this._isHorizontal()) {
                            if (pos < -p.x) {
                                pos = -p.x;
                            }
                            Header.this.repaintCanvas(pos, -p.y, d.width, d.height);
                            break;
                        }
                        if (pos < -p.y) {
                            pos = -p.y;
                        }
                        Header.this.repaintCanvas(-p.x, pos, d.width, d.height);
                        break;
                    }
                    finally {
                        Header.this.unfreezeRepaints();
                    }
                }
                default: {
                    Header.this.invalidateCanvas();
                }
            }
        }
    }

    private class SelectionListener
    implements VetoableChangeListener,
    PropertyChangeListener {
        private SelectionListener() {
        }

        @Override
        public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
            Header.this.fireVetoableChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!Header.this._ignoreSelectionRepaints) {
                Header.this._paintSelections((OneDSelection)evt.getOldValue(), (OneDSelection)evt.getNewValue());
            }
            Header.this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
        }
    }

    private class KeyboardActionListener
    implements ActionListener {
        private KeyboardActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String name = e.getActionCommand();
            int focusItem = Header.this.getFocusItem();
            if (focusItem == -1) {
                return;
            }
            if (Header._MOVE_LEFT.equals(name) || Header._MOVE_RIGHT.equals(name) || Header._MOVE_UP.equals(name) || Header._MOVE_DOWN.equals(name)) {
                if (Header.this.isItemMovable(focusItem)) {
                    int vIndex = Header.this.getItemVisibleIndex(focusItem);
                    if (Header._MOVE_LEFT.equals(name) || Header._MOVE_UP.equals(name)) {
                        if (vIndex != 0 && !Header.this.fireCancelableEvent(2007, focusItem)) {
                            Header.this.setItemVisibleIndex(focusItem, vIndex - 1);
                            Header.this.fireEvent(2008, focusItem);
                        }
                    } else if ((Header._MOVE_RIGHT.equals(name) || Header._MOVE_DOWN.equals(name)) && vIndex != Header.this.getItemCount() - 1 && !Header.this.fireCancelableEvent(2007, focusItem)) {
                        Header.this.setItemVisibleIndex(focusItem, vIndex + 1);
                        Header.this.fireEvent(2008, focusItem);
                    }
                }
            } else if ((Header._RESIZE_LEFT.equals(name) || Header._RESIZE_RIGHT.equals(name) || Header._RESIZE_UP.equals(name) || Header._RESIZE_DOWN.equals(name)) && Header.this.isItemResizable(focusItem)) {
                int size = Header.this.getItemSize(focusItem);
                if (Header._RESIZE_LEFT.equals(name) || Header._RESIZE_UP.equals(name)) {
                    if (size != 0 && !Header.this.fireCancelableEvent(2005, focusItem)) {
                        Header.this.setItemSize(focusItem, size - 1);
                        Header.this.fireEvent(2006, focusItem);
                    }
                } else if ((Header._RESIZE_RIGHT.equals(name) || Header._RESIZE_DOWN.equals(name)) && !Header.this.fireCancelableEvent(2005, focusItem)) {
                    Header.this.setItemSize(focusItem, size + 1);
                    Header.this.fireEvent(2006, focusItem);
                }
            }
        }
    }

    private class ItemPaintContext
    extends PaintContextProxy {
        private int _item;
        private PaintContext _context;

        public ItemPaintContext(PaintContext context, int item) {
            this._context = context;
            this.setItem(item);
        }

        public void setItem(int item) {
            this._item = item;
        }

        @Override
        protected PaintContext getPaintContext() {
            return this._context;
        }

        @Override
        public int getPaintState() {
            int state = super.getPaintState();
            int item = this._item;
            if (Header.this.isEnabled()) {
                HeaderSelectionManager sm = Header.this.getHeaderSelectionManager();
                if (sm.getSelection().contains(item) && Header.this.getDrawSelected()) {
                    state |= 0x20;
                }
                if (Header.this.getFocusItem() == item) {
                    if (((state |= 0x40) & 0x20) != 0 && Header.this.getDrawSelectionBorder() && ((state & 4) == 0 && Header.this.hasFocus() || Header.this.isAlwaysDrawFocusItemHighlite())) {
                        state &= 0xFFFFFFDF;
                    }
                } else {
                    state &= 0xFFFFFFBF;
                }
            }
            if (Header.this.getArmedItem() == item) {
                state |= 2;
            }
            return Header.this.getItemPaintState(state, item);
        }

        @Override
        public Color getPaintForeground() {
            int state = this.getPaintState();
            if ((state & 0x20) == 0 || Header.this.isSelectionTransparent()) {
                Color fgColor = this.getAppearance().getForeground();
                if (fgColor == null) {
                    fgColor = super.getPaintForeground();
                }
                return fgColor;
            }
            return this.getAppearance().getSelectForeground();
        }

        @Override
        public Color getPaintBackground() {
            boolean active;
            int state = this.getPaintState();
            Color color = null;
            boolean selected = (state & 0x20) != 0;
            boolean bl = active = (state & 4) == 0;
            if (selected) {
                if (active) {
                    color = this.getAppearance().getSelectBackground();
                    if (Header.this.isSelectionTransparent() && color != null) {
                        Color base = this.getAppearance().getBackground();
                        if (base == null) {
                            base = super.getPaintBackground();
                        }
                        if (base != null) {
                            color = ColorUtils.getTransparentColor(base, color, 60);
                        }
                    }
                } else {
                    color = UIManager.getColor("Header.inactiveSelectedBackground");
                }
            }
            if (color == null) {
                color = this.getAppearance().getBackground();
            }
            if (color == null) {
                color = super.getPaintBackground();
            }
            return color;
        }

        @Override
        public Font getPaintFont() {
            int state = this.getPaintState();
            Font font = null;
            if ((state & 0x20) != 0 || !Header.this.isSelectionTransparent()) {
                font = this.getAppearance().getSelectFont();
            }
            if (font == null) {
                font = this.getAppearance().getFont();
            }
            if (font == null) {
                font = super.getPaintFont();
            }
            return font;
        }

        @Override
        public float getInteriorAlignmentX() {
            float align;
            Appearance a = this.getAppearance();
            int hJustify = a.getHorizontalJustify();
            if (hJustify == 0) {
                int direction = a.getReadingDirection();
                switch (direction) {
                    case 0: {
                        return super.getInteriorAlignmentX();
                    }
                }
                hJustify = LocaleUtils.getAlignmentForReadingDirection(direction);
            }
            switch (hJustify) {
                case 3: {
                    align = 0.5f;
                    break;
                }
                case 2: {
                    align = 1.0f;
                    break;
                }
                default: {
                    align = 0.0f;
                }
            }
            return align;
        }

        @Override
        public float getInteriorAlignmentY() {
            int hJustify = this.getAppearance().getVerticalJustify();
            float align = 0.0f;
            switch (hJustify) {
                case 1: {
                    align = 0.5f;
                    break;
                }
                case 0: {
                    align = 0.0f;
                    break;
                }
                case 2: {
                    align = 1.0f;
                }
            }
            return align;
        }

        @Override
        public int getReadingDirection() {
            int direction = this.getAppearance().getReadingDirection();
            if (direction == 0) {
                direction = super.getReadingDirection();
            }
            return direction;
        }

        @Override
        public Object getPaintData(Object key) {
            Object o = Header.this.getItemPaintData(this._item, key);
            if (o != null) {
                return o;
            }
            if (key == PaintContext.MNEMONIC_INDEX_KEY) {
                return null;
            }
            if (KEY_APPEARANCE.equals(key)) {
                return this.getAppearance();
            }
            if (Header.KEY_HEADER_ITEM.equals(key)) {
                return IntegerUtils.getInteger((int)this._item);
            }
            Object data = super.getPaintData(key);
            if (data == null) {
                data = Header.this.getPaintData(key);
            }
            if (data == null) {
                try {
                    data = Header.this.getModel().getData(this._item);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return data;
        }

        public Appearance getAppearance() {
            return Header.this._getItemAppearance(this._item);
        }
    }

    private class DSListen
    implements OneDModelListener {
        private DSListen() {
        }

        @Override
        public void itemsAdded(OneDModelEvent e) {
            Header.this.internalItemsAdded(e);
        }

        @Override
        public void itemsRemoved(OneDModelEvent e) {
            Header.this.internalItemsRemoved(e);
        }

        @Override
        public void invalidateItems(OneDModelEvent e) {
            Header.this.internalInvalidateItems(e);
        }
    }
}

