/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Enumeration;
import oracle.bali.ewt.layout.ChildEnumeration;

public abstract class EqualLayout
implements LayoutManager {
    public static final int ALIGN_START = 0;
    public static final int ALIGN_CENTER = 1;
    public static final int ALIGN_END = 2;
    private int _interiorGap;
    private int _layoutAlignment;
    private int _perpendicularAlignment;

    public EqualLayout() {
        this(0);
    }

    public EqualLayout(int interiorGap) {
        this(interiorGap, 1, 1);
    }

    public EqualLayout(int interiorGap, int layoutAlignment, int perpendicularAlignment) {
        this.setInteriorGap(interiorGap);
        this.setLayoutAlignment(layoutAlignment);
        this.setPerpendicularAlignment(perpendicularAlignment);
    }

    @Override
    public abstract void layoutContainer(Container var1);

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    @Override
    public Dimension preferredLayoutSize(Container target) {
        return this.getLayoutSize(target, true);
    }

    @Override
    public Dimension minimumLayoutSize(Container target) {
        return this.getLayoutSize(target, false);
    }

    public void setInteriorGap(int interiorGap) {
        this._interiorGap = interiorGap;
    }

    public int getInteriorGap() {
        return this._interiorGap;
    }

    public void setLayoutAlignment(int layoutAlignment) {
        this._layoutAlignment = layoutAlignment;
    }

    public int getLayoutAlignment() {
        return this._layoutAlignment;
    }

    public void setPerpendicularAlignment(int perpendicularAlignment) {
        this._perpendicularAlignment = perpendicularAlignment;
    }

    public int getPerpendicularAlignment() {
        return this._perpendicularAlignment;
    }

    public static int getNumberVisibleChildren(Container container) {
        int numChildren = container.getComponentCount();
        int numVisibleChildren = 0;
        for (int i = 0; i < numChildren; ++i) {
            if (!container.getComponent(i).isVisible()) continue;
            ++numVisibleChildren;
        }
        return numVisibleChildren;
    }

    protected Enumeration getComponentEnumeration(Container target) {
        return new ChildEnumeration(target);
    }

    protected Dimension getCellSize(Container container, boolean usePreferredSize) {
        int maxWidth = 0;
        int maxHeight = 0;
        int numChildren = container.getComponentCount();
        for (int i = 0; i < numChildren; ++i) {
            Dimension childSize;
            Component currChild = container.getComponent(i);
            if (!currChild.isVisible()) continue;
            Dimension dimension = childSize = usePreferredSize ? currChild.getPreferredSize() : currChild.getMinimumSize();
            if (maxHeight < childSize.height) {
                maxHeight = childSize.height;
            }
            if (maxWidth >= childSize.width) continue;
            maxWidth = childSize.width;
        }
        return new Dimension(maxWidth, maxHeight);
    }

    protected abstract Dimension getInsetLayoutSize(Container var1, boolean var2);

    protected Dimension getLayoutSize(Container target, boolean usePreferredSize) {
        Dimension insetLayoutSize = this.getInsetLayoutSize(target, usePreferredSize);
        Insets margins = target.getInsets();
        insetLayoutSize.width += margins.left + margins.right;
        insetLayoutSize.height += margins.top + margins.bottom;
        return insetLayoutSize;
    }
}

