/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf;

import java.awt.Color;
import java.awt.Graphics;
import javax.swing.JComboBox;
import javax.swing.UIDefaults;
import oracle.bali.ewt.olaf.ColorScheme;
import oracle.bali.ewt.painter.AbstractBorderPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.util.ImmInsets;

class OracleComboBoxBorderPainter
extends AbstractBorderPainter {
    private static final ImmInsets _sInsets = new ImmInsets(3, 3, 2, 2);

    public OracleComboBoxBorderPainter() {
        super(null);
    }

    @Override
    protected ImmInsets getOwnInsets(PaintContext context) {
        return _sInsets;
    }

    @Override
    protected void paintBorder(PaintContext context, Graphics g, int x, int y, int width, int height) {
        Color lowerLeft;
        Color upperLeft;
        Color gray;
        Color innerHighlight;
        Color outerHighlight;
        Color innerShadow;
        UIDefaults defaults = context.getPaintUIDefaults();
        Color savedColor = g.getColor();
        Color outerShadow = defaults.getColor(ColorScheme.CONTROL_SHADOW_DARK);
        int state = context.getPaintState();
        JComboBox combo = (JComboBox)context.getComponent();
        boolean isDisabled = (state & 1) != 0;
        boolean isArmed = (state & 2) != 0;
        boolean isInactive = (state & 4) != 0;
        boolean isEditable = combo.isEditable();
        if (isInactive) {
            Color backgroundColor = !isDisabled ? (isEditable ? combo.getEditor().getEditorComponent().getBackground() : context.getPaintBackground()) : defaults.getColor(ColorScheme.LIGHT_INTENSITY);
            innerShadow = backgroundColor;
            outerHighlight = outerShadow;
            innerHighlight = backgroundColor;
            gray = backgroundColor;
        } else {
            gray = defaults.getColor(ColorScheme.NORMAL_INTENSITY);
            innerShadow = defaults.getColor(ColorScheme.DARK_INTENSITY);
            outerHighlight = defaults.getColor("controlLtHighlight");
            innerHighlight = isEditable ? context.getPaintBackground() : innerShadow;
        }
        int bottom = y + height - 1;
        int right = x + width - 1;
        if (isInactive) {
            upperLeft = outerShadow;
            lowerLeft = outerShadow;
        } else {
            upperLeft = innerShadow;
            lowerLeft = gray;
        }
        g.setColor(outerShadow);
        g.drawLine(x + 1, y, right - 2, y);
        g.drawLine(x, y + 1, x, bottom - 2);
        g.drawLine(right - 1, y + 1, right - 1, y + 1);
        g.setColor(lowerLeft);
        g.drawLine(x + 1, bottom - 1, x + 1, bottom - 1);
        g.setColor(gray);
        g.drawLine(right - 2, y + 2, right - 2, y + 2);
        if (isInactive) {
            g.setColor(outerShadow);
            g.drawLine(x, bottom - 1, x + 1, bottom);
            g.drawLine(right - 1, y, right, y + 1);
        }
        g.setColor(upperLeft);
        g.drawLine(x + 1, y + 1, x + 1, y + 1);
        g.setColor(innerShadow);
        g.drawLine(x + 2, y + 1, right - 2, y + 1);
        g.drawLine(x + 1, y + 2, x + 1, bottom - 2);
        g.setColor(innerHighlight);
        g.drawLine(x + 2, bottom - 1, right - 2, bottom - 1);
        g.drawLine(right - 1, y + 2, right - 1, bottom - 2);
        if (!isInactive) {
            g.setColor(outerShadow);
            g.drawLine(right - 2, bottom - 2, right - 2, bottom - 2);
            if (!isDisabled || !isEditable) {
                g.drawLine(x + 2, y + 2, x + 2, y + 2);
                g.drawLine(x + 2, bottom - 2, x + 2, bottom - 2);
            }
        } else {
            g.setColor(innerShadow);
            g.drawLine(x + 2, y + 2, right - 2, y + 2);
            g.drawLine(x + 2, y + 3, x + 2, bottom - 2);
        }
        g.setColor(outerHighlight);
        g.drawLine(x + 2, bottom, right - 1, bottom);
        g.drawLine(right, y + 2, right, bottom - 1);
        g.drawLine(right - 1, bottom - 1, right - 1, bottom - 1);
        if (!(isInactive || isDisabled && isEditable)) {
            if (isArmed) {
                g.setColor(innerShadow);
            } else {
                g.setColor(Color.white);
            }
            g.drawLine(x + 3, y + 2, right - 3, y + 2);
            g.drawLine(x + 2, y + 3, x + 2, bottom - 3);
        }
        g.setColor(savedColor);
    }

    @Override
    public int getRepaintFlags(PaintContext context) {
        return super.getRepaintFlags(context) | 1 | 4 | 0x80 | 2 | 0x400;
    }

    @Override
    protected boolean isBorderTransparent(PaintContext context) {
        return true;
    }
}

