/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Shape;
import javax.swing.BoundedRangeModel;
import javax.swing.JProgressBar;
import javax.swing.UIDefaults;
import oracle.bali.ewt.graphics.GraphicUtils;
import oracle.bali.ewt.painter.AbstractPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.util.StringUtils;

final class ProgressBarPainter
extends AbstractPainter {
    private static final int _MIN_PREFERRED_WIDTH = 100;
    private static final int _MIN_HEIGHT = 8;
    private static Painter _sInstance;

    private ProgressBarPainter() {
    }

    public static Painter getPainter() {
        if (_sInstance == null) {
            _sInstance = new ProgressBarPainter();
        }
        return _sInstance;
    }

    @Override
    public void paint(PaintContext context, Graphics g, int x, int y, int width, int height) {
        String displayString;
        Color savedColor = g.getColor();
        BoundedRangeModel model = this._getModel(context);
        double percent = this._getPercent(model);
        UIDefaults defaults = context.getPaintUIDefaults();
        Color barForegroundColor = context.getPaintForeground();
        int barPosition = (int)((double)width * percent);
        if (barPosition > 0) {
            g.setColor(barForegroundColor);
            g.fillRect(x, y, x + barPosition, height);
            g.setColor(savedColor);
        }
        if ((displayString = (String)context.getPaintData(PaintContext.LABEL_KEY)) != null) {
            displayString = StringUtils.getDisplayString(displayString, context);
            FontMetrics metrics = context.getFontMetrics(context.getPaintFont());
            int stringWidth = metrics.stringWidth(displayString);
            int drawX = (width - stringWidth) / 2;
            if (drawX < 0) {
                drawX = 0;
            }
            int ascent = metrics.getAscent();
            int drawY = (height - (ascent + metrics.getDescent())) / 2 + ascent;
            if (barPosition > drawX) {
                g.setColor(defaults.getColor("ProgressBar.textSelectionColor"));
                if (barPosition < drawX + stringWidth) {
                    Shape savedClip = g.getClip();
                    g.clipRect(x, y, barPosition, height);
                    GraphicUtils.drawString(g, displayString, x + drawX, y + drawY);
                    g.setClip(savedClip);
                    g.setColor(defaults.getColor("ProgressBar.textNonSelectionColor"));
                    g.clipRect(x + barPosition, y, width - barPosition, height);
                    GraphicUtils.drawString(g, displayString, x + drawX, y + drawY);
                    g.setClip(savedClip);
                } else {
                    GraphicUtils.drawString(g, displayString, x + drawX, y + drawY);
                }
            } else {
                g.setColor(defaults.getColor("ProgressBar.textNonSelectionColor"));
                GraphicUtils.drawString(g, displayString, x + drawX, y + drawY);
            }
        }
        g.setColor(savedColor);
    }

    @Override
    public Dimension getMinimumSize(PaintContext context) {
        String displayString = (String)context.getPaintData(PaintContext.LABEL_KEY);
        int displayWidth = 0;
        int displayHeight = 8;
        if (displayString != null) {
            FontMetrics metrics = context.getFontMetrics(context.getPaintFont());
            displayWidth = metrics.stringWidth(displayString);
            displayHeight = metrics.getAscent() + metrics.getDescent();
        }
        return new Dimension(displayWidth, displayHeight);
    }

    @Override
    public Dimension getPreferredSize(PaintContext context) {
        BoundedRangeModel model = this._getModel(context);
        Dimension preferredSize = this.getMinimumSize(context);
        if (preferredSize.width < 100) {
            preferredSize.width = 100;
        }
        return preferredSize;
    }

    @Override
    public int getRepaintFlags(PaintContext context) {
        return 0;
    }

    private double _getPercent(BoundedRangeModel model) {
        int value = 0;
        int min = 0;
        int max = 0;
        if (model != null) {
            value = model.getValue();
            min = model.getMinimum();
            max = model.getMaximum();
        }
        double percent = value == min ? 0.0 : (value == max ? 1.0 : ((double)value - (double)min) / (double)(max - min));
        return percent;
    }

    private BoundedRangeModel _getModel(PaintContext context) {
        JProgressBar bar = (JProgressBar)context.getComponent();
        return bar.getModel();
    }
}

