/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf;

import java.awt.Color;
import java.awt.Graphics;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.TruncatingTextPainter;

class TabTextPainter
extends TruncatingTextPainter {
    public static final Object MINIMUM_TAB_CHARACTERS = "MinTabChars";

    @Override
    public void paint(PaintContext context, Graphics g, int x, int y, int width, int height) {
        Color old = g.getColor();
        if ((context.getPaintState() & 0x20) != 0) {
            g.setColor(context.getPaintUIDefaults().getColor("TabbedPane.selectedTextColor"));
        }
        super.paint(context, g, x, y, width, height);
        if (old != null) {
            g.setColor(old);
        }
    }

    @Override
    public String getMinimumStringData(PaintContext context) {
        int length;
        String string = super.getMinimumStringData(context);
        Object obj = context.getPaintData(MINIMUM_TAB_CHARACTERS);
        if (obj instanceof Integer && (length = ((Integer)obj).intValue()) < string.length()) {
            return string.substring(0, length) + TabTextPainter.getEllipsis(context);
        }
        return string;
    }
}

