/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.text.View;
import oracle.bali.ewt.painter.AbstractPainter;
import oracle.bali.ewt.painter.AbstractWrappingPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.share.collection.StringKey;

class ViewPainter
extends AbstractWrappingPainter {
    public static final Object VIEW_KEY = new StringKey("View");
    private static Painter _sInstance;

    public static boolean hasView(JComponent component) {
        return component.getClientProperty("html") != null;
    }

    public static View getHTMLView(JComponent component) {
        Object o = component.getClientProperty("html");
        if (o instanceof View) {
            return (View)o;
        }
        return null;
    }

    public ViewPainter(Painter ifNoViewPainter) {
        super(ifNoViewPainter);
    }

    @Override
    protected final Painter getWrappedPainter(PaintContext context) {
        if (context.getPaintData(VIEW_KEY) != null) {
            return ViewPainter._getViewPainter();
        }
        return super.getWrappedPainter(context);
    }

    private static Painter _getViewPainter() {
        if (_sInstance == null) {
            _sInstance = new _Painter();
        }
        return _sInstance;
    }

    private static class _Painter
    extends AbstractPainter {
        @Override
        public void paint(PaintContext context, Graphics g, int x, int y, int width, int height) {
            View view = this._getView(context);
            if (view != null) {
                view.paint(g, new Rectangle(x, y, width, height));
            }
        }

        @Override
        public Dimension getPreferredSize(PaintContext context) {
            View view = this._getView(context);
            int x = 0;
            int y = 0;
            if (view != null) {
                x = (int)view.getPreferredSpan(0);
                y = (int)view.getPreferredSpan(1);
            }
            return new Dimension(x, y);
        }

        @Override
        public Dimension getMinimumSize(PaintContext context) {
            View view = this._getView(context);
            int x = 0;
            int y = 0;
            if (view != null) {
                x = (int)view.getMinimumSpan(0);
                y = (int)view.getMinimumSpan(1);
            }
            return new Dimension(x, y);
        }

        @Override
        public Dimension getMaximumSize(PaintContext context) {
            View view = this._getView(context);
            int x = 0;
            int y = 0;
            if (view != null) {
                x = (int)view.getMaximumSpan(0);
                y = (int)view.getMaximumSpan(1);
            }
            return new Dimension(x, y);
        }

        @Override
        public boolean isTransparent(PaintContext context) {
            return true;
        }

        private View _getView(PaintContext context) {
            return (View)context.getPaintData(VIEW_KEY);
        }
    }
}

