/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.painter;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import oracle.bali.ewt.painter.AbstractPainter;
import oracle.bali.ewt.painter.PaintContext;

public class GradientPainter
extends AbstractPainter {
    private Color _startColor;
    private Color _endColor;
    private boolean _vertical;
    private boolean _twoWay;
    private Image _gradient;

    public GradientPainter(Color startColor, Color endColor) {
        this._startColor = startColor;
        this._endColor = endColor;
    }

    public boolean isVertical() {
        return this._vertical;
    }

    public synchronized void setVertical(boolean vertical) {
        if (this._vertical != vertical) {
            this._vertical = vertical;
            this._gradient = null;
        }
    }

    public boolean isTwoWay() {
        return this._twoWay;
    }

    public void setTwoWay(boolean twoWay) {
        this._twoWay = twoWay;
    }

    @Override
    public Dimension getMinimumSize(PaintContext context) {
        return new Dimension(0, 0);
    }

    @Override
    public Dimension getPreferredSize(PaintContext context) {
        int maxDelta;
        int redDelta = this._startColor.getRed() - this._endColor.getRed();
        int greenDelta = this._startColor.getGreen() - this._endColor.getGreen();
        int blueDelta = this._startColor.getBlue() - this._endColor.getBlue();
        if (redDelta < 0) {
            redDelta *= -1;
        }
        if (greenDelta < 0) {
            greenDelta *= -1;
        }
        if (blueDelta < 0) {
            blueDelta *= -1;
        }
        if (greenDelta > (maxDelta = redDelta)) {
            maxDelta = greenDelta;
        }
        if (blueDelta > maxDelta) {
            maxDelta = blueDelta;
        }
        maxDelta >>= 8;
        if (this.isTwoWay()) {
            maxDelta += maxDelta;
        }
        return new Dimension(maxDelta, maxDelta);
    }

    @Override
    public void paint(PaintContext context, Graphics g, int x, int y, int width, int height) {
        Image gradient = this._getGradient();
        ImageObserver observer = context.getImageObserver();
        if (this.isTwoWay()) {
            int gradientWidth = gradient.getWidth(observer);
            int gradientHeight = gradient.getHeight(observer);
            if (this.isVertical()) {
                int halfWidth = width / 2;
                g.drawImage(gradient, x, y, halfWidth, height, observer);
                g.drawImage(gradient, width, y, halfWidth, height, x, y, gradientWidth, gradientHeight, observer);
            } else {
                int halfHeight = height / 2;
                g.drawImage(gradient, x, y, width, halfHeight, observer);
                g.drawImage(gradient, x, height, width, halfHeight, x, y, gradientWidth, gradientHeight, observer);
            }
        } else {
            g.drawImage(gradient, x, y, width, height, observer);
        }
    }

    @Override
    public boolean isTransparent(PaintContext context) {
        return false;
    }

    @Override
    public int getRepaintFlags(PaintContext context) {
        return 128;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Image _getGradient() {
        Image gradient = this._gradient;
        if (gradient != null) {
            return gradient;
        }
        GradientPainter gradientPainter = this;
        synchronized (gradientPainter) {
            if (gradient != null) {
                return gradient;
            }
            int startRed = this._startColor.getRed();
            int startBlue = this._startColor.getBlue();
            int startGreen = this._startColor.getGreen();
            int endRed = this._endColor.getRed();
            int endBlue = this._endColor.getBlue();
            int endGreen = this._endColor.getGreen();
            int steps = Math.max(Math.abs(startRed - endRed), Math.max(Math.abs(startBlue - endBlue), Math.abs(startGreen - endGreen)));
            if (steps == 0) {
                steps = 1;
            }
            byte[] reds = new byte[steps + 1];
            byte[] blues = new byte[steps + 1];
            byte[] greens = new byte[steps + 1];
            endRed -= startRed;
            endBlue -= startBlue;
            endGreen -= startGreen;
            for (int i = 0; i <= steps; ++i) {
                reds[i] = (byte)(startRed + endRed * i / steps);
                blues[i] = (byte)(startBlue + endBlue * i / steps);
                greens[i] = (byte)(startGreen + endGreen * i / steps);
            }
            byte[] pixels = new byte[steps + 1];
            for (int i = 0; i <= steps; ++i) {
                pixels[i] = (byte)i;
            }
            IndexColorModel model = new IndexColorModel(8, steps + 1, reds, greens, blues);
            MemoryImageSource source = this.isVertical() ? new MemoryImageSource(steps + 1, 1, (ColorModel)model, pixels, 0, steps + 1) : new MemoryImageSource(1, steps + 1, (ColorModel)model, pixels, 0, 1);
            this._gradient = gradient = Toolkit.getDefaultToolkit().createImage(source);
            return gradient;
        }
    }
}

