/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.text;

import java.awt.Component;
import java.awt.FontMetrics;
import java.util.Locale;
import oracle.bali.ewt.text.LineInfo;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.TextWrapper;
import oracle.bali.ewt.text.WrapInfo;
import oracle.bali.ewt.util.StringUtils;
import oracle.bali.share.nls.LocaleUtils;

class LabelGeometry
implements WrapInfo {
    private MultiLineLabel _label;
    private TextWrapper _wrapper;
    private String _text;
    private FontMetrics _metrics;
    private int _wrapWidth;
    private LineInfo[] _lineInfos;
    private int _topLineInfoIndex;
    private int _maxPixelWidth;
    private boolean _isValid;
    private boolean _preferred;

    LabelGeometry(MultiLineLabel label, TextWrapper wrapper, String text) {
        this(label, wrapper, text, null, 0, false);
    }

    LabelGeometry(MultiLineLabel label, TextWrapper wrapper, String text, FontMetrics metrics, int wrapWidth, boolean preferred) {
        if (label == null) {
            throw new IllegalArgumentException("Null MultiLineLabel");
        }
        if (wrapper == null) {
            throw new IllegalArgumentException("Null TextWrapper");
        }
        if (wrapWidth < 0) {
            throw new IllegalArgumentException("Null Paragraph wrapper");
        }
        this._label = label;
        this._text = text;
        this._wrapper = wrapper;
        this._metrics = metrics;
        this._wrapWidth = wrapWidth;
        this._isValid = true;
        this._preferred = preferred;
        this._invalidate();
    }

    @Override
    public boolean addLine(String text, int startOfLine, int endOfLine) {
        LineInfo newLineInfo = this._getNextLineInfo();
        if (text == null) {
            newLineInfo.text = null;
            newLineInfo.pixelWidth = 0;
            newLineInfo.isNotWrapped = true;
        } else {
            String subtext = text.substring(startOfLine, endOfLine);
            newLineInfo.text = subtext = StringUtils.getDisplayString(subtext, this.getLocale(), this._label.getActualReadingDirection());
            newLineInfo.pixelWidth = this.getFontMetrics().stringWidth(subtext);
            if (this._maxPixelWidth < newLineInfo.pixelWidth) {
                this._maxPixelWidth = newLineInfo.pixelWidth;
            }
            newLineInfo.isNotWrapped = endOfLine == text.length();
        }
        LineInfo prevLineInfo = this._getPreviousLineInfo();
        newLineInfo.isNewParagraph = prevLineInfo == null || prevLineInfo.isNotWrapped;
        return true;
    }

    @Override
    public boolean isCalculatingPreferred() {
        return this._preferred ? !this._label.isForceWrapping() : false;
    }

    @Override
    public int getWrapWidth() {
        return this._wrapWidth;
    }

    @Override
    public FontMetrics getFontMetrics() {
        return this._metrics;
    }

    @Override
    public Locale getLocale() {
        return LocaleUtils.getDefaultableLocale((Component)this._label);
    }

    public int getMaxPixelWidth() {
        this._validate();
        return this._maxPixelWidth;
    }

    public int getLineCount() {
        this._validate();
        return this._topLineInfoIndex;
    }

    public LineInfo getLineInfo(int index, LineInfo outInfo) {
        if (!this._isValid) {
            return null;
        }
        this._lineInfos[index].copy(outInfo);
        return outInfo;
    }

    protected boolean isValid() {
        return this._isValid;
    }

    void _setText(String newText) {
        if (this._text != newText) {
            this._text = newText;
            this._invalidate();
        }
    }

    String _getText() {
        return this._text;
    }

    void _setTextWrapper(TextWrapper newWrapper) {
        if (this._wrapper != newWrapper) {
            this._wrapper = newWrapper;
            this._invalidate();
        }
    }

    TextWrapper _getTextWrapper() {
        return this._wrapper;
    }

    void _setWrapWidth(int newWrapWidth) {
        if (this._wrapWidth != newWrapWidth) {
            this._wrapWidth = newWrapWidth;
            this._invalidate();
        }
    }

    void _setFontMetrics(FontMetrics newMetrics) {
        if (newMetrics != this._metrics) {
            this._metrics = newMetrics;
            this._invalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _invalidate() {
        if (this._isValid) {
            boolean doInvalidate = false;
            LabelGeometry labelGeometry = this;
            synchronized (labelGeometry) {
                if (this._isValid) {
                    this._isValid = false;
                    this._topLineInfoIndex = 0;
                    this._maxPixelWidth = 0;
                    doInvalidate = true;
                }
            }
            if (doInvalidate && !this._preferred) {
                this._label.invalidateMultiLineLabelCanvas();
            }
        }
    }

    synchronized void _validate() {
        if (!this._isValid && this._metrics != null) {
            this._wrapText();
            this._isValid = true;
        }
    }

    private LineInfo _getPreviousLineInfo() {
        if (this._topLineInfoIndex > 1) {
            return this._lineInfos[this._topLineInfoIndex - 2];
        }
        return null;
    }

    private LineInfo _getNextLineInfo() {
        if (this._lineInfos == null || this._topLineInfoIndex == this._lineInfos.length) {
            this._lineInfos = LineInfo._reallocExact(this._lineInfos, this._topLineInfoIndex + 1);
            this._lineInfos[this._topLineInfoIndex] = new LineInfo();
        }
        LineInfo nextLineInfo = this._lineInfos[this._topLineInfoIndex];
        ++this._topLineInfoIndex;
        return nextLineInfo;
    }

    private void _wrapText() {
        String text = this._text;
        int textLength = text.length();
        int currIndex = 0;
        int lastIndex = 0;
        do {
            if ((currIndex = text.indexOf(10, lastIndex)) == -1) {
                currIndex = textLength;
            }
            if (currIndex == lastIndex) {
                this.addLine(null, 0, 0);
                continue;
            }
            this._wrapper.wrapParagraph(this, text.substring(lastIndex, currIndex));
        } while ((lastIndex = currIndex + 1) < textLength);
        this._lineInfos = LineInfo._reallocExact(this._lineInfos, this._topLineInfoIndex);
    }
}

