/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.wizard.dWizard;

import java.util.NoSuchElementException;
import oracle.bali.ewt.wizard.WizardPage;
import oracle.bali.ewt.wizard.dWizard.NullSequence;
import oracle.bali.ewt.wizard.dWizard.WizardSequence;

public class SequenceSeries
implements WizardSequence {
    private WizardSequence[] _series;
    private int _index;

    public SequenceSeries() {
        this(null);
    }

    public SequenceSeries(WizardSequence[] series) {
        this.setSeries(series);
    }

    public void setSeries(WizardSequence[] series) {
        if (series == null) {
            series = new WizardSequence[]{NullSequence.getWizardSequence()};
        }
        this._series = series;
        this._index = 0;
    }

    public WizardSequence[] getSeries() {
        return this._series;
    }

    @Override
    public void goToFirstPage() {
        this._index = 0;
        this._series[0].goToFirstPage();
        if (this.getCurrentPage() == null && this.getNextPage() != null) {
            this.goForward();
        }
    }

    @Override
    public void goToLastPage() {
        this._index = this._series.length - 1;
        this._series[this._index].goToLastPage();
        if (this.getCurrentPage() == null && this.getPreviousPage() != null) {
            this.goBackwards();
        }
    }

    @Override
    public void goForward() {
        int index = this._index;
        if (this._series[index].getNextPage() != null) {
            this._series[index].goForward();
        } else {
            do {
                if (this._index == this._series.length - 1) {
                    throw new NoSuchElementException();
                }
                this._series[++this._index].goToFirstPage();
            } while (this.getCurrentPage() == null);
        }
    }

    @Override
    public void goBackwards() {
        int index = this._index;
        if (this._series[index].getPreviousPage() != null) {
            this._series[index].goBackwards();
        } else {
            do {
                if (this._index == 0) {
                    throw new NoSuchElementException();
                }
                this._series[--this._index].goToLastPage();
            } while (this.getCurrentPage() == null);
        }
    }

    @Override
    public WizardPage getNextPage() {
        int index = this._index;
        WizardPage page = this._series[index].getNextPage();
        while (page == null && index < this._series.length - 1) {
            this._series[++index].goToFirstPage();
            page = this._series[index].getCurrentPage();
        }
        return page;
    }

    @Override
    public WizardPage getPreviousPage() {
        int index = this._index;
        WizardPage page = this._series[index].getPreviousPage();
        while (page == null && index > 0) {
            this._series[--index].goToLastPage();
            page = this._series[index].getCurrentPage();
        }
        return page;
    }

    @Override
    public WizardPage getCurrentPage() {
        return this._series[this._index].getCurrentPage();
    }

    @Override
    public int getPageCount() {
        int count = 0;
        for (int i = 0; i < this._series.length; ++i) {
            count += this._series[i].getPageCount();
        }
        return count;
    }
}

