/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.worker;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.Hashtable;
import oracle.bali.ewt.worker.AbstractWorker;
import oracle.bali.ewt.worker.InvocationContext;
import oracle.bali.ewt.worker.Worker;
import oracle.bali.share.collection.CompoundEnumeration;

public abstract class DelegatingWorker
extends AbstractWorker {
    private Worker _delegatedWorker = null;
    private transient PropertyResender _propertyResender = null;
    private static final Object _NULL_OBJECT = new Object();

    protected DelegatingWorker() {
    }

    @Override
    public Object getValue(Object key) {
        Object value = super.getValue(key);
        if (value != null) {
            return this._fixObject(value);
        }
        if (this._delegatedWorker != null) {
            return this._delegatedWorker.getValue(key);
        }
        return null;
    }

    @Override
    public Object putValue(Object key, Object newValue) {
        if (newValue == null) {
            newValue = _NULL_OBJECT;
        }
        return this._fixObject(super.putValue(key, newValue));
    }

    @Override
    public Enumeration getValueKeys() {
        Enumeration keys = super.getValueKeys();
        if (this._delegatedWorker != null) {
            keys = new CompoundEnumeration(this._delegatedWorker.getValueKeys(), keys);
        }
        return keys;
    }

    @Override
    public Object getDefaultParameterValue(Object key) {
        Object value = super.getDefaultParameterValue(key);
        if (this._delegatedWorker != null && value == InvocationContext.UNDEFINED) {
            value = this._delegatedWorker.getDefaultParameterValue(key);
        }
        return value;
    }

    @Override
    public boolean isEnabled() {
        boolean delegatedEnabled = false;
        if (this._delegatedWorker != null) {
            delegatedEnabled = this._delegatedWorker.isEnabled();
        }
        return delegatedEnabled && super.isEnabled();
    }

    @Override
    protected Object runWorker(InvocationContext invokeContext) throws Throwable {
        if (this._delegatedWorker != null) {
            return this._delegatedWorker.run(invokeContext);
        }
        return null;
    }

    @Override
    protected void firePropertyChange(Object key, Object oldValue, Object newValue) {
        super.firePropertyChange(key, this._fixObject(oldValue), this._fixObject(newValue));
    }

    protected final Worker getDelegatedWorker() {
        return this._delegatedWorker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setDelegatedWorker(Worker newDelegatedWorker) {
        boolean wasEnabled = this.isEnabled();
        Worker currDelegatedWorker = this._delegatedWorker;
        if (this._propertyResender == null) {
            this._propertyResender = new PropertyResender();
        }
        DelegatingWorker delegatingWorker = this;
        synchronized (delegatingWorker) {
            if (currDelegatedWorker != newDelegatedWorker) {
                if (currDelegatedWorker != null) {
                    currDelegatedWorker.removePropertyChangeListener(this._propertyResender);
                }
                if (newDelegatedWorker != null) {
                    newDelegatedWorker.addPropertyChangeListener(this._propertyResender);
                }
                this._delegatedWorker = newDelegatedWorker;
            }
        }
        this._fireChangeEvents(currDelegatedWorker, newDelegatedWorker);
        this.fireEnabledPropertyChange(wasEnabled);
    }

    private void _fireChangeEvents(Worker oldWorker, Worker newWorker) {
        Enumeration newOnlyKeys;
        Enumeration oldValueKeys;
        Enumeration newValueKeys = newWorker != null ? newWorker.getValueKeys() : null;
        Hashtable newOnlyValues = new Hashtable();
        if (newValueKeys != null) {
            while (newValueKeys.hasMoreElements()) {
                Object currNewKey = newValueKeys.nextElement();
                newOnlyValues.put(currNewKey, newWorker.getValue(currNewKey));
            }
        }
        if (oldWorker != null && (oldValueKeys = oldWorker.getValueKeys()) != null) {
            while (oldValueKeys.hasMoreElements()) {
                Object currOldKey = oldValueKeys.nextElement();
                if (super.getValue(currOldKey) != null) continue;
                Object newValue = newOnlyValues.remove(currOldKey);
                this.firePropertyChange(currOldKey, oldWorker.getValue(currOldKey), newValue);
            }
        }
        if ((newOnlyKeys = newOnlyValues.keys()) != null) {
            while (newOnlyKeys.hasMoreElements()) {
                Object currNewOnlyKey = newOnlyKeys.nextElement();
                if (super.getValue(currNewOnlyKey) != null) continue;
                this.firePropertyChange(currNewOnlyKey, null, newOnlyValues.get(currNewOnlyKey));
            }
        }
    }

    private Object _fixObject(Object o) {
        if (o == _NULL_OBJECT) {
            return null;
        }
        return o;
    }

    private Object _getValueFromSuperclass(String propertyName) {
        return super.getValue(propertyName);
    }

    private class PropertyResender
    implements PropertyChangeListener {
        private PropertyResender() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            String name = event.getPropertyName();
            if (DelegatingWorker.this._getValueFromSuperclass(name) == null) {
                DelegatingWorker.this.firePropertyChange(event.getPropertyName(), event.getOldValue(), event.getNewValue());
            }
        }
    }
}

